/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellUsageInfo;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.memory.ObjSize;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

class CellRevisionJ
extends CellRevision {
    private static final int BIN_SORT_THRESHOLD = 32;
    private volatile SoftReference<int[]> connectionsRef = new SoftReference<Object>(null);
    private volatile SoftReference<ImmutableExport[]> exportIndexByOriginalPortRef = new SoftReference<Object>(null);
    private static final Comparator<ImmutableExport> BY_ORIGINAL_PORT = new Comparator<ImmutableExport>(){

        @Override
        public int compare(ImmutableExport e1, ImmutableExport e2) {
            int result2 = e1.originalNodeId - e2.originalNodeId;
            if (result2 != 0) {
                return result2;
            }
            result2 = e1.originalPortId.getChronIndex() - e2.originalPortId.getChronIndex();
            if (result2 != 0) {
                return result2;
            }
            return e1.exportId.chronIndex - e2.exportId.chronIndex;
        }
    };

    protected CellRevisionJ(ImmutableCell d, ImmutableNodeInst.Iterable nodes, ImmutableArcInst.Iterable arcs, int[] arcIndex, ImmutableExport.Iterable exports, int[] exportIndex, BitSet techUsages, CellUsageInfo[] cellUsages, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        super(d, nodes, arcs, arcIndex, exports, exportIndex, techUsages, cellUsages, definedExports, definedExportsLength, deletedExports);
    }

    protected CellRevisionJ(ImmutableCell d) {
        this(d, CellRevision.getProvider().createNodeList(ImmutableNodeInst.NULL_ARRAY, null), CellRevision.getProvider().createArcList(ImmutableArcInst.NULL_ARRAY, null), NULL_INT_ARRAY, CellRevision.getProvider().createExportList(ImmutableExport.NULL_ARRAY, null), NULL_INT_ARRAY, CellRevision.makeTechUsages(d.techId), NULL_CELL_USAGE_INFO_ARRAY, EMPTY_BITSET, 0, EMPTY_BITSET);
        if (d.techId == null) {
            throw new NullPointerException("techId");
        }
    }

    @Override
    protected CellRevision lowLevelWith(ImmutableCell d, ImmutableNodeInst.Iterable nodes, ImmutableArcInst.Iterable arcs, int[] arcIndex, ImmutableExport.Iterable exports, int[] exportIndex, BitSet techUsages, CellUsageInfo[] cellUsages, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        CellRevisionJ newCellRevision = new CellRevisionJ(d, nodes, arcs, arcIndex, exports, exportIndex, techUsages, cellUsages, definedExports, definedExportsLength, deletedExports);
        if (this.nodes == nodes) {
            if (this.arcs == arcs) {
                assert (this.arcIndex == arcIndex);
                newCellRevision.connectionsRef = this.connectionsRef;
            }
            if (this.exports == exports) {
                assert (this.exportIndex == exportIndex);
                assert (this.definedExports == definedExports && this.definedExportsLength == definedExportsLength && this.deletedExports == deletedExports);
                newCellRevision.exportIndexByOriginalPortRef = this.exportIndexByOriginalPortRef;
            }
        }
        return newCellRevision;
    }

    @Override
    public boolean hasConnectionsOnNode(ImmutableNodeInst n) {
        int chronIndex;
        if (this.getNodeById(n.nodeId) != n) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        int i = this.searchConnectionByPort(connections, n.nodeId, chronIndex = 0);
        if (i >= connections.length) {
            return false;
        }
        int con = connections[i];
        ImmutableArcInst a = this.arcs.get(con >>> 1);
        boolean end = (con & 1) != 0;
        int nodeId = end ? a.headNodeId : a.tailNodeId;
        return nodeId == n.nodeId;
    }

    @Override
    public int getNumConnectionsOnNode(ImmutableNodeInst n) {
        int i;
        int j;
        if (this.getNodeById(n.nodeId) != n) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        int myNodeId = n.nodeId;
        for (j = i = this.searchConnectionByPort(connections, myNodeId, 0); j < connections.length; ++j) {
            int nodeId;
            int con = connections[j];
            ImmutableArcInst a = this.arcs.get(con >>> 1);
            boolean end = (con & 1) != 0;
            int n2 = nodeId = end ? a.headNodeId : a.tailNodeId;
            if (nodeId != myNodeId) break;
        }
        return j - i;
    }

    @Override
    public List<ImmutableArcInst> getConnectionsOnNode(BitSet headEnds, ImmutableNodeInst n) {
        int i;
        if (this.getNodeById(n.nodeId) != n) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        List<ImmutableArcInst> result2 = null;
        if (headEnds != null) {
            headEnds.clear();
        }
        int myNodeId = n.nodeId;
        int chronIndex = 0;
        for (int j = i = this.searchConnectionByPort(connections, myNodeId, chronIndex); j < connections.length; ++j) {
            int nodeId;
            int con = connections[j];
            ImmutableArcInst a = this.arcs.get(con >>> 1);
            boolean end = (con & 1) != 0;
            int n2 = nodeId = end ? a.headNodeId : a.tailNodeId;
            if (nodeId != myNodeId) break;
            if (result2 == null) {
                result2 = new ArrayList<ImmutableArcInst>();
            }
            if (headEnds != null && end) {
                headEnds.set(((ArrayList)result2).size());
            }
            ((ArrayList)result2).add(a);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @Override
    public boolean hasConnectionsOnPort(ImmutableNodeInst n, PortProtoId portId) {
        int nodeId;
        int chronIndex;
        if (this.getNodeById(n.nodeId) != n || portId.parentId != n.protoId) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        int i = this.searchConnectionByPort(connections, n.nodeId, chronIndex = portId.chronIndex);
        if (i >= connections.length) {
            return false;
        }
        int con = connections[i];
        ImmutableArcInst a = this.arcs.get(con >>> 1);
        boolean end = (con & 1) != 0;
        int n2 = nodeId = end ? a.headNodeId : a.tailNodeId;
        if (nodeId != n.nodeId) {
            return false;
        }
        return portId == null || portId == (end ? a.headPortId : a.tailPortId);
    }

    @Override
    public int getNumConnectionsOnPort(ImmutableNodeInst n, PortProtoId portId) {
        int i;
        int j;
        if (this.getNodeById(n.nodeId) != n || portId.parentId != n.protoId) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        int myNodeId = n.nodeId;
        int myChronIndex = portId.chronIndex;
        for (j = i = this.searchConnectionByPort(connections, myNodeId, myChronIndex); j < connections.length; ++j) {
            int chronIndex;
            int nodeId;
            int con = connections[j];
            ImmutableArcInst a = this.arcs.get(con >>> 1);
            boolean end = (con & 1) != 0;
            int n2 = nodeId = end ? a.headNodeId : a.tailNodeId;
            if (nodeId != myNodeId) break;
            int n3 = chronIndex = end ? a.headPortId.chronIndex : a.tailPortId.chronIndex;
            if (chronIndex != myChronIndex) break;
        }
        return j - i;
    }

    @Override
    public List<ImmutableArcInst> getConnectionsOnPort(BitSet headEnds, ImmutableNodeInst n, PortProtoId portId) {
        int i;
        if (this.getNodeById(n.nodeId) != n || portId.parentId != n.protoId) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        List<ImmutableArcInst> result2 = null;
        if (headEnds != null) {
            headEnds.clear();
        }
        int myNodeId = n.nodeId;
        assert (portId.parentId == n.protoId);
        int chronIndex = portId.chronIndex;
        for (int j = i = this.searchConnectionByPort(connections, myNodeId, chronIndex); j < connections.length; ++j) {
            PortProtoId endProtoId;
            int nodeId;
            int con = connections[j];
            ImmutableArcInst a = this.arcs.get(con >>> 1);
            boolean end = (con & 1) != 0;
            int n2 = nodeId = end ? a.headNodeId : a.tailNodeId;
            if (nodeId != myNodeId) break;
            PortProtoId portProtoId = endProtoId = end ? a.headPortId : a.tailPortId;
            if (endProtoId.getChronIndex() != chronIndex) break;
            if (result2 == null) {
                result2 = new ArrayList<ImmutableArcInst>();
            }
            if (headEnds != null && end) {
                headEnds.set(((ArrayList)result2).size());
            }
            ((ArrayList)result2).add(a);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    private int searchConnectionByPort(int[] connections, int nodeId, int chronIndex) {
        int low = 0;
        int high = connections.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int con = connections[mid];
            ImmutableArcInst a = this.arcs.get(con >>> 1);
            boolean end = (con & 1) != 0;
            int endNodeId = end ? a.headNodeId : a.tailNodeId;
            int cmp = endNodeId - nodeId;
            if (cmp == 0) {
                PortProtoId portId = end ? a.headPortId : a.tailPortId;
                cmp = portId.getChronIndex() - chronIndex;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    private int[] getConnections() {
        int[] connections = this.connectionsRef.get();
        return connections != null ? connections : this.makeConnections();
    }

    private int[] makeConnections() {
        int nodeId;
        int[] connections = new int[this.arcs.size() * 2];
        int[] connectionsByNodeId = new int[this.getMaxNodeId() + 1];
        for (ImmutableArcInst a : this.arcs) {
            int n = a.headNodeId;
            connectionsByNodeId[n] = connectionsByNodeId[n] + 1;
            int n2 = a.tailNodeId;
            connectionsByNodeId[n2] = connectionsByNodeId[n2] + 1;
        }
        int sum2 = 0;
        for (nodeId = 0; nodeId < connectionsByNodeId.length; ++nodeId) {
            int start = sum2;
            sum2 += connectionsByNodeId[nodeId];
            connectionsByNodeId[nodeId] = start;
        }
        for (int i = 0; i < this.arcs.size(); ++i) {
            ImmutableArcInst a = this.arcs.get(i);
            int n = a.tailNodeId;
            int n3 = connectionsByNodeId[n];
            connectionsByNodeId[n] = n3 + 1;
            connections[n3] = i * 2;
            int n4 = a.headNodeId;
            int n5 = connectionsByNodeId[n4];
            connectionsByNodeId[n4] = n5 + 1;
            connections[n5] = i * 2 + 1;
        }
        sum2 = 0;
        for (nodeId = 0; nodeId < connectionsByNodeId.length; ++nodeId) {
            sum2 = connectionsByNodeId[nodeId];
            int start = sum2;
            if (sum2 - 1 <= start) continue;
            this.sortConnections(connections, start, sum2 - 1);
        }
        this.connectionsRef = new SoftReference<int[]>(connections);
        return connections;
    }

    private void sortConnections(int[] connections, int l, int r) {
        while (r - l > 32) {
            int x = connections[l + r >>> 1];
            ImmutableArcInst ax = this.arcs.get(x >>> 1);
            boolean endx = (x & 1) != 0;
            PortProtoId portIdX = endx ? ax.headPortId : ax.tailPortId;
            int chronIndexX = portIdX.getChronIndex();
            int i = l;
            int j = r;
            while (true) {
                PortProtoId portId;
                int con = connections[i];
                ImmutableArcInst a = this.arcs.get(con >>> 1);
                boolean end = (con & 1) != 0;
                PortProtoId portProtoId = portId = end ? a.headPortId : a.tailPortId;
                if (portId.getChronIndex() <= chronIndexX && (portId.getChronIndex() != chronIndexX || con < x)) {
                    ++i;
                    continue;
                }
                while (true) {
                    con = connections[j];
                    a = this.arcs.get(con >>> 1);
                    end = (con & 1) != 0;
                    PortProtoId portProtoId2 = portId = end ? a.headPortId : a.tailPortId;
                    if (chronIndexX > portId.getChronIndex() || chronIndexX == portId.getChronIndex() && x >= con) break;
                    --j;
                }
                if (i <= j) {
                    int w = connections[i];
                    connections[i] = connections[j];
                    connections[j] = w;
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (j - l < r - i) {
                this.sortConnections(connections, l, j);
                l = i;
                continue;
            }
            this.sortConnections(connections, i, r);
            r = j;
        }
        this.binarySort(connections, l, r + 1);
    }

    private void binarySort(int[] connections, int lo, int hi) {
        PortProtoId portIdS;
        ImmutableArcInst aS;
        int conS;
        assert (lo <= hi);
        int start = lo + 1;
        if (start >= hi) {
            return;
        }
        int conL = connections[lo];
        ImmutableArcInst aL = this.arcs.get(conL >>> 1);
        PortProtoId portIdL = (conL & 1) != 0 ? aL.headPortId : aL.tailPortId;
        while (true) {
            conS = connections[start];
            aS = this.arcs.get(conS >>> 1);
            portIdS = (conS & 1) != 0 ? aS.headPortId : aS.tailPortId;
            int cmp = portIdS.chronIndex - portIdL.chronIndex;
            if (cmp < 0 || cmp == 0 && conS < conL) break;
            if (++start >= hi) {
                return;
            }
            conL = conS;
            aL = aS;
            portIdL = portIdS;
        }
        while (true) {
            assert (start < hi);
            int left = lo;
            int right = start;
            assert (left <= right);
            while (left < right) {
                int mid = left + right >>> 1;
                int conM = connections[mid];
                ImmutableArcInst aM = this.arcs.get(conM >>> 1);
                PortProtoId portIdM = (conM & 1) != 0 ? aM.headPortId : aM.tailPortId;
                int cmp = portIdS.chronIndex - portIdM.chronIndex;
                if (cmp == 0) {
                    cmp = conS - conM;
                }
                if (cmp < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            assert (left == right);
            int n = start - left;
            switch (n) {
                case 2: {
                    connections[left + 2] = connections[left + 1];
                }
                case 1: {
                    connections[left + 1] = connections[left];
                    break;
                }
                default: {
                    System.arraycopy(connections, left, connections, left + 1, n);
                }
            }
            connections[left] = conS;
            if (++start >= hi) {
                return;
            }
            conS = connections[start];
            aS = this.arcs.get(conS >>> 1);
            portIdS = (conS & 1) != 0 ? aS.headPortId : aS.tailPortId;
        }
    }

    private int compareConnections(int con1, int con2) {
        boolean end2;
        int nodeId2;
        ImmutableArcInst a1 = this.arcs.get(con1 >>> 1);
        ImmutableArcInst a2 = this.arcs.get(con2 >>> 1);
        boolean end1 = (con1 & 1) != 0;
        int nodeId1 = end1 ? a1.headNodeId : a1.tailNodeId;
        int cmp = nodeId1 - (nodeId2 = (end2 = (con2 & 1) != 0) ? a2.headNodeId : a2.tailNodeId);
        if (cmp != 0) {
            return cmp;
        }
        PortProtoId portId1 = end1 ? a1.headPortId : a1.tailPortId;
        PortProtoId portId2 = end2 ? a2.headPortId : a2.tailPortId;
        cmp = portId1.getChronIndex() - portId2.getChronIndex();
        if (cmp != 0) {
            return cmp;
        }
        return con1 - con2;
    }

    @Override
    public boolean hasExportsOnNode(ImmutableNodeInst originalNode) {
        if (this.getNodeById(originalNode.nodeId) != originalNode) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        int startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNode.nodeId, 0);
        if (startIndex >= exportIndexByOriginalPort.length) {
            return false;
        }
        ImmutableExport e = exportIndexByOriginalPort[startIndex];
        return e.originalNodeId == originalNode.nodeId;
    }

    @Override
    public int getNumExportsOnNode(ImmutableNodeInst originalNode) {
        int startIndex;
        int j;
        int originalNodeId = originalNode.nodeId;
        if (this.getNodeById(originalNodeId) != originalNode) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        for (j = startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNodeId, 0); j < exportIndexByOriginalPort.length; ++j) {
            ImmutableExport e = exportIndexByOriginalPort[j];
            if (e.originalNodeId != originalNodeId) break;
        }
        return j - startIndex;
    }

    @Override
    public Iterator<ImmutableExport> getExportsOnNode(ImmutableNodeInst originalNode) {
        int startIndex;
        int j;
        int originalNodeId = originalNode.nodeId;
        if (this.getNodeById(originalNodeId) != originalNode) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        for (j = startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNodeId, 0); j < exportIndexByOriginalPort.length; ++j) {
            ImmutableExport e = exportIndexByOriginalPort[j];
            if (e.originalNodeId != originalNodeId) break;
        }
        return ArrayIterator.iterator(exportIndexByOriginalPort, startIndex, j);
    }

    @Override
    public boolean hasExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        int originalNodeId = originalNode.nodeId;
        if (this.getNodeById(originalNodeId) != originalNode || portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        int startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNodeId, portId.chronIndex);
        if (startIndex >= exportIndexByOriginalPort.length) {
            return false;
        }
        ImmutableExport e = exportIndexByOriginalPort[startIndex];
        return e.originalNodeId == originalNodeId && e.originalPortId == portId;
    }

    @Override
    public int getNumExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        int startIndex;
        int j;
        int originalNodeId = originalNode.nodeId;
        if (this.getNodeById(originalNodeId) != originalNode || portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        for (j = startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNodeId, portId.chronIndex); j < exportIndexByOriginalPort.length; ++j) {
            ImmutableExport e = exportIndexByOriginalPort[j];
            if (e.originalNodeId != originalNodeId || e.originalPortId != portId) break;
        }
        return j - startIndex;
    }

    @Override
    public Iterator<ImmutableExport> getExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        int startIndex;
        int j;
        int originalNodeId = originalNode.nodeId;
        if (this.getNodeById(originalNodeId) != originalNode || portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        for (j = startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNodeId, portId.chronIndex); j < exportIndexByOriginalPort.length; ++j) {
            ImmutableExport e = exportIndexByOriginalPort[j];
            if (e.originalNodeId != originalNodeId || e.originalPortId != portId) break;
        }
        return ArrayIterator.iterator(exportIndexByOriginalPort, startIndex, j);
    }

    private static int searchExportByOriginalPort(ImmutableExport[] exportIndexByOriginalPort, int originalNodeId, int originalChronIndex) {
        int low = 0;
        int high = exportIndexByOriginalPort.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            ImmutableExport e = exportIndexByOriginalPort[mid];
            int cmp = e.originalNodeId - originalNodeId;
            if (cmp == 0) {
                int n = cmp = e.originalPortId.getChronIndex() >= originalChronIndex ? 1 : -1;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    private ImmutableExport[] getExportIndexByOriginalPort() {
        ImmutableExport[] exportIndexByOriginalPort = this.exportIndexByOriginalPortRef.get();
        return exportIndexByOriginalPort != null ? exportIndexByOriginalPort : this.makeExportIndexByOriginalPort();
    }

    private ImmutableExport[] makeExportIndexByOriginalPort() {
        ImmutableExport[] exportIndexByOriginalPort = this.exports.toArray();
        Arrays.sort(exportIndexByOriginalPort, BY_ORIGINAL_PORT);
        this.exportIndexByOriginalPortRef = new SoftReference<ImmutableExport[]>(exportIndexByOriginalPort);
        return exportIndexByOriginalPort;
    }

    @Override
    public long getConnectivityMemorySize(ObjSize objSize, boolean restore) {
        ImmutableExport[] exportIndexByOriginalPort;
        int[] connections;
        long s2 = 0L;
        int[] nArray = connections = restore ? this.getConnections() : this.connectionsRef.get();
        if (connections != null) {
            s2 += objSize.sizeOf(connections);
        }
        ImmutableExport[] immutableExportArray = exportIndexByOriginalPort = restore ? this.getExportIndexByOriginalPort() : this.exportIndexByOriginalPortRef.get();
        if (exportIndexByOriginalPort != null) {
            s2 += objSize.sizeOf(exportIndexByOriginalPort);
        }
        return s2;
    }

    @Override
    public void check() {
        ImmutableExport[] exportIndexByOriginalPort;
        super.check();
        int[] connections = this.connectionsRef.get();
        if (connections != null) {
            assert (connections.length == this.arcs.size() * 2);
            for (int i = 1; i < connections.length; ++i) {
                assert (this.compareConnections(connections[i - 1], connections[i]) < 0);
            }
        }
        if ((exportIndexByOriginalPort = this.exportIndexByOriginalPortRef.get()) != null) {
            assert (exportIndexByOriginalPort.length == this.exports.size());
            ImmutableExport prevE = null;
            for (ImmutableExport e : exportIndexByOriginalPort) {
                if (prevE != null) assert (BY_ORIGINAL_PORT.compare(prevE, e) < 0);
                assert (e == this.getExport(e.exportId));
                prevE = e;
            }
        }
        if (connections != null && exportIndexByOriginalPort != null) {
            this.checkConnectivity();
        }
    }
}

