/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.text.Setting;
import com.sun.electric.tool.extract.Extract;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NetworkTab
extends PreferencePanel {
    private Setting ignoreResistorsSetting = NetworkTool.getIgnoreResistorsSetting();
    private Setting includeDateAndVersionInOutputSetting = User.getIncludeDateAndVersionInOutputSetting();
    private ButtonGroup activeHandling;
    private JCheckBox extractApproximateCuts;
    private JTextField extractCellPattern;
    private JCheckBox extractFlattenPCells;
    private JCheckBox extractGridAlign;
    private JCheckBox extractIgnoreTiny;
    private JRadioButton extractIgnoreWellSelect;
    private JRadioButton extractNeedProperActive;
    private JCheckBox extractPureLayer;
    private JTextField extractSmallestPolygonSize;
    private JRadioButton extractUnifyNandP;
    private JCheckBox generalIncludeDateAndVersion;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JRadioButton netAscending;
    private ButtonGroup netDefaultOrder;
    private JRadioButton netDescending;
    private JCheckBox netIgnoreResistors;
    private JLabel netOrderingLabel;
    private JPanel nodeExtractionPreferences;
    private JPanel preferences;
    private JPanel projectSettings;

    public NetworkTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.extractSmallestPolygonSize);
        EDialog.makeTextFieldSelectAllOnTab(this.extractCellPattern);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.preferences;
    }

    @Override
    public JPanel getProjectPreferencesPanel() {
        return this.projectSettings;
    }

    @Override
    public String getName() {
        return "Network";
    }

    @Override
    public void init() {
        if (NetworkTool.isBusAscending()) {
            this.netAscending.setSelected(true);
        } else {
            this.netDescending.setSelected(true);
        }
        this.extractGridAlign.setSelected(Extract.isGridAlignExtraction());
        switch (Extract.getActiveHandling()) {
            case 0: {
                this.extractNeedProperActive.setSelected(true);
                break;
            }
            case 1: {
                this.extractUnifyNandP.setSelected(true);
                break;
            }
            case 2: {
                this.extractIgnoreWellSelect.setSelected(true);
            }
        }
        this.extractApproximateCuts.setSelected(Extract.isApproximateCuts());
        this.extractIgnoreTiny.setSelected(Extract.isIgnoreTinyPolygons());
        this.extractSmallestPolygonSize.setText(Double.toString(Extract.getSmallestPolygonSize()));
        this.extractCellPattern.setText(Extract.getCellExpandPattern());
        this.extractFlattenPCells.setSelected(Extract.isFlattenPcells());
        this.extractPureLayer.setSelected(Extract.isUsePureLayerNodes());
        this.netIgnoreResistors.setSelected(this.getBoolean(this.ignoreResistorsSetting));
        this.generalIncludeDateAndVersion.setSelected(this.getBoolean(this.includeDateAndVersionInOutputSetting));
    }

    @Override
    public void term() {
        double nowDouble;
        boolean nowBoolean = this.netAscending.isSelected();
        if (NetworkTool.isBusAscending() != nowBoolean) {
            NetworkTool.setBusAscending(nowBoolean);
        }
        nowBoolean = this.extractGridAlign.isSelected();
        if (Extract.isGridAlignExtraction() != nowBoolean) {
            Extract.setGridAlignExtraction(nowBoolean);
        }
        int nowInt = 0;
        if (this.extractUnifyNandP.isSelected()) {
            nowInt = 1;
        } else if (this.extractIgnoreWellSelect.isSelected()) {
            nowInt = 2;
        }
        if (Extract.getActiveHandling() != nowInt) {
            Extract.setActiveHandling(nowInt);
        }
        nowBoolean = this.extractApproximateCuts.isSelected();
        if (Extract.isApproximateCuts() != nowBoolean) {
            Extract.setApproximateCuts(nowBoolean);
        }
        nowBoolean = this.extractIgnoreTiny.isSelected();
        if (Extract.isIgnoreTinyPolygons() != nowBoolean) {
            Extract.setIgnoreTinyPolygons(nowBoolean);
        }
        if ((nowDouble = TextUtils.atof(this.extractSmallestPolygonSize.getText())) != Extract.getSmallestPolygonSize()) {
            Extract.setSmallestPolygonSize(nowDouble);
        }
        String nowString = this.extractCellPattern.getText();
        if (!Extract.getCellExpandPattern().equals(nowString)) {
            Extract.setCellExpandPattern(nowString);
        }
        nowBoolean = this.extractFlattenPCells.isSelected();
        if (Extract.isFlattenPcells() != nowBoolean) {
            Extract.setFlattenPcells(nowBoolean);
        }
        nowBoolean = this.extractPureLayer.isSelected();
        if (Extract.isUsePureLayerNodes() != nowBoolean) {
            Extract.setUsePureLayerNodes(nowBoolean);
        }
        this.setBoolean(this.ignoreResistorsSetting, this.netIgnoreResistors.isSelected());
        this.setBoolean(this.includeDateAndVersionInOutputSetting, this.generalIncludeDateAndVersion.isSelected());
    }

    @Override
    public void reset() {
        if (NetworkTool.isFactoryBusAscending() != NetworkTool.isBusAscending()) {
            NetworkTool.setBusAscending(NetworkTool.isFactoryBusAscending());
        }
        if (Extract.isFactoryGridAlignExtraction() != Extract.isGridAlignExtraction()) {
            Extract.setGridAlignExtraction(Extract.isFactoryGridAlignExtraction());
        }
        if (Extract.isFactoryApproximateCuts() != Extract.isApproximateCuts()) {
            Extract.setApproximateCuts(Extract.isFactoryApproximateCuts());
        }
        if (Extract.getFactoryActiveHandling() != Extract.getActiveHandling()) {
            Extract.setActiveHandling(Extract.getFactoryActiveHandling());
        }
        if (Extract.isFactoryIgnoreTinyPolygons() != Extract.isIgnoreTinyPolygons()) {
            Extract.setIgnoreTinyPolygons(Extract.isFactoryIgnoreTinyPolygons());
        }
        if (Extract.getFactorySmallestPolygonSize() != Extract.getSmallestPolygonSize()) {
            Extract.setSmallestPolygonSize(Extract.getFactorySmallestPolygonSize());
        }
        if (!Extract.getFactoryCellExpandPattern().equals(Extract.getCellExpandPattern())) {
            Extract.setCellExpandPattern(Extract.getFactoryCellExpandPattern());
        }
        if (Extract.isFactoryFlattenPcells() != Extract.isFlattenPcells()) {
            Extract.setFlattenPcells(Extract.isFactoryFlattenPcells());
        }
        if (Extract.isFactoryUsePureLayerNodes() != Extract.isUsePureLayerNodes()) {
            Extract.setUsePureLayerNodes(Extract.isFactoryUsePureLayerNodes());
        }
    }

    private void initComponents() {
        this.netDefaultOrder = new ButtonGroup();
        this.activeHandling = new ButtonGroup();
        this.preferences = new JPanel();
        this.netOrderingLabel = new JLabel();
        this.netAscending = new JRadioButton();
        this.netDescending = new JRadioButton();
        this.nodeExtractionPreferences = new JPanel();
        this.extractGridAlign = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.extractCellPattern = new JTextField();
        this.extractSmallestPolygonSize = new JTextField();
        this.extractApproximateCuts = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.extractNeedProperActive = new JRadioButton();
        this.extractUnifyNandP = new JRadioButton();
        this.extractIgnoreWellSelect = new JRadioButton();
        this.extractIgnoreTiny = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.extractFlattenPCells = new JCheckBox();
        this.extractPureLayer = new JCheckBox();
        this.projectSettings = new JPanel();
        this.generalIncludeDateAndVersion = new JCheckBox();
        this.netIgnoreResistors = new JCheckBox();
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NetworkTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.preferences.setLayout(new GridBagLayout());
        this.netOrderingLabel.setText("Default bus order:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.preferences.add((Component)this.netOrderingLabel, gridBagConstraints);
        this.netDefaultOrder.add(this.netAscending);
        this.netAscending.setText("Ascending (0:N)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.preferences.add((Component)this.netAscending, gridBagConstraints);
        this.netDefaultOrder.add(this.netDescending);
        this.netDescending.setText("Descending (N:0)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.preferences.add((Component)this.netDescending, gridBagConstraints);
        this.nodeExtractionPreferences.setBorder(BorderFactory.createTitledBorder("Node Extraction"));
        this.nodeExtractionPreferences.setLayout(new GridBagLayout());
        this.extractGridAlign.setText("Grid-align to minimum technology resolution");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.nodeExtractionPreferences.add((Component)this.extractGridAlign, gridBagConstraints);
        this.jLabel1.setText("Flatten cells whose names match this (comma-separated):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.nodeExtractionPreferences.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.nodeExtractionPreferences.add((Component)this.extractCellPattern, gridBagConstraints);
        this.extractSmallestPolygonSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        this.nodeExtractionPreferences.add((Component)this.extractSmallestPolygonSize, gridBagConstraints);
        this.extractApproximateCuts.setText("Approximate cut placement");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.nodeExtractionPreferences.add((Component)this.extractApproximateCuts, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Active Handling", 2, 0));
        this.jPanel2.setLayout(new GridBagLayout());
        this.activeHandling.add(this.extractNeedProperActive);
        this.extractNeedProperActive.setText("Require separate N and P active; require proper select/well");
        this.extractNeedProperActive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.jPanel2.add((Component)this.extractNeedProperActive, gridBagConstraints);
        this.activeHandling.add(this.extractUnifyNandP);
        this.extractUnifyNandP.setText("Ignore N vs. P active; require proper select/well");
        this.extractUnifyNandP.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.extractUnifyNandP.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.jPanel2.add((Component)this.extractUnifyNandP, gridBagConstraints);
        this.activeHandling.add(this.extractIgnoreWellSelect);
        this.extractIgnoreWellSelect.setText("Require separate N and P active; ignore select/well");
        this.extractIgnoreWellSelect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.extractIgnoreWellSelect.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.jPanel2.add((Component)this.extractIgnoreWellSelect, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 2, 4, 2);
        this.nodeExtractionPreferences.add((Component)this.jPanel2, gridBagConstraints);
        this.extractIgnoreTiny.setText("Ignore polygons smaller than:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 1);
        this.nodeExtractionPreferences.add((Component)this.extractIgnoreTiny, gridBagConstraints);
        this.jLabel2.setText("square units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 1, 2, 4);
        this.nodeExtractionPreferences.add((Component)this.jLabel2, gridBagConstraints);
        this.extractFlattenPCells.setText("Flatten Cadence Pcells (with $$number at end of name)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.nodeExtractionPreferences.add((Component)this.extractFlattenPCells, gridBagConstraints);
        this.extractPureLayer.setText("Use pure-layer nodes for connectivity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.nodeExtractionPreferences.add((Component)this.extractPureLayer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.preferences.add((Component)this.nodeExtractionPreferences, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.preferences, gridBagConstraints);
        this.projectSettings.setLayout(new GridBagLayout());
        this.generalIncludeDateAndVersion.setText("Include date and version in output files");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.projectSettings.add((Component)this.generalIncludeDateAndVersion, gridBagConstraints);
        this.netIgnoreResistors.setText("Ignore Resistors when building netlists");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.projectSettings.add((Component)this.netIgnoreResistors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.projectSettings, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

