/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.extract.GeometrySearch;
import com.sun.electric.tool.user.CellChangeJobs;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.CellLists;
import com.sun.electric.tool.user.dialogs.CellProperties;
import com.sun.electric.tool.user.dialogs.CrossLibCopy;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.NewCell;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CellMenu {
    static EMenu makeMenu() {
        return new EMenu("_Cell", new EMenuItem("Ne_w Cell...", 'N'){

            @Override
            public void run() {
                CellMenu.newCellCommand();
            }
        }, new EMenuItem("_Edit Cell..."){

            @Override
            public void run() {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.editCell);
            }
        }, new EMenuItem("_Place Cell Instance...", KeyStroke.getKeyStroke(78, 0)){

            @Override
            public void run() {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.newInstance);
            }
        }, new EMenuItem("_Rename Cell..."){

            @Override
            public void run() {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.renameCell);
            }
        }, new EMenuItem("Duplic_ate Cell..."){

            @Override
            public void run() {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.duplicateCell);
            }
        }, new EMenuItem("De_lete Cell..."){

            @Override
            public void run() {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.deleteCell);
            }
        }, new EMenu("_Multi-Page Cells", new EMenuItem("_Make Cell Multi-Page"){

            @Override
            public void run() {
                CellMenu.makeMultiPageCell();
            }
        }, new EMenuItem("_Create New Page"){

            @Override
            public void run() {
                CellMenu.createNewMultiPage();
            }
        }, new EMenuItem("_Delete This Page"){

            @Override
            public void run() {
                CellMenu.deleteThisMultiPage();
            }
        }, new EMenuItem("_Edit Next Page"){

            @Override
            public void run() {
                CellMenu.editNextMultiPage();
            }
        }, new EMenuItem("Con_vert old-style Multi-Page Schematics"){

            @Override
            public void run() {
                ViewChanges.convertMultiPageViews();
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("_Cross-Library Copy..."){

            @Override
            public void run() {
                CellMenu.crossLibraryCopyCommand();
            }
        }, new EMenu("Merge Li_braries", new EMenuItem("_Add Exports from Library..."){

            @Override
            public void run() {
                ExportChanges.synchronizeLibrary();
            }
        }, new EMenuItem("_Replace Cells from Library..."){

            @Override
            public void run() {
                ExportChanges.replaceFromOtherLibrary();
            }
        }), EMenuItem.SEPARATOR, new EMenu("_Down Hierarchy", new EMenuItem("_Down Hierarchy", 'D'){

            @Override
            public void run() {
                CellMenu.downHierCommand(false, false);
            }
        }, new EMenuItem("Down Hierarchy, Keep _Focus"){

            @Override
            public void run() {
                CellMenu.downHierCommand(true, false);
            }
        }, new EMenuItem("Down Hierarchy, New _Window"){

            @Override
            public void run() {
                CellMenu.downHierCommand(false, true);
            }
        }, new EMenuItem("Down Hierarchy, _Keep Focus, New Window"){

            @Override
            public void run() {
                CellMenu.downHierCommand(true, true);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Down Hierarchy In _Place", KeyStroke.getKeyStroke(68, 0)){

            @Override
            public void run() {
                CellMenu.downHierInPlaceCommand();
            }
        }, new EMenuItem("Down Hierarchy In Place To Object", KeyStroke.getKeyStroke(68, 1)){

            @Override
            public void run() {
                CellMenu.downHierInPlaceToObject();
            }
        }), new EMenu("_Up Hierarchy", new EMenuItem("_Up Hierarchy", 'U'){

            @Override
            public void run() {
                CellMenu.upHierCommand(false);
            }
        }, new EMenuItem("Up Hierarchy, Keep _Focus"){

            @Override
            public void run() {
                CellMenu.upHierCommand(true);
            }
        }), new EMenu("Cell Viewing Histor_y", new EMenuItem("Go _Back a Cell"){

            @Override
            public void run() {
                CellMenu.changeCellHistory(true);
            }
        }, new EMenuItem("Go _Forward a Cell"){

            @Override
            public void run() {
                CellMenu.changeCellHistory(false);
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("New _Version of Current Cell"){

            @Override
            public void run() {
                CellMenu.newCellVersionCommand();
            }
        }, new EMenuItem("Duplicate Curre_nt Cell"){

            @Override
            public void run() {
                CellMenu.duplicateCellCommand();
            }
        }, new EMenuItem("Delete Unused _Old Versions"){

            @Override
            public void run() {
                CellMenu.deleteOldCellVersionsCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenu("Cell In_fo", new EMenuItem("_Describe this Cell"){

            @Override
            public void run() {
                CellLists.describeThisCellCommand();
            }
        }, new EMenuItem("_General Cell Lists..."){

            @Override
            public void run() {
                CellLists.generalCellListsCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Summarize Cell Contents"){

            @Override
            public void run() {
                CellLists.designSummaryCommand();
            }
        }, new EMenuItem("List _Nodes/Arcs in this Cell"){

            @Override
            public void run() {
                CellLists.listNodesAndArcsInCellCommand();
            }
        }, new EMenuItem("List Cell _Instances"){

            @Override
            public void run() {
                CellLists.listCellInstancesCommand();
            }
        }, new EMenuItem("List Cell _Usage"){

            @Override
            public void run() {
                CellLists.listCellUsageCommand(false);
            }
        }, new EMenuItem("List Cell Usage, _Hierarchically"){

            @Override
            public void run() {
                CellLists.listCellUsageCommand(true);
            }
        }, new EMenuItem("Number of _Transistors"){

            @Override
            public void run() {
                CellLists.numberOfTransistorsCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Cell Graph, _Entire Library"){

            @Override
            public void run() {
                CircuitChanges.graphCellsInLibrary();
            }
        }, new EMenuItem("Cell Graph, _From Current Cell"){

            @Override
            public void run() {
                CircuitChanges.graphCellsFromCell();
            }
        }, new EMenuItem("_Library Graph"){

            @Override
            public void run() {
                CircuitChanges.graphLibraries();
            }
        }), new EMenuItem("Cell Propertie_s..."){

            @Override
            public void run() {
                CellMenu.cellControlCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenu("E_xpand Cell Instances", ToolBar.expandOneLevelCommand, new EMenuItem("_All the Way"){

            @Override
            public void run() {
                CircuitChanges.DoExpandCommands(false, Integer.MAX_VALUE);
            }
        }, new EMenuItem("_Specified Amount..."){

            @Override
            public void run() {
                CircuitChanges.DoExpandCommands(false, -1);
            }
        }), new EMenu("Unexpand Cell Ins_tances", ToolBar.unexpandOneLevelCommand, new EMenuItem("_All the Way"){

            @Override
            public void run() {
                CircuitChanges.DoExpandCommands(true, Integer.MAX_VALUE);
            }
        }, new EMenuItem("_Specified Amount..."){

            @Override
            public void run() {
                CircuitChanges.DoExpandCommands(true, -1);
            }
        }), new EMenuItem("Loo_k Inside Highlighted", 'P'){

            @Override
            public void run() {
                CellMenu.peekCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Packa_ge Into Cell..."){

            @Override
            public void run() {
                CircuitChanges.packageIntoCell();
            }
        }, new EMenu("Extract Cell _Instance", new EMenuItem("_One Level Down"){

            @Override
            public void run() {
                CircuitChanges.extractCells(1);
            }
        }, new EMenuItem("_All the Way"){

            @Override
            public void run() {
                CircuitChanges.extractCells(Integer.MAX_VALUE);
            }
        }, new EMenuItem("_Specified Amount..."){

            @Override
            public void run() {
                CircuitChanges.extractCells(-1);
            }
        }));
    }

    private static void cellControlCommand() {
        CellProperties dialog = new CellProperties(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    private static void newCellCommand() {
        NewCell dialog = new NewCell((Frame)TopLevel.getCurrentJFrame(), null);
        dialog.setVisible(true);
    }

    public static void cellBrowserCommand(CellBrowser.DoAction action) {
        CellBrowser dialog = new CellBrowser((Frame)TopLevel.getCurrentJFrame(), false, action);
        dialog.setVisible(true);
    }

    private static void makeMultiPageCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (!cell.isSchematic()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Only Schematic cells can be made multi-page", "Cannot make multipage design", 0);
            return;
        }
        new SetMultiPageJob(cell, 1);
    }

    private static void createNewMultiPage() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (!cell.isMultiPage()) {
            System.out.println("First turn this cell into a multi-page schematic");
            return;
        }
        int numPages = cell.getNumMultiPages();
        new SetMultiPageJob(cell, numPages + 1);
        wnd.setMultiPageNumber(numPages);
    }

    private static void deleteThisMultiPage() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (!cell.isMultiPage()) {
            System.out.println("This is not a multi-page schematic.  To delete this cell, use 'Cell / Delete Cell'");
            return;
        }
        int curPage = wnd.getMultiPageNumber();
        new DeleteMultiPageJob(cell, curPage);
        int numPages = cell.getNumMultiPages();
        if (curPage >= numPages) {
            wnd.setMultiPageNumber(numPages - 1);
        }
    }

    private static void editNextMultiPage() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (!cell.isMultiPage()) {
            System.out.println("First turn this cell into a multi-page schematic");
            return;
        }
        int curPage = wnd.getMultiPageNumber();
        int numPages = cell.getNumMultiPages();
        wnd.setMultiPageNumber((curPage + 1) % numPages);
    }

    private static void crossLibraryCopyCommand() {
        CrossLibCopy dialog = new CrossLibCopy(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    private static void downHierCommand(boolean keepFocus, boolean newWindow) {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        curEdit.downHierarchy(keepFocus, newWindow, false);
    }

    private static void downHierInPlaceCommand() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        curEdit.downHierarchy(false, false, true);
    }

    private static void downHierInPlaceToObject() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        Cell cell = curEdit.getCell();
        if (cell == null) {
            return;
        }
        if (cell.getView() != View.LAYOUT) {
            System.out.println("Current cell should be a layout cell for 'Down Hierarchy In Place To Object'");
            return;
        }
        Point2D mouse = ClickZoomWireListener.theOne.getLastMouse();
        Point2D mouseDB = curEdit.screenToDatabase((int)mouse.getX(), (int)mouse.getY());
        EPoint point = EPoint.fromLambda(mouseDB.getX(), mouseDB.getY());
        GeometrySearch.GeometrySearchResult foundAtTopLevel = null;
        GeometrySearch search = new GeometrySearch(curEdit.getLayerVisibility(), curEdit.getGraphicsPreferences());
        List<GeometrySearch.GeometrySearchResult> possibleTargets = search.searchGeometries(cell, point, true);
        for (int i = 0; i < possibleTargets.size(); ++i) {
            GeometrySearch.GeometrySearchResult res = possibleTargets.get(i);
            if (res.getContext() == VarContext.globalContext) {
                possibleTargets.remove(i);
                --i;
                foundAtTopLevel = res;
                continue;
            }
            for (int j = 0; j < i; ++j) {
                GeometrySearch.GeometrySearchResult oRes = possibleTargets.get(j);
                if (!CellMenu.sameContext(oRes.getContext(), res.getContext())) continue;
                possibleTargets.remove(i);
                --i;
            }
        }
        if (possibleTargets.size() == 0) {
            if (foundAtTopLevel != null) {
                System.out.println(foundAtTopLevel.describe() + " is at the top level, not down the hierarchy");
            } else {
                System.out.println("No primitive node or arc found under the mouse at lower levels of hierarchy");
            }
            return;
        }
        if (possibleTargets.size() == 1) {
            CellMenu.descendToObject(possibleTargets.get(0));
        } else {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Multiple objects under the cursor...choose one");
            menu.add(menuItem);
            menu.addSeparator();
            for (GeometrySearch.GeometrySearchResult res : possibleTargets) {
                menuItem = new JMenuItem(res.describe());
                menuItem.addActionListener(new DownHierToObjectActionListener(res));
                menu.add(menuItem);
            }
            menu.show(curEdit, 100, 100);
        }
    }

    private static boolean sameContext(VarContext vc1, VarContext vc2) {
        if (vc1.getNumLevels() != vc2.getNumLevels()) {
            return false;
        }
        while (vc1.getNodable() != null && vc2.getNodable() != null) {
            if (vc1.getNodable() != vc2.getNodable()) {
                return false;
            }
            vc1 = vc1.pop();
            vc2 = vc2.pop();
        }
        return true;
    }

    private static void descendToObject(GeometrySearch.GeometrySearchResult res) {
        EditWindow curEdit = EditWindow.needCurrent();
        System.out.println("Descending to cell " + res.getGeometric().getParent().getName());
        Iterator<Nodable> it = res.getContext().getPathIterator();
        while (it.hasNext()) {
            Nodable no = it.next();
            Cell curCell = no.getParent();
            curEdit.getHighlighter().clear();
            curEdit.getHighlighter().addElectricObject(no.getNodeInst(), curCell);
            curEdit.getHighlighter().finished();
            System.out.println("  Descended into " + no.getName() + "[" + no.getProto().getName() + "] in cell " + curCell.getName());
            curEdit.downHierarchy(false, false, true);
        }
        curEdit.getHighlighter().clear();
        curEdit.getHighlighter().addElectricObject(res.getGeometric(), res.getGeometric().getParent());
        curEdit.getHighlighter().finished();
    }

    private static void upHierCommand(boolean keepFocus) {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        curEdit.upHierarchy(keepFocus);
    }

    private static void changeCellHistory(boolean back) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (back) {
            wf.cellHistoryGoBack();
        } else {
            wf.cellHistoryGoForward();
        }
    }

    private static void newCellVersionCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        CircuitChanges.newVersionOfCell(curCell);
    }

    private static void duplicateCellCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        new NewCellName(false, curCell);
    }

    private static void deleteOldCellVersionsCommand() {
        int oldUnusedCurrent = 0;
        int oldUnusedElsewhere = 0;
        for (Library lib : Library.getVisibleLibraries()) {
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (cell.getNewestVersion() == cell || cell.getInstancesOf().hasNext()) continue;
                if (lib == Library.getCurrent()) {
                    ++oldUnusedCurrent;
                    continue;
                }
                ++oldUnusedElsewhere;
            }
        }
        if (oldUnusedCurrent + oldUnusedElsewhere != 0 && oldUnusedElsewhere != 0) {
            String[] options = new String[]{"Current library", "Other libraries", "All libraries", "Cancel"};
            int ret = Job.getUserInterface().askForChoice("There are " + oldUnusedCurrent + " old unused cells in the current library and " + oldUnusedElsewhere + " in other libraries.  Which libraries should have their old unused cells deleted?", "Which Old Unused Cells to Delete", options, "No");
            if (ret == 0) {
                oldUnusedElsewhere = 0;
            }
            if (ret == 1) {
                oldUnusedCurrent = 0;
            }
            if (ret == 3) {
                return;
            }
        }
        if (oldUnusedCurrent == 0 && oldUnusedElsewhere == 0) {
            System.out.println("There are no old unused cells to delete");
            return;
        }
        ArrayList<Cell> cellsToDelete = new ArrayList<Cell>();
        for (Library lib : Library.getVisibleLibraries()) {
            if (lib == Library.getCurrent() ? oldUnusedCurrent == 0 : oldUnusedElsewhere == 0) continue;
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (cell.getNewestVersion() == cell || cell.getInstancesOf().hasNext()) continue;
                CircuitChanges.cleanCellRef(cell);
                cellsToDelete.add(cell);
            }
        }
        new CellChangeJobs.DeleteManyCells(cellsToDelete);
    }

    private static void peekCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
        if (bounds == null) {
            System.out.println("Must define an area in which to display");
            return;
        }
        wnd.repaintContents(ERectangle.fromLambda(bounds), true);
    }

    public static class NewCellName
    extends EDialog {
        private JTextField cellName;
        private Cell cell;
        private boolean allInGroup;

        public NewCellName(boolean allInGroup, Cell cell) {
            super((Frame)TopLevel.getCurrentJFrame(), true);
            this.allInGroup = allInGroup;
            this.cell = cell;
            this.setTitle(allInGroup ? "New Group Name" : "New Cell Name");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    NewCellName.this.closeDialog();
                }
            });
            this.getContentPane().setLayout(new GridBagLayout());
            String prompt = "Name of duplicated cell";
            if (allInGroup) {
                prompt = prompt + " group";
            }
            JLabel lab = new JLabel(prompt + ":");
            lab.setHorizontalAlignment(2);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab, gbc);
            String oldCellName = cell.getName();
            String newName = oldCellName + "NEW";
            this.cellName = new JTextField(newName);
            this.cellName.setSelectionStart(oldCellName.length());
            this.cellName.setSelectionEnd(newName.length());
            this.cellName.setColumns(Math.max(20, newName.length()));
            this.cellName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewCellName.this.ok();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.cellName, gbc);
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewCellName.this.closeDialog();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            JButton ok = new JButton("OK");
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewCellName.this.ok();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            this.getRootPane().setDefaultButton(ok);
            this.pack();
            this.finishInitialization();
            this.setVisible(true);
        }

        @Override
        protected void escapePressed() {
            this.closeDialog();
        }

        private void ok() {
            int response;
            String newName = this.cellName.getText();
            this.closeDialog();
            Cell already = this.cell.getLibrary().findNodeProto(newName);
            if (already != null && already.getView() == this.cell.getView() && (response = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Cell " + newName + " already exists.  Make this a new version?", "Confirm duplication", -1, 2, null, new String[]{"Yes", "Cancel"}, "Yes")) != 0) {
                return;
            }
            new CellChangeJobs.DuplicateCell(this.cell, newName, this.cell.getLibrary(), this.allInGroup, false);
        }
    }

    private static class DownHierToObjectActionListener
    implements ActionListener {
        GeometrySearch.GeometrySearchResult result;

        DownHierToObjectActionListener(GeometrySearch.GeometrySearchResult r) {
            this.result = r;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellMenu.descendToObject(this.result);
        }
    }

    public static class DeleteMultiPageJob
    extends Job {
        private Cell cell;
        private int page;
        private int numPages;

        public DeleteMultiPageJob(Cell cell, int page) {
            super("Delete Page from Multi-Page Schematic", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.page = page;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            double lY = (double)this.page * 1000.0 - 500.0;
            double hY = lY + 1000.0;
            ArrayList<Geometric> deleteList = new ArrayList<Geometric>();
            Iterator<Geometric> it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!(ni.getAnchorCenterY() > lY) || !(ni.getAnchorCenterY() < hY)) continue;
                deleteList.add(ni);
            }
            it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                double ctrY = ai.getBounds().getCenterY();
                if (!(ctrY > lY) || !(ctrY < hY)) continue;
                deleteList.add(ai);
            }
            CircuitChangeJobs.eraseObjectsInList(this.cell, deleteList, false, null, ep);
            this.numPages = this.cell.getNumMultiPages();
            if (this.page + 1 < this.numPages) {
                CircuitChangeJobs.spreadCircuitry(this.cell, null, 'u', -1000.0, 0.0, 0.0, lY, hY);
            }
            this.cell.newVar(Cell.MULTIPAGE_COUNT_KEY, (Object)new Integer(this.numPages - 1), ep);
            this.fieldVariableChanged("numPages");
            return true;
        }

        @Override
        public void terminateOK() {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                int wndPage;
                EditWindow wnd;
                WindowFrame wf = it.next();
                if (!(wf.getContent() instanceof EditWindow) || (wnd = (EditWindow)wf.getContent()).getCell() != this.cell || (wndPage = wnd.getMultiPageNumber()) + 1 < this.numPages) continue;
                wnd.setMultiPageNumber(wndPage - 1);
            }
        }
    }

    public static class SetMultiPageJob
    extends Job {
        private Cell cell;
        private int numPages;

        public SetMultiPageJob(Cell cell, int numPages) {
            super("Make Cell be Multi-Page", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.numPages = numPages;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            Dimension d = new Dimension(0, 0);
            if (Cell.FrameDescription.getCellFrameInfo(this.cell, d) != 0) {
                this.cell.newVar(User.FRAME_SIZE, (Object)"a", ep);
                System.out.println("Multi-page schematics must have cell frames turned on.  Setting this to A-size.");
            }
            boolean wasMulti = this.cell.isMultiPage();
            this.cell.setMultiPage(true);
            this.cell.newVar(Cell.MULTIPAGE_COUNT_KEY, (Object)new Integer(this.numPages), ep);
            if (!wasMulti) {
                System.out.println("Cell " + this.cell.describe(true) + " is now a multi-page schematic");
            }
            return true;
        }
    }
}

