/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.util.ElapseTimer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SeaOfGates {
    public static void seaOfGatesRoute(boolean justSubCells) {
        if (justSubCells) {
            UserInterface ui = Job.getUserInterface();
            Cell cell = ui.needCurrentCell();
            if (cell == null) {
                return;
            }
            HashSet<Cell> subCells = new HashSet<Cell>();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                subCells.add((Cell)ni.getProto());
            }
            for (Cell subCell : subCells) {
                ArrayList<ArcInst> selected = new ArrayList<ArcInst>();
                Iterator<ArcInst> it2 = subCell.getArcs();
                while (it2.hasNext()) {
                    ArcInst ai = it2.next();
                    if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                    selected.add(ai);
                }
                if (selected.isEmpty()) continue;
                SeaOfGatesHandlers.startInJob(subCell, selected, SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
            }
        } else {
            SeaOfGates.seaOfGatesRoute(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        }
    }

    public static void seaOfGatesRoute(SeaOfGatesEngineFactory.SeaOfGatesEngineType version) {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        List<ArcInst> selected = SeaOfGates.getSelected();
        if (selected == null) {
            return;
        }
        if (selected.isEmpty()) {
            ui.showErrorMessage("There are no Unrouted Arcs in this cell", "Routing Error");
            return;
        }
        SeaOfGatesHandlers.startInJob(cell, selected, version);
    }

    public static void seaOfGatesRoute(EditingPreferences ep, SeaOfGatesEngine router) {
        if (router == null) {
            throw new NullPointerException();
        }
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        List<ArcInst> selected = SeaOfGates.getSelected();
        if (selected.isEmpty()) {
            ui.showErrorMessage("There are no Unrouted Arcs in this cell", "Routing Error");
            return;
        }
        Job job = Job.getRunningJob();
        router.routeIt(SeaOfGatesHandlers.getDefault(cell, job, ep), cell, selected);
    }

    private static List<ArcInst> getSelected() {
        EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
        if (wnd == null) {
            return null;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return null;
        }
        ArrayList<ArcInst> selected = new ArrayList<ArcInst>();
        List<Geometric> highlighted = wnd.getHighlightedEObjs(false, true);
        for (Geometric h : highlighted) {
            ArcInst ai = (ArcInst)h;
            if (ai.getProto() != Generic.tech().unrouted_arc) continue;
            selected.add(ai);
        }
        if (selected.isEmpty()) {
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                selected.add(ai);
            }
        }
        return selected;
    }

    public static class SeaOfGatesCellParameters
    implements Serializable {
        private Cell cell;
        private boolean steinerDone;
        private boolean favorHorVer;
        private boolean horEven;
        private Map<ArcProto, String> gridSpacing;
        private Set<ArcProto> preventedArcs;
        private Set<ArcProto> favoredArcs;
        private static final Variable.Key ROUTING_SOG_PARAMETERS_KEY = Variable.newKey("ATTR_ROUTING_SOG_PARAMETERS");

        public SeaOfGatesCellParameters(Cell cell) {
            this.cell = cell;
            this.steinerDone = false;
            this.favorHorVer = true;
            this.horEven = false;
            this.gridSpacing = new HashMap<ArcProto, String>();
            this.preventedArcs = new HashSet<ArcProto>();
            this.favoredArcs = new HashSet<ArcProto>();
            Variable var = cell.getVar(ROUTING_SOG_PARAMETERS_KEY);
            if (var != null) {
                String[] lines2 = (String[])var.getObject();
                for (int i = 0; i < lines2.length; ++i) {
                    ArcProto ap;
                    Technology tech;
                    String layerName;
                    String techName;
                    int colonPos;
                    String[] parts = lines2[i].split(" ");
                    if (parts.length <= 0 || parts[0].startsWith(";")) continue;
                    if (parts[0].equalsIgnoreCase("SteinerTreesDone")) {
                        this.steinerDone = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("IgnoreHorVer")) {
                        this.favorHorVer = false;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("HorizontalEven")) {
                        this.horEven = true;
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcGrid") && parts.length >= 3) {
                        colonPos = parts[1].indexOf(58);
                        if (colonPos < 0) continue;
                        techName = parts[1].substring(0, colonPos);
                        layerName = parts[1].substring(colonPos + 1);
                        tech = Technology.findTechnology(techName);
                        ap = tech.findArcProto(layerName);
                        this.gridSpacing.put(ap, parts[2]);
                        continue;
                    }
                    if (parts[0].equalsIgnoreCase("ArcAvoid") && parts.length >= 2) {
                        colonPos = parts[1].indexOf(58);
                        if (colonPos < 0) continue;
                        techName = parts[1].substring(0, colonPos);
                        layerName = parts[1].substring(colonPos + 1);
                        tech = Technology.findTechnology(techName);
                        ap = tech.findArcProto(layerName);
                        this.preventedArcs.add(ap);
                        continue;
                    }
                    if (!parts[0].equalsIgnoreCase("ArcFavor") || parts.length < 2 || (colonPos = parts[1].indexOf(58)) < 0) continue;
                    techName = parts[1].substring(0, colonPos);
                    layerName = parts[1].substring(colonPos + 1);
                    tech = Technology.findTechnology(techName);
                    ap = tech.findArcProto(layerName);
                    this.favoredArcs.add(ap);
                }
            }
        }

        public void saveParameters(EditingPreferences ep) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.add("; Parameters for Cell " + this.cell.describe(false));
            if (this.steinerDone) {
                strings.add("SteinerTreesDone");
            }
            if (!this.favorHorVer) {
                strings.add("IgnoreHorVer");
            }
            if (this.horEven) {
                strings.add("HorizontalEven");
            }
            for (ArcProto ap : this.gridSpacing.keySet()) {
                String grid = this.gridSpacing.get(ap);
                strings.add("ArcGrid " + ap.getTechnology().getTechName() + ":" + ap.getName() + " " + grid);
            }
            for (ArcProto ap : this.preventedArcs) {
                strings.add("ArcAvoid " + ap.getTechnology().getTechName() + ":" + ap.getName());
            }
            for (ArcProto ap : this.favoredArcs) {
                strings.add("ArcFavor " + ap.getTechnology().getTechName() + ":" + ap.getName());
            }
            String[] paramArray = new String[strings.size()];
            for (int i = 0; i < strings.size(); ++i) {
                paramArray[i] = (String)strings.get(i);
            }
            this.cell.newVar(ROUTING_SOG_PARAMETERS_KEY, (Object)paramArray, ep);
        }

        public void setSteinerDone(boolean sd) {
            this.steinerDone = sd;
        }

        public boolean isSteinerDone() {
            return this.steinerDone;
        }

        public void setFavorHorVer(boolean f2) {
            this.favorHorVer = f2;
        }

        public boolean isFavorHorVer() {
            return this.favorHorVer;
        }

        public void setHorizontalEven(boolean he) {
            this.horEven = he;
        }

        public boolean isHorizontalEven() {
            return this.horEven;
        }

        public void setPrevented(ArcProto ap, boolean prevent) {
            if (prevent) {
                this.preventedArcs.add(ap);
            } else {
                this.preventedArcs.remove(ap);
            }
        }

        public boolean isPrevented(ArcProto ap) {
            return this.preventedArcs.contains(ap);
        }

        public void setFavored(ArcProto ap, boolean prevent) {
            if (prevent) {
                this.favoredArcs.add(ap);
            } else {
                this.favoredArcs.remove(ap);
            }
        }

        public boolean isFavored(ArcProto ap) {
            return this.favoredArcs.contains(ap);
        }

        public String getGrid(ArcProto ap) {
            String v = this.gridSpacing.get(ap);
            return v;
        }

        public void setGrid(ArcProto ap, String grid) {
            if (grid == null) {
                this.gridSpacing.remove(ap);
            } else {
                this.gridSpacing.put(ap, grid);
            }
        }
    }

    public static class SeaOfGatesOptions
    implements Serializable {
        public boolean useParallelFromToRoutes = true;
        public boolean useParallelRoutes = false;
        public double maxArcWidth = 10.0;
        public int complexityLimit = 200000;
        public boolean useGlobalRouter = false;
        public boolean reRunFailedRoutes = false;
        public int forcedNumberOfThreads = 0;
        public ElapseTimer theTimer;

        public void getOptionsFromPreferences() {
            this.useParallelFromToRoutes = Routing.isSeaOfGatesUseParallelFromToRoutes();
            this.useParallelRoutes = Routing.isSeaOfGatesUseParallelRoutes();
            this.maxArcWidth = Routing.getSeaOfGatesMaxWidth();
            this.complexityLimit = Routing.getSeaOfGatesComplexityLimit();
            this.useGlobalRouter = Routing.isSeaOfGatesUseGlobalRouting();
            this.reRunFailedRoutes = Routing.isSeaOfGatesRerunFailedRoutes();
            this.forcedNumberOfThreads = Routing.getSeaOfGatesForcedProcessorCount();
        }
    }
}

