/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LEFDEF;
import com.sun.electric.tool.user.IconParameters;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DEF
extends LEFDEF {
    private static final int LIMITNETS = -1;
    private static final boolean READCOMPONENTS = true;
    private static final boolean READPINS = true;
    private static final boolean READBLOCKAGES = true;
    private static final boolean READSPECIALNETS = true;
    private static final boolean READNETS = true;
    private static final boolean LIMITINGAREA = false;
    private static final double MAXX = 79100.0;
    private static final double MAXY = 200000.0;
    private double scaleUnits;
    private Map<String, LEFDEF.ViaDef> allViaDefs;
    private Map<String, PortInst> specialNetsHT = null;
    private Map<String, PortInst> normalNetsHT = null;
    private Map<String, NodeInst> instanceMap = null;
    private NodeInst dummyNodeInst = null;
    private boolean schImport = false;
    private Job job;
    private Pattern pat_starleftbracket = Pattern.compile(".*\\\\\\[");
    private Pattern pat_leftbracket = Pattern.compile("\\\\\\[");
    private Pattern pat_starrightbracket = Pattern.compile(".*\\\\\\]");
    private Pattern pat_rightbracket = Pattern.compile("\\\\\\]");
    private DEFPreferences localPrefs;
    private Map<String, Cell> dummyCells = new HashMap<String, Cell>();
    private static final boolean NEWPORTSTORAGE = false;
    private Map<Double, List<NodeInst>> portHT = null;
    private RTNode<PortInstBound> portRoot;

    DEF(EditingPreferences ep, DEFPreferences ap) {
        super(ep);
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        this.initKeywordParsing();
        this.scaleUnits = 1000.0;
        this.allViaDefs = new HashMap<String, LEFDEF.ViaDef>();
        this.instanceMap = new HashMap<String, NodeInst>();
        this.initializeLEFDEF(tech);
        try {
            if (this.readFile(lib, currentCells)) {
                return null;
            }
        }
        catch (IOException e) {
            System.out.println("ERROR reading DEF libraries");
        }
        return lib;
    }

    @Override
    protected String preprocessLine(String line) {
        int sharpPos = line.indexOf(35);
        if (sharpPos >= 0) {
            return line.substring(0, sharpPos);
        }
        return line;
    }

    private boolean readFile(Library lib, Map<Library, Cell> currentCells) throws IOException {
        Cell cell = null;
        while (true) {
            if (this.job != null && this.job.checkAbort()) {
                System.out.println("DEF import aborted!");
                break;
            }
            String key = this.getAKeyword();
            if (key == null) break;
            if (key.equalsIgnoreCase("BUSBITCHARS") || key.equalsIgnoreCase("DIEAREA") || key.equalsIgnoreCase("DIVIDERCHAR") || key.equalsIgnoreCase("GCELLGRID") || key.equalsIgnoreCase("HISTORY") || key.equalsIgnoreCase("NAMESCASESENSITIVE") || key.equalsIgnoreCase("ROW") || key.equalsIgnoreCase("TECHNOLOGY") || key.equalsIgnoreCase("TRACKS") || key.equalsIgnoreCase("VERSION")) {
                if (!this.ignoreToSemicolon(key)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("DEFAULTCAP") || key.equalsIgnoreCase("GROUPS") || key.equalsIgnoreCase("NONDEFAULTRULES") || key.equalsIgnoreCase("PROPERTYDEFINITIONS") || key.equalsIgnoreCase("REGIONS")) {
                if (!this.ignoreBlock(key)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("DESIGN")) {
                String cellName = this.mustGetKeyword("DESIGN");
                if (cellName == null) {
                    return true;
                }
                cell = currentCells.get(lib);
                if (!Input.isNewLibraryCreated()) {
                    if (cell == null) {
                        this.reportError("A cell must be currently opened for this operation, aborting.");
                        return true;
                    }
                    if (!cell.getCellName().getName().equals(cellName)) {
                        this.reportError("Cell name in DEF file '" + cellName + "' does not equal current cell name '" + cell.getCellName().getName() + "', aborting.");
                        return true;
                    }
                    View cellView = cell.getCellName().getView();
                    if (cellView.getAbbreviation().equals("sch")) {
                        this.schImport = true;
                    }
                } else if (cell == null || !cell.getCellName().getName().equals(cellName)) {
                    cell = Cell.makeInstance(this.ep, lib, cellName + "{lay}");
                }
                if (cell == null) {
                    this.reportError("Cannot create cell '" + cellName + "'");
                    return true;
                }
                if (!this.ignoreToSemicolon("DESIGN")) continue;
                return true;
            }
            if (key.equalsIgnoreCase("UNITS")) {
                if (!this.readUnits()) continue;
                return true;
            }
            if (key.equalsIgnoreCase("VIAS")) {
                if (!this.readVias(lib)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("COMPONENTS")) {
                this.reportSection("COMPONENTS");
                if (!this.readComponents(cell, lib)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("PINS")) {
                this.reportSection("PINS");
                if (!this.readPins(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("BLOCKAGES")) {
                this.reportSection("BLOCKAGES");
                if (!this.readBlockages(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("SPECIALNETS")) {
                if (this.localPrefs.logicalPlacement || this.localPrefs.physicalPlacement) {
                    this.reportSection("SPECIALNETS");
                    boolean fail = this.readNets(cell, true);
                    if (!fail) continue;
                    return true;
                }
                if (!this.ignoreBlock(key)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("NETS")) {
                if (this.localPrefs.logicalPlacement || this.localPrefs.physicalPlacement) {
                    this.reportSection("NETS");
                    boolean fail = this.readNets(cell, false);
                    if (fail) {
                        return true;
                    }
                } else if (this.ignoreBlock(key)) {
                    return true;
                }
                if (!this.ignoreBlock(key)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("END")) {
                key = this.getAKeyword();
                break;
            }
            this.reportError("Unknown top-level keyword: " + key);
        }
        return false;
    }

    private void reportSection(String name) {
        if (Job.getDebug()) {
            long pct = this.byteCount * 100L / this.fileLength;
            System.out.println("Reading " + name + " starting at " + pct + "%");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean readBlockages(Cell cell) throws IOException {
        block19: {
            if (this.ignoreToSemicolon("BLOCKAGES")) {
                return true;
            }
            do lbl-1000:
            // 3 sources

            {
                block20: {
                    if (this.job != null && this.job.checkAbort()) {
                        System.out.println("DEF import aborted!");
                        return true;
                    }
                    key = this.mustGetKeyword("BLOCKAGES");
                    if (key == null) {
                        return true;
                    }
                    if (!key.equals("-")) break block20;
                    key = this.mustGetKeyword("BLOCKAGES");
                    np /* !! */  = null;
                    if (key.equalsIgnoreCase("PLACEMENT")) {
                        np /* !! */  = Generic.tech().drcNode;
                    } else if (key.equalsIgnoreCase("LAYER")) {
                        key = this.mustGetKeyword("BLOCKAGES");
                        li = this.getLayerInformation(key);
                        if (li.pin == null) {
                            this.reportError("Unknown layer (" + key + ")");
                            return true;
                        }
                        np /* !! */  = li.pin;
                    }
                    key = this.mustGetKeyword("BLOCKAGES");
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("+")) {
                        key = this.mustGetKeyword("BLOCKAGES");
                        if (key == null) {
                            return true;
                        }
                        if (key.equalsIgnoreCase("SOFT")) {
                            key = this.mustGetKeyword("BLOCKAGES");
                            if (key == null) {
                                return true;
                            }
                        } else {
                            this.reportError("Unknown Placement keyword in Blockages section (" + key + ")");
                            return true;
                        }
                    }
                    if (key.equalsIgnoreCase("RECT")) {
                        ll = this.readCoordinate();
                        if (ll == null) {
                            return true;
                        }
                        ur = this.readCoordinate();
                        if (ur == null) {
                            return true;
                        }
                        sX = Math.abs(ll.getX() - ur.getX());
                        sY = Math.abs(ll.getY() - ur.getY());
                        cX = (ll.getX() + ur.getX()) / 2.0;
                        loc = EPoint.fromLambda(cX, cY = (ll.getY() + ur.getY()) / 2.0);
                        if (this.acceptNode(loc, sX, sY) && this.makeNode(np /* !! */ , loc, sX, sY, cell) == null) {
                            return true;
                        }
                    } else {
                        this.reportError("Expected RECT in BLOCKAGES section");
                        return true;
                    }
                    if (!this.ignoreToSemicolon(key)) ** GOTO lbl-1000
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block19;
            } while (!this.ignoreToSemicolon(key));
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readPins(Cell cell) throws IOException {
        String key;
        block5: {
            if (this.ignoreToSemicolon("PINS")) {
                return true;
            }
            while (true) {
                if (this.job != null && this.job.checkAbort()) {
                    System.out.println("DEF import aborted!");
                    return true;
                }
                key = this.mustGetKeyword("PINs");
                if (key == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readPin(cell)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block5;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readPin(Cell cell) throws IOException {
        String key = this.mustGetKeyword("PIN");
        if (key == null) {
            return true;
        }
        String pinName = this.translateDefName(key);
        PortCharacteristic portCharacteristic = null;
        NodeProto np = null;
        Point2D ll = null;
        Point2D ur = null;
        Point2D xy = null;
        boolean haveCoord = false;
        GetOrientation orient = null;
        while (true) {
            if ((key = this.mustGetKeyword("PIN")) == null) {
                return true;
            }
            if (key.equals("+")) {
                key = this.mustGetKeyword("PIN");
                if (key == null) {
                    return true;
                }
                if (key.equalsIgnoreCase("NET")) {
                    key = this.mustGetKeyword("net name");
                    if (key != null) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("DIRECTION")) {
                    key = this.mustGetKeyword("DIRECTION");
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("INPUT")) {
                        portCharacteristic = PortCharacteristic.IN;
                        continue;
                    }
                    if (key.equalsIgnoreCase("OUTPUT")) {
                        portCharacteristic = PortCharacteristic.OUT;
                        continue;
                    }
                    if (key.equalsIgnoreCase("INOUT")) {
                        portCharacteristic = PortCharacteristic.BIDIR;
                        continue;
                    }
                    if (key.equalsIgnoreCase("FEEDTHRU")) {
                        portCharacteristic = PortCharacteristic.BIDIR;
                        continue;
                    }
                    this.reportError("Unknown direction (" + key + ")");
                    return true;
                }
                if (key.equalsIgnoreCase("USE")) {
                    key = this.mustGetKeyword("USE");
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("SIGNAL")) continue;
                    if (key.equalsIgnoreCase("POWER")) {
                        portCharacteristic = PortCharacteristic.PWR;
                        continue;
                    }
                    if (key.equalsIgnoreCase("GROUND")) {
                        portCharacteristic = PortCharacteristic.GND;
                        continue;
                    }
                    if (key.equalsIgnoreCase("CLOCK")) {
                        portCharacteristic = PortCharacteristic.CLK;
                        continue;
                    }
                    if (key.equalsIgnoreCase("TIEOFF") || key.equalsIgnoreCase("ANALOG")) continue;
                    this.reportError("Unknown usage (" + key + ")");
                    return true;
                }
                if (key.equalsIgnoreCase("LAYER")) {
                    key = this.mustGetKeyword("LAYER");
                    if (key == null) {
                        return true;
                    }
                    if (!this.schImport) {
                        LEFDEF.GetLayerInformation li = this.getLayerInformation(key);
                        if (li.pin == null) {
                            this.reportError("Unknown layer (" + key + ")");
                            return true;
                        }
                        np = li.pin;
                    }
                    if ((ll = this.readCoordinate()) == null) {
                        return true;
                    }
                    ur = this.readCoordinate();
                    if (ur != null) continue;
                    return true;
                }
                if (!key.equalsIgnoreCase("PLACED") && !key.equalsIgnoreCase("FIXED")) continue;
                xy = this.readCoordinate();
                if (xy == null) {
                    return true;
                }
                orient = new GetOrientation();
                haveCoord = true;
                continue;
            }
            if (key.equals(";")) break;
        }
        if (this.schImport) {
            ArcProto apTry = null;
            Iterator<Comparable<ArcProto>> it = this.curTech.getArcs();
            while (it.hasNext() && !(apTry = it.next()).getName().equals("wire")) {
            }
            if (apTry == null) {
                this.reportError("Unable to resolve pin component");
                return true;
            }
            it = this.curTech.getNodes();
            while (it.hasNext()) {
                PrimitivePort pp;
                PrimitiveNode loc_np = (PrimitiveNode)it.next();
                if (loc_np.getNumPorts() != 1 || !(pp = loc_np.getPort(0)).connectsTo(apTry)) continue;
                np = loc_np;
                break;
            }
        }
        if (np != null && haveCoord) {
            FixpTransform trans = orient.orient.pureRotate();
            trans.transform(ll, ll);
            trans.transform(ur, ur);
            double sX = Math.abs(ll.getX() - ur.getX());
            double sY = Math.abs(ll.getY() - ur.getY());
            double cX = (ll.getX() + ur.getX()) / 2.0 + xy.getX();
            double cY = (ll.getY() + ur.getY()) / 2.0 + xy.getY();
            EPoint loc = EPoint.fromLambda(cX, cY);
            if (this.acceptNode(loc, sX, sY)) {
                NodeInst ni = this.makeNode(np, loc, sX, sY, cell);
                if (ni == null) {
                    return true;
                }
                PortInst pi = ni.findPortInstFromProto(np.getPort(0));
                Export e = Export.newInstance(cell, pi, pinName, this.ep, portCharacteristic);
                if (e == null) {
                    this.reportError("Unable to create pin name");
                    return true;
                }
            }
        }
        return false;
    }

    private boolean readComponents(Cell cell, Library lib) throws IOException {
        String key;
        block5: {
            if (this.ignoreToSemicolon("COMPONENTS")) {
                return true;
            }
            while (true) {
                if (this.job != null && this.job.checkAbort()) {
                    System.out.println("DEF import aborted!");
                    return true;
                }
                key = this.mustGetKeyword("COMPONENTs");
                if (key == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readComponent(cell, lib)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block5;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private Cell makeDummyCell(String name, Library lib) {
        Cell cell = this.dummyCells.get(name);
        if (cell != null) {
            return cell;
        }
        System.out.println("WARNING: Cell " + name + " not found: making a dummy cell for it");
        cell = Cell.makeInstance(this.ep, lib, name);
        this.dummyCells.put(name, cell);
        PrimitiveNode cornerNp = Generic.tech().essentialBoundsNode;
        double cornerWid = cornerNp.getDefWidth(this.ep);
        double cornerHei = cornerNp.getDefHeight(this.ep);
        NodeInst.makeInstance((NodeProto)cornerNp, this.ep, EPoint.fromLambda(-50.0, -50.0), cornerWid, cornerHei, cell, Orientation.RR, null);
        NodeInst.makeInstance(cornerNp, this.ep, EPoint.fromLambda(50.0, 50.0), cornerWid, cornerHei, cell);
        PrimitiveNode portNp = Generic.tech().universalPinNode;
        double portWid = portNp.getDefWidth(this.ep);
        double portHei = portNp.getDefHeight(this.ep);
        NodeInst ni = NodeInst.makeInstance(portNp, this.ep, EPoint.fromLambda(0.0, 0.0), portWid, portHei, cell);
        Export.newInstance(cell, ni.getOnlyPortInst(), "dummyPort", this.ep);
        return cell;
    }

    private boolean readComponent(Cell cell, Library lib) throws IOException {
        String key = this.mustGetKeyword("COMPONENT");
        if (key == null) {
            return true;
        }
        String compName = key;
        String compNameLC = compName.toLowerCase();
        key = this.mustGetKeyword("COMPONENT");
        if (key == null) {
            return true;
        }
        String modelName = key;
        Cell np = cell.getView() != null ? this.getNodeProto(modelName, cell.getLibrary(), cell) : this.getNodeProto(modelName, cell.getLibrary());
        if (np == null) {
            if (this.localPrefs.makeDummyCells) {
                np = this.makeDummyCell(modelName, lib);
            } else {
                this.reportError("Unknown cell (" + modelName + ").  To allow this, use DEF Preferences and check 'Make dummy cells for unknown cells'");
                return true;
            }
        }
        while (true) {
            if ((key = this.mustGetKeyword("COMPONENT")) == null) {
                return true;
            }
            if (key.equals("+")) {
                EPoint loc;
                key = this.mustGetKeyword("COMPONENT");
                if (key == null) {
                    return true;
                }
                if (!key.equalsIgnoreCase("PLACED") && !key.equalsIgnoreCase("FIXED")) continue;
                Point2D pt = this.readCoordinate();
                if (pt == null) {
                    return true;
                }
                double nx = pt.getX();
                double ny = pt.getY();
                Orientation or = this.FetchOrientation();
                double sX = np.getDefWidth();
                double sY = np.getDefHeight();
                Variable prX = np.getVar(prXkey);
                double width = 0.0;
                if (prX != null) {
                    String tmps = prX.getPureValue(0);
                    width = TextUtils.atof(tmps);
                } else {
                    width = sX;
                }
                Variable prY = np.getVar(prYkey);
                double height = 0.0;
                if (prY != null) {
                    String tmps = prY.getPureValue(0);
                    height = TextUtils.atof(tmps);
                } else {
                    height = sY;
                }
                if (or.equals(Orientation.YRR)) {
                    nx += width;
                }
                if (or.equals(Orientation.Y)) {
                    ny += height;
                }
                if (or.equals(Orientation.RR)) {
                    ny += height;
                    nx += width;
                }
                if (or.equals(Orientation.RRR)) {
                    ny += width;
                }
                if (or.equals(Orientation.R)) {
                    nx += height;
                }
                if (or.equals(Orientation.YRRR)) {
                    // empty if block
                }
                if (or.equals(Orientation.YR)) {
                    nx += height;
                    ny += width;
                }
                if (this.acceptNode(loc = EPoint.fromLambda(nx, ny), sX, sY)) {
                    NodeInst ni = this.makeNodeMoreInfo(np, loc, sX, sY, cell, or, compName);
                    if (ni == null) {
                        return true;
                    }
                    this.instanceMap.put(compNameLC, ni);
                    continue;
                }
                if (this.dummyNodeInst == null) {
                    this.dummyNodeInst = NodeInst.makeDummyInstance((NodeProto)np, this.ep);
                }
                this.instanceMap.put(compNameLC, this.dummyNodeInst);
                continue;
            }
            if (key.equals(";")) break;
        }
        return false;
    }

    private boolean readNets(Cell cell, boolean special) throws IOException {
        if (special) {
            this.specialNetsHT = new HashMap<String, PortInst>();
        } else {
            this.normalNetsHT = new HashMap<String, PortInst>();
        }
        this.initNets();
        int numNets = 0;
        String key = this.mustGetKeyword("NETs");
        if (key == null) {
            return true;
        }
        if (TextUtils.isANumber(key)) {
            numNets = TextUtils.atoi(key);
        }
        if (!key.equals(";") && this.ignoreToSemicolon(key)) {
            return true;
        }
        int net = 1;
        while (true) {
            if (this.job != null && this.job.checkAbort()) {
                System.out.println("DEF import aborted!");
                return true;
            }
            key = this.mustGetKeyword("NETs");
            if (key == null) {
                return true;
            }
            if (key.equals("-")) {
                boolean fail = this.readNet(cell, special, net, numNets);
                if (fail) {
                    return true;
                }
            } else if (key.equalsIgnoreCase("END")) break;
            ++net;
        }
        key = this.getAKeyword();
        this.connectSpecialNormalNets();
        return false;
    }

    private void connectSpecialNormalNets() {
        if (this.specialNetsHT == null) {
            return;
        }
        if (this.normalNetsHT == null) {
            return;
        }
        if (!this.localPrefs.logicalPlacement) {
            return;
        }
        for (String netName : this.specialNetsHT.keySet()) {
            PortInst specPi = this.specialNetsHT.get(netName);
            PortInst normalPi = null;
            if (!this.normalNetsHT.containsKey(netName) || (normalPi = this.normalNetsHT.get(netName)) == null || !this.makeUnroutedConnection(specPi, normalPi)) continue;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readNet(Cell cell, boolean special, int netNum, int totalNets) throws IOException {
        if (this.schImport && special) {
            this.ignoreToSemicolon("NET");
            return false;
        }
        String key = this.mustGetKeyword("NET");
        if (key == null) {
            return true;
        }
        String netName = this.translateDefName(key);
        key = this.mustGetKeyword("NET");
        if (key == null) {
            return true;
        }
        boolean adjustPinLocPi = false;
        boolean adjustPinLocLastPi = false;
        boolean wantPinPairs = true;
        boolean connectAllComponents = false;
        String wildcardPort = null;
        double lastX = 0.0;
        double lastY = 0.0;
        double curX = 0.0;
        double curY = 0.0;
        double specialWidth = 0.0;
        boolean pathStart = true;
        PortInst lastLogPi = null;
        PortInst lastPi = null;
        EPoint lastPT = null;
        LEFDEF.GetLayerInformation li = null;
        boolean foundCoord = false;
        boolean stackedViaFlag = false;
        while (true) {
            boolean fail;
            PortInst nextPi;
            Double wid;
            double sYNi;
            double sXNi;
            double hY;
            EPoint locNi;
            NodeInst ni;
            EPoint loc;
            if (this.job != null && this.job.checkAbort()) {
                System.out.println("DEF import aborted!");
                return true;
            }
            if (key.equals(";")) {
                boolean fail2;
                if (lastPi != null) {
                    if (special) {
                        this.specialNetsHT.put(netName, lastPi);
                    } else {
                        this.normalNetsHT.put(netName, lastPi);
                    }
                }
                if (lastLogPi == null) return false;
                if (lastPi == null) return false;
                if (!this.localPrefs.logicalPlacement) return false;
                if (this.localPrefs.ignoreLogicalInSpecialNets) {
                    if (special) return false;
                }
                if (!(fail2 = this.makeUnroutedConnection(lastPi, lastLogPi))) return false;
                return true;
            }
            if (key.equals("+")) {
                wantPinPairs = false;
                if (this.schImport) {
                    this.ignoreToSemicolon("NET");
                    return false;
                }
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                if (key.equalsIgnoreCase("USE")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                } else if (key.equalsIgnoreCase("SHIELDNET")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                } else if (key.equalsIgnoreCase("ROUTED")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    li = this.getLayerInformation(key);
                    if (li.pin == null) {
                        this.reportError("Unknown layer (" + key + ")");
                        return true;
                    }
                    pathStart = true;
                    if (special) {
                        key = this.mustGetKeyword("NET");
                        if (key == null) {
                            return true;
                        }
                        specialWidth = this.convertDEFString(key);
                    }
                } else if (key.equalsIgnoreCase("FIXED")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    li = this.getLayerInformation(key);
                    if (li.pin == null) {
                        this.reportError("Unknown layer (" + key + ")");
                        return true;
                    }
                    pathStart = true;
                    if (special) {
                        key = this.mustGetKeyword("NET");
                        if (key == null) {
                            return true;
                        }
                        specialWidth = this.convertDEFString(key);
                    }
                } else if (key.equalsIgnoreCase("SHIELD")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    li = this.getLayerInformation(key);
                    if (li.pin == null) {
                        this.reportError("Unknown layer (" + key + ")");
                        return true;
                    }
                    pathStart = true;
                    if (special) {
                        key = this.mustGetKeyword("NET");
                        if (key == null) {
                            return true;
                        }
                        specialWidth = this.convertDEFString(key);
                    }
                } else if (key.equalsIgnoreCase("SHAPE")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                } else if (key.equalsIgnoreCase("SOURCE")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                } else if (key.equalsIgnoreCase("ORIGINAL")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                } else {
                    if (!key.equalsIgnoreCase("NONDEFAULTRULE")) {
                        this.reportError("Cannot handle '" + key + "' nets");
                        return true;
                    }
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                }
                if ((key = this.mustGetKeyword("NET")) != null) continue;
                return true;
            }
            if (wantPinPairs) {
                boolean fail3;
                if (!key.equals("(")) {
                    this.reportError("Expected '(' of pin pair");
                    return true;
                }
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                PortInst pi = null;
                if (key.equalsIgnoreCase("PIN")) {
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    Export pp = (Export)cell.findPortProto(key = this.translateDefName(key));
                    if (pp == null) {
                        this.reportError("Warning: unknown pin '" + key + "'");
                        if (!this.ignoreToSemicolon("NETS")) return false;
                        return true;
                    }
                    pi = pp.getOriginalPort();
                } else {
                    NodeInst found = null;
                    if (key.equals("*")) {
                        connectAllComponents = true;
                    } else {
                        connectAllComponents = false;
                        String lcKey = key.toLowerCase();
                        found = this.instanceMap.get(lcKey);
                        if (found == null) {
                            this.reportError("Unknown component '" + key + "'");
                            return true;
                        }
                    }
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    if (connectAllComponents) {
                        wildcardPort = key;
                    } else if (found != this.dummyNodeInst) {
                        PortProto pp = found.getProto().findPortProto(key);
                        if (pp == null && (pp = found.getProto().findPortProto("dummyPort")) == null) {
                            this.reportError("Unknown port '" + key + "' on component " + found);
                            return true;
                        }
                        pi = found.findPortInstFromProto(pp);
                    }
                }
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                if (!key.equals(")")) {
                    this.reportError("Expected ')' of pin pair");
                    return true;
                }
                if (this.localPrefs.logicalPlacement && (!this.localPrefs.ignoreLogicalInSpecialNets || !special) && (connectAllComponents ? (pi = this.connectGlobal(cell, wildcardPort)) == null : lastLogPi != null && (fail3 = this.makeUnroutedConnection(pi, lastLogPi)))) {
                    return true;
                }
                lastLogPi = pi;
                key = this.mustGetKeyword("NET");
                if (key != null) continue;
                return true;
            }
            if (key.equalsIgnoreCase("NEW")) {
                boolean fail4;
                if (lastLogPi != null && lastPi != null && this.localPrefs.logicalPlacement && (!this.localPrefs.ignoreLogicalInSpecialNets || !special) && (fail4 = this.makeUnroutedConnection(lastPi, lastLogPi))) {
                    return true;
                }
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                li = this.getLayerInformation(key);
                if (li.pin == null) {
                    this.reportError("Unknown layer (" + key + ")");
                    return true;
                }
                pathStart = true;
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                if (!special) continue;
                specialWidth = this.convertDEFString(key);
                key = this.mustGetKeyword("NET");
                if (key != null) continue;
                return true;
            }
            if (!stackedViaFlag) {
                foundCoord = false;
            }
            if (key.equals("(")) {
                foundCoord = true;
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                curX = key.equals("*") ? lastX : this.convertDEFString(key);
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                curY = key.equals("*") ? lastY : this.convertDEFString(key);
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                if (TextUtils.isANumber(key) && (key = this.mustGetKeyword("NET")) == null) {
                    return true;
                }
                if (!key.equals(")")) {
                    this.reportError("Expected ')' of coordinate pair");
                    return true;
                }
            }
            if (!stackedViaFlag && (key = this.mustGetKeyword("NET")) == null) {
                return true;
            }
            LEFDEF.ViaDef vd = this.findViaDef(key);
            if (!this.localPrefs.physicalPlacement || this.schImport) {
                if (vd == null || (key = this.mustGetKeyword("NET")) != null) continue;
                return true;
            }
            PortInst pi = null;
            EPoint piPT = null;
            boolean placedVia = false;
            if (vd != null) {
                double sX = vd.sX;
                double sY = vd.sY;
                if (vd.via == null) {
                    this.reportError("Cannot create via '" + vd.viaName + "'");
                    return true;
                }
                if (pathStart) {
                    EPoint loc2;
                    if (!this.localPrefs.usePureLayerNodes) {
                        lastPi = this.findConnection(curX, curY, li.arc, cell, null);
                    }
                    if (this.acceptNode(loc2 = EPoint.fromLambda(curX, curY), 0.0, 0.0)) {
                        lastPT = loc2;
                    }
                }
                SizeOffset so = vd.via.getProtoSizeOffset();
                loc = EPoint.fromLambda(curX, curY);
                if (this.acceptNode(loc, sX += so.getLowXOffset() + so.getHighXOffset(), sY += so.getLowYOffset() + so.getHighYOffset())) {
                    boolean fail5;
                    double sYNi2;
                    double sXNi2;
                    double hY2;
                    double lY;
                    double hX;
                    double lX;
                    EPoint locNi2;
                    NodeInst newNi;
                    Double wid2;
                    ni = this.makeNode(vd.via, loc, sX, sY, cell);
                    if (ni == null) {
                        return true;
                    }
                    pi = ni.getOnlyPortInst();
                    piPT = EPoint.fromLambda(curX, curY);
                    double width = li.arc.getDefaultLambdaBaseWidth(this.ep);
                    if (special) {
                        width = specialWidth;
                    } else if (widthsFromLEF != null && (wid2 = (Double)widthsFromLEF.get(li.arc)) != null) {
                        width = wid2;
                    }
                    if (this.localPrefs.usePureLayerNodes ? !(!pathStart || lastPT == null || !foundCoord || this.localPrefs.ignorePhysicalInNets && !special || lastPT.getX() == piPT.getX() && lastPT.getY() == piPT.getY() || (newNi = this.makeNode(li.pure, locNi2 = EPoint.fromLambda(((lX = Math.min(lastPT.getX(), piPT.getX()) - width / 2.0) + (hX = Math.max(lastPT.getX(), piPT.getX()) + width / 2.0)) / 2.0, ((lY = Math.min(lastPT.getY(), piPT.getY()) - width / 2.0) + (hY2 = Math.max(lastPT.getY(), piPT.getY()) + width / 2.0)) / 2.0), sXNi2 = hX - lX, sYNi2 = hY2 - lY, cell)) != null) : pathStart && lastPi != null && foundCoord && (!this.localPrefs.ignorePhysicalInNets || special) && (fail5 = this.makeConnection(cell, li.arc, width, lastPi, pi, lastPT, piPT))) {
                        return true;
                    }
                }
                placedVia = true;
                key = this.mustGetKeyword("NET");
                if (key == null) {
                    return true;
                }
                LEFDEF.ViaDef vdStack = this.findViaDef(key);
                stackedViaFlag = vdStack != null;
            } else {
                if (li == null) {
                    this.reportError("No Layer specified for pin");
                    return true;
                }
                EPoint testPT = EPoint.fromLambda(curX, curY);
                if (this.acceptNode(testPT, 0.0, 0.0)) {
                    if (!this.localPrefs.usePureLayerNodes && (pi = this.getPin(curX, curY, li.arc, cell)) == null) {
                        return true;
                    }
                    piPT = testPT;
                }
                adjustPinLocPi = true;
            }
            if (!foundCoord) continue;
            if (!pathStart) {
                boolean fail6;
                double lY;
                double hX;
                double lX;
                NodeInst newNi;
                Double wid3;
                if (this.localPrefs.usePureLayerNodes) {
                    EPoint loc3;
                    if (piPT == null && this.acceptNode(loc3 = EPoint.fromLambda(curX, curY), 0.0, 0.0)) {
                        piPT = loc3;
                    }
                } else if (pi == null || !pi.getPortProto().connectsTo(li.arc)) {
                    PrimitiveNode np = li.arc.findPinProto();
                    double sX = np.getDefWidth(this.ep);
                    double sY = np.getDefHeight(this.ep);
                    loc = EPoint.fromLambda(curX, curY);
                    if (this.acceptNode(loc, sX, sY)) {
                        ni = this.makeNode(np, loc, sX, sY, cell);
                        if (ni == null) {
                            return true;
                        }
                        pi = ni.getOnlyPortInst();
                        piPT = EPoint.fromLambda(curX, curY);
                    }
                }
                double width = li.arc.getDefaultLambdaBaseWidth(this.ep);
                if (special) {
                    width = specialWidth;
                } else if (widthsFromLEF != null && (wid3 = (Double)widthsFromLEF.get(li.arc)) != null) {
                    width = wid3;
                }
                if (adjustPinLocLastPi && special) {
                    double dX = 0.0;
                    double dY = 0.0;
                    if (curX != lastX) {
                        dX = width / 2.0;
                        if (curX < lastX) {
                            dX = -dX;
                        }
                    }
                    if (curY != lastY) {
                        dY = width / 2.0;
                        if (curY < lastY) {
                            dY = -dY;
                        }
                    }
                    if (lastPi != null) {
                        lastPi.getNodeInst().move(dX, dY);
                    }
                    if (lastPT != null) {
                        lastPT = EPoint.fromLambda(lastPT.getX() + dX, lastPT.getY() + dY);
                    }
                    adjustPinLocLastPi = false;
                }
                if (adjustPinLocPi && special) {
                    double dX = 0.0;
                    double dY = 0.0;
                    if (curX != lastX) {
                        dX = -width / 2.0;
                        if (curX < lastX) {
                            dX = -dX;
                        }
                    }
                    if (curY != lastY) {
                        dY = -width / 2.0;
                        if (curY < lastY) {
                            dY = -dY;
                        }
                    }
                    if (pi != null) {
                        pi.getNodeInst().move(dX, dY);
                    }
                    if (piPT != null) {
                        piPT = EPoint.fromLambda(piPT.getX() + dX, piPT.getY() + dY);
                    }
                    adjustPinLocPi = false;
                }
                if ((!this.localPrefs.ignorePhysicalInNets || special) && (this.localPrefs.usePureLayerNodes ? lastPT != null && piPT != null && (lastPT.getX() != piPT.getX() || lastPT.getY() != piPT.getY()) && (newNi = this.makeNode(li.pure, locNi = EPoint.fromLambda(((lX = Math.min(lastPT.getX(), piPT.getX()) - width / 2.0) + (hX = Math.max(lastPT.getX(), piPT.getX()) + width / 2.0)) / 2.0, ((lY = Math.min(lastPT.getY(), piPT.getY()) - width / 2.0) + (hY = Math.max(lastPT.getY(), piPT.getY()) + width / 2.0)) / 2.0), sXNi = hX - lX, sYNi = hY - lY, cell)) == null : (fail6 = this.makeConnection(cell, li.arc, width, lastPi, pi, lastPT, piPT)))) {
                    return true;
                }
            }
            lastX = curX;
            lastY = curY;
            pathStart = false;
            lastPi = pi;
            lastPT = piPT;
            adjustPinLocLastPi = adjustPinLocPi;
            adjustPinLocPi = false;
            if (placedVia) {
                if (li.equals(vd.gLay1)) {
                    li = vd.gLay2;
                } else if (li.equals(vd.gLay2)) {
                    li = vd.gLay1;
                }
            }
            if (!key.equalsIgnoreCase("NEW") && !key.equals(";")) continue;
            double width = li.arc.getDefaultLambdaBaseWidth(this.ep);
            if (special) {
                width = specialWidth;
            } else if (widthsFromLEF != null && (wid = (Double)widthsFromLEF.get(li.arc)) != null) {
                width = wid;
            }
            if (this.localPrefs.usePureLayerNodes) {
                if (piPT == null || this.localPrefs.ignorePhysicalInNets && !special || curX == piPT.getX() && curY == piPT.getY()) continue;
                double lX = Math.min(curX, piPT.getX()) - width / 2.0;
                double hX = Math.max(curX, piPT.getX()) + width / 2.0;
                double lY = Math.min(curY, piPT.getY()) - width / 2.0;
                hY = Math.max(curY, piPT.getY()) + width / 2.0;
                locNi = EPoint.fromLambda((lX + hX) / 2.0, (lY + hY) / 2.0);
                sXNi = hX - lX;
                sYNi = hY - lY;
                PrimitiveNode np = li.arc.getLayer(0).getPureLayerNode();
                NodeInst newNi = this.makeNode(np, locNi, sXNi, sYNi, cell);
                if (newNi != null) continue;
                return true;
            }
            if (pi != null && (nextPi = this.findConnection(curX, curY, li.arc, cell, pi.getNodeInst())) != null && (!this.localPrefs.ignorePhysicalInNets || special) && (fail = this.makeConnection(cell, li.arc, width, pi, nextPi, piPT, EPoint.fromLambda(curX, curY)))) break;
        }
        return true;
    }

    private PortInst connectGlobal(Cell cell, String portName) {
        PortInst lastPi = null;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            boolean fail;
            PortInst pi;
            EPoint pt;
            NodeInst ni = it.next();
            PortProto pp = ni.getProto().findPortProto(portName);
            if (pp == null || !this.acceptNode(pt = (pi = ni.findPortInstFromProto(pp)).getCenter(), 0.0, 0.0)) continue;
            if (lastPi != null && (fail = this.makeUnroutedConnection(pi, lastPi))) {
                return null;
            }
            lastPi = pi;
        }
        return lastPi;
    }

    private boolean readVias(Library lib) throws IOException {
        String key;
        block4: {
            if (this.ignoreToSemicolon("VIAS")) {
                return true;
            }
            while (true) {
                if ((key = this.mustGetKeyword("VIAs")) == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readVia(lib)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block4;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readVia(Library lib) throws IOException {
        if (this.schImport) {
            this.ignoreToSemicolon("VIA");
            return false;
        }
        String key = this.mustGetKeyword("VIA");
        if (key == null) {
            return true;
        }
        Cell cell = Cell.makeInstance(this.ep, lib, key + "{lay}");
        LEFDEF.ViaDef vd = new LEFDEF.ViaDef(key, cell);
        this.allViaDefs.put(key.toLowerCase(), vd);
        NodeInst ni = this.makeNode(Generic.tech().universalPinNode, EPoint.fromLambda(0.0, 0.0), 0.0, 0.0, cell);
        if (ni == null) {
            return true;
        }
        Export e = Export.newInstance(cell, ni.getOnlyPortInst(), "viaPort", this.ep, PortCharacteristic.UNKNOWN);
        if (e == null) {
            this.reportError("Unable to create export in " + vd.viaName + " via");
            return true;
        }
        while (true) {
            if ((key = this.mustGetKeyword("VIA")) == null) {
                return true;
            }
            if (key.equals("+")) {
                double cY;
                Point2D ll;
                key = this.mustGetKeyword("VIA");
                if (key == null) {
                    return true;
                }
                if (!key.equalsIgnoreCase("RECT")) continue;
                key = this.mustGetKeyword("VIA");
                if (key == null) {
                    return true;
                }
                LEFDEF.GetLayerInformation li = this.getLayerInformation(key);
                if (li.pure == null) {
                    this.reportError("Layer " + key + " not found");
                    return true;
                }
                if (li.layerFun.isMetal()) {
                    if (vd.gLay1 == null) {
                        vd.gLay1 = li;
                    } else {
                        vd.gLay2 = li;
                    }
                }
                if ((ll = this.readCoordinate()) == null) {
                    return true;
                }
                Point2D ur = this.readCoordinate();
                if (ur == null) {
                    return true;
                }
                double sX = Math.abs(ll.getX() - ur.getX());
                double sY = Math.abs(ll.getY() - ur.getY());
                double cX = (ll.getX() + ur.getX()) / 2.0;
                ni = this.makeNode(li.pure, EPoint.fromLambda(cX, cY = (ll.getY() + ur.getY()) / 2.0), sX, sY, cell);
                if (ni != null) continue;
                return true;
            }
            if (key.equals(";")) break;
        }
        if (vd.gLay1 != null && vd.gLay2 != null) {
            String[] preferredArcs = new String[]{vd.gLay1.arc.getFullName(), vd.gLay2.arc.getFullName()};
            e.newVar(Export.EXPORT_PREFERRED_ARCS, (Object)preferredArcs, this.ep);
        }
        vd.sX = vd.via.getDefWidth(this.ep);
        vd.sY = vd.via.getDefHeight(this.ep);
        return false;
    }

    private boolean readUnits() throws IOException {
        String key = this.mustGetKeyword("UNITS");
        if (key == null) {
            return true;
        }
        if (!key.equalsIgnoreCase("DISTANCE")) {
            this.reportError("Expected 'DISTANCE' after 'UNITS'");
            return true;
        }
        key = this.mustGetKeyword("UNITS");
        if (key == null) {
            return true;
        }
        if (!key.equalsIgnoreCase("MICRONS")) {
            this.reportError("Expected 'MICRONS' after 'UNITS'");
            return true;
        }
        key = this.mustGetKeyword("UNITS");
        if (key == null) {
            return true;
        }
        this.scaleUnits = TextUtils.atof(key) * 1.0;
        return this.ignoreToSemicolon("UNITS");
    }

    private boolean ignoreToSemicolon(String command) throws IOException {
        String key;
        do {
            if ((key = this.mustGetKeyword(command)) != null) continue;
            return true;
        } while (!key.equals(";"));
        return false;
    }

    private boolean ignoreBlock(String command) throws IOException {
        String key;
        do {
            if ((key = this.mustGetKeyword(command)) != null) continue;
            return true;
        } while (!key.equalsIgnoreCase("END"));
        this.getAKeyword();
        return false;
    }

    private Point2D readCoordinate() throws IOException {
        String key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        if (!key.equals("(")) {
            this.reportError("Expected '(' in coordinate");
            return null;
        }
        key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        double x2 = this.convertDEFString(key);
        key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        double y = this.convertDEFString(key);
        key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        if (TextUtils.isANumber(key) && (key = this.mustGetKeyword("coordinate")) == null) {
            return null;
        }
        if (!key.equals(")")) {
            this.reportError("Expected ')' in coordinate");
            return null;
        }
        return new Point2D.Double(x2, y);
    }

    private String mustGetKeyword(String where) throws IOException {
        String key = this.getAKeyword();
        if (key == null) {
            this.reportError("EOF parsing " + where);
        }
        return key;
    }

    private double convertDEFString(String key) {
        double v = TextUtils.atof(key) / this.scaleUnits;
        return TextUtils.convertFromDistance(v, this.curTech, TextUtils.UnitScale.MICRO);
    }

    private void reportError(String command) {
        System.out.println("File " + this.filePath + ", line " + this.lineReader.getLineNumber() + ": " + command);
    }

    private Cell getNodeProto(String name, Library curlib, Cell parent) {
        CellName cn = this.schImport ? CellName.newName(name, View.ICON, 0) : CellName.newName(name, parent.getView(), 0);
        Cell cell = curlib.findNodeProto(cn.toString());
        if (cell != null) {
            return cell;
        }
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || lib == curlib || (cell = lib.findNodeProto(name)) == null) continue;
            return cell;
        }
        return null;
    }

    private Cell getNodeProto(String name, Library curlib) {
        Cell cell = curlib.findNodeProto(name);
        if (cell != null) {
            return cell;
        }
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || lib == curlib || (cell = lib.findNodeProto(name)) == null) continue;
            return cell;
        }
        return null;
    }

    private Orientation FetchOrientation() throws IOException {
        int angle;
        String key = this.mustGetKeyword("orientation");
        if (key == null) {
            return null;
        }
        boolean transpose2 = false;
        if (key.equalsIgnoreCase("N")) {
            angle = 0;
        } else if (key.equalsIgnoreCase("S")) {
            angle = 1800;
        } else if (key.equalsIgnoreCase("E")) {
            angle = 2700;
        } else if (key.equalsIgnoreCase("W")) {
            angle = 900;
        } else if (key.equalsIgnoreCase("FN")) {
            angle = 900;
            transpose2 = true;
        } else if (key.equalsIgnoreCase("FS")) {
            angle = 2700;
            transpose2 = true;
        } else if (key.equalsIgnoreCase("FE")) {
            angle = 1800;
            transpose2 = true;
        } else if (key.equalsIgnoreCase("FW")) {
            angle = 0;
            transpose2 = true;
        } else {
            this.reportError("Unknown orientation (" + key + ")");
            return null;
        }
        return Orientation.fromC(angle, transpose2);
    }

    private boolean acceptNode(EPoint loc, double sX, double sY) {
        return true;
    }

    private NodeInst makeNodeMoreInfo(NodeProto np, EPoint loc, double sX, double sY, Cell cell, Orientation or, String name) {
        NodeInst ni = NodeInst.makeInstance(np, this.ep, loc, sX, sY, cell, or, name);
        if (ni == null) {
            this.reportError("Unable to create node");
            return null;
        }
        return ni;
    }

    private NodeInst makeNode(NodeProto np, EPoint loc, double sX, double sY, Cell cell) {
        NodeInst ni = NodeInst.makeInstance(np, this.ep, loc, sX, sY, cell);
        if (ni == null) {
            this.reportError("Unable to create node");
            return null;
        }
        return ni;
    }

    private boolean makeUnroutedConnection(PortInst pi1, PortInst pi2) {
        if (pi1 == null || pi2 == null) {
            return false;
        }
        ArcInst ai = ArcInst.makeInstance(Generic.tech().unrouted_arc, this.ep, pi1, pi2);
        if (ai == null) {
            this.reportError("Could not create unrouted arc");
            return true;
        }
        return false;
    }

    private boolean makeConnection(Cell cell, ArcProto ap, double width, PortInst pi1, PortInst pi2, EPoint pt1, EPoint pt2) {
        if (pi1 == null || pi2 == null) {
            return false;
        }
        long gridExtendOverMin = DBMath.lambdaToGrid(0.5 * width) - ap.getBaseExtend().getGrid();
        TextDescriptor nameDescriptor = this.ep.getArcTextDescriptor();
        ArcInst ai = ArcInst.newInstanceNoCheck(cell, ap, null, nameDescriptor, pi1, pi2, pt1, pt2, gridExtendOverMin, -1, ImmutableArcInst.DEFAULT_FLAGS);
        if (ai == null) {
            this.reportError("Could not create arc");
            return true;
        }
        return false;
    }

    private LEFDEF.ViaDef findViaDef(String key) {
        if (key.equals(";")) {
            return null;
        }
        String lcName = key.toLowerCase();
        LEFDEF.ViaDef vd = this.allViaDefs.get(lcName);
        if (vd != null) {
            return vd;
        }
        if (viaDefsFromLEF != null && (vd = (LEFDEF.ViaDef)viaDefsFromLEF.get(lcName)) != null) {
            return vd;
        }
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Cell cell;
            Library lib = it.next();
            if (lib.isHidden() || (cell = lib.findNodeProto(key)) == null) continue;
            LEFDEF.ViaDef vDef = new LEFDEF.ViaDef(key, cell);
            this.allViaDefs.put(lcName, vDef);
            vDef.sX = cell.getBounds().getWidth();
            vDef.sY = cell.getBounds().getHeight();
            if (cell.getNumPorts() > 0) {
                Export e = cell.getPort(0);
                Variable var = e.getVar(Export.EXPORT_PREFERRED_ARCS);
                if (var != null) {
                    String[] preferredArcs = (String[])var.getObject();
                    vDef.gLay1 = this.getLayerInformation(preferredArcs[0]);
                    vDef.gLay2 = this.getLayerInformation(preferredArcs[1]);
                } else {
                    ArcProto[] cons = e.getBasePort().getConnections();
                    for (int i = 0; i < cons.length; ++i) {
                        if (cons[i].getTechnology() == Generic.tech()) continue;
                        if (vDef.gLay1 == null) {
                            vDef.gLay1 = this.getLayerInformation(cons[i].getName());
                            continue;
                        }
                        if (vDef.gLay2 != null) continue;
                        vDef.gLay2 = this.getLayerInformation(cons[i].getName());
                    }
                }
            }
            return vDef;
        }
        return null;
    }

    private void initNets() {
        this.portHT = new HashMap<Double, List<NodeInst>>();
    }

    private PortInst findConnection(double x2, double y, ArcProto ap, Cell cell, NodeInst noti) {
        Double key = new Double(x2 + y);
        List<NodeInst> pl = this.portHT.get(key);
        if (pl != null) {
            Point2D.Double pt = new Point2D.Double(x2, y);
            for (NodeInst ni : pl) {
                if (ni == noti) continue;
                Iterator<PortInst> it = ni.getPortInsts();
                while (it.hasNext()) {
                    Poly poly;
                    PortInst pi = it.next();
                    if (!pi.getPortProto().connectsTo(ap) || !(poly = pi.getPoly()).isInside(pt)) continue;
                    return pi;
                }
            }
        }
        return null;
    }

    private PortInst getPin(double x2, double y, ArcProto ap, Cell cell) {
        PortInst pi = this.findConnection(x2, y, ap, cell, null);
        if (pi != null) {
            return pi;
        }
        PrimitiveNode pin = ap.findPinProto();
        double sX = pin.getDefWidth(this.ep);
        double sY = pin.getDefHeight(this.ep);
        NodeInst ni = this.makeNode(pin, EPoint.fromLambda(x2, y), sX, sY, cell);
        if (ni == null) {
            return null;
        }
        pi = ni.getOnlyPortInst();
        Double key = new Double(x2 + y);
        List<NodeInst> pl = this.portHT.get(key);
        if (pl == null) {
            pl = new ArrayList<NodeInst>();
            this.portHT.put(key, pl);
        }
        pl.add(ni);
        return pi;
    }

    private String translateDefName(String name) {
        int quotedBracketPos = name.indexOf("\\[");
        if (quotedBracketPos >= 0) {
            name = name.replaceAll("\\\\\\[", "_").replaceAll("\\\\\\]", "_");
        }
        Matcher m_starleftbracket = this.pat_starleftbracket.matcher(name);
        Matcher m_starrightbracket = this.pat_starrightbracket.matcher(name);
        if (m_starleftbracket.matches() || m_starrightbracket.matches()) {
            Matcher m_leftbracket = this.pat_leftbracket.matcher(name);
            String tmpa = m_leftbracket.replaceAll("[");
            Matcher m_rightbracket = this.pat_rightbracket.matcher(tmpa);
            String tmpb = m_rightbracket.replaceAll("]");
            return tmpb;
        }
        return name;
    }

    private static class PortInstBound
    implements RTBounds {
        private final PortInst pi;
        private final FixpRectangle bound;

        PortInstBound(PortInst p, FixpRectangle b) {
            this.pi = p;
            this.bound = b;
        }

        @Override
        public FixpRectangle getBounds() {
            return this.bound;
        }
    }

    private class GetOrientation {
        private Orientation orient;

        private GetOrientation() throws IOException {
            int angle;
            String key = DEF.this.mustGetKeyword("orientation");
            if (key == null) {
                return;
            }
            boolean transpose2 = false;
            if (key.equalsIgnoreCase("N")) {
                angle = 0;
            } else if (key.equalsIgnoreCase("S")) {
                angle = 1800;
            } else if (key.equalsIgnoreCase("E")) {
                angle = 2700;
            } else if (key.equalsIgnoreCase("W")) {
                angle = 900;
            } else if (key.equalsIgnoreCase("FN")) {
                angle = 900;
                transpose2 = true;
            } else if (key.equalsIgnoreCase("FS")) {
                angle = 2700;
                transpose2 = true;
            } else if (key.equalsIgnoreCase("FE")) {
                angle = 1800;
                transpose2 = true;
            } else if (key.equalsIgnoreCase("FW")) {
                angle = 0;
                transpose2 = true;
            } else {
                DEF.this.reportError("Unknown orientation (" + key + ")");
                return;
            }
            this.orient = Orientation.fromC(angle, transpose2);
        }
    }

    public static class DEFPreferences
    extends Input.InputPreferences {
        public boolean physicalPlacement;
        public boolean ignorePhysicalInNets;
        public boolean usePureLayerNodes;
        public boolean logicalPlacement;
        public boolean ignoreLogicalInSpecialNets;
        public boolean makeDummyCells;
        public IconParameters iconParameters;

        public DEFPreferences(boolean factory) {
            super(factory);
            this.iconParameters = IconParameters.makeInstance(!factory);
            if (factory) {
                this.physicalPlacement = IOTool.isFactoryDEFPhysicalPlacement();
                this.ignorePhysicalInNets = IOTool.isFactoryDEFIgnorePhysicalInNets();
                this.usePureLayerNodes = IOTool.isFactoryDEFUsePureLayerNodes();
                this.logicalPlacement = IOTool.isFactoryDEFLogicalPlacement();
                this.ignoreLogicalInSpecialNets = IOTool.isFactoryDEFIgnoreLogicalInSpecialNets();
                this.makeDummyCells = IOTool.isFactoryDEFMakeDummyCells();
            } else {
                this.physicalPlacement = IOTool.isDEFPhysicalPlacement();
                this.ignorePhysicalInNets = IOTool.isDEFIgnorePhysicalInNets();
                this.usePureLayerNodes = IOTool.isDEFUsePureLayerNodes();
                this.logicalPlacement = IOTool.isDEFLogicalPlacement();
                this.ignoreLogicalInSpecialNets = IOTool.isDEFIgnoreLogicalInSpecialNets();
                this.makeDummyCells = IOTool.isDEFMakeDummyCells();
            }
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            DEF in = new DEF(ep, this);
            in.job = job;
            if (in.openTextInput(fileURL)) {
                return null;
            }
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            return lib;
        }
    }
}

