/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.collections.ImmutableArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import scala.Predef$;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001I4Q!\u0001\u0002\u0001\u0005)\u0011qBT8eK\u000e{gN\\3di&|gn\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002Z1uC\n\f7/\u001a\u0006\u0003\u000b\u0019\t\u0001\"\u001a7fGR\u0014\u0018n\u0019\u0006\u0003\u000f!\t1a];o\u0015\u0005I\u0011aA2p[N\u0019\u0001aC\n\u0011\u00051\tR\"A\u0007\u000b\u00059y\u0011\u0001\u00027b]\u001eT\u0011\u0001E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0013\u001b\t1qJ\u00196fGR\u0004\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u00111bU2bY\u0006|%M[3di\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\u0003be\u000e\u001c8\u0001\u0001\t\u0004)uy\u0012B\u0001\u0010\u0016\u0005\u0015\t%O]1z!\t\u0001\u0013%D\u0001\u0003\u0013\t\u0011#A\u0001\tJ[6,H/\u00192mK\u0006\u00138-\u00138ti\"AA\u0005\u0001B\u0001B\u0003%Q%A\u0004be\u000e,e\u000eZ:\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!z\u0011\u0001B;uS2L!AK\u0014\u0003\r\tKGoU3u\u0011!a\u0003A!A!\u0002\u0013i\u0013aB3ya>\u0014Ho\u001d\t\u0004)uq\u0003C\u0001\u00110\u0013\t\u0001$AA\bJ[6,H/\u00192mK\u0016C\bo\u001c:u\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q!A'\u000e\u001c8!\t\u0001\u0003\u0001C\u0003\u001bc\u0001\u0007A\u0004C\u0003%c\u0001\u0007Q\u0005C\u0003-c\u0001\u0007Q\u0006\u0003\u0004:\u0001\u0011\u0005!AO\u0001\bO\u0016$\u0018I]2t+\u0005a\u0002B\u0002\u001f\u0001\t\u0003\u0011Q(\u0001\u0006hKR\f%oY#oIN,\u0012!\n\u0005\u0007\u007f\u0001!\tA\u0001!\u0002\u0015\u001d,G/\u0012=q_J$8/F\u0001.\u0011\u0015\u0011\u0005\u0001\"\u0001D\u000399W\r^\"p]:,7\r^5p]N$\"\u0001R$\u0011\u0007\u0019*u$\u0003\u0002GO\t!A*[:u\u0011\u0015A\u0015\t1\u0001&\u0003!AW-\u00193F]\u0012\u001c\b\"\u0002\"\u0001\t\u0003QEc\u0001#L\u0019\")\u0001*\u0013a\u0001K!)Q*\u0013a\u0001\u001d\u00061\u0001o\u001c:u\u0013\u0012\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u0002\u0002\u0005%$\u0017BA*Q\u0005-\u0001vN\u001d;Qe>$x.\u00133\t\u000bU\u0003A\u0011\u0001,\u0002\u001d!\f7oQ8o]\u0016\u001cG/[8ogV\tq\u000b\u0005\u0002\u00151&\u0011\u0011,\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015)\u0006\u0001\"\u0001\\)\t9F\fC\u0003N5\u0002\u0007a\nC\u0003_\u0001\u0011\u0005q,A\thKRtU/\\\"p]:,7\r^5p]N,\u0012\u0001\u0019\t\u0003)\u0005L!AY\u000b\u0003\u0007%sG\u000fC\u0003e\u0001\u0011%Q-\u0001\ftK\u0006\u00148\r[\"p]:,7\r^5p]\nK\bk\u001c:u)\t\u0001g\rC\u0003hG\u0002\u0007\u0001-\u0001\u0006dQJ|g.\u00138eKbDQ!\u001b\u0001\u0005\u0002Y\u000b\u0001\u0003[1t\u000bb\u0004xN\u001d;t\u001f:tu\u000eZ3\t\u000b-\u0004A\u0011A0\u0002'\u001d,GOT;n\u000bb\u0004xN\u001d;t\u001f:tu\u000eZ3\t\u000b5\u0004A\u0011\u00018\u0002!\u001d,G/\u0012=q_J$8o\u00148O_\u0012,W#A8\u0011\u0007\u0019\u0002h&\u0003\u0002rO\tA\u0011\n^3sCR|'\u000f")
public class NodeConnections
implements ScalaObject {
    private final ImmutableArcInst[] arcs;
    private final BitSet arcEnds;
    private final ImmutableExport[] exports;

    public ImmutableArcInst[] getArcs() {
        return this.arcs;
    }

    public BitSet getArcEnds() {
        return this.arcEnds;
    }

    public ImmutableExport[] getExports() {
        return this.exports;
    }

    public List<ImmutableArcInst> getConnections(BitSet headEnds) {
        if (headEnds != null) {
            headEnds.clear();
            headEnds.or(this.arcEnds);
        }
        return Predef$.MODULE$.refArrayOps((Object[])this.arcs).isEmpty() ? Collections.emptyList() : new ImmutableArrayList<Object>((Object[])this.arcs);
    }

    public List<ImmutableArcInst> getConnections(BitSet headEnds, PortProtoId portId) {
        int i;
        int j;
        int chronIndex = portId.chronIndex;
        for (j = i = this.searchConnectionByPort(chronIndex); j < this.arcs.length; ++j) {
            PortProtoId portProtoId;
            PortProtoId portProtoId2 = portId;
            PortProtoId portProtoId3 = portProtoId = this.arcEnds.get(j) ? this.arcs[j].headPortId : this.arcs[j].tailPortId;
            if (portProtoId2 != null ? !portProtoId2.equals(portProtoId) : portProtoId != null) break;
        }
        if (headEnds != null) {
            headEnds.clear();
            for (int k = i; k < j; ++k) {
                if (!this.arcEnds.get(k)) continue;
                headEnds.set(k - i);
            }
        }
        return i < j ? new ImmutableArrayList<Object>((Object[])this.arcs, i, j) : Collections.emptyList();
    }

    public boolean hasConnections() {
        return !Predef$.MODULE$.refArrayOps((Object[])this.arcs).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasConnections(PortProtoId portId) {
        PortProtoId portProtoId;
        int i = this.searchConnectionByPort(portId.chronIndex);
        if (i >= this.arcs.length) return false;
        ImmutableArcInst a = this.arcs[i];
        boolean end = this.arcEnds.get(i);
        PortProtoId portProtoId2 = portId;
        PortProtoId portProtoId3 = portProtoId = end ? a.headPortId : a.tailPortId;
        if (portProtoId2 != null) {
            if (!portProtoId2.equals(portProtoId)) return false;
            return true;
        }
        if (portProtoId == null) return true;
        return false;
    }

    public int getNumConnections() {
        return Predef$.MODULE$.refArrayOps((Object[])this.arcs).size();
    }

    /*
     * WARNING - void declaration
     */
    private int searchConnectionByPort(int chronIndex) {
        void var2_2;
        int low = 0;
        int high = this.arcs.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            ImmutableArcInst a = this.arcs[mid];
            boolean end = this.arcEnds.get(mid);
            PortProtoId portId = end ? a.headPortId : a.tailPortId;
            int cmp = portId.getChronIndex() - chronIndex;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return (int)var2_2;
    }

    public boolean hasExportsOnNode() {
        return !Predef$.MODULE$.refArrayOps((Object[])this.exports).isEmpty();
    }

    public int getNumExportsOnNode() {
        return Predef$.MODULE$.refArrayOps((Object[])this.exports).size();
    }

    public Iterator<ImmutableExport> getExportsOnNode() {
        return ArrayIterator.iterator((Object[])this.exports);
    }

    public NodeConnections(ImmutableArcInst[] arcs, BitSet arcEnds, ImmutableExport[] exports) {
        this.arcs = arcs;
        this.arcEnds = arcEnds;
        this.exports = exports;
    }
}

