/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.ELIB;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.JelibParser;
import com.sun.electric.tool.io.output.JELIB;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryStatistics
implements Serializable {
    private static final long serialVersionUID = -361650802811567400L;
    private transient IdManager idManager;
    private final TreeMap<String, Directory> directories = new TreeMap();
    private final TreeMap<String, LibraryName> libraryNames = new TreeMap();
    transient VarStat varStat = new VarStat();

    private LibraryStatistics(IdManager idManager) {
        this.idManager = idManager;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.idManager = new IdManager();
        in.defaultReadObject();
    }

    Directory getDirectory(String dirName) {
        Directory dir = this.directories.get(dirName);
        if (dir == null) {
            dir = new Directory(this, dirName);
        }
        return dir;
    }

    LibraryName getLibraryName(String name) {
        LibraryName libraryName = this.libraryNames.get(name);
        if (libraryName == null) {
            libraryName = new LibraryName(this, name);
        }
        return libraryName;
    }

    Iterator<Directory> getDirectories() {
        return this.directories.values().iterator();
    }

    Iterator<LibraryName> getLibraryNames() {
        return this.libraryNames.values().iterator();
    }

    public static void scanProjectDirs(String[] dirNames, String[] excludeDirs, File projListDir) {
        HashSet<String> canonicalDirs = new HashSet<String>();
        TreeSet<String> projectDirs = new TreeSet<String>();
        for (int i = 0; i < dirNames.length; ++i) {
            LibraryStatistics.scanProjectDir(new File(dirNames[i]), excludeDirs, canonicalDirs, projectDirs);
        }
        File projListFile = new File(projListDir, "proj.list");
        try {
            PrintWriter out = new PrintWriter(projListFile);
            Iterator<String> it = projectDirs.iterator();
            while (it.hasNext()) {
                out.println(it.next());
            }
            out.close();
        }
        catch (IOException e) {
            System.out.println("Error writing " + projListFile);
            e.printStackTrace();
        }
    }

    private static void scanProjectDir(File dir, String[] excludeDirs, Set<String> canonicalDirs, TreeSet<String> projectDirs) {
        try {
            String canonicalDir = dir.getCanonicalPath();
            if (canonicalDirs.contains(canonicalDir)) {
                return;
            }
            canonicalDirs.add(canonicalDir);
            if (!canonicalDir.equals(dir.getPath())) {
                System.out.println(dir + " -> " + canonicalDir);
            }
            dir = new File(canonicalDir);
            assert (dir.getPath().equals(canonicalDir));
        }
        catch (IOException e) {
            System.out.println(dir + " CANONICAL FAILED");
            return;
        }
        for (String excludeDir : excludeDirs) {
            if (!dir.getPath().equals(excludeDir)) continue;
            System.out.println(dir + " EXCLUDED");
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            System.out.println(dir + " ACCESS DENIED");
            return;
        }
        boolean libdirs = false;
        int xmls = 0;
        int txts = 0;
        int elibs = 0;
        int jelibs = 0;
        int delibs = 0;
        for (File file : files) {
            int extensionPos;
            String name = file.getName();
            if (name.startsWith("._") || (extensionPos = name.lastIndexOf(46)) < 0) continue;
            String extension = name.substring(extensionPos);
            name = name.substring(0, extensionPos);
            if (file.isDirectory()) {
                if (!extension.equals(".delib")) continue;
                ++delibs;
                continue;
            }
            if (name.equals("LIBDIRS")) {
                libdirs = true;
            }
            if (extension.equals(".xml")) {
                ++xmls;
            }
            if (extension.equals(".txt")) {
                ++txts;
            }
            if (extension.equals(".elib")) {
                ++elibs;
            }
            if (!extension.equals(".jelib")) continue;
            ++jelibs;
        }
        if (delibs > 0 || elibs > 0 || jelibs > 0) {
            String projectDir = dir.getPath();
            System.out.print(projectDir + " :");
            if (libdirs) {
                System.out.print(" LIBDIRS");
            }
            if (xmls > 0) {
                System.out.print(" " + xmls + " xmls");
            }
            if (txts > 0) {
                System.out.print(" " + txts + " txts");
            }
            if (elibs > 0) {
                System.out.print(" " + elibs + " elibs");
            }
            if (jelibs > 0) {
                System.out.print(" " + jelibs + " jelibs");
            }
            if (delibs > 0) {
                System.out.print(" " + delibs + " delibs");
            }
            System.out.println();
            assert (canonicalDirs.contains(projectDir));
            boolean added = projectDirs.add(projectDir);
            assert (added);
        }
        for (File file : files) {
            if (!file.isDirectory() || file.getName().equals("CVS")) continue;
            LibraryStatistics.scanProjectDir(file, excludeDirs, canonicalDirs, projectDirs);
        }
    }

    public static TreeSet<String> readProjList(File wrkDir) {
        File projListFile = new File(wrkDir, "proj.list");
        try {
            String line;
            TreeSet<String> dirs = new TreeSet<String>();
            BufferedReader in = new BufferedReader(new FileReader(projListFile));
            while ((line = in.readLine()) != null) {
                if (line.length() == 0) continue;
                boolean added = dirs.add(line);
                assert (added);
            }
            in.close();
            return dirs;
        }
        catch (IOException e) {
            System.out.println("Error reading " + projListFile + " : " + e);
            return null;
        }
    }

    public static Map<String, File[]> readProjectDirs(File wrkDir, boolean allDirs) {
        String projectsExt = ".projects";
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".projects");
            }
        };
        TreeMap<String, File[]> projectDirs = new TreeMap<String, File[]>();
        for (File file : wrkDir.listFiles(filter)) {
            String projectName = file.getName();
            assert (projectName.endsWith(".projects"));
            projectName = projectName.substring(0, projectName.length() - ".projects".length());
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(file));
                ArrayList<File> dirs = new ArrayList<File>();
                while ((line = in.readLine()) != null) {
                    char firstChar;
                    if (line.length() == 0 || ((firstChar = line.charAt(0)) == '-' ? !allDirs : firstChar != '+')) continue;
                    String fileName = line.substring(1);
                    dirs.add(new File(fileName));
                }
                in.close();
                projectDirs.put(projectName, dirs.toArray(new File[dirs.size()]));
            }
            catch (IOException e) {
                System.out.println("Error reading " + file);
                e.printStackTrace();
            }
        }
        return projectDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LibraryStatistics scanDirectories(IdManager idManager, File[] dirs) {
        LibraryStatistics stat = new LibraryStatistics(idManager);
        HashSet<String> canonicalDirs = new HashSet<String>();
        HashMap<String, Set<FileInstance>> preLibraries = new HashMap<String, Set<FileInstance>>();
        for (File dir : dirs) {
            stat.scanDir(dir, canonicalDirs, preLibraries, null);
        }
        byte[] buf = new byte[65536];
        for (Map.Entry entry : preLibraries.entrySet()) {
            String libName = (String)entry.getKey();
            TreeSet files = (TreeSet)entry.getValue();
            LibraryName libraryName = new LibraryName(stat, libName);
            while (!files.isEmpty()) {
                FileInstance f = (FileInstance)files.iterator().next();
                files.remove(f);
                FileContents fc = new FileContents(libraryName, f);
                byte[] bytes = null;
                int len = (int)f.fileLength;
                Iterator it = files.iterator();
                block14: while (it.hasNext()) {
                    FileInstance f1 = (FileInstance)it.next();
                    if (f1.fileLength != (long)len || f1.crc != f.crc) continue;
                    if (!f.canonicalPath.equals(f1.canonicalPath)) {
                        Input in;
                        if (bytes == null) {
                            in = new Input();
                            if (in.openBinaryInput(f1.getUrl())) continue;
                            try {
                                bytes = new byte[len];
                                try {
                                    in.dataInputStream.readFully(bytes);
                                }
                                catch (IOException e) {
                                    in.closeInput();
                                    continue;
                                }
                                in.closeInput();
                            }
                            catch (Throwable throwable) {
                                in.closeInput();
                                throw throwable;
                            }
                        }
                        if ((in = new Input()).openBinaryInput(f1.getUrl())) continue;
                        try {
                            int count;
                            for (int n = 0; n < len; n += count) {
                                count = -1;
                                try {
                                    count = in.dataInputStream.read(buf, 0, Math.min(len - n, buf.length));
                                }
                                catch (IOException ex) {
                                    // empty catch block
                                }
                                if (count < 0) continue block14;
                                for (int i = 0; i < count; ++i) {
                                    if (buf[i] == bytes[n + i]) continue;
                                    in.closeInput();
                                    continue block14;
                                }
                            }
                        }
                        finally {
                            in.closeInput();
                            continue;
                        }
                    }
                    it.remove();
                    fc.add(f1);
                }
            }
        }
        return stat;
    }

    private void scanDir(File dir, Set<String> canonicalDirs, Map<String, Set<FileInstance>> preLibraries, String parentLibName) {
        int i;
        int extPos;
        try {
            String canonicalDir = dir.getCanonicalPath();
            if (canonicalDirs.contains(canonicalDir)) {
                return;
            }
            canonicalDirs.add(canonicalDir);
            dir = new File(canonicalDir);
        }
        catch (IOException e) {
            System.out.println(dir + " CANONICAL FAILED");
            return;
        }
        if (dir.getPath().equals("/import/async/archive/2005/tic/gilda/TreasureIsland/electric-old/projectManagement") || dir.getPath().equals("/import/async/archive/2005/tic/jkg/projectTest") || dir.getPath().equals("/import/async/cad/cvs")) {
            System.out.println(dir + " IGNORED");
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            System.out.println(dir + " ACCESS DENIED");
            return;
        }
        boolean isDelib = dir.getName().endsWith(".delib");
        String libName = null;
        if (isDelib && (extPos = (libName = dir.getName()).lastIndexOf(46)) >= 0) {
            libName = libName.substring(0, extPos);
        }
        boolean libFound = false;
        for (i = 0; i < files.length; ++i) {
            int extensionPos;
            String name;
            if (files[i].isDirectory() || (name = files[i].getName()).startsWith("._") || (extensionPos = name.lastIndexOf(46)) < 0) continue;
            String extension = name.substring(extensionPos);
            name = name.substring(0, extensionPos);
            if (!extension.equals(".elib") && !extension.equals(".jelib") && (!isDelib || extension.equals(".bak") || extension.equals(".log")) && parentLibName == null) continue;
            if (!libFound) {
                System.out.println(dir.toString());
                libFound = true;
            }
            String strippedName = isDelib ? libName + ":" + name : (parentLibName != null ? parentLibName + ":" + name : LibraryStatistics.stripBackup(name));
            try {
                FileInstance f = new FileInstance(this, files[i].toString());
                Set<FileInstance> libFiles = preLibraries.get(strippedName);
                if (libFiles == null) {
                    libFiles = new TreeSet<FileInstance>();
                    preLibraries.put(strippedName, libFiles);
                }
                libFiles.add(f);
                continue;
            }
            catch (IOException e) {
                System.out.println(files[i] + " FAILED " + e);
            }
        }
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory() || files[i].getName().equals("CVS")) continue;
            this.scanDir(files[i], canonicalDirs, preLibraries, isDelib ? libName : null);
        }
    }

    public void readHeaders(ErrorLogger errorLogger) {
        Iterator<LibraryName> lit = this.getLibraryNames();
        while (lit.hasNext()) {
            LibraryName libraryName = lit.next();
            Iterator<FileContents> it = libraryName.getVersions();
            while (it.hasNext()) {
                URL fileUrl;
                FileContents fc = it.next();
                if (!fc.isElib()) continue;
                Iterator<URL> uit = fc.fileUrl();
                while (uit.hasNext() && ELIB.readStatistics(fileUrl = uit.next(), errorLogger, fc)) {
                }
                if (fc.header != null) continue;
                System.out.println(fc.fileUrl().next() + " INVALID HEADER");
            }
        }
    }

    public void readJelibVersions(ErrorLogger errorLogger) {
        Iterator<LibraryName> lit = this.getLibraryNames();
        while (lit.hasNext()) {
            LibraryName libraryName = lit.next();
            Iterator<FileContents> it = libraryName.getVersions();
            block3: while (it.hasNext()) {
                FileContents fc = it.next();
                if (fc.isElib()) continue;
                Iterator<URL> uit = fc.fileUrl();
                while (uit.hasNext()) {
                    URL fileUrl = uit.next();
                    try {
                        JelibParser parser = JelibParser.parse(libraryName.getLibId(), fileUrl, FileType.JELIB, false, errorLogger);
                        fc.version = parser.version;
                        TreeMap<String, ExternalCell> externalCells = new TreeMap<String, ExternalCell>();
                        for (JelibParser.CellContents cc : parser.allCells.values()) {
                            fc.localCells.add(cc.cellId.cellName.toString());
                            for (JelibParser.NodeContents nc : cc.nodes) {
                                CellId cellId;
                                if (!(nc.protoId instanceof CellId) || externalCells.containsKey((cellId = (CellId)nc.protoId).toString())) continue;
                                String libPath = parser.externalLibIds.get(cellId.libId);
                                ExternalCell ec = new ExternalCell(libPath, cellId.libId.libName, cellId.cellName.toString());
                                externalCells.put(cellId.toString(), ec);
                            }
                        }
                        fc.externalCells.addAll(externalCells.values());
                        continue block3;
                    }
                    catch (Exception e) {
                        System.out.println("Error reading " + fileUrl + " " + e.getMessage());
                    }
                }
            }
        }
    }

    public static void checkLibraries(ErrorLogger errorLogger, File[] dirs) {
        for (File dir : dirs) {
            LibraryStatistics.checkLibrariesInProject(errorLogger, dir);
        }
    }

    private static void checkLibrariesInProject(ErrorLogger errorLogger, File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            System.out.println(dir + " ACCESS DENIED");
            return;
        }
        for (File file : files) {
            String name = file.getName();
            if (name.endsWith(".jelib")) {
                LibraryStatistics.checkJelib(errorLogger, file, FileType.JELIB);
                continue;
            }
            if (!name.endsWith(".delib")) continue;
            LibraryStatistics.checkJelib(errorLogger, file, FileType.DELIB);
        }
    }

    private static void checkJelib(ErrorLogger errorLogger, File file, FileType fileType) {
        try {
            IdManager idManager = new IdManager();
            String libName = file.getName();
            int extPos = libName.lastIndexOf(46);
            if (extPos >= 0) {
                libName = libName.substring(0, extPos);
            }
            LibId libId = idManager.newLibId(LibId.legalLibraryName(libName));
            URL fileUrl = file.toURI().toURL();
            JelibParser parser = JelibParser.parse(libId, fileUrl, fileType, false, errorLogger);
            LibraryStatistics.checkVars(parser.libVars, file);
            for (JelibParser.CellContents cc : parser.allCells.values()) {
                LibraryStatistics.checkVars(cc.vars, file);
                for (JelibParser.NodeContents nc : cc.nodes) {
                    LibraryStatistics.checkVars(nc.vars, file);
                }
                for (JelibParser.ArcContents ac : cc.arcs) {
                    LibraryStatistics.checkVars(ac.vars, file);
                }
                for (JelibParser.ExportContents ec : cc.exports) {
                    LibraryStatistics.checkVars(ec.vars, file);
                }
            }
            TreeMap<CellName, ArrayList<JelibParser.CellContents>> groups = new TreeMap<CellName, ArrayList<JelibParser.CellContents>>();
            for (JelibParser.CellContents cellContents : parser.allCells.values()) {
                ArrayList<JelibParser.CellContents> group = (ArrayList<JelibParser.CellContents>)groups.get(cellContents.groupName);
                if (group == null) {
                    group = new ArrayList<JelibParser.CellContents>();
                    groups.put(cellContents.groupName, group);
                }
                group.add(cellContents);
            }
            for (Map.Entry entry : groups.entrySet()) {
                Variable[] params;
                CellName groupName = (CellName)entry.getKey();
                ArrayList cells = (ArrayList)entry.getValue();
                int numParameterizedCells = 0;
                for (JelibParser.CellContents cc : cells) {
                    params = LibraryStatistics.getParams(cc);
                    if (params.length <= 0) continue;
                    ++numParameterizedCells;
                }
                if (numParameterizedCells <= 1) continue;
                System.out.println("Checking " + file);
                System.out.println("***** Group " + libId + ":" + groupName + " has params");
                for (JelibParser.CellContents cc : cells) {
                    params = LibraryStatistics.getParams(cc);
                    if (params.length == 0) continue;
                    CellName cellName = cc.cellId.cellName;
                    System.out.print("    " + cellName);
                    for (Variable var : params) {
                        System.out.print(" " + var + "(" + JELIB.describeDescriptor(var, var.getTextDescriptor(), true) + ")" + var.getObject());
                    }
                    System.out.println();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error reading " + file + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void checkVars(Variable[] vars, File file) {
        for (Variable var : vars) {
            if (!var.isCode() || var.getObject() instanceof String) continue;
            System.out.println("$$$$$ Variable " + var.getPureValue(-1) + " in " + file);
        }
    }

    private static Variable[] getParams(JelibParser.CellContents cc) {
        int count = 0;
        for (Variable var : cc.vars) {
            if (!var.getTextDescriptor().isParam() || var.getKey() == NccCellAnnotations.NCC_ANNOTATION_KEY) continue;
            ++count;
        }
        if (count == 0) {
            return Variable.NULL_ARRAY;
        }
        Variable[] params = new Variable[count];
        count = 0;
        for (Variable var : cc.vars) {
            if (!var.getTextDescriptor().isParam() || var.getKey() == NccCellAnnotations.NCC_ANNOTATION_KEY) continue;
            params[count++] = var;
        }
        return params;
    }

    public void writeList(String fileName) {
        try {
            new StatisticsOutput(fileName);
        }
        catch (IOException e) {
            System.out.println("Error storing LibraryStatistics to " + fileName + " " + e);
        }
    }

    public static LibraryStatistics readList(IdManager idManager, String fileName) {
        URL fileURL = TextUtils.makeURLToFile(fileName);
        try {
            StatisticsInput in = new StatisticsInput(idManager, fileURL);
            return in.stat;
        }
        catch (IOException e) {
            System.out.println("Error loading LibraryStatistics from " + fileName + " " + e);
            return null;
        }
    }

    public void writeSerialized(String fileName) {
        try {
            new StatisticsOutputSerialized(fileName);
        }
        catch (IOException e) {
            System.out.println("Error storing LibraryStatistics to " + fileName + " " + e);
        }
    }

    public static LibraryStatistics readSerialized(String fileName) {
        URL fileURL = TextUtils.makeURLToFile(fileName);
        try {
            StatisticsInputSerialized in = new StatisticsInputSerialized(fileURL);
            return in.stat;
        }
        catch (IOException e) {
            System.out.println("Error loading LibraryStatistics from " + fileName + " " + e);
            return null;
        }
    }

    public void reportFileLength() {
        int elibUniqueCount = 0;
        int jelibUniqueCount = 0;
        int elibCount = 0;
        int jelibCount = 0;
        long elibUniqueLength = 0L;
        long jelibUniqueLength = 0L;
        long elibLength = 0L;
        long jelibLength = 0L;
        TreeMap headerCounts = new TreeMap();
        int withoutHeader = 0;
        TreeMap versionCounts = new TreeMap();
        int withoutVersion = 0;
        Iterator<LibraryName> lit = this.getLibraryNames();
        while (lit.hasNext()) {
            LibraryName libraryName = lit.next();
            libraryName.getLibId();
            Iterator<FileContents> it = libraryName.getVersions();
            while (it.hasNext()) {
                FileContents fc = it.next();
                if (fc.isElib()) {
                    ++elibUniqueCount;
                    elibCount += fc.instances.size();
                    elibUniqueLength += fc.fileLength;
                    elibLength += fc.fileLength * (long)fc.instances.size();
                    if (fc.header != null) {
                        GenMath.addToBag(headerCounts, fc.header);
                    } else {
                        ++withoutHeader;
                    }
                } else {
                    ++jelibUniqueCount;
                    jelibCount += fc.instances.size();
                    jelibUniqueLength += fc.fileLength;
                    jelibLength += fc.fileLength * (long)fc.instances.size();
                }
                if (fc.version != null) {
                    GenMath.addToBag(versionCounts, fc.version);
                } else {
                    ++withoutVersion;
                }
                System.out.println(fc.getFileName() + " " + fc.version);
            }
        }
        System.out.println("Scanned " + this.directories.size() + " directories. " + this.libraryNames.size() + " library names");
        System.out.println((elibUniqueLength >> 20) + "M (" + elibUniqueLength + ") in " + elibUniqueCount + " ELIB files ( unique )");
        System.out.println((elibLength >> 20) + "M (" + elibLength + ") in " + elibCount + " ELIB files ( with duplicates )");
        System.out.println("NOHEADER:" + withoutHeader + LibraryStatistics.bagReport(headerCounts));
        System.out.println((jelibUniqueLength >> 20) + "M (" + jelibUniqueLength + ") in " + jelibUniqueCount + " JELIB files ( unique )");
        System.out.println((jelibLength >> 20) + "M (" + jelibLength + ") in " + jelibCount + " JELIB files ( with duplicates )");
        System.out.println("NOVERSION:" + withoutVersion + LibraryStatistics.bagReport(versionCounts));
    }

    public void reportFilePaths() {
        TreeMap paths = new TreeMap();
        System.out.println(this.directories.size() + " Directories");
        Iterator<Directory> it = this.getDirectories();
        while (it.hasNext()) {
            Directory directory = it.next();
            String projName = directory.dirName;
            if (projName.startsWith("/import/async/cad/tools/electric/builds/svn") || projName.startsWith("/import/async/archive/2005/tic/gilda/TreasureIsland/electric-old/projectManagement") || projName.startsWith("/import/async/archive/2005/tic/jkg/projectTest") || projName.startsWith("/import/async/cad/cvs")) continue;
            int delibPos = projName.indexOf(".delib");
            if (delibPos >= 0) {
                int slashPos = projName.lastIndexOf(47, delibPos);
                projName = projName.substring(0, slashPos);
            }
            GenMath.addToBag(paths, projName);
        }
        System.out.println(paths.size() + " Projects");
        for (Map.Entry e : paths.entrySet()) {
            System.out.println((String)e.getKey());
        }
    }

    public void reportCells() {
        Iterator<LibraryName> lit = this.getLibraryNames();
        while (lit.hasNext()) {
            LibraryName libraryName = lit.next();
            System.out.println("LibraryName " + libraryName.getLibId() + " " + libraryName.getName());
            Iterator<FileContents> it = libraryName.getVersions();
            while (it.hasNext()) {
                FileContents fc = it.next();
                System.out.println("    " + fc.getFileName() + " " + fc.fileLength + " " + fc.localCells.size() + " " + fc.externalCells.size());
                for (String localName : fc.localCells) {
                    System.out.println("\t" + localName);
                }
                for (ExternalCell extCell : fc.externalCells) {
                    System.out.println("\t" + extCell.libPath + " " + extCell.libName + " " + extCell.cellName);
                }
            }
        }
    }

    public static VarStat readVariableNames(String fileName) {
        URL fileURL = TextUtils.makeURLToFile(fileName);
        try {
            StatisticsInputVariableNames in = new StatisticsInputVariableNames(fileURL);
            long totalVars = 0L;
            long[] typeCounts = new long[32];
            long[] typeTotals = new long[32];
            TreeMap charCount = new TreeMap();
            TreeMap charTotal = new TreeMap();
            TreeMap bitsCount = new TreeMap();
            TreeMap bitsTotal = new TreeMap();
            for (VarDesc vd : ((StatisticsInputVariableNames)in).vs.varBag.values()) {
                Character character = new Character(vd.role.charAt(0));
                GenMath.addToBag(charCount, character);
                GenMath.addToBag(charTotal, character, vd.count);
                VarDesc vd1 = new VarDesc();
                vd1.role = "";
                vd1.varName = "";
                vd1.varBits = Character.isUpperCase(vd.role.charAt(0)) ? vd.varBits & 0xE00001FF : 68;
                vd1.td0 = vd.td0;
                vd1.td1 = vd.td1;
                GenMath.addToBag(bitsCount, vd1);
                GenMath.addToBag(bitsTotal, vd1, vd.count);
                totalVars += (long)vd.count;
                int n = vd.varBits & 0x1F;
                typeCounts[n] = typeCounts[n] + 1L;
                int n2 = vd.varBits & 0x1F;
                typeTotals[n2] = typeTotals[n2] + (long)vd.count;
                if ((vd.varBits & 0x1F) == 7) {
                    System.out.println("VNODEINST " + vd.role + " " + vd.varName);
                }
                if ((vd.varBits & 0x1F) == 8) {
                    System.out.println("VNODEPROTO " + vd.role + " " + vd.varName);
                }
                if ((vd.varBits & 0x20000020) == 0) continue;
                System.out.println(Integer.toOctalString(vd.varBits) + " " + vd.role + " " + vd.varName);
            }
            System.out.println(((StatisticsInputVariableNames)in).vs.varBag.size() + " bag: " + LibraryStatistics.bagReport(charCount));
            System.out.println(totalVars + "bagTotal: " + LibraryStatistics.bagReport(charTotal));
            for (int i = 0; i < 32; ++i) {
                System.out.println(Integer.toOctalString(i) + " " + typeCounts[i] + " " + typeTotals[i]);
            }
            for (Map.Entry entry : bitsCount.entrySet()) {
                VarDesc vd = (VarDesc)entry.getKey();
                System.out.println(vd.role + " " + Integer.toOctalString(vd.varBits) + " " + Integer.toOctalString(vd.td0) + " " + Integer.toOctalString(vd.td1) + " " + GenMath.countInBag(bitsCount, vd) + " " + GenMath.countInBag(bitsTotal, vd));
            }
            System.out.println(bitsCount.size() + " variable descriptors");
            return in.vs;
        }
        catch (IOException e) {
            System.out.println("Error loading LibraryStatistics from " + fileName + " " + e);
            return null;
        }
    }

    private static String stripBackup(String libName) {
        int i;
        for (i = libName.length(); i > 0 && Character.isDigit(libName.charAt(i - 1)); --i) {
        }
        if (i == libName.length()) {
            return libName;
        }
        if (i > 3 && libName.charAt(i - 1) == '-' && libName.charAt(i - 2) == '-' && Character.isDigit(libName.charAt(i - 3))) {
            i -= 3;
            while (i > 0 && Character.isDigit(libName.charAt(i - 1))) {
                --i;
            }
        }
        if (i < 2 || libName.charAt(i - 1) != '-' || !Character.isDigit(libName.charAt(i - 2))) {
            return libName;
        }
        i -= 2;
        while (i > 0 && Character.isDigit(libName.charAt(i - 1))) {
            --i;
        }
        if (i < 2 || libName.charAt(i - 1) != '-' || !Character.isDigit(libName.charAt(i - 2))) {
            return libName;
        }
        i -= 2;
        while (i > 0 && Character.isDigit(libName.charAt(i - 1))) {
            --i;
        }
        if (i < 1 || libName.charAt(i - 1) != '-') {
            return libName;
        }
        return libName.substring(0, i - 1);
    }

    static <T> String bagReport(Map<T, GenMath.MutableInteger> bag) {
        String s = "";
        for (Map.Entry<T, GenMath.MutableInteger> e : bag.entrySet()) {
            GenMath.MutableInteger count = e.getValue();
            s = s + " " + e.getKey() + ":" + count.intValue();
        }
        return s;
    }

    private class StatisticsOutputVariableNames
    extends Output {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsOutputVariableNames(String filePath) throws IOException {
            if (this.openBinaryOutputStream(filePath)) {
                throw new IOException("openStatisticsOutputSerialized");
            }
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.dataOutputStream);
                objectOutputStream.writeObject(LibraryStatistics.this.varStat);
                objectOutputStream.close();
                int total = 0;
                Iterator it = LibraryStatistics.this.varStat.varBag.values().iterator();
                while (it.hasNext()) {
                    total += ((VarDesc)it.next()).count;
                }
                System.out.println(LibraryStatistics.this.varStat.varBag.size() + " (" + total + ") variable descriptors");
            }
            finally {
                this.closeBinaryOutputStream();
            }
        }
    }

    private static class StatisticsInputVariableNames
    extends Input {
        private VarStat vs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsInputVariableNames(URL url) throws IOException {
            if (this.openBinaryInput(url)) {
                throw new IOException("openStatisticsInputVariableNames");
            }
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.dataInputStream);
                try {
                    this.vs = (VarStat)objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                objectInputStream.close();
            }
            finally {
                this.closeInput();
            }
        }
    }

    static class VarStat
    implements Serializable {
        private static final long serialVersionUID = -2536836777200853733L;
        TreeMap varNamePool = new TreeMap();
        TreeMap varBag = new TreeMap();
        TreeMap userBitsBag = new TreeMap();
        transient TreeMap otherStrings = new TreeMap();
        transient VarDesc dummyVarDesc = new VarDesc();
        transient UserBits dummyUserBits = new UserBits();

        VarStat() {
        }

        String getVarName(String name) {
            String v = (String)this.varNamePool.get(name);
            if (v == null) {
                v = name;
                this.varNamePool.put(v, v);
            }
            return v;
        }

        void addVarDesc(String varName, int varBits, int td0, int td1, String role) {
            this.dummyVarDesc.varName = varName;
            this.dummyVarDesc.varBits = varBits;
            this.dummyVarDesc.td0 = td0;
            this.dummyVarDesc.td1 = td1 &= 0xFFC07FFF;
            this.dummyVarDesc.role = role;
            VarDesc v = (VarDesc)this.varBag.get(this.dummyVarDesc);
            if (v == null) {
                v = new VarDesc();
                v.varName = this.getVarName(varName);
                v.varBits = varBits;
                v.td0 = td0;
                v.td1 = td1;
                v.role = (String)this.otherStrings.get(role);
                if (v.role == null) {
                    v.role = role;
                    this.otherStrings.put(role, role);
                }
                this.varBag.put(v, v);
            }
            ++v.count;
        }

        void addUserBits(int userBits, String role) {
            this.dummyUserBits.bits = userBits;
            this.dummyUserBits.role = role;
            UserBits u = (UserBits)this.userBitsBag.get(this.dummyUserBits);
            if (u == null) {
                u = new UserBits();
                u.bits = userBits;
                u.role = (String)this.otherStrings.get(role);
                if (u.role == null) {
                    u.role = role;
                    this.otherStrings.put(role, role);
                }
                this.userBitsBag.put(u, u);
            }
            ++u.count;
        }
    }

    static class UserBits
    implements Serializable,
    Comparable {
        String role;
        int bits;
        int count;

        UserBits() {
        }

        public int compareTo(Object o) {
            UserBits u = (UserBits)o;
            int cmp = this.role.compareTo(u.role);
            if (cmp != 0) {
                return cmp;
            }
            if (this.bits > u.bits) {
                return 1;
            }
            if (this.bits < u.bits) {
                return -1;
            }
            return 0;
        }
    }

    static class VarDesc
    implements Serializable,
    Comparable {
        String role;
        String varName;
        int varBits;
        int td0;
        int td1;
        int count;

        VarDesc() {
        }

        public int compareTo(Object o) {
            VarDesc v = (VarDesc)o;
            int cmp = this.role.compareTo(v.role);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.varName.compareTo(v.varName);
            if (cmp != 0) {
                return cmp;
            }
            if (this.varBits > v.varBits) {
                return 1;
            }
            if (this.varBits < v.varBits) {
                return -1;
            }
            if (this.td0 > v.td0) {
                return 1;
            }
            if (this.td0 < v.td0) {
                return -1;
            }
            if (this.td1 > v.td1) {
                return 1;
            }
            if (this.td1 < v.td1) {
                return -1;
            }
            return 0;
        }
    }

    private class StatisticsOutputSerialized
    extends Output {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsOutputSerialized(String filePath) throws IOException {
            if (this.openBinaryOutputStream(filePath)) {
                throw new IOException("openStatisticsOutputSerialized");
            }
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.dataOutputStream);
                objectOutputStream.writeObject(LibraryStatistics.this);
                objectOutputStream.close();
            }
            finally {
                this.closeBinaryOutputStream();
            }
        }
    }

    private static class StatisticsInputSerialized
    extends Input {
        private LibraryStatistics stat;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsInputSerialized(URL url) throws IOException {
            if (this.openBinaryInput(url)) {
                throw new IOException("openStatisticsInputSerialized");
            }
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.dataInputStream);
                try {
                    this.stat = (LibraryStatistics)objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                objectInputStream.close();
            }
            finally {
                this.closeInput();
            }
        }
    }

    private class StatisticsOutput
    extends Output {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsOutput(String filePath) throws IOException {
            if (this.openTextOutputStream(filePath)) {
                throw new IOException("openStatisticsOutput");
            }
            try {
                Iterator<LibraryName> lit = LibraryStatistics.this.getLibraryNames();
                while (lit.hasNext()) {
                    LibraryName libraryName = lit.next();
                    this.printWriter.println(libraryName.getName());
                    Iterator<FileContents> it = libraryName.getVersions();
                    while (it.hasNext()) {
                        FileContents fc = it.next();
                        Date date = new Date(fc.lastModified);
                        this.printWriter.println("    " + fc.fileLength + " " + Long.toHexString(fc.crc) + " " + TextUtils.formatDateGMT(date));
                        for (FileInstance f : fc.instances) {
                            date = new Date(f.lastModified);
                            this.printWriter.println("        " + f.fileName + " " + f.lastModified + " " + TextUtils.formatDateGMT(date));
                        }
                    }
                }
            }
            finally {
                this.closeTextOutputStream();
            }
        }
    }

    private static class StatisticsInput
    extends Input {
        private LibraryStatistics stat;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StatisticsInput(IdManager idManager, URL url) throws IOException {
            block22: {
                if (this.openTextInput(url)) {
                    throw new IOException("openStatisticsInput");
                }
                try {
                    String line;
                    this.stat = new LibraryStatistics(idManager);
                    LibraryName libraryName = null;
                    long fileLength = 0L;
                    long crc = 0L;
                    FileContents fc = null;
                    while (true) {
                        if ((line = this.lineReader.readLine()) == null) {
                            break block22;
                        }
                        if (line.length() == 0) continue;
                        if (line.charAt(0) != ' ') {
                            libraryName = this.stat.getLibraryName(line);
                            continue;
                        }
                        if (line.startsWith("        ")) {
                            long lastModified;
                            int indexDelib;
                            String timeString;
                            String fileName;
                            int indexElib = line.lastIndexOf(".elib");
                            int indexJelib = line.lastIndexOf(".jelib");
                            if (indexElib >= 0) {
                                fileName = line.substring(8, indexElib + 5);
                                timeString = line.substring(indexElib + 5);
                            } else if (indexJelib >= 0) {
                                fileName = line.substring(8, indexJelib + 6);
                                timeString = line.substring(indexJelib + 6);
                            } else if (indexDelib >= 0) {
                                for (indexDelib = line.lastIndexOf(".delib"); indexDelib < line.length() && line.charAt(indexDelib) != ' '; ++indexDelib) {
                                }
                                fileName = line.substring(8, indexDelib);
                                timeString = line.substring(indexDelib);
                            } else {
                                throw new IOException("Library extension: " + line);
                            }
                            String[] pieces = timeString.split(" +");
                            try {
                                lastModified = Long.parseLong(pieces[1]);
                            }
                            catch (NumberFormatException e) {
                                throw new IOException("lastModified:" + pieces[1]);
                            }
                            FileInstance f = new FileInstance(this.stat, fileName, fileLength, lastModified, crc);
                            if (fc == null) {
                                fc = new FileContents(libraryName, f);
                                continue;
                            }
                            fc.add(f);
                            continue;
                        }
                        if (!line.startsWith("    ")) break;
                        String[] pieces = line.split(" +");
                        try {
                            fileLength = Long.parseLong(pieces[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("fileLength: " + pieces[1]);
                        }
                        try {
                            crc = Long.parseLong(pieces[2], 16);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("crc: " + pieces[2]);
                        }
                        fc = null;
                    }
                    throw new IOException("bad line:" + line);
                }
                finally {
                    this.closeInput();
                }
            }
        }
    }

    private static class FileInstance
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -5726569346410497467L;
        private FileContents contents;
        private String fileName;
        private final File file;
        private long fileLength;
        private long crc;
        private long lastModified;
        transient String canonicalPath;

        private FileInstance(LibraryStatistics stat, String fileName, long fileLength, long lastModified, long crc) throws IOException {
            this.file = new File(fileName);
            this.fileName = fileName;
            this.fileLength = fileLength;
            this.lastModified = lastModified;
            this.crc = crc;
            stat.getDirectory(this.file.getParent()).files.put(this.file.getName(), this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FileInstance(LibraryStatistics stat, String fileName) throws IOException {
            this.file = new File(fileName);
            this.fileName = fileName;
            this.canonicalPath = this.file.getCanonicalPath();
            this.fileLength = this.file.length();
            this.lastModified = this.file.lastModified();
            Input in = new Input();
            try {
                if (in.openBinaryInput(this.getUrl())) {
                    throw new IOException("openBytesInput");
                }
                CheckedInputStream checkedInputStream = new CheckedInputStream(in.dataInputStream, new CRC32());
                if (checkedInputStream.skip(this.fileLength) != this.fileLength) {
                    throw new IOException("skip failed");
                }
                this.crc = checkedInputStream.getChecksum().getValue();
            }
            finally {
                in.closeInput();
            }
            stat.getDirectory(this.file.getParent()).files.put(this.file.getName(), this);
        }

        private URL getUrl() {
            try {
                return this.file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        public int compareTo(Object o) {
            FileInstance f = (FileInstance)o;
            if (this.lastModified > f.lastModified) {
                return 1;
            }
            if (this.lastModified < f.lastModified) {
                return -1;
            }
            return this.fileName.compareTo(f.fileName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileContents
    implements Serializable {
        private static final long serialVersionUID = 8673043477742718970L;
        LibraryName libraryName;
        long fileLength;
        long crc;
        long lastModified;
        List<FileInstance> instances = new ArrayList<FileInstance>();
        TreeMap<String, LibraryUse> uses = new TreeMap();
        ELIB.Header header;
        Version version;
        List<String> localCells = new ArrayList<String>();
        List<ExternalCell> externalCells = new ArrayList<ExternalCell>();
        boolean readOk;
        int toolCount;
        int techCount;
        int primNodeProtoCount;
        int primPortProtoCount;
        int arcProtoCount;
        int nodeProtoCount;
        int nodeInstCount;
        int portProtoCount;
        int arcInstCount;
        int geomCount;
        int cellCount;
        int userBits;
        int viewCount;
        int nameLength;
        int varNameCount;
        int varNameLength;
        int bytesRead;

        private FileContents(LibraryName libraryName, FileInstance f) {
            this.libraryName = libraryName;
            libraryName.versions.add(this);
            this.fileLength = f.fileLength;
            this.crc = f.crc;
            this.lastModified = f.lastModified;
            f.contents = this;
            this.instances.add(f);
        }

        void add(FileInstance f) {
            assert (f.fileLength == this.fileLength && f.crc == this.crc);
            f.contents = this;
            this.instances.add(f);
            if (f.lastModified < this.lastModified) {
                this.lastModified = f.lastModified;
            }
        }

        Iterator<URL> fileUrl() {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (FileInstance instance : this.instances) {
                urls.add(instance.getUrl());
            }
            return urls.iterator();
        }

        IdManager idManager() {
            return this.libraryName.stat.idManager;
        }

        boolean isElib() {
            return this.instances.get(0).fileName.endsWith(".elib");
        }

        String getFileName() {
            return this.instances.get(0).fileName;
        }
    }

    static class ExternalCell
    implements Serializable {
        final String libPath;
        final String libName;
        final String cellName;

        ExternalCell(String libPath, String libName, String cellName) {
            this.libPath = libPath;
            this.libName = libName;
            this.cellName = cellName;
        }
    }

    private static class LibraryUse
    implements Serializable {
        Directory dir;
        LibraryName libName;
        String fullName;
        FileContents from;

        private LibraryUse() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryName
    implements Serializable {
        final LibraryStatistics stat;
        final String name;
        final List<FileContents> versions = new ArrayList<FileContents>();
        TreeMap<String, LibraryUse> references;

        LibraryName(LibraryStatistics stat, String name) {
            this.stat = stat;
            this.name = name;
            stat.libraryNames.put(name, this);
        }

        LibId getLibId() {
            String libName = this.name;
            int indexOfColon = libName.indexOf(58);
            if (indexOfColon >= 0) {
                libName = libName.substring(0, indexOfColon);
            }
            return this.stat.idManager.newLibId(LibId.legalLibraryName(libName));
        }

        String getName() {
            return this.name;
        }

        Iterator<FileContents> getVersions() {
            return this.versions.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Directory
    implements Serializable {
        private static final long serialVersionUID = -8627329891776990655L;
        private String dirName;
        private TreeMap<String, FileInstance> files = new TreeMap();

        Directory(LibraryStatistics stat, String dirName) {
            this.dirName = dirName;
            stat.directories.put(dirName, this);
        }

        String getName() {
            return this.dirName;
        }

        Iterator<FileInstance> getFiles() {
            return this.files.values().iterator();
        }
    }
}

