/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.ExplorerTreeModel;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorLoggerTree {
    private static final DefaultMutableTreeNode errorTree = new DefaultMutableTreeNode("ERRORS");
    private static final TreePath errorPath = new TreePath("Explorer").pathByAddingChild(errorTree);
    static DefaultMutableTreeNode currentLogger;
    private static final ErrorLogger networkErrorLogger;
    private static DefaultMutableTreeNode networkTree;
    private static DefaultMutableTreeNode drcTree;

    public static boolean hasLogger(ErrorLogger logger) {
        return ErrorLoggerTree.indexOf(logger) >= 0;
    }

    public static void addLogger(ErrorLogger logger, boolean explain, boolean terminate) {
        logger.termLogging_(terminate);
        if (logger.getNumLogs() == 0) {
            return;
        }
        SwingUtilities.invokeLater(new AddLogger(logger, explain));
    }

    public static void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        SwingUtilities.invokeLater(new UpdateNetwork(cell.getId(), errors));
    }

    public static void updateDrcErrors(Cell cell, List<ErrorLogger.MessageLog> newErrors, List<ErrorLogger.MessageLog> delErrors) {
        SwingUtilities.invokeLater(new UpdateDrc(cell.getId(), newErrors, delErrors));
    }

    public static DefaultMutableTreeNode getExplorerTree() {
        return errorTree;
    }

    public static String reportNextMessage() {
        if (currentLogger == null) {
            return "No errors to report";
        }
        return ((ErrorLoggerTreeNode)currentLogger.getUserObject()).reportNextMessage_(true);
    }

    public static String reportPrevMessage() {
        if (currentLogger == null) {
            return "No errors to report";
        }
        return ((ErrorLoggerTreeNode)currentLogger.getUserObject()).reportPrevMessage_();
    }

    public static void showCurrentErrors() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (currentLogger == null) {
            return;
        }
        Job.getUserInterface().getCurrentEditWindow_().clearHighlighting();
        ErrorLoggerTreeNode node = (ErrorLoggerTreeNode)currentLogger.getUserObject();
        int index = ErrorLoggerTree.indexOf(node);
        ErrorLoggerTree.highlightLogger(index);
        Job.getUserInterface().getCurrentEditWindow_().finishedHighlighting();
    }

    private static void explain(ErrorLogger logger) {
        String extraMsg = "errors/warnings";
        if (logger.getNumErrors() == 0) {
            extraMsg = "warnings";
        } else if (logger.getNumWarnings() == 0) {
            extraMsg = "errors";
        }
        String msg = logger.getInfo();
        System.out.println(msg);
        if (logger.getNumLogs() > 0) {
            System.out.println("Type > and < to step through " + extraMsg + ", or open the ERRORS view in the explorer");
        }
        if (logger.getNumErrors() > 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), msg, logger.getSystem() + " finished with Errors", 1);
        }
    }

    private static DefaultMutableTreeNode addLogger(int index, ErrorLogger logger) {
        ErrorLoggerTreeNode tn = new ErrorLoggerTreeNode(logger);
        UserInterfaceMain.addDatabaseChangeListener(tn);
        ErrorLoggerDefaultMutableTreeNode newNode = new ErrorLoggerDefaultMutableTreeNode(tn);
        int[] childIndices = new int[]{index};
        Object[] children = new DefaultMutableTreeNode[]{newNode};
        ErrorLoggerTree.setCurrent(-1);
        errorTree.insert(newNode, index);
        currentLogger = newNode;
        ExplorerTreeModel.fireTreeNodesInserted(errorTree, errorPath, childIndices, children);
        ErrorLoggerTree.updateTree(newNode);
        return newNode;
    }

    private static void removeLogger(int index) {
        if (errorTree.getChildCount() <= index) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)errorTree.getChildAt(index);
        ErrorLoggerTreeNode treeNode = (ErrorLoggerTreeNode)node.getUserObject();
        UserInterfaceMain.removeDatabaseChangeListener(treeNode);
        ErrorLogger drcErrorLogger = DRC.getDRCIncrementalLogger();
        if (treeNode.getLogger() == drcErrorLogger) {
            drcErrorLogger.clearAllLogs();
        }
        if (node == networkTree) {
            networkTree = null;
        }
        if (node == drcTree) {
            drcTree = null;
        }
        if (node == currentLogger) {
            currentLogger = null;
        }
        int[] childIndices = new int[]{index};
        Object[] children = new DefaultMutableTreeNode[]{node};
        errorTree.remove(index);
        ExplorerTreeModel.fireTreeNodesRemoved(errorTree, errorPath, childIndices, children);
    }

    private static void highlightLogger(int index) {
        EditWindow ew = EditWindow.getCurrent();
        if (ew == null) {
            return;
        }
        Highlighter h = ew.getHighlighter();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)errorTree.getChildAt(index);
        ErrorLoggerTreeNode eltn = (ErrorLoggerTreeNode)node.getUserObject();
        ErrorLogger el = eltn.getLogger();
        EDatabase database = EDatabase.clientDatabase();
        for (int i = 0; i < el.getNumLogs(); ++i) {
            ErrorLogger.MessageLog ml = el.getLog(i);
            Iterator<ErrorHighlight> it = ml.getHighlights();
            while (it.hasNext()) {
                ErrorHighlight eh = it.next();
                eh.addToHighlighter(h, database);
            }
        }
    }

    private static void updateTree(DefaultMutableTreeNode loggerNode) {
        ErrorLogger logger;
        TreePath loggerPath = errorPath.pathByAddingChild(loggerNode);
        int oldChildCount = loggerNode.getChildCount();
        if (oldChildCount != 0) {
            int[] childIndex = new int[oldChildCount];
            Object[] children = new DefaultMutableTreeNode[oldChildCount];
            for (int i = 0; i < oldChildCount; ++i) {
                childIndex[i] = i;
                children[i] = (DefaultMutableTreeNode)loggerNode.getChildAt(i);
            }
            loggerNode.removeAllChildren();
            ExplorerTreeModel.fireTreeNodesRemoved(errorTree, loggerPath, childIndex, children);
        }
        if ((logger = ((ErrorLoggerTreeNode)loggerNode.getUserObject()).logger).getNumLogs() == 0) {
            return;
        }
        DefaultMutableTreeNode groupNode = loggerNode;
        HashMap<Integer, DefaultMutableTreeNode> sortKeyMap = new HashMap<Integer, DefaultMutableTreeNode>();
        HashMap<Integer, String> sortKeyGroupNamesMap = logger.getSortKeyToGroupNames();
        if (sortKeyGroupNamesMap != null) {
            for (Map.Entry<Integer, String> e : sortKeyGroupNamesMap.entrySet()) {
                String name = e.getValue();
                DefaultMutableTreeNode grpNode = new DefaultMutableTreeNode(name);
                loggerNode.add(grpNode);
                sortKeyMap.put(e.getKey(), grpNode);
            }
        }
        Iterator<ErrorLogger.MessageLog> it = logger.getLogs();
        while (it.hasNext()) {
            ErrorLogger.MessageLog el = it.next();
            if (logger.getSortKeyToGroupNames() != null && (groupNode = (DefaultMutableTreeNode)sortKeyMap.get(el.getSortKey())) == null) {
                groupNode = loggerNode;
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(el);
            groupNode.add(node);
        }
        int newChildCount = loggerNode.getChildCount();
        int[] childIndex = new int[newChildCount];
        Object[] children = new DefaultMutableTreeNode[newChildCount];
        for (int i = 0; i < newChildCount; ++i) {
            childIndex[i] = i;
            children[i] = (DefaultMutableTreeNode)loggerNode.getChildAt(i);
        }
        ExplorerTreeModel.fireTreeNodesInserted(errorTree, loggerPath, childIndex, children);
    }

    private static void setCurrent(int index) {
        int oldIndex;
        int n = oldIndex = currentLogger != null ? ErrorLoggerTree.indexOf((ErrorLoggerTreeNode)currentLogger.getUserObject()) : -1;
        if (index == oldIndex) {
            return;
        }
        currentLogger = index >= 0 ? (DefaultMutableTreeNode)errorTree.getChildAt(index) : null;
        int l = 0;
        if (oldIndex >= 0) {
            ++l;
        }
        if (index >= 0) {
            ++l;
        }
        int[] childIndex = new int[l];
        Object[] children = new TreeNode[l];
        l = 0;
        if (oldIndex >= 0 && oldIndex < index) {
            childIndex[l] = oldIndex;
            children[l] = errorTree.getChildAt(oldIndex);
            ++l;
        }
        if (index >= 0) {
            childIndex[l] = index;
            children[l] = errorTree.getChildAt(index);
            ++l;
        }
        if (oldIndex >= 0 && oldIndex > index) {
            childIndex[l] = oldIndex;
            children[l] = errorTree.getChildAt(oldIndex);
            ++l;
        }
        ExplorerTreeModel.fireTreeNodesChanged(errorTree, errorPath, childIndex, children);
    }

    private static int indexOf(ErrorLoggerTreeNode tn) {
        int numLoggers = errorTree.getChildCount();
        for (int i = 0; i < numLoggers; ++i) {
            if (((DefaultMutableTreeNode)errorTree.getChildAt(i)).getUserObject() != tn) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(ErrorLogger logger) {
        int numLoggers = errorTree.getChildCount();
        for (int i = 0; i < numLoggers; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)errorTree.getChildAt(i);
            ErrorLoggerTreeNode errorLoggerTreeNode = (ErrorLoggerTreeNode)defaultMutableTreeNode.getUserObject();
            if (errorLoggerTreeNode.logger != logger) continue;
            return i;
        }
        return -1;
    }

    public static JPopupMenu getPopupMenu(ErrorLoggerTreeNode log) {
        JPopupMenu p = new JPopupMenu();
        JMenuItem m = new JMenuItem("Delete");
        m.addActionListener(log);
        p.add(m);
        m = new JMenuItem("Show All");
        m.addActionListener(log);
        p.add(m);
        m = new JMenuItem("Export");
        m.addActionListener(log);
        p.add(m);
        m = new JMenuItem("Set Current");
        m.addActionListener(log);
        p.add(m);
        p.addSeparator();
        m = new JMenuItem("Get Info");
        m.addActionListener(log);
        p.add(m);
        return p;
    }

    public static void importLogger() {
        String fileName = OpenFile.chooseInputFile(FileType.XML, "Read ErrorLogger");
        if (fileName == null) {
            return;
        }
        try {
            ErrorLogger.XMLParser parser = new ErrorLogger.XMLParser();
            ErrorLogger logger = parser.process(TextUtils.makeURLToFile(fileName), true);
            if (logger != null) {
                ErrorLoggerTree.addLogger(logger, false, true);
            }
        }
        catch (Exception e) {
            System.out.println("Error loading " + fileName);
            return;
        }
    }

    public static void deleteAllLoggers() {
        for (int i = errorTree.getChildCount() - 1; i >= 0; --i) {
            ErrorLoggerTree.removeLogger(i);
        }
    }

    static {
        networkErrorLogger = ErrorLogger.newInstance("Network Errors");
    }

    public static class ErrorLoggerTreeNode
    implements DatabaseChangeListener,
    ActionListener {
        private ErrorLogger logger;
        private int currentLogNumber;

        ErrorLoggerTreeNode(ErrorLogger log) {
            this.logger = log;
        }

        public ErrorLogger getLogger() {
            return this.logger;
        }

        public String reportNextMessage_(boolean showHigh) {
            if (this.currentLogNumber < this.logger.getNumLogs() - 1) {
                ++this.currentLogNumber;
            } else {
                if (this.logger.getNumLogs() <= 0) {
                    return "No " + this.logger.getSystem() + " errors";
                }
                this.currentLogNumber = 0;
            }
            return this.reportLog(this.currentLogNumber, showHigh);
        }

        public String reportPrevMessage_() {
            if (this.currentLogNumber > 0) {
                --this.currentLogNumber;
            } else {
                if (this.logger.getNumLogs() <= 0) {
                    return "No " + this.logger.getSystem() + " errors";
                }
                this.currentLogNumber = this.logger.getNumLogs() - 1;
            }
            return this.reportLog(this.currentLogNumber, true);
        }

        private String reportLog(int logNumber, boolean showHigh) {
            if (logNumber < 0 || logNumber >= this.logger.getNumLogs()) {
                return this.logger.getSystem() + ": no such error or warning " + (logNumber + 1) + ", only " + this.logger.getNumLogs() + " errors.";
            }
            ErrorLogger.MessageLog el = this.logger.getLog(logNumber);
            String extraMsg = null;
            extraMsg = logNumber < this.logger.getNumErrors() ? " error " + (logNumber + 1) + " of " + this.logger.getNumErrors() : " warning " + (logNumber + 1 - this.logger.getNumErrors()) + " of " + this.logger.getNumWarnings();
            String message = Job.getUserInterface().reportLog(el, showHigh, null);
            return this.logger.getSystem() + extraMsg + ": " + message;
        }

        public void databaseChanged(DatabaseChangeEvent e) {
            boolean changed = false;
            for (int i = this.logger.getNumLogs() - 1; i >= 0; --i) {
                ErrorLogger.MessageLog err = this.logger.getLog(i);
                if (err.isValid(EDatabase.clientDatabase())) continue;
                this.logger.deleteLog(i);
                if (i < this.currentLogNumber) {
                    --this.currentLogNumber;
                } else if (i == this.currentLogNumber) {
                    this.currentLogNumber = 0;
                }
                changed = true;
            }
            if (!changed) {
                return;
            }
            int index = ErrorLoggerTree.indexOf(this);
            if (index < 0) {
                return;
            }
            if (this.logger.getNumLogs() == 0) {
                ErrorLoggerTree.removeLogger(index);
            } else {
                ErrorLoggerTree.updateTree((DefaultMutableTreeNode)errorTree.getChildAt(index));
            }
        }

        public void actionPerformed(ActionEvent e) {
            int index = ErrorLoggerTree.indexOf(this);
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem m = (JMenuItem)e.getSource();
                if (m.getText().equals("Delete")) {
                    boolean removedStuff = false;
                    WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                    if (wf != null) {
                        ExplorerTree ex = wf.getExplorerTab();
                        TreePath[] paths = ex.getSelectionPaths();
                        for (int i = 0; i < paths.length; ++i) {
                            Object clickedObject;
                            Object obj = paths[i].getLastPathComponent();
                            if (!(obj instanceof DefaultMutableTreeNode) || !((clickedObject = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof ErrorLoggerTreeNode)) continue;
                            index = ErrorLoggerTree.indexOf((ErrorLoggerTreeNode)clickedObject);
                            ErrorLoggerTree.removeLogger(index);
                            removedStuff = true;
                        }
                    }
                    if (!removedStuff) {
                        ErrorLoggerTree.removeLogger(index);
                    }
                } else if (m.getText().equals("Export")) {
                    String filePath = null;
                    try {
                        filePath = OpenFile.chooseOutputFile(FileType.XML, null, "ErrorLoggerSave.xml");
                        if (filePath == null) {
                            return;
                        }
                        this.logger.exportErrorLogger(filePath);
                    }
                    catch (Exception se) {
                        System.out.println("Error creating " + filePath);
                    }
                } else if (m.getText().equals("Show All")) {
                    WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                    if (wf == null) {
                        return;
                    }
                    Job.getUserInterface().getCurrentEditWindow_().clearHighlighting();
                    ExplorerTree ex = wf.getExplorerTab();
                    TreePath[] paths = ex.getSelectionPaths();
                    for (int i = 0; i < paths.length; ++i) {
                        Object clickedObject;
                        Object obj = paths[i].getLastPathComponent();
                        if (!(obj instanceof DefaultMutableTreeNode) || !((clickedObject = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof ErrorLoggerTreeNode)) continue;
                        index = ErrorLoggerTree.indexOf((ErrorLoggerTreeNode)clickedObject);
                        ErrorLoggerTree.highlightLogger(index);
                    }
                    Job.getUserInterface().getCurrentEditWindow_().finishedHighlighting();
                } else if (m.getText().equals("Get Info")) {
                    System.out.println("ErrorLogger Information: " + this.logger.getInfo());
                } else if (m.getText().equals("Set Current")) {
                    ErrorLoggerTree.setCurrent(index);
                }
            }
        }
    }

    public static class ErrorLoggerDefaultMutableTreeNode
    extends DefaultMutableTreeNode {
        ErrorLoggerDefaultMutableTreeNode(ErrorLoggerTreeNode tn) {
            super(tn);
        }

        public boolean isLeaf() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateDrc
    implements Runnable {
        private CellId cellId;
        private ArrayList<ErrorLogger.MessageLog> newErrors;
        private ArrayList<ErrorLogger.MessageLog> delErrors;

        UpdateDrc(CellId cId, List<ErrorLogger.MessageLog> newErrs, List<ErrorLogger.MessageLog> delErrs) {
            this.cellId = cId;
            if (newErrs != null) {
                this.newErrors = new ArrayList<ErrorLogger.MessageLog>(newErrs);
            }
            if (delErrs != null) {
                this.delErrors = new ArrayList<ErrorLogger.MessageLog>(delErrs);
            }
        }

        @Override
        public void run() {
            int index;
            Cell cell = EDatabase.clientDatabase().getCell(this.cellId);
            if (cell == null) {
                return;
            }
            ErrorLogger drcErrorLogger = DRC.getDRCIncrementalLogger();
            drcErrorLogger.addMessages(this.newErrors);
            drcErrorLogger.deleteMessages(this.delErrors);
            drcErrorLogger.termLogging_(true);
            int n = index = networkTree != null ? 1 : 0;
            if (drcErrorLogger.getNumLogs() == 0) {
                if (drcTree != null) {
                    ErrorLoggerTree.removeLogger(errorTree.getIndex(drcTree));
                }
                return;
            }
            if (drcTree == null) {
                drcTree = ErrorLoggerTree.addLogger(index, drcErrorLogger);
            }
            ErrorLoggerTree.updateTree(drcTree);
            ErrorLoggerTree.setCurrent(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateNetwork
    implements Runnable {
        private CellId cellId;
        private ArrayList<ErrorLogger.MessageLog> errors;

        UpdateNetwork(CellId cellId, List<ErrorLogger.MessageLog> errors) {
            this.cellId = cellId;
            this.errors = new ArrayList<ErrorLogger.MessageLog>(errors);
        }

        @Override
        public void run() {
            Cell cell = EDatabase.clientDatabase().getCell(this.cellId);
            if (cell == null) {
                return;
            }
            boolean changed = networkErrorLogger.clearLogs(cell) || !this.errors.isEmpty();
            networkErrorLogger.addMessages(this.errors);
            if (!changed) {
                return;
            }
            networkErrorLogger.termLogging_(true);
            if (networkErrorLogger.getNumLogs() == 0) {
                ErrorLoggerTree.removeLogger(0);
                return;
            }
            if (networkTree == null) {
                networkTree = ErrorLoggerTree.addLogger(0, networkErrorLogger);
            }
            ErrorLoggerTree.updateTree(networkTree);
            ErrorLoggerTree.setCurrent(0);
        }
    }

    private static class AddLogger
    implements Runnable {
        private ErrorLogger logger;
        private boolean explain;

        AddLogger(ErrorLogger logger, boolean explain) {
            this.logger = logger;
            this.explain = explain;
        }

        public void run() {
            int i = ErrorLoggerTree.indexOf(this.logger);
            if (i >= 0) {
                ErrorLoggerTree.updateTree((DefaultMutableTreeNode)errorTree.getChildAt(i));
            } else {
                ErrorLoggerTree.addLogger(errorTree.getChildCount(), this.logger);
                if (this.explain) {
                    ErrorLoggerTree.explain(this.logger);
                }
            }
        }
    }
}

