/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.Waveform;
import com.sun.electric.tool.simulation.WaveformImpl;

public class ComplexWaveform
extends WaveformImpl {
    private final WaveformImpl realWaveform;
    private final WaveformImpl imagWaveform;
    private final WaveformImpl phaseWaveform;

    public ComplexWaveform(double[] time, double[] realValue, double[] imagValue) {
        super(time, ComplexWaveform.calcAmplitude(realValue, imagValue));
        this.realWaveform = new WaveformImpl(time, realValue);
        this.imagWaveform = new WaveformImpl(time, imagValue);
        double[] phaseValue = new double[time.length];
        for (int i = 0; i < phaseValue.length; ++i) {
            phaseValue[i] = Math.atan2(imagValue[i], realValue[i]);
        }
        this.phaseWaveform = new WaveformImpl(time, phaseValue);
    }

    public Waveform getReal() {
        return this.realWaveform;
    }

    public Waveform getImag() {
        return this.imagWaveform;
    }

    public Waveform getAmplitude() {
        return this;
    }

    public Waveform getPhase() {
        return this.phaseWaveform;
    }

    private static double[] calcAmplitude(double[] realValue, double[] imagValue) {
        if (realValue.length != imagValue.length) {
            throw new IllegalArgumentException();
        }
        double[] amplitude = new double[realValue.length];
        for (int i = 0; i < amplitude.length; ++i) {
            amplitude[i] = Math.hypot(realValue[i], imagValue[i]);
        }
        return amplitude;
    }
}

