/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.Highlighter;
import java.io.PrintStream;

class ErrorHighNode
extends ErrorHighlight {
    private final int nodeId;

    public ErrorHighNode(VarContext con, NodeInst ni) {
        super(ni.getParent(), con);
        this.nodeId = ni.getD().nodeId;
    }

    @Override
    boolean containsObject(Cell c, Object obj) {
        EDatabase database = c.getDatabase();
        return this.getCell(database) == c && this.getObject(database) == obj;
    }

    @Override
    Object getObject(EDatabase database) {
        Cell cell = this.getCell(database);
        if (cell == null) {
            return null;
        }
        return cell.getNodeById(this.nodeId);
    }

    @Override
    void xmlDescription(PrintStream msg, EDatabase database) {
        NodeInst ni = (NodeInst)this.getObject(database);
        msg.append("\t\t<ERRORTYPEGEOM ");
        msg.append("geomName=\"" + ni.getName() + "\" ");
        msg.append("cellName=\"" + ni.getParent().describe(false) + "\"");
        msg.append(" />\n");
    }

    @Override
    boolean isValid(EDatabase database) {
        return this.getObject(database) != null;
    }

    @Override
    void addToHighlighter(Highlighter h, EDatabase database) {
        NodeInst ni = (NodeInst)this.getObject(database);
        if (ni != null) {
            h.addElectricObject(ni, ni.getParent());
        }
    }
}

