/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DisplayedCells
implements Serializable {
    private List<Integer> formerWindows = new ArrayList<Integer>();
    private List<Cell> formerCellsInWindows = new ArrayList<Cell>();
    private Set<Cell> createdCells = new HashSet<Cell>();

    public DisplayedCells() {
        Cell displayedCell;
        WindowFrame wf;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            wf = it.next();
            this.formerWindows.add(new Integer(wf.getIndex()));
            displayedCell = wf.getContent().getCell();
            this.formerCellsInWindows.add(displayedCell);
        }
        it = WindowFrame.getWindows();
        while (it.hasNext()) {
            wf = it.next();
            displayedCell = wf.getContent().getCell();
            if (!this.formerCellsInWindows.contains(displayedCell)) continue;
            wf.getContent().setCell(null, null, null);
        }
    }

    void setCellsToBeChanged(List<Cell> checkOutCells) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            Cell displayedCell = wf.getContent().getCell();
            if (!checkOutCells.contains(displayedCell)) continue;
            wf.getContent().setCell(null, null, null);
        }
    }

    public void swap(Cell oldVers, Cell newVers) {
        for (int i = 0; i < this.formerCellsInWindows.size(); ++i) {
            if (this.formerCellsInWindows.get(i) != oldVers) continue;
            this.formerCellsInWindows.set(i, newVers);
        }
        this.createdCells.add(newVers);
    }

    public void updateWindows() {
        for (int i = 0; i < this.formerCellsInWindows.size(); ++i) {
            WindowFrame wf = WindowFrame.findFromIndex(this.formerWindows.get(i));
            if (wf == null) continue;
            Cell newVers = this.formerCellsInWindows.get(i);
            Cell displayedCell = wf.getContent().getCell();
            if (displayedCell == newVers) continue;
            WindowFrame.DisplayAttributes da = new WindowFrame.DisplayAttributes();
            da.scale = 1.0;
            if (wf.getContent() instanceof EditWindow_) {
                EditWindow_ wnd = (EditWindow_)((Object)wf.getContent());
                da.scale = wnd.getScale();
                da.offX = wnd.getOffset().getX();
                da.offY = wnd.getOffset().getY();
            }
            wf.getContent().setCell(newVers, VarContext.globalContext, da);
        }
    }

    public Iterator<Cell> getCreatedCells() {
        return this.createdCells.iterator();
    }
}

