/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.infinity;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.infinity.ConnList;
import com.sun.electric.tool.generator.infinity.Stages;
import com.sun.electric.tool.generator.layout.AbutRouter;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Infinity {
    private static final String STAGE_LIB_NAME = new String("stagesF");
    private static final String AUTO_GEN_LIB_NAME = new String("autoInfinity");
    private static final String AUTO_GEN_CELL_NAME = new String("autoInfCell{lay}");
    private static final TechType tech = TechType.CMOS90;
    private static final double STAGE_SPACING = 144.0;
    private static final double ABUT_ROUTE_PORT_TO_BOUND_SPACING = 0.0;

    private void prln(String s) {
        System.out.println(s);
    }

    private Stages findStageCells() {
        Library lib = Library.findLibrary(STAGE_LIB_NAME);
        Stages stages = new Stages(lib);
        if (lib == null) {
            this.prln("Please open the library containing stage cells: " + STAGE_LIB_NAME);
        }
        return stages;
    }

    private void ensurePwrGndExportsOnBoundingBox(Collection<Cell> stages) {
        for (Cell c : stages) {
            Rectangle2D bBox = c.findEssentialBounds();
            if (bBox == null) {
                this.prln("Stage: " + c.getName() + " is missing essential bounds");
                continue;
            }
            double minX = bBox.getMinX();
            double maxX = bBox.getMaxX();
            double minY = bBox.getMinY();
            double maxY = bBox.getMaxY();
            Iterator<Export> it = c.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                PortCharacteristic pc = e.getCharacteristic();
                if (pc != PortCharacteristic.PWR && pc != PortCharacteristic.GND) continue;
                PortInst pi = e.getOriginalPort();
                EPoint center = pi.getCenter();
                double x = center.getX();
                double y = center.getY();
                if (x == minX || x == maxX || y == minY || y == maxY) continue;
                this.prln("Cell: " + c.getName() + ", Export: " + e.getName() + " Export not on Cell Bounding Box");
                this.prln("  Bounding box: (" + minX + ", " + minY + ") (" + maxX + ", " + maxY + ")");
                this.prln("  Export coordinates: (" + x + ", " + y + ")");
            }
        }
    }

    private List<NodeInst> addInstances(Cell parentCell, Stages stages) {
        ArrayList<NodeInst> stageInsts = new ArrayList<NodeInst>();
        for (Cell c : stages.getStages()) {
            stageInsts.add(LayoutLib.newNodeInst(c, 0.0, 0.0, 0.0, 0.0, 0.0, parentCell));
        }
        LayoutLib.abutBottomTop(stageInsts, 144.0);
        return stageInsts;
    }

    private void sortSchStageInstsByX(List<Nodable> stageInsts) {
        Collections.sort(stageInsts, new Comparator<Nodable>(){

            @Override
            public int compare(Nodable n1, Nodable n2) {
                double x2;
                double x1 = n1.getNodeInst().getBounds().getMinX();
                double delta = x1 - (x2 = n2.getNodeInst().getBounds().getMinX());
                if (delta > 0.0) {
                    return 1;
                }
                if (delta == 0.0) {
                    return 0;
                }
                if (delta < 0.0) {
                    return -1;
                }
                LayoutLib.error(true, "stage instances x-coord unordered in schematic");
                return 0;
            }
        });
    }

    private List<Nodable> getStageInstances(Cell autoSch) {
        Library stageLib = Library.findLibrary(STAGE_LIB_NAME);
        ArrayList<Nodable> stageInsts = new ArrayList<Nodable>();
        Iterator<Nodable> nIt = autoSch.getNodables();
        while (nIt.hasNext()) {
            Cell c;
            Nodable na = nIt.next();
            NodeProto np = na.getNodeInst().getProto();
            if (!(np instanceof Cell) || (c = (Cell)np).getLibrary() != stageLib) continue;
            stageInsts.add(na);
        }
        this.sortSchStageInstsByX(stageInsts);
        return stageInsts;
    }

    private List<NodeInst> addInstances(Cell parentCell, Cell autoSch) {
        Library stageLib = Library.findLibrary(STAGE_LIB_NAME);
        ArrayList<NodeInst> layInsts = new ArrayList<NodeInst>();
        List<Nodable> schInsts = this.getStageInstances(autoSch);
        for (Nodable no : schInsts) {
            Cell schCell = (Cell)no.getProto();
            this.prln("Name of schematic instance is: " + schCell.getName());
            Cell layCell = stageLib.findNodeProto(schCell.getName() + "{lay}");
            NodeInst layInst = LayoutLib.newNodeInst(layCell, 0.0, 0.0, 0.0, 0.0, 0.0, parentCell);
            layInst.setName(no.getName());
            layInsts.add(layInst);
        }
        LayoutLib.abutBottomTop(layInsts, 144.0);
        return layInsts;
    }

    private void connectPwrGnd(List<NodeInst> nodeInsts) {
        NodeInst prev = null;
        for (NodeInst ni : nodeInsts) {
            if (prev != null) {
                AbutRouter.abutRouteBotTop(prev, ni, 0.0, tech);
            }
            prev = ni;
        }
    }

    private List<ConnList> getLayConnFromSch(Cell autoSch, Cell autoLay) {
        ArrayList<ConnList> toConnects = new ArrayList<ConnList>();
        List<Nodable> stageInsts = this.getStageInstances(autoSch);
        HashMap<Network, ConnList> intToConn = new HashMap<Network, ConnList>();
        Netlist schNets = autoSch.getNetlist(true);
        for (Nodable schInst : stageInsts) {
            String schInstNm = schInst.getName();
            NodeInst layInst = autoLay.findNode(schInstNm);
            LayoutLib.error(layInst == null, "layout instance missing");
            Cell schCell = (Cell)schInst.getProto();
            Iterator<Export> eIt = schCell.getExports();
            while (eIt.hasNext()) {
                Export e = eIt.next();
                Name eNmKey = e.getNameKey();
                int busWid = eNmKey.busWidth();
                for (int i = 0; i < busWid; ++i) {
                    String subNm = eNmKey.subname(i).toString();
                    PortInst layPortInst = layInst.findPortInst(subNm);
                    LayoutLib.error(layPortInst == null, "layout instance port missing");
                    Network schNet = schNets.getNetwork(schInst, e, i);
                    ConnList conn = (ConnList)intToConn.get(schNet);
                    if (conn == null) {
                        conn = new ConnList();
                        intToConn.put(schNet, conn);
                    }
                    conn.addPortInst(layPortInst);
                }
            }
        }
        this.prln("Dump nets");
        for (Network n : intToConn.keySet()) {
            ConnList cl = (ConnList)intToConn.get(n);
            this.prln("  " + cl.toString());
        }
        return toConnects;
    }

    public Infinity() {
        this.prln("Generating layout for Infinity");
        Stages stages = this.findStageCells();
        if (stages.someStageIsMissing()) {
            return;
        }
        this.ensurePwrGndExportsOnBoundingBox(stages.getStages());
        Library autoLib = LayoutLib.openLibForWrite(AUTO_GEN_LIB_NAME);
        Cell parentCell = Cell.newInstance(autoLib, AUTO_GEN_CELL_NAME);
        Cell autoSch = autoLib.findNodeProto("autoInfCell{sch}");
        if (autoSch == null) {
            this.prln("Can't find autoInfCell{sch}");
            return;
        }
        List<NodeInst> stageInsts = this.addInstances(parentCell, autoSch);
        this.connectPwrGnd(stageInsts);
        this.getLayConnFromSch(autoSch, parentCell);
        System.out.println("done.");
    }
}

