/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.change.Undo;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.StreamClient;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.User;
import java.io.IOException;

public abstract class Client {
    final int connectionId;
    final String userName = System.getProperty("user.name");
    private static final OS os = Client.OSInitialize();

    private static OS OSInitialize() {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("windows")) {
                return OS.WINDOWS;
            }
            if (osName.startsWith("linux") || osName.startsWith("solaris") || osName.startsWith("sunos")) {
                return OS.UNIX;
            }
            if (osName.startsWith("mac")) {
                return OS.MACINTOSH;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("No OS detected");
        return null;
    }

    public static OS getOperatingSystem() {
        return os;
    }

    public static boolean isOSWindows() {
        return os == OS.WINDOWS;
    }

    public static boolean isOSMac() {
        return os == OS.MACINTOSH;
    }

    public Client(int connectionId) {
        this.connectionId = connectionId;
    }

    static void fireEJobEvent(EJob ejob) {
        Client.fireServerEvent(new EJobEvent(ejob, ejob.state));
    }

    static void print(Client client, String s) {
        Client.fireServerEvent(new PrintEvent(client, s));
    }

    private static void fireServerEvent(ServerEvent serverEvent) {
        if (Job.currentUI != null) {
            Job.currentUI.addEvent(serverEvent);
        }
        StreamClient.addEvent(serverEvent);
    }

    static class PrintEvent
    extends ServerEvent {
        private final String s;

        PrintEvent(Client client, String s) {
            this.s = s;
        }

        @Override
        public void run() {
        }

        @Override
        void dispatchOnStreamClient(StreamClient client) throws IOException {
            client.writeString(this.s);
        }
    }

    static class EJobEvent
    extends ServerEvent {
        final EJob ejob;
        private final EJob.State newState;
        final long timeStamp;

        private EJobEvent(EJob ejob, EJob.State newState) {
            this.ejob = ejob;
            this.newState = newState;
            this.timeStamp = System.currentTimeMillis();
        }

        EJobEvent(EJob ejob, EJob.State newState, long timeStamp) {
            this.ejob = ejob;
            this.newState = newState;
            this.timeStamp = timeStamp;
        }

        @Override
        public void run() {
            if (this.newState == EJob.State.SERVER_DONE) {
                boolean undoRedo;
                boolean bl = undoRedo = this.ejob.jobType == Job.Type.UNDO;
                if (!this.ejob.isExamine()) {
                    int restoredHighlights = Undo.endChanges(this.ejob.oldSnapshot, this.ejob.getJob().tool, this.ejob.jobName, this.ejob.newSnapshot);
                    Job.getExtendedUserInterface().showSnapshot(this.ejob.newSnapshot, undoRedo);
                    Job.getExtendedUserInterface().restoreHighlights(restoredHighlights);
                }
                if (this.ejob.client == Job.getExtendedUserInterface()) {
                    Throwable jobException = null;
                    if (this.ejob.startedByServer) {
                        jobException = this.ejob.deserializeToClient();
                    }
                    if (jobException != null) {
                        System.out.println("Error deserializing " + this.ejob.jobName);
                        ActivityLogger.logException(jobException);
                        return;
                    }
                    jobException = this.ejob.deserializeResult();
                    Job job = this.ejob.clientJob;
                    if (job == null) {
                        ActivityLogger.logException(jobException);
                        return;
                    }
                    try {
                        job.terminateIt(jobException);
                    }
                    catch (Throwable e) {
                        System.out.println("Exception executing terminateIt");
                        e.printStackTrace(System.out);
                    }
                    job.endTime = System.currentTimeMillis();
                    job.finished = true;
                    if (job.reportExecution || job.endTime - job.startTime >= 60000L) {
                        if (User.isBeepAfterLongJobs()) {
                            Job.getExtendedUserInterface().beep();
                        }
                        System.out.println(job.getInfo());
                    }
                }
            }
        }

        @Override
        void dispatchOnStreamClient(StreamClient client) throws IOException {
            client.writeEJobEvent(this.ejob, this.newState, this.timeStamp);
        }
    }

    public static class ServerEvent
    implements Runnable {
        ServerEvent next;

        ServerEvent() {
        }

        @Override
        public void run() {
        }

        void dispatchOnStreamClient(StreamClient client) throws IOException {
        }
    }

    public static enum OS {
        WINDOWS("Windows"),
        UNIX("UNIX"),
        MACINTOSH("Macintosh");

        private String name;

        private OS(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

