/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class NewExport
extends EDialog {
    private static String latestCharacteristic;
    private JCheckBox alwaysDrawn;
    private JCheckBox bodyOnly;
    private JButton cancel;
    private JComboBox exportCharacteristics;
    private JTextField exportName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton ok;
    private JTextField referenceExport;

    public NewExport(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        String last = latestCharacteristic;
        Iterator it = PortCharacteristic.getOrderedCharacteristics().iterator();
        while (it.hasNext()) {
            PortCharacteristic ch = (PortCharacteristic)it.next();
            this.exportCharacteristics.addItem(ch.getName());
        }
        if (last != null) {
            this.exportCharacteristics.setSelectedItem(last);
        }
        this.referenceExport.setEditable(false);
        this.exportName.grabFocus();
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.exportName = new JTextField();
        this.exportCharacteristics = new JComboBox();
        this.alwaysDrawn = new JCheckBox();
        this.bodyOnly = new JCheckBox();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.referenceExport = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Create New Export");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewExport.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Export name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Export characteristics:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Reference export:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.exportName.setPreferredSize(new Dimension(250, 20));
        this.exportName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExport.this.exportNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.exportName, gridBagConstraints);
        this.exportCharacteristics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExport.this.exportCharacteristicsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.exportCharacteristics, gridBagConstraints);
        this.alwaysDrawn.setText("Always drawn");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.alwaysDrawn, gridBagConstraints);
        this.bodyOnly.setText("Body only");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.bodyOnly, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExport.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 40, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExport.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 40);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.referenceExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExport.this.referenceExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.referenceExport, gridBagConstraints);
        this.pack();
    }

    private void referenceExportActionPerformed(ActionEvent evt) {
        this.okActionPerformed(evt);
    }

    private void exportNameActionPerformed(ActionEvent evt) {
        this.okActionPerformed(evt);
    }

    private void exportCharacteristicsActionPerformed(ActionEvent evt) {
        latestCharacteristic = (String)this.exportCharacteristics.getSelectedItem();
        PortCharacteristic characteristic = PortCharacteristic.findCharacteristic(latestCharacteristic);
        this.referenceExport.setEditable(characteristic.isReference());
    }

    private void okActionPerformed(ActionEvent evt) {
        String name = this.exportName.getText();
        String referenceName = this.referenceExport.getText();
        String characteristics = (String)this.exportCharacteristics.getSelectedItem();
        PortCharacteristic ch = PortCharacteristic.findCharacteristic(characteristics);
        boolean drawn = this.alwaysDrawn.isSelected();
        boolean body = this.bodyOnly.isSelected();
        if (name.length() <= 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Must enter an export name");
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlight h = wnd.getHighlighter().getOneHighlight();
        if (h == null) {
            return;
        }
        if (h.getType() != Highlight.Type.EOBJ) {
            System.out.println("Must select a node");
            return;
        }
        ElectricObject eobj = h.getElectricObject();
        PortProto pp = null;
        if (eobj instanceof PortInst) {
            pp = ((PortInst)eobj).getPortProto();
            eobj = ((PortInst)eobj).getNodeInst();
        }
        if (!(eobj instanceof NodeInst)) {
            System.out.println("Must select a node");
            return;
        }
        NodeInst ni = (NodeInst)eobj;
        Cell parent = ni.getParent();
        PortInst pi = null;
        pi = pp == null ? ni.getOnlyPortInst() : ni.findPortInstFromProto(pp);
        if (pi == null) {
            System.out.println("Cannot figure out which port to export");
            return;
        }
        MakeExport job = new MakeExport(parent, pi, name, body, drawn, ch, referenceName);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class MakeExport
    extends Job {
        Cell cell;
        PortInst pi;
        String name;
        String referenceName;
        boolean body;
        boolean drawn;
        PortCharacteristic ch;

        protected MakeExport(Cell cell, PortInst pi, String name, boolean body, boolean drawn, PortCharacteristic ch, String referenceName) {
            super("Make Export", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.pi = pi;
            this.name = name;
            this.body = body;
            this.drawn = drawn;
            this.ch = ch;
            this.referenceName = referenceName;
            this.startJob();
        }

        public boolean doIt() {
            Export e = this.cell.findExport(this.name);
            if (e != null && this.cell.isMultiPage()) {
                int exportPage = e.getOriginalPort().getNodeInst().whichMultiPage();
                int currentPage = this.pi.getNodeInst().whichMultiPage();
                if (currentPage != exportPage) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "That export name already exists on page " + (exportPage + 1), "Duplicate Export", 2);
                }
            }
            if (CircuitChanges.cantEdit(this.cell, this.pi.getNodeInst(), true) != 0) {
                return false;
            }
            e = Export.newInstance(this.cell, this.pi, this.name);
            if (e == null) {
                System.out.println("Failed to create export");
                return false;
            }
            e.setCharacteristic(this.ch);
            if (this.drawn) {
                e.setAlwaysDrawn();
            }
            if (this.body) {
                e.setBodyOnly();
            }
            if (this.ch.isReference()) {
                e.newVar(Export.EXPORT_REFERENCE_NAME, (Object)this.referenceName);
            }
            return true;
        }
    }
}

