// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "engine.h"

using namespace ost;
using namespace std;

BayonneFeeder *BayonneFeeder::first = NULL;

BayonneFeeder::BayonneFeeder(const char *name) :
ThreadLock()
{
	next = first;
	first = this;
	id = name;
	pos = 0;
	last = 0;
	count = 0;
	active = false;
	memset(buffer, 0, sizeof(buffer));
}
	
Audio::Linear BayonneFeeder::getBuffer(unsigned offset, unsigned size)
{
	Linear buf = NULL;

	readLock();

	if(active || (offset < last && (offset + size) <= last))
		buf = &buffer[offset];

	unlock();

	return buf;
}

Audio::Linear BayonneFeeder::putBuffer(unsigned size)
{
	Linear buf;

	writeLock();

	buf = &buffer[pos];

	pos += size;
	if(pos >= MAX_AUDIOFEED)
		pos = 0;

	if(count < MAX_AUDIOFEED)
		count += size;

	if(active)
		last += size;

	if(last >= MAX_AUDIOFEED)
		last = 0;

	if(count >= MIN_AUDIOFEED && !active)
		active = true;


	unlock();

	return buf;
}

BayonneFeeder *BayonneFeeder::get(const char *id)
{
	BayonneFeeder *feed = first;

	while(feed)
	{
		if(!stricmp(feed->id, id))
			return feed;
		feed = feed->next;
	}
	return NULL;
}

unsigned BayonneFeeder::getPosition(void)
{
	unsigned pos;
	readLock();
	pos = last;
	unlock();
	return pos;
}

void BayonneFeeder::setEnding(void)
{
	writeLock();
	last = pos;
	count = 0;
	active = false;
	unlock();
}

