// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "module.h"

namespace binder {
using namespace ost;
using namespace std;

bool Methods::scrConnect(void)
{
	BayonneSession *child = NULL;
	BayonneDriver *trunk = BayonneDriver::getTrunking();
	BayonneDriver *proto = NULL;
	BayonneSpan *span;
	const char *caller = getKeyword("caller");
	const char *display = getKeyword("display");
	ScriptImage *img;
	Name *target;
	const char *number = getValue(NULL);
	const char *script = getValue(NULL);
	char dbuf[65];
	char nbuf[256];
	timeslot_t limit = Bayonne::ts_count;
	const char *cp = getKeyword("limit");
	Line *sel = getLine();
	Symbol *sym = getKeysymbol("session", 16);
        Audio::Level level = 26000;
        TelTone::tonekey_t *key = NULL;  
	Event event;
	unsigned idx;
	const char *prefix = NULL;
	const char *suffix = NULL;
	timeout_t pos;
	unsigned count;

	if(cp)
		limit = atoi(cp);

	if(!stricmp(sel->cmd, "connect"))
		trunk = proto = BayonneDriver::getProtocol();	

	if(strchr(script, ':') && proto)
	{
                if(!strnicmp(script, "routing:", 8)) 
                {
                        error("invalid-destination");
                        return true;
                }  
	}
	else if(strchr(script, ':'))
	{
		if(!strnicmp(script, "dialing:", 8))
		{
			error("invalid-destination");
			return true;
		}
	}
	else if(proto)
	{
                snprintf(dbuf, sizeof(dbuf), "routing::%s", script);
                script = dbuf;  
	}
	else 
	{
		snprintf(dbuf, sizeof(dbuf), "dialing::%s", script);
		script = dbuf;
	}

	img = getImage();
	target = img->getScript(script);
	if(!target)
	{
		endImage(img);
		if(!scriptEvent("start:missing"))
			error("missing-destination");
		return true;
	}

	if(!trunk)
	{
		endImage(img);
		if(!scriptEvent("start:service"))
			error("missing-service");
		return true;
	}

	release();

	sel = target->select;

	if(!sel && proto)
	{
		child = proto->getIdle();
		goto any;
	}
	else if(!sel)
	{
		child = trunk->getIdle();
		goto any;
	}

	while(sel)
	{
		idx = 0;
		if(!stricmp(sel->cmd, "timeslot"))
		{
			while(NULL != (cp = ScriptChecks::getOption(sel, &idx)))
			{
				child = getSid(cp);
				if(!child)
					continue;
				if(child->getDriver() != trunk)
					continue;
				child->enter();
				if(!child->isIdle())
				{
					child->leave();
					continue;
				}
				prefix = findKeyword(sel, "prefix");
				suffix = findKeyword(sel, "suffix");
				goto start;
			}
			goto next;
		}
		if(!strnicmp(sel->cmd, "protocol", 8))
		{
			cp = ScriptChecks::getMember(sel);
			if(cp && *cp == '.')
				++cp;
			if(cp)
				proto = BayonneDriver::get(cp);
			else
				proto = BayonneDriver::getProtocol();

			if(!proto)
				goto next;

			trunk = proto;
			while(NULL != (cp = ScriptChecks::getOption(sel, &idx)))
			{
				if(!proto->getDestination(cp, number, nbuf, sizeof(nbuf)))
					continue;
				child = proto->getIdle();
				if(child)
				{
					number = nbuf;
					child->enter();
					goto start;
				}	
			}
			goto next;
		}

		if(stricmp(sel->cmd, "span"))		
			goto next;

		while(NULL != (cp = ScriptChecks::getOption(sel, &idx)))
		{
			span = BayonneSpan::get(atoi(cp));
			if(!span)	
				continue;

			pos = span->getFirst();
			count = span->getCount();
			while(count--)
			{
				child = getSession(pos++);
				if(!child)
					continue;
				child->enter();
				if(!child->isIdle())
				{
					child->leave();
					continue;
				}
                                prefix = findKeyword(sel, "prefix");
                                suffix = findKeyword(sel, "suffix");   
				goto start;
			}
		}
next:
		sel = sel->next;
	}
	child = NULL;

any:
	if(!child)
	{
		endImage(img);
		if(!scriptEvent("start:service"))
			error("dial-failed");
		return true;
	}		
			
	child->enter();

start:
        if(caller)
                child->setConst("session.caller", caller);

        if(display)
                child->setConst("session.display", display);  

	if(!prefix)
		prefix = "";

	if(!suffix)
		suffix = "";

	if(!proto)
	{
		snprintf(nbuf, sizeof(nbuf), "%s%s%s", prefix, number, suffix);
		number = nbuf;
	}

        memset(&event, 0, sizeof(event));
        event.id = START_OUTGOING;
        event.start.img = img;
        event.start.scr = target;
        event.start.parent = this;
        event.start.dialing = number;

        if(!child->postEvent(&event))
	{
        	child->leave();

		endImage(img);
		if(sym)
			ScriptInterp::commit(sym, "none");
		if(!scriptEvent("start:failed"))
			error("start-failed");

		return true;
	}

	strcpy(state.tone.sessionid, child->getExternal("session.id"));
	if(sym)
		ScriptInterp::commit(sym, state.tone.sessionid);

	child->leave();

        state.timeout = getTimeoutKeyword("timeout");
        state.tone.duration = getTimeoutKeyword("duration");  
	state.tone.dtmf = false;	// make true when fixed!
        if(state.timeout && state.timeout != TIMEOUT_INF)
        {
                if(audio.tone)
                {
                        delete audio.tone;
                        audio.tone = NULL;
                }
                cp = getKeyword("tone");
                if(cp)
                key = TelTone::find(cp, Bayonne::server->getLast("location"));
                if(key)
                        audio.tone = new TelTone(key, level, getToneFraming());
		setState(STATE_CONNECT);
		return false;
	}
	advance();
	return true;
}

bool Methods::scrAccept(void)
{
        const char *cp = getKeyword("id");
        state.timeout = getTimeoutKeyword("timeout");

        if(!cp)
                cp = getValue(NULL);

        if(cp)
        {
                state.join.peer = getSid(cp);
                if(!state.join.peer)
                {  
                        error("session-invalid");
                        return true;
                }   
        }
        else
                state.join.peer = NULL;

        state.join.dtmf = false;	// make true when fixed!!!
        setState(STATE_WAIT);
        return false; 
}                                                                                
	
} // end namespace
