## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::Morph::Helsinki::EN.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: morphological analysis via Gfsm automata, for use with Helsinki-style transducers (English)
## + transducers available in HFST format from https://sourceforge.net/projects/hfst/files/resources/morphological-transducers/

##==============================================================================
## Package: Analyzer::Morph
##==============================================================================
package DTA::CAB::Analyzer::Morph::Helsinki::EN;
use DTA::CAB::Analyzer::Morph::Helsinki;
use Carp;
use strict;
our @ISA = qw(DTA::CAB::Analyzer::Morph::Helsinki);

## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer::Automaton::Gfsm
sub new {
  my $that = shift;
  my $aut = $that->SUPER::new(
			      ##-- defaults

			      ##-- analysis selection
			      label => 'morph',
			      wantAnalysisLo => 0,
			      wantAnalysisLemma => 0, ##-- default=0
			      tolower => 1,

			      ##-- verbosity
			      check_symbols => 0,

			      ##-- language
			      helsinkiLang => 'en',

			      ##-- user args
			      @_
			     );
  return $aut;
}


1; ##-- be happy

__END__
##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::Morph::Helsinki::EN - morphological analysis via Gfsm automata, English (Helsinki)

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Analyzer::Morph::Helsinki;
 
 $morph = DTA::CAB::Analyzer::Morph::Helsinki::EN->new(%args);
 $morph->analyze($tok);

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

DTA::CAB::Analyzer::Morph::Helsinki::EN
is a simplified wrapper for
L<DTA::CAB::Analyzer::Morph::Helsinki|DTA::CAB::Analyzer::Morph::Helsinki>
suitable for use with a modified transducer from the C<hfst-english-installable> package.
which sets the following default options:

 ##-- analysis selection
 label => 'morph',        ##-- analysis output property
 wantAnalysisLo => 0,     ##-- don't output lower label paths
 tolower => 1,            ##-- bash input to lower-case
 helsinkiLang => 'en',    ##-- just in case we need it

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2021 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=cut
