/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.ColorQuantizerOpImage;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class NeuQuantOpImage
extends ColorQuantizerOpImage {
    protected static final int prime1 = 499;
    protected static final int prime2 = 491;
    protected static final int prime3 = 487;
    protected static final int prime4 = 503;
    protected static final int minpicturebytes = 1509;
    private int ncycles;
    private final int maxnetpos;
    private final int netbiasshift = 4;
    private final int intbiasshift = 16;
    private final int intbias = 65536;
    private final int gammashift = 10;
    private final int gamma = 1024;
    private final int betashift = 10;
    private final int beta = 64;
    private final int betagamma = 65536;
    private final int initrad;
    private final int radiusbiasshift = 6;
    private final int radiusbias = 64;
    private final int initradius;
    private final int radiusdec = 30;
    private final int alphabiasshift = 10;
    private final int initalpha = 1024;
    private int alphadec;
    private final int radbiasshift = 8;
    private final int radbias = 256;
    private final int alpharadbshift = 18;
    private final int alpharadbias = 262144;
    private int[][] network;
    private int[] netindex;
    private int[] bias;
    private int[] freq;
    private int[] radpower;

    public NeuQuantOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n, int n2, ROI rOI, int n3, int n4) {
        super(renderedImage, map, imageLayout, n, rOI, n3, n4);
        this.maxnetpos = this.maxColorNum - 1;
        this.netbiasshift = 4;
        this.intbiasshift = 16;
        this.intbias = 65536;
        this.gammashift = 10;
        this.gamma = 1024;
        this.betashift = 10;
        this.beta = 64;
        this.betagamma = 65536;
        this.initrad = this.maxColorNum >> 3;
        this.radiusbiasshift = 6;
        this.radiusbias = 64;
        this.initradius = this.initrad * 64;
        this.radiusdec = 30;
        this.alphabiasshift = 10;
        this.initalpha = 1024;
        this.radbiasshift = 8;
        this.radbias = 256;
        this.alpharadbshift = 18;
        this.alpharadbias = 262144;
        this.netindex = new int[256];
        this.bias = new int[this.maxColorNum];
        this.freq = new int[this.maxColorNum];
        this.radpower = new int[this.initrad];
        this.colorMap = null;
        this.ncycles = n2;
    }

    protected synchronized void train() {
        Object object;
        this.network = new int[this.maxColorNum][];
        int n = 0;
        while (n < this.maxColorNum) {
            this.network[n] = new int[4];
            object = this.network[n];
            int n2 = (n << 12) / this.maxColorNum;
            object[2] = n2;
            object[1] = n2;
            object[0] = n2;
            this.freq[n] = 65536 / this.maxColorNum;
            this.bias[n] = 0;
            ++n;
        }
        object = this.getSourceImage(0);
        Rectangle rectangle = ((PlanarImage)object).getBounds();
        if (this.roi != null) {
            rectangle = this.roi.getBounds();
        }
        RandomIter randomIter = RandomIterFactory.create((RenderedImage)object, rectangle);
        int n3 = this.xPeriod * this.yPeriod;
        int n4 = rectangle.x / this.xPeriod;
        int n5 = rectangle.y / this.yPeriod;
        int n6 = rectangle.x % this.xPeriod;
        int n7 = rectangle.y % this.yPeriod;
        int n8 = (rectangle.width - 1) / this.xPeriod + 1;
        int n9 = n8 * ((rectangle.height - 1) / this.yPeriod + 1);
        if (n9 < 1509) {
            n3 = 1;
        }
        this.alphadec = 30 + (n3 - 1) / 3;
        int n10 = 0;
        int n11 = n9 / this.ncycles;
        int n12 = 1024;
        int n13 = this.initradius;
        int n14 = n13 >> 6;
        if (n14 <= 1) {
            n14 = 0;
        }
        int n15 = 0;
        while (n15 < n14) {
            this.radpower[n15] = n12 * ((n14 * n14 - n15 * n15) * 256 / (n14 * n14));
            ++n15;
        }
        int n16 = n9 < 1509 ? 3 : (n9 % 499 != 0 ? 1497 : (n9 % 491 != 0 ? 1473 : (n9 % 487 != 0 ? 1461 : 1509)));
        int[] nArray = new int[3];
        int n17 = 0;
        while (n17 < n9) {
            int n18 = (n10 / n8 + n5) * this.yPeriod + n7;
            int n19 = (n10 % n8 + n4) * this.xPeriod + n6;
            try {
                randomIter.getPixel(n19, n18, nArray);
            }
            catch (Exception exception) {
                continue;
            }
            int n20 = nArray[2] << 4;
            int n21 = nArray[1] << 4;
            int n22 = nArray[0] << 4;
            int n23 = this.contest(n20, n21, n22);
            this.altersingle(n12, n23, n20, n21, n22);
            if (n14 != 0) {
                this.alterneigh(n14, n23, n20, n21, n22);
            }
            if ((n10 += n16) >= n9) {
                n10 -= n9;
            }
            if (++n17 % n11 != 0) continue;
            n12 -= n12 / this.alphadec;
            if ((n14 = (n13 -= n13 / 30) >> 6) <= 1) {
                n14 = 0;
            }
            n23 = 0;
            while (n23 < n14) {
                this.radpower[n23] = n12 * ((n14 * n14 - n23 * n23) * 256 / (n14 * n14));
                ++n23;
            }
        }
        this.unbiasnet();
        this.inxbuild();
        this.createLUT();
        this.setProperty("LUT", this.colorMap);
    }

    private void createLUT() {
        this.colorMap = new LookupTableJAI(new byte[3][this.maxColorNum]);
        byte[][] byArray = this.colorMap.getByteData();
        int[] nArray = new int[this.maxColorNum];
        int n = 0;
        while (n < this.maxColorNum) {
            nArray[this.network[n][3]] = n;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.maxColorNum) {
            int n3 = nArray[n2];
            byArray[2][n2] = (byte)this.network[n3][0];
            byArray[1][n2] = (byte)this.network[n3][1];
            byArray[0][n2] = (byte)this.network[n3][2];
            ++n2;
        }
    }

    private void inxbuild() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.maxColorNum) {
            int[] nArray;
            int[] nArray2 = this.network[n3];
            int n4 = n3;
            int n5 = nArray2[1];
            int n6 = n3 + 1;
            while (n6 < this.maxColorNum) {
                nArray = this.network[n6];
                if (nArray[1] < n5) {
                    n4 = n6;
                    n5 = nArray[1];
                }
                ++n6;
            }
            nArray = this.network[n4];
            if (n3 != n4) {
                n6 = nArray[0];
                nArray[0] = nArray2[0];
                nArray2[0] = n6;
                n6 = nArray[1];
                nArray[1] = nArray2[1];
                nArray2[1] = n6;
                n6 = nArray[2];
                nArray[2] = nArray2[2];
                nArray2[2] = n6;
                n6 = nArray[3];
                nArray[3] = nArray2[3];
                nArray2[3] = n6;
            }
            if (n5 != n) {
                this.netindex[n] = n2 + n3 >> 1;
                n6 = n + 1;
                while (n6 < n5) {
                    this.netindex[n6] = n3;
                    ++n6;
                }
                n = n5;
                n2 = n3;
            }
            ++n3;
        }
        this.netindex[n] = n2 + this.maxnetpos >> 1;
        int n7 = n + 1;
        while (n7 < 256) {
            this.netindex[n7] = this.maxnetpos;
            ++n7;
        }
    }

    protected byte findNearestEntry(int n, int n2, int n3) {
        int n4 = 1000;
        int n5 = -1;
        int n6 = this.netindex[n2];
        int n7 = n6 - 1;
        while (n6 < this.maxColorNum || n7 >= 0) {
            int n8;
            int n9;
            int[] nArray;
            if (n6 < this.maxColorNum) {
                nArray = this.network[n6];
                n9 = nArray[1] - n2;
                if (n9 >= n4) {
                    n6 = this.maxColorNum;
                } else {
                    ++n6;
                    if (n9 < 0) {
                        n9 = -n9;
                    }
                    if ((n8 = nArray[0] - n3) < 0) {
                        n8 = -n8;
                    }
                    if ((n9 += n8) < n4) {
                        n8 = nArray[2] - n;
                        if (n8 < 0) {
                            n8 = -n8;
                        }
                        if ((n9 += n8) < n4) {
                            n4 = n9;
                            n5 = nArray[3];
                        }
                    }
                }
            }
            if (n7 < 0) continue;
            nArray = this.network[n7];
            n9 = n2 - nArray[1];
            if (n9 >= n4) {
                n7 = -1;
                continue;
            }
            --n7;
            if (n9 < 0) {
                n9 = -n9;
            }
            if ((n8 = nArray[0] - n3) < 0) {
                n8 = -n8;
            }
            if ((n9 += n8) >= n4) continue;
            n8 = nArray[2] - n;
            if (n8 < 0) {
                n8 = -n8;
            }
            if ((n9 += n8) >= n4) continue;
            n4 = n9;
            n5 = nArray[3];
        }
        return (byte)n5;
    }

    private void unbiasnet() {
        int n = 0;
        while (n < this.maxColorNum) {
            int[] nArray = this.network[n];
            nArray[0] = nArray[0] >> 4;
            int[] nArray2 = this.network[n];
            nArray2[1] = nArray2[1] >> 4;
            int[] nArray3 = this.network[n];
            nArray3[2] = nArray3[2] >> 4;
            this.network[n][3] = n;
            ++n;
        }
    }

    private void alterneigh(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n2 - n;
        if (n7 < -1) {
            n7 = -1;
        }
        if ((n6 = n2 + n) > this.maxColorNum) {
            n6 = this.maxColorNum;
        }
        int n8 = n2 + 1;
        int n9 = n2 - 1;
        int n10 = 1;
        while (n8 < n6 || n9 > n7) {
            int[] nArray;
            int n11 = this.radpower[n10++];
            if (n8 < n6) {
                nArray = this.network[n8++];
                nArray[0] = nArray[0] - n11 * (nArray[0] - n3) / 262144;
                nArray[1] = nArray[1] - n11 * (nArray[1] - n4) / 262144;
                nArray[2] = nArray[2] - n11 * (nArray[2] - n5) / 262144;
            }
            if (n9 <= n7) continue;
            nArray = this.network[n9--];
            nArray[0] = nArray[0] - n11 * (nArray[0] - n3) / 262144;
            nArray[1] = nArray[1] - n11 * (nArray[1] - n4) / 262144;
            nArray[2] = nArray[2] - n11 * (nArray[2] - n5) / 262144;
        }
    }

    private void altersingle(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = this.network[n2];
        nArray[0] = nArray[0] - n * (nArray[0] - n3) / 1024;
        nArray[1] = nArray[1] - n * (nArray[1] - n4) / 1024;
        nArray[2] = nArray[2] - n * (nArray[2] - n5) / 1024;
    }

    private int contest(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n5 = Integer.MAX_VALUE;
        int n7 = n4 = -1;
        int n8 = 0;
        while (n8 < this.maxColorNum) {
            int n9;
            int n10;
            int[] nArray = this.network[n8];
            int n11 = nArray[0] - n;
            if (n11 < 0) {
                n11 = -n11;
            }
            if ((n10 = nArray[1] - n2) < 0) {
                n10 = -n10;
            }
            n11 += n10;
            n10 = nArray[2] - n3;
            if (n10 < 0) {
                n10 = -n10;
            }
            if ((n11 += n10) < n5) {
                n5 = n11;
                n4 = n8;
            }
            if ((n9 = n11 - (this.bias[n8] >> 12)) < n6) {
                n6 = n9;
                n7 = n8;
            }
            int n12 = this.freq[n8] >> 10;
            int n13 = n8;
            this.freq[n13] = this.freq[n13] - n12;
            int n14 = n8++;
            this.bias[n14] = this.bias[n14] + (n12 << 10);
        }
        int n15 = n4;
        this.freq[n15] = this.freq[n15] + 64;
        int n16 = n4;
        this.bias[n16] = this.bias[n16] - 65536;
        return n7;
    }
}

