/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.IntPair;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class Features {
    private ArrayList<Feature> f = new ArrayList();
    private static int maxValue = 11000000;

    public Features() {
    }

    public void add(Feature m) {
        this.f.add(m);
    }

    public void removeLast() {
        this.f.remove(this.f.size() - 1);
    }

    public Feature get(int index) {
        return this.f.get(index);
    }

    public int size() {
        return this.f.size();
    }

    public Experiments domain() {
        this.get(0);
        return Feature.domain;
    }

    public void clean() {
    }

    public void print() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).print();
        }
    }

    public void save(String filename) {
        try {
            OutDataStreamFile rF = new OutDataStreamFile(filename);
            rF.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.get(i).save(rF);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Features(String filename, Experiments domain) {
        Exception e1 = new Exception("Incorrect data file format!");
        Index<IntPair> instanceIndex = domain.createIndex();
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while (!(s = in.readLine()).equals("<features>")) {
            }
            if (s == null) {
                throw e1;
            }
            s = in.readLine();
            if (!s.startsWith("<fSize>")) {
                throw e1;
            }
            if (!s.endsWith("</fSize>")) {
                throw e1;
            }
            int index1 = s.indexOf(">");
            int index2 = s.lastIndexOf("<");
            String fSt = s.substring(index1 + 1, index2);
            System.out.println(fSt);
            int number = Integer.parseInt(fSt);
            System.out.println("fSize is " + number);
            int[] arrIndexes = new int[maxValue];
            double[] arrValues = new double[maxValue];
            for (int f = 0; f < number; ++f) {
                String line = in.readLine();
                int indSp = -1;
                int current = 0;
                while ((indSp = line.indexOf(" ")) > -1) {
                    int x = Integer.parseInt(line.substring(0, indSp));
                    if ((indSp = (line = line.substring(indSp + 1)).indexOf(" ")) == -1) {
                        indSp = line.length();
                    }
                    int y = Integer.parseInt(line.substring(0, indSp));
                    if ((indSp = (line = line.substring(indSp + 1)).indexOf(" ")) == -1) {
                        indSp = line.length();
                    }
                    double val = Double.parseDouble(line.substring(0, indSp));
                    if (indSp < line.length()) {
                        line = line.substring(indSp + 1);
                    }
                    arrIndexes[current] = instanceIndex.indexOf(new IntPair(x, y));
                    arrValues[current] = val;
                    ++current;
                }
                int[] indValues = new int[current];
                double[] values = new double[current];
                for (int j = 0; j < current; ++j) {
                    indValues[j] = arrIndexes[j];
                    values[j] = arrValues[j];
                }
                Feature bf = new Feature(domain, indValues, values, instanceIndex);
                this.add(bf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile rF = new InDataStreamFile(filename);
            int numFeats = rF.readInt();
            for (int i = 0; i < numFeats; ++i) {
                Feature tF = new Feature();
                tF.read(rF);
                this.add(tF);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

