/* FixArrays.c
 * This file is part of the LaBrea package
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "labrea.h"

/* used to clean up stuff in */
/* the input files, this one */
/* skips over any spaces and */
/* carriage returns and then */
/* changes a line feed to a  */
/* null                      */
static void cleanup(char *p) {
  char *p2 = p;

  while(*p != '\0') {
    /*skip spaces and returns */
    while((*p2 == ' ') || (*p2 == '\r') || (*p2 == '\t')) {
      p2++;
    }
    *p = (char)toupper(*p2);
    if(*p == '\n')
      *p = '\0';
    else {
      p2++;
      p++;
    }
  }
}

static void TestPrint(char *output) {
  extern int testflag, oflag;
  extern char format5[];

  if(testflag || oflag)
    printf(format5, output);
  else
    syslog(LOGTYPE, output);
}

/* We have two styles for the configuration files. */
/* The "old style" had a separate file for each of */
/* the different options:  hard exclude, exclude,  */
/* ip ignore, and port ignore.  In the "new" style */
/* there is a common file with "tags" on lines to  */
/* indicate what type of configuration the line is */
/* supposed to be... for example:                  */
/* 192.168.0.1 - 192.168.0.10 exclude              */
/* would exclude the range of IPs from 192.168.0.1 */
/* through 192.168.0.10 while:                     */
/* 192.168.0.20 ipignore                           */
/* would cause connection attempts sourced from    */
/* 192.168.0.20 to NOT be tarpitted or trapped     */
/* Tags are: "hardexclude", "exclude", "ipignore", */
/* and "portignore"                                */
/* NB: Version 2.4 is the final version that the   */
/* "old style" configuration files will officially */
/* be supported...                                 */

#ifdef OLDSTYLE
/* read exclusion files and create */
/* arrays to keep stuff straight...*/
void FixArrays(int wait) {
  extern int testflag, xflag, Xflag, hflag, Hflag;
  extern u_int addresses;
  extern u_char *exclusion;
  extern u_int *addr_array, base, topend;
  extern bpf_u_int32 randqueue1[];
  extern time_t *time_array;
  extern char mybuffer[], mybuffer2[];
  extern struct ignore_ip *ignorelist;
  extern unsigned char ignoreport[8192];
  FILE *in = NULL;
  bpf_u_int32 exip, lowip = 0, i, ip;
  int tempxflag, boolContinue = 1, boolRangeFlag = 0;
  u_short lowport = 0, export, offset, leftover;
  u_int c;
  struct ignore_ip *iip, *tempiip;
  char *p, *rtn, temp;
  extern char format3[], format4[], format7[], format11[], str10[], str11[], str4[], str9[];
  extern char HardExcludeName[], HardExcludeNotFound[], str12[], str14[], IgnoreName[],
              IgnoreNotFound[], ExcludeName[], ExcludeNotFound[], IgnorePortName[],
              IgnorePortNotFound[], rstring[], dashstr[], ignorestr[], str15[];
  extern unsigned char mask[8];

  /* shut off capture */
  tempxflag = xflag;
  xflag = 1;
  if(wait)
    sleep(1);
  if(Hflag)
    temp = IP_HARDCAPTURED;
  else
    temp = 0;
  /* clear out the exclusion array */
  for(c = 0; c < addresses+2; c++)
    exclusion[c] = temp;
  /* clear the ARP addr array */
  if(addr_array != NULL) {
    for(c = 0; c < addresses+2; c++)
      addr_array[c] = 0;
  }
  /* clear out the ARP time array */
  if(time_array != NULL) {
    for(c = 0; c < addresses+2; c++)
      time_array[c] = 0;
  }
  /* make us some random numbers */
  for(c = 0; c < RANDSIZE1; c++)
    randqueue1[c] = libnet_get_prand(PRu32);
  /* handle hardexclusion file */
  if(hflag) {
    if((in = fopen(HardExcludeName, rstring)) == NULL) {
      sprintf(mybuffer, HardExcludeNotFound);
      TestPrint(mybuffer);
    } else {
      while(boolContinue) {
        rtn = fgets(mybuffer, 1024, in);
        if(rtn != NULL) {
          if((*mybuffer != '#') && (strlen(mybuffer) > 2)) {
            cleanup(mybuffer);
            boolRangeFlag = 0;
            if((p = strstr(mybuffer, dashstr)) != NULL) {
              boolRangeFlag = 1;
              *p = '\0';
              lowip = ntohl(libnet_name_resolve(mybuffer, 0)) - base;
              p++;
            } else
              p = mybuffer;
            exip = ntohl(libnet_name_resolve(p,0));
            exip -= base;
            if(!boolRangeFlag)
              lowip = exip;
            for(i = lowip; i <= exip; i++) {
              if((i < 0) || (i > addresses)) {
                sprintf(mybuffer2, format7, str9, mybuffer);
                TestPrint(mybuffer2);
              } else {
                exclusion[i] = 2;
                if(testflag)
                  printf(format4,(((base + i) & 0xFF000000) >> 24),
                         (((base + i) & 0xFF0000) >> 16),
                         (((base + i) & 0xFF00) >> 8),((base + i) & 0xFF));
              }
            }
          }
        } else
          boolContinue = 0;
      }
      if(testflag)
        printf(str4);
      fclose(in);
    }
  }
  /* handle exclusion file */
  /* note: some people have questioned this...     */
  /* it makes sense to me... full blown exclusions */
  /* override hard excludes.                       */
  boolContinue = 1;
  if((in = fopen(ExcludeName, rstring)) == NULL) {
    sprintf(mybuffer, ExcludeNotFound);
    TestPrint(mybuffer);
  } else {
    while(boolContinue) {
      rtn = fgets(mybuffer, 1024, in);
      if(rtn != NULL) {
        if((*mybuffer != '#') && (strlen(mybuffer) > 2)) {
          cleanup(mybuffer);
          boolRangeFlag = 0;
          if((p = strstr(mybuffer, dashstr)) != NULL) {
            boolRangeFlag = 1;
            *p = '\0';
            lowip = ntohl(libnet_name_resolve(mybuffer, 0)) - base;
            p++;
          } else
            p = mybuffer;
          exip = ntohl(libnet_name_resolve(p,0));
          exip -= base;
          if(!boolRangeFlag)
            lowip = exip;
          for(i = lowip; i <= exip; i++) {
            if((i < 0) || (i > addresses)) {
              sprintf(mybuffer2, format7, str10, mybuffer);
              TestPrint(mybuffer2);
            } else {
               exclusion[i] = 1;
               if(testflag)
                 printf(format3,(((base + i) & 0xFF000000) >> 24),
                         (((base + i) & 0xFF0000) >> 16),
                         (((base + i) & 0xFF00) >> 8),((base + i) & 0xFF));
            }
          }
        }
      } else
        boolContinue = 0;
    }
    fclose(in);
  }
  /* handle ignoreIP file */
  boolContinue = 1;
  for(iip = ignorelist; iip; iip = tempiip) {
    tempiip = iip->next;
    MYFREE(iip);
  }
  ignorelist = NULL;
  tempiip = NULL;
  if((in = fopen(IgnoreName, rstring)) == NULL) {
    sprintf(mybuffer, IgnoreNotFound);
    TestPrint(mybuffer);
  } else {
    while(boolContinue) {
      rtn = fgets(mybuffer, 1024, in);
      if(rtn != NULL) {
        if((*mybuffer != '#') && (strlen(mybuffer) > 2)) {
          cleanup(mybuffer);
          boolRangeFlag = 0;
          if((p = strstr(mybuffer, dashstr)) != NULL) {
            *p = '\0';
            boolRangeFlag = 1;
            lowip = ntohl(libnet_name_resolve(mybuffer, 0));
            p++;
          } else
            p = mybuffer;
          exip = ntohl(libnet_name_resolve(p,0));
          if(!boolRangeFlag)
            lowip = exip;
          for(i = lowip; i <= exip; i++) {
            if(i < 0) {
              sprintf(mybuffer2, format7, str11, mybuffer);
              TestPrint(mybuffer2);
            } else {
              iip = malloc(sizeof(struct ignore_ip));
              if(iip != NULL) {
                if(ignorelist == NULL)
                  ignorelist = iip;
                if(tempiip != NULL)
                  tempiip->next = iip;
                tempiip = iip;
                iip->ip = htonl(i);
                iip->next = NULL;
              }
              if(testflag)
                printf(format11, ignorestr, (((base + i) & 0xFF000000) >> 24),
                       (((base + i) & 0xFF0000) >> 16),
                       (((base + i) & 0xFF00) >> 8),((base + i) & 0xFF));
            }
          }
        }
      } else
        boolContinue = 0;
    }
    fclose(in);
  }
  boolContinue = 1;
  for(i = 0; i < 8192; i++)
    ignoreport[i] = 0;
  if((in = fopen(IgnorePortName, rstring)) == NULL) {
    sprintf(mybuffer, IgnorePortNotFound);
    TestPrint(mybuffer);
  } else {
    while(boolContinue) {
      rtn = fgets(mybuffer, 1024, in);
      if(rtn != NULL) {
        if((*mybuffer != '#') && (strlen(mybuffer) > 2)) {
          cleanup(mybuffer);
          boolRangeFlag = 0;
          if((p = strstr(mybuffer, dashstr)) != NULL) {
            *p = '\0';
            boolRangeFlag = 1;
            lowport = atoi(mybuffer);
            p++;
          } else
            p = mybuffer;
          export = atoi(p);
          if(!boolRangeFlag)
            lowport = export;
          for(i = lowport; i <= export; i++) {
            if((i < 0) || (i > 65535)){
              sprintf(mybuffer2, format7, str12, mybuffer);
              TestPrint(mybuffer2);
            } else {
              offset = i / 8;
              leftover = i % 8;
              ignoreport[offset] |= mask[leftover];
              if(testflag)
                printf(str15, i);
            }
          }
        }
      } else
        boolContinue = 0;
    }
    fclose(in);
  }
  if(Xflag) {
    if(testflag)
      printf(str14);
    for(i = base; i <= topend; i++) {
      ip = htonl(i);
      if(gethostbyaddr((void *)&ip,4,AF_INET)) {
        exclusion[i-base] = 1;
        if(testflag)
          printf(format3,((i & 0xFF000000) >> 24),
                 ((i & 0xFF0000) >> 16),((i & 0xFF00) >> 8),(i & 0xFF));
      }
    }
  }
  /* turn on ARP capture -- if it was on */
  xflag = tempxflag;
}
#else

/* read exclusion files and create */
/* arrays to keep stuff straight...*/
void FixArrays(int wait) {
  extern int testflag, xflag, Xflag, Hflag;
  extern u_int addresses;
  extern u_char *exclusion;
  extern u_int *addr_array, base, topend;
  extern bpf_u_int32 randqueue1[];
  extern time_t *time_array;
  extern char mybuffer[], mybuffer2[];
  extern struct ignore_ip *ignorelist;
  extern unsigned char ignoreport[8192];
  FILE *in = NULL;
  bpf_u_int32 exip, lowip = 0, i, ip;
  int tempxflag, boolContinue = 1, boolRangeFlag = 0;
  int iExclude, boolIPIgnore, boolPortIgnore;
  u_short lowport = 0, export, offset, leftover;
  u_int c;
  struct ignore_ip *iip, *tempiip;
  char *p = NULL, *rtn, *strptr = NULL, temp;
  extern char format11[], format9[], ignorestr[], dashstr[];
  extern char ConfigName[], ConfigNotFound[], str4[], str5[], str12[];
  extern char rstring[], str6[], str7[], str8[], str13[], str14[], format7[];
  extern char str9[], str10[], str15[];
  extern unsigned char mask[8];

  /* shut off capture */
  tempxflag = xflag;
  xflag = 1;
  if(wait)
    sleep(1);
  if(Hflag)
    temp = IP_HARDCAPTURED;
  else
    temp = 0;
  /* clear out the exclusion array */
  for(c = 0; c < addresses + 2; c++)
    *(exclusion + c) = temp;
  /* clear the ARP addr array */
  if(addr_array != NULL) {
    for(c = 0; c < addresses + 2; c++)
      *(addr_array + c) = 0;
  }
  /* clear out the ARP time array */
  if(time_array != NULL) {
    for(c = 0; c < addresses + 2; c++)
      *(time_array + c) = 0;
  }
  /* make us some random numbers for IPIDs */
  for(c = 0; c < RANDSIZE1; c++)
    *(randqueue1 + c) = libnet_get_prand(PRu32);
  /* free up our ignore list */
  for(iip = ignorelist; iip; iip = tempiip){
    tempiip = iip->next;
    MYFREE(iip);
  }
  ignorelist = NULL;
  tempiip = NULL;
  /* handle configuration file */
  if((in = fopen(ConfigName, rstring)) == NULL) {
    sprintf(mybuffer, ConfigNotFound);
    TestPrint(mybuffer);
  } else {
    while(boolContinue) {
      rtn = fgets(mybuffer, 1024, in);
      if(rtn != NULL) {
        if((*mybuffer != '#') && (strlen(mybuffer) > 2)) {
          cleanup(mybuffer);
          boolRangeFlag = iExclude = boolIPIgnore = boolPortIgnore = 0;
          if((p = strstr(mybuffer, str5)) != NULL){
            iExclude = IP_HARDEXCLUDE;
            strptr = str9;
            *p = '\0';
          } else {
            if((p = strstr(mybuffer, str6)) != NULL){
              iExclude = IP_EXCLUDE;
              strptr = str10;
              *p = '\0';
            } else {
              if((p = strstr(mybuffer, str7)) != NULL) {
                boolIPIgnore = 1;
                *p = '\0';
              } else {
                if((p = strstr(mybuffer, str8)) != NULL){
                  *p = '\0';
                  boolPortIgnore = 1;
                } else
                  printf(str13, mybuffer);
              }
            }
          }
          if(iExclude){
            if((p = strstr(mybuffer, dashstr)) != NULL) {
              boolRangeFlag = 1;
              *p = '\0';
              lowip = ntohl(libnet_name_resolve(mybuffer, 0)) - base;
              p++;
            } else
              p = mybuffer;
            exip = ntohl(libnet_name_resolve(p,0));
            exip -= base;
            if(!boolRangeFlag)
              lowip = exip;
            for(i = lowip; i <= exip; i++) {
              if((i < 0) || (i > addresses)) {
                sprintf(mybuffer2, format7, strptr, mybuffer);
                TestPrint(mybuffer2);
              } else {
                if(exclusion[i] != IP_EXCLUDE)
                  exclusion[i] = iExclude;
                if(testflag)
                  printf(format11, strptr, (((base + i) & 0xFF000000) >> 24),
                         (((base + i) & 0xFF0000) >> 16),
                         (((base + i) & 0xFF00) >> 8),((base + i) & 0xFF));
              }
            }
          } else {
            if(boolIPIgnore){
              if((p = strstr(mybuffer, dashstr)) != NULL) {
                *p = '\0';
                boolRangeFlag = 1;
                lowip = ntohl(libnet_name_resolve(mybuffer, 0));
                p++;
              } else
                p = mybuffer;
              exip = ntohl(libnet_name_resolve(p,0));
              if(!boolRangeFlag)
                lowip = exip;
              for(i = lowip; i <= exip; i++) {
                if(i < 0) {
                  sprintf(mybuffer2, format9, mybuffer);
                  TestPrint(mybuffer2);
                } else {
                  iip = malloc(sizeof(struct ignore_ip));
                  if(iip != NULL) {
                    if(ignorelist == NULL)
                      ignorelist = iip;
                    if(tempiip != NULL)
                      tempiip->next = iip;
                    tempiip = iip;
                    iip->ip = htonl(i);
                    iip->next = NULL;
                  }
                  if(testflag)
                    printf(format11, ignorestr,((i & 0xFF000000) >> 24),
                           ((i & 0xFF0000) >> 16),
                           ((i & 0xFF00) >> 8),(i & 0xFF));
                }
              }
            } else {
              if(boolPortIgnore){
                if((p = strstr(mybuffer, dashstr)) != NULL) {
                  *p = '\0';
                  boolRangeFlag = 1;
                  lowport = atoi(mybuffer);
                  p++;
                } else
                  p = mybuffer;
                export = atoi(p);
                if(!boolRangeFlag)
                  lowport = export;
                for(i = lowport; i <= export; i++) {
                  if((i < 0) || (i > 65535)){
                    sprintf(mybuffer2, format7, str12, mybuffer);
                    TestPrint(mybuffer2);
                  } else {
                    offset = i / 8;
                    leftover = i % 8;
                    ignoreport[offset] |= mask[leftover];
                    if(testflag)
                      printf(str15,i);
                  }
                }
              }
            }
          }
        }
      } else
        boolContinue = 0;
    }
    if(testflag)
      printf(str4);
    fclose(in);
  }
  if(Xflag) {
    if(testflag)
      printf(str14);
    for(i = base; i <= topend; i++) {
      ip = htonl(i);
      if(gethostbyaddr((void *)&ip,4,AF_INET)) {
        exclusion[i-base] = 1;
        if(testflag)
          printf(format11, str10,((i & 0xFF000000) >> 24),
                 ((i & 0xFF0000) >> 16),((i & 0xFF00) >> 8),(i & 0xFF));
      }
    }
  }
  /* turn on ARP capture -- if it was on */
  xflag = tempxflag;
}
#endif


