/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.sort.MergeInstr;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLMergeKey;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class XSLMergeSource
extends StyleElement {
    private Expression forEachItem;
    private Expression forEachSource;
    private Expression select;
    private boolean sortBeforeMerge = false;
    private int mergeKeyCount = 0;
    private String sourceName;
    private int validationAction = 4;
    private SchemaType schemaType = null;
    private boolean streamable = false;
    private Set<Accumulator> accumulators = new HashSet<Accumulator>();

    public boolean isInstruction() {
        return false;
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public Expression getForEachItem() {
        return this.forEachItem;
    }

    public Expression getForEachSource() {
        return this.forEachSource;
    }

    public Expression getSelect() {
        return this.select;
    }

    public boolean isSortBeforeMerge() {
        return this.sortBeforeMerge;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getValidationAction() {
        return this.validationAction;
    }

    public SchemaType getSchemaTypeAttribute() {
        return this.schemaType;
    }

    public MergeInstr.MergeSource makeMergeSource(MergeInstr mi, Expression select) {
        MergeInstr.MergeSource ms = new MergeInstr.MergeSource(mi);
        if (this.forEachItem != null) {
            ms.initForEachItem(mi, this.forEachItem);
        }
        if (this.forEachSource != null) {
            ms.initForEachStream(mi, this.forEachSource);
        }
        if (select != null) {
            this.select = select;
            ms.initRowSelect(mi, select);
        }
        ms.baseURI = this.getBaseURI();
        ms.sourceName = this.sourceName;
        ms.validation = this.validationAction;
        ms.schemaType = this.schemaType;
        ms.streamable = this.streamable;
        ms.accumulators = this.accumulators;
        return ms;
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return null;
    }

    protected void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String forEachItemAtt = null;
        String forEachSourceAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        String streamableAtt = null;
        String useAccumulatorsAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("for-each-item")) {
                forEachItemAtt = atts.getValue(a);
                this.forEachItem = this.makeExpression(forEachItemAtt, a);
                continue;
            }
            if (f.equals("for-each-stream") || f.equals("for-each-source")) {
                forEachSourceAtt = atts.getValue(a);
                this.forEachSource = this.makeExpression(forEachSourceAtt, a);
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            if (f.equals("sort-before-merge")) {
                this.sortBeforeMerge = this.processBooleanAttribute("sort-before-merge", atts.getValue(a));
                continue;
            }
            if (f.equals("name")) {
                String nameAtt = Whitespace.trim(atts.getValue(a));
                if (NameChecker.isValidNCName(nameAtt)) {
                    this.sourceName = nameAtt;
                    continue;
                }
                this.compileError("xsl:merge-source/@name (" + nameAtt + ") is not a valid NCName", "XTSE0020");
                continue;
            }
            if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("streamable")) {
                streamableAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("use-accumulators")) {
                useAccumulatorsAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.sourceName == null) {
            this.sourceName = "saxon-merge-source-" + this.hashCode();
        }
        if (forEachItemAtt != null && forEachSourceAtt != null) {
            this.compileError("The for-each-item and for-each-source attributes must not both be present", "XTSE3195");
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
        }
        this.validationAction = validationAtt == null ? this.getDefaultValidation() : this.validateValidationAttribute(validationAtt);
        if (typeAtt != null) {
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(typeAtt);
            this.validationAction = 8;
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if ((typeAtt != null || validationAtt != null) && forEachSourceAtt == null) {
            this.compileError("The @type and @validation attributes can be used only when @for-each-stream is specified", "XTSE0020");
        }
        if (streamableAtt != null) {
            this.streamable = this.processStreamableAtt(streamableAtt);
            if (this.streamable && this.forEachSource == null) {
                this.compileError("Streaming on xsl:merge-source is possible only when @for-each-source is used", "XTSE3195");
            }
        } else if (this.forEachSource != null) {
            this.streamable = false;
        }
        if (useAccumulatorsAtt == null) {
            useAccumulatorsAtt = "";
        }
        AccumulatorRegistry registry = this.getPrincipalStylesheetModule().getStylesheetPackage().getAccumulatorRegistry();
        this.accumulators = registry.getUsedAccumulators(useAccumulatorsAtt, this);
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        this.forEachItem = this.typeCheck("for-each-item", this.forEachItem);
        this.forEachSource = this.typeCheck("for-each-source", this.forEachSource);
        this.select = this.typeCheck("select", this.select);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLMergeKey) {
                ++this.mergeKeyCount;
                continue;
            }
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:merge-source", "XTSE0010");
                continue;
            }
            if (!(child instanceof StyleElement)) continue;
            ((StyleElement)child).compileError("No children other than xsl:merge-key are allowed within xsl:merge-source", "XTSE0010");
        }
        if (this.mergeKeyCount == 0) {
            this.compileError("xsl:merge-source must have exactly at least one xsl:merge-key child element", "XTSE0010");
        }
    }
}

