/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.JDBCBoot;
import org.apache.derby.iapi.services.i18n.MessageService;

public class EmbeddedDriver
implements Driver {
    public EmbeddedDriver() {
        EmbeddedDriver.boot();
    }

    public boolean acceptsURL(String string) throws SQLException {
        return this.getRegisteredDriver().acceptsURL(string);
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        return this.getRegisteredDriver().connect(string, properties);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return this.getRegisteredDriver().getPropertyInfo(string, properties);
    }

    public int getMajorVersion() {
        try {
            return this.getRegisteredDriver().getMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return this.getRegisteredDriver().getMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        try {
            return this.getRegisteredDriver().jdbcCompliant();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private static void boot() {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            printStream = System.err;
        }
        new JDBCBoot().boot("jdbc:derby:", printStream);
    }

    private Driver getRegisteredDriver() throws SQLException {
        try {
            return DriverManager.getDriver("jdbc:derby:");
        }
        catch (SQLException sQLException) {
            throw new SQLException(MessageService.getTextMessage("I015"));
        }
    }

    static {
        EmbeddedDriver.boot();
    }
}

