package # hide from PAUSE(The [Perl programming] Authors Upload Server)
        warnings;

$VERSION =
$VERSION = '0.02';

BEGIN {
    my @pragma = grep -e, map {"$_/" . __FILE__} @INC;
    my %pragma = map { $_ => 1 } @pragma;
    if (scalar(keys %pragma) >= 2) {
        my $pragma = join "\n", sort keys %pragma;
        CORE::warn <<END;
****************************************************
                   C A U T I O N

            CONFLICT warnings.pm PRAGMA

$pragma
****************************************************
END
    }
}

sub carp {
    my($package,$filename,$line) = caller(1);
    print STDERR "@_ at $filename line $line.\n";
}

sub croak {
    my($package,$filename,$line) = caller(1);
    print STDERR "@_ at $filename line $line.\n";
    die "\n";
}

sub import {
    $^W = 1;
}

sub unimport {
    $^W = 0;
}

sub enabled {
    return $^W;
}

sub warn {
    if (@_ == 1) {
        carp $_[0];
    }
    elsif (@_ == 2) {
        carp $_[1];
    }
    else {
        croak "Usage: warnings::warn([category,] 'message')";
    }
}

sub warnif {
    if (@_ == 1) {
        carp $_[0] if $^W;
    }
    elsif (@_ == 2) {
        carp $_[1] if $^W;
    }
    else {
        croak "Usage: warnings::warnif([category,] 'message')";
    }
}

1;
__END__

=pod

=head1 NAME

warnings - poor warnings.pm to emulate "use warnings;"

=head1 SYNOPSIS

    use warnings;
    no warnings;

    use warnings "all";
    no warnings "all";

    use warnings::register;
    if (warnings::enabled()) {
        warnings::warn("some warning");
    }

    if (warnings::enabled("void")) {
        warnings::warn("void", "some warning");
    }

    if (warnings::enabled($object)) {
        warnings::warn($object, "some warning");
    }

    warnings::warnif("some warning");
    warnings::warnif("void", "some warning");
    warnings::warnif($object, "some warning");

=head1 ABSTRACT

This file helps to make your perl interpreter modern.

=head1 DEPENDENCIES

This software requires perl5.00503 or later.

=head1 AUTHOR

INABA Hitoshi E<lt>ina@cpan.orgE<gt>

This project was originated by INABA Hitoshi.

=head1 LICENSE AND COPYRIGHT

This software is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>.

This software is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

=head1 ACKNOWLEDGEMENTS

This software was made referring to software and the document that the
following hackers or persons had made.
I am thankful to all persons.

 Sebastien Aperghis-Tramoni, warnings-compat
 http://search.cpan.org/dist/warnings-compat/

=cut

