/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class AssignmentExprent
extends Exprent {
    public static final int CONDITION_NONE = -1;
    private static final String[] OPERATORS = new String[]{" += ", " -= ", " *= ", " /= ", " &= ", " |= ", " ^= ", " %= ", " <<= ", " >>= ", " >>>= "};
    private Exprent left;
    private Exprent right;
    private int condType = -1;

    public AssignmentExprent(Exprent left, Exprent right, BitSet bytecodeOffsets) {
        super(2);
        this.left = left;
        this.right = right;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    @NotNull
    public VarType getExprType() {
        VarType varType = this.left.getExprType();
        if (varType == null) {
            AssignmentExprent.$$$reportNull$$$0(0);
        }
        return varType;
    }

    @Override
    public void inferExprType(VarType upperBounds) {
        this.left.inferExprType(upperBounds);
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        VarType typeLeft = this.left.getExprType();
        VarType typeRight = this.right.getExprType();
        if (typeLeft.getTypeFamily() > typeRight.getTypeFamily()) {
            result.addMinTypeExprent(this.right, VarType.getMinTypeInFamily(typeLeft.getTypeFamily()));
        } else if (typeLeft.getTypeFamily() < typeRight.getTypeFamily()) {
            result.addMinTypeExprent(this.left, typeRight);
        } else {
            result.addMinTypeExprent(this.left, VarType.getCommonSupertype(typeLeft, typeRight));
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        lst.add(this.left);
        lst.add(this.right);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new AssignmentExprent(this.left.copy(), this.right.copy(), this.bytecode);
    }

    @Override
    public int getPrecedence() {
        return 13;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        this.left.inferExprType(null);
        VarType leftType = this.left.getExprType();
        this.right.inferExprType(leftType);
        VarType rightType = this.right.getExprType();
        boolean fieldInClassInit = false;
        boolean hiddenField = false;
        if (this.left.type == 5) {
            StructField fd;
            FieldExprent field = (FieldExprent)this.left;
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node != null && (fd = node.classStruct.getField(field.getName(), field.getDescriptor().descriptorString)) != null) {
                if (field.isStatic() && fd.hasModifier(16)) {
                    fieldInClassInit = true;
                }
                if (node.getWrapper() != null && node.getWrapper().getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()))) {
                    hiddenField = true;
                }
            }
        }
        if (hiddenField) {
            return new TextBuffer();
        }
        TextBuffer buffer = new TextBuffer();
        if (fieldInClassInit) {
            buffer.append(((FieldExprent)this.left).getName());
        } else {
            buffer.append(this.left.toJava(indent, tracer));
        }
        if (this.right.type == 3) {
            ((ConstExprent)this.right).adjustConstType(leftType);
        }
        TextBuffer res = this.right.toJava(indent, tracer);
        if (this.condType == -1) {
            this.wrapInCast(leftType, rightType, res, this.right.getPrecedence());
        }
        buffer.append(this.condType == -1 ? " = " : OPERATORS[this.condType]).append(res);
        tracer.addMapping(this.bytecode);
        return buffer;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.left) {
            this.left = newExpr;
        }
        if (oldExpr == this.right) {
            this.right = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssignmentExprent)) {
            return false;
        }
        AssignmentExprent as = (AssignmentExprent)o;
        return Objects.equals(this.left, as.getLeft()) && Objects.equals(this.right, as.getRight()) && this.condType == as.getCondType();
    }

    @Override
    public void fillBytecodeRange(@Nullable BitSet values) {
        AssignmentExprent.measureBytecode(values, this.left);
        AssignmentExprent.measureBytecode(values, this.right);
        this.measureBytecode(values);
    }

    public Exprent getLeft() {
        return this.left;
    }

    public Exprent getRight() {
        return this.right;
    }

    public void setRight(Exprent right) {
        this.right = right;
    }

    public int getCondType() {
        return this.condType;
    }

    public void setCondType(int condType) {
        this.condType = condType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/decompiler/modules/decompiler/exps/AssignmentExprent", "getExprType"));
    }
}

