/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.RelationToType;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKind;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u00018B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000fH\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000fH\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J5\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0018H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001bH\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001cJ-\u0010\u001d\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001eH\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001fJ1\u0010 \u001a\u00020\u0007*\u00020!2\u0006\u0010\"\u001a\u00020\u0015H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010#J9\u0010$\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010)JA\u0010*\u001a\u0004\u0018\u00010+*\u00020,2\u0006\u0010-\u001a\u00020\u00152\b\b\u0002\u0010.\u001a\u00020/2\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u00020,01H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00102J$\u00103\u001a\u00020+2\n\u00104\u001a\u0006\u0012\u0002\b\u0003052\u0006\u00106\u001a\u00020\u00152\u0006\u00107\u001a\u00020/H\u0002\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkSupertypes", "checkParameterBounds", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "visibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)V", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)V", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkExposure", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "declarationVisibility", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)V", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "findVisibilityExposure", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker$SymbolWithRelation;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "ignoreInternalExposure", "", "visitedTypes", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;ZLjava/util/Set;)Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker$SymbolWithRelation;", "symbolWithRelation", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "effectiveVisibility", "fromTypeArgument", "SymbolWithRelation", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExposedVisibilityDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,373:1\n30#2:374\n30#2:375\n30#2:376\n30#2:377\n58#2:378\n30#2:379\n30#2:380\n30#2:381\n45#3:382\n45#3:383\n44#3:385\n44#3:386\n44#3:387\n1#4:384\n*S KotlinDebug\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n*L\n52#1:374\n57#1:375\n129#1:376\n150#1:377\n151#1:378\n192#1:379\n247#1:380\n271#1:381\n303#1:382\n304#1:383\n348#1:385\n352#1:386\n355#1:387\n*E\n"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias(reporter, context, (FirTypeAlias)declaration);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty(reporter, context, (FirProperty)declaration);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction(reporter, context, (FirFunction)declaration);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass(reporter, context, (FirRegularClass)declaration);
        }
    }

    private final void checkClass(DiagnosticReporter reporter, CheckerContext context, FirRegularClass declaration) {
        this.checkSupertypes(reporter, context, declaration);
        FirTypeParameterRefsOwner firTypeParameterRefsOwner = declaration;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        this.checkParameterBounds(reporter, context, firTypeParameterRefsOwner, (EffectiveVisibility)firResolvedDeclarationStatus);
    }

    private final void checkSupertypes(DiagnosticReporter reporter, CheckerContext context, FirRegularClass declaration) {
        FirResolvedDeclarationStatus classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(classVisibility = firResolvedDeclarationStatus), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes = declaration.getSuperTypeRefs();
        boolean isInterface = declaration.getClassKind() == ClassKind.INTERFACE;
        for (FirTypeRef supertypeRef : supertypes) {
            SymbolWithRelation symbolWithRelation;
            FirRegularClassSymbol classSymbol;
            boolean superIsInterface;
            ConeKotlinType supertype;
            KtSourceElement ktSourceElement = supertypeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumSuperTypeRef.INSTANCE) || ToSymbolUtilsKt.toRegularClassSymbol(supertype = FirTypeUtilsKt.getConeType(supertypeRef), context.getSession()) == null || (superIsInterface = classSymbol.getClassKind() == ClassKind.INTERFACE) != isInterface || FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context, supertype, (EffectiveVisibility)classVisibility, false, null, 12, null) == null) continue;
            FirClassLikeSymbol<?> restricting = symbolWithRelation.component1();
            EffectiveVisibility restrictingVisibility = symbolWithRelation.component2();
            RelationToType relation = symbolWithRelation.component3();
            DiagnosticContext diagnosticContext = context;
            KtSourceElement ktSourceElement2 = supertypeRef.getSource();
            if (ktSourceElement2 == null) {
                ktSourceElement2 = declaration.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement2), isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), (Object)classVisibility, restricting, (Object)relation, (Object)restrictingVisibility, null, (int)128, null);
        }
    }

    private final void checkParameterBounds(DiagnosticReporter reporter, CheckerContext context, FirTypeParameterRefsOwner declaration, EffectiveVisibility visibility2) {
        if (Intrinsics.areEqual((Object)visibility2, (Object)EffectiveVisibility.Local.INSTANCE) || declaration instanceof FirConstructor) {
            return;
        }
        KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> diagnosticForNonInternalBounds = FirExposedVisibilityDeclarationChecker.checkParameterBounds$getDiagnosticByFeature(context, declaration, LanguageFeature.ReportExposedTypeForMoreCasesOfTypeParameterBounds);
        KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> diagnosticForInternalBounds = FirExposedVisibilityDeclarationChecker.checkParameterBounds$getDiagnosticByFeature(context, declaration, LanguageFeature.ReportExposedTypeForInternalTypeParameterBounds);
        for (FirTypeParameterRef parameter : declaration.getTypeParameters()) {
            for (FirResolvedTypeRef bound2 : parameter.getSymbol().getResolvedBounds()) {
                SymbolWithRelation symbolWithRelation = FirExposedVisibilityDeclarationChecker.checkParameterBounds$findVisibilityExposure(bound2, context, visibility2, true);
                if (symbolWithRelation == null || (symbolWithRelation = TuplesKt.to((Object)symbolWithRelation, diagnosticForNonInternalBounds)) == null) {
                    SymbolWithRelation symbolWithRelation2 = FirExposedVisibilityDeclarationChecker.checkParameterBounds$findVisibilityExposure(bound2, context, visibility2, false);
                    if (symbolWithRelation2 == null) continue;
                    symbolWithRelation = TuplesKt.to((Object)symbolWithRelation2, diagnosticForInternalBounds);
                }
                SymbolWithRelation symbolWithRelation3 = symbolWithRelation;
                SymbolWithRelation symbolWithRelation4 = (SymbolWithRelation)symbolWithRelation3.component1();
                KtDiagnosticFactory4 diagnostic = (KtDiagnosticFactory4)symbolWithRelation3.component2();
                FirClassLikeSymbol<?> restricting = symbolWithRelation4.component1();
                EffectiveVisibility restrictingVisibility = symbolWithRelation4.component2();
                RelationToType relation = symbolWithRelation4.component3();
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)bound2.getSource()), (KtDiagnosticFactory4)diagnostic, (Object)visibility2, restricting, (Object)relation, (Object)restrictingVisibility, null, (int)128, null);
            }
        }
    }

    private final void checkTypeAlias(DiagnosticReporter reporter, CheckerContext context, FirTypeAlias declaration) {
        FirResolvedDeclarationStatus typeAliasVisibility;
        ConeClassLikeType expandedType = FirDeclarationUtilKt.getExpandedConeType(declaration);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(typeAliasVisibility = firResolvedDeclarationStatus), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        this.checkParameterBounds(reporter, context, declaration, (EffectiveVisibility)typeAliasVisibility);
        if (expandedType == null || ($i$f$getEffectiveVisibility = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context, expandedType, (EffectiveVisibility)typeAliasVisibility, false, null, 12, null)) == null) {
            return;
        }
        SymbolWithRelation symbolWithRelation = $i$f$getEffectiveVisibility;
        FirClassLikeSymbol<?> restricting = symbolWithRelation.component1();
        EffectiveVisibility restrictingVisibility = symbolWithRelation.component2();
        RelationToType relation = symbolWithRelation.component3();
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), (Object)typeAliasVisibility, restricting, (Object)relation, (Object)restrictingVisibility, null, (int)128, null);
    }

    private final void checkFunction(DiagnosticReporter reporter, CheckerContext context, FirFunction declaration) {
        boolean isNonLocal;
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        FirResolvedDeclarationStatus functionVisibility = null;
        Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = functionVisibility = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (declaration instanceof FirConstructor) {
            FirMemberDeclaration $this$isFromSealedClass$iv = declaration;
            boolean $i$f$isFromSealedClass = false;
            if ($this$isFromSealedClass$iv.getStatus().isFromSealedClass()) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        boolean bl = isNonLocal = !Intrinsics.areEqual((Object)functionVisibility, (Object)EffectiveVisibility.Local.INSTANCE);
        if (!(declaration instanceof FirPropertyAccessor)) {
            SymbolWithRelation symbolWithRelation;
            if (isNonLocal && !(declaration instanceof FirConstructor) && (symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), (EffectiveVisibility)functionVisibility, false, null, 12, null)) != null) {
                SymbolWithRelation symbolWithRelation2 = symbolWithRelation;
                boolean bl2 = false;
                FirClassLikeSymbol<?> restricting = symbolWithRelation2.component1();
                EffectiveVisibility restrictingVisibility = symbolWithRelation2.component2();
                RelationToType relation = symbolWithRelation2.component3();
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), (Object)functionVisibility, restricting, (Object)relation, (Object)restrictingVisibility, null, (int)128, null);
            }
            for (FirValueParameter valueParameter : declaration.getValueParameters()) {
                this.checkExposure(reporter, context, valueParameter, (EffectiveVisibility)functionVisibility);
            }
            for (FirValueParameter valueParameter : declaration.getContextParameters()) {
                this.checkExposure(reporter, context, valueParameter, (EffectiveVisibility)functionVisibility);
            }
        }
        if (isNonLocal) {
            FirReceiverParameter firReceiverParameter = declaration.getReceiverParameter();
            this.checkMemberReceiver(reporter, context, firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration : null);
        }
        this.checkParameterBounds(reporter, context, declaration, (EffectiveVisibility)functionVisibility);
    }

    private final void checkProperty(DiagnosticReporter reporter, CheckerContext context, FirProperty declaration) {
        FirResolvedDeclarationStatus propertyVisibility;
        if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor(declaration), (Object)true)) {
            return;
        }
        if (declaration.isLocal()) {
            return;
        }
        KtSourceElement ktSourceElement = declaration.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(propertyVisibility = firResolvedDeclarationStatus), (Object)EffectiveVisibility.Local.INSTANCE) || Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE)) {
            return;
        }
        SymbolWithRelation symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), (EffectiveVisibility)propertyVisibility, false, null, 12, null);
        if (symbolWithRelation != null) {
            object = symbolWithRelation;
            boolean bl = false;
            FirClassLikeSymbol<?> restricting = ((SymbolWithRelation)object).component1();
            EffectiveVisibility restrictingVisibility = ((SymbolWithRelation)object).component2();
            RelationToType relation = ((SymbolWithRelation)object).component3();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), (Object)propertyVisibility, restricting, (Object)relation, (Object)restrictingVisibility, null, (int)128, null);
        }
        FirReceiverParameter firReceiverParameter = declaration.getReceiverParameter();
        this.checkMemberReceiver(reporter, context, firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration);
        this.checkParameterBounds(reporter, context, declaration, (EffectiveVisibility)propertyVisibility);
        for (FirValueParameter parameter : declaration.getContextParameters()) {
            this.checkExposure(reporter, context, parameter, (EffectiveVisibility)propertyVisibility);
        }
    }

    private final void checkExposure(DiagnosticReporter reporter, CheckerContext context, FirValueParameter $this$checkExposure, EffectiveVisibility declarationVisibility) {
        block7: {
            FirResolvedDeclarationStatus propertyVisibility;
            SymbolWithRelation symbolWithRelation;
            if (!Intrinsics.areEqual((Object)declarationVisibility, (Object)EffectiveVisibility.Local.INSTANCE) && (symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context, FirTypeUtilsKt.getConeType($this$checkExposure.getReturnTypeRef()), declarationVisibility, false, null, 12, null)) != null) {
                SymbolWithRelation symbolWithRelation2 = symbolWithRelation;
                boolean bl = false;
                FirClassLikeSymbol<?> restricting = symbolWithRelation2.component1();
                EffectiveVisibility restrictingVisibility = symbolWithRelation2.component2();
                RelationToType relation = symbolWithRelation2.component3();
                if ($this$checkExposure.getValueParameterKind() == FirValueParameterKind.LegacyContextReceiver) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$checkExposure.getSource()), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), (Object)declarationVisibility, restricting, (Object)relation, (Object)restrictingVisibility, null, (int)128, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$checkExposure.getSource()), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), (Object)declarationVisibility, restricting, (Object)relation, (Object)restrictingVisibility, null, (int)128, null);
                }
                return;
            }
            FirProperty firProperty = ClassMembersKt.getCorrespondingProperty($this$checkExposure);
            if (firProperty == null) {
                return;
            }
            FirProperty property = firProperty;
            if (property.isLocal()) {
                return;
            }
            FirMemberDeclaration $this$effectiveVisibility$iv = property;
            boolean $i$f$getEffectiveVisibility = false;
            Object object = $this$effectiveVisibility$iv.getStatus();
            FirResolvedDeclarationStatus firResolvedDeclarationStatus = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
            if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
                firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)(propertyVisibility = firResolvedDeclarationStatus), (Object)EffectiveVisibility.Local.INSTANCE)) {
                return;
            }
            SymbolWithRelation symbolWithRelation3 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context, FirTypeUtilsKt.getConeType(property.getReturnTypeRef()), (EffectiveVisibility)propertyVisibility, false, null, 12, null);
            if (symbolWithRelation3 == null) break block7;
            object = symbolWithRelation3;
            boolean bl = false;
            FirClassLikeSymbol<?> restricting = ((SymbolWithRelation)object).component1();
            EffectiveVisibility restrictingVisibility = ((SymbolWithRelation)object).component2();
            RelationToType relation = ((SymbolWithRelation)object).component3();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$checkExposure.getSource()), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR_ERROR(), (Object)propertyVisibility, restricting, (Object)relation, (Object)restrictingVisibility, null, (int)128, null);
        }
    }

    private final void checkMemberReceiver(DiagnosticReporter reporter, CheckerContext context, FirTypeRef typeRef, FirCallableDeclaration memberDeclaration) {
        FirResolvedDeclarationStatus memberVisibility;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (firResolvedDeclarationStatus == null || (firResolvedDeclarationStatus = firResolvedDeclarationStatus.getEffectiveVisibility()) == null) {
            firResolvedDeclarationStatus = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(memberVisibility = firResolvedDeclarationStatus), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        SymbolWithRelation symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context, receiverParameterType, (EffectiveVisibility)memberVisibility, false, null, 12, null);
        if (symbolWithRelation == null) {
            return;
        }
        SymbolWithRelation symbolWithRelation2 = symbolWithRelation;
        FirClassLikeSymbol<?> restricting = symbolWithRelation2.component1();
        EffectiveVisibility restrictingVisibility = symbolWithRelation2.component2();
        RelationToType relation = symbolWithRelation2.component3();
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)typeRef.getSource()), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), (Object)memberVisibility, restricting, (Object)relation, (Object)restrictingVisibility, null, (int)128, null);
    }

    private final SymbolWithRelation findVisibilityExposure(CheckerContext context, ConeKotlinType $this$findVisibilityExposure, EffectiveVisibility base, boolean ignoreInternalExposure, Set<ConeKotlinType> visitedTypes) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        FirClassLikeSymbol<?> $this$effectiveVisibility$iv;
        Object object;
        ConeClassLikeType coneClassLikeType;
        if (!visitedTypes.add($this$findVisibilityExposure)) {
            return null;
        }
        ConeKotlinType coneKotlinType = $this$findVisibilityExposure;
        if (coneKotlinType instanceof ConeClassLikeType) {
            coneClassLikeType = (ConeClassLikeType)$this$findVisibilityExposure;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = ((ConeFlexibleType)$this$findVisibilityExposure).getLowerBound();
            coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if (coneClassLikeType == null) {
                return null;
            }
        } else {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context, type2).getLookupTag(), context.getSession());
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        object = classSymbol;
        if (object instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else if (object instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (ignoreInternalExposure && Intrinsics.areEqual((Object)effectiveVisibility, (Object)EffectiveVisibility.Internal.INSTANCE)) {
            return null;
        }
        if (effectiveVisibility != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[effectiveVisibility.relation(base, (TypeCheckerProviderContext)TypeComponentsKt.getTypeContext(context.getSession())).ordinal()]) {
                case 1: 
                case 2: {
                    return this.symbolWithRelation(classSymbol, effectiveVisibility, visitedTypes.size() > 1);
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        object = type2.getTypeArguments();
        int n = ((ConeTypeProjection[])object).length;
        for (int j = 0; j < n; ++j) {
            Object it;
            Object object2;
            int index2 = j;
            ConeTypeProjection it2 = object[j];
            ConeTypeProjection coneTypeProjection = it2;
            if (coneTypeProjection instanceof ConeClassLikeType) {
                object2 = this.findVisibilityExposure(context, (ConeKotlinType)it2, base, ignoreInternalExposure, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
                object2 = this.findVisibilityExposure(context, ((ConeKotlinTypeProjection)it2).getType(), base, ignoreInternalExposure, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeStarProjection) {
                Object object3;
                block22: {
                    Object object4;
                    List<FirResolvedTypeRef> list2;
                    FirTypeParameterSymbol firTypeParameterSymbol;
                    List<FirTypeParameterSymbol> list3;
                    object2 = ToSymbolUtilsKt.toRegularClassSymbol(type2, context.getSession());
                    if (object2 == null || (list3 = ((FirClassLikeSymbol)object2).getTypeParameterSymbols()) == null || (firTypeParameterSymbol = (FirTypeParameterSymbol)CollectionsKt.getOrNull(list3, (int)index2)) == null || (list2 = firTypeParameterSymbol.getResolvedBounds()) == null) continue;
                    for (Object it3 : (Iterable)list2) {
                        boolean bl = false;
                        if ((it3 = INSTANCE.findVisibilityExposure(context, ((FirResolvedTypeRef)it3).getConeType(), base, ignoreInternalExposure, visitedTypes)) == null) continue;
                        object4 = it3;
                        break block22;
                    }
                    object4 = object3 = null;
                }
                if (object3 == null) continue;
                Object it4 = object3;
                boolean bl = false;
                return it4;
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    static /* synthetic */ SymbolWithRelation findVisibilityExposure$default(FirExposedVisibilityDeclarationChecker firExposedVisibilityDeclarationChecker, CheckerContext checkerContext, ConeKotlinType coneKotlinType, EffectiveVisibility effectiveVisibility, boolean bl, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            set = new LinkedHashSet();
        }
        return firExposedVisibilityDeclarationChecker.findVisibilityExposure(checkerContext, coneKotlinType, effectiveVisibility, bl, set);
    }

    private final SymbolWithRelation symbolWithRelation(FirClassLikeSymbol<?> symbol, EffectiveVisibility effectiveVisibility, boolean fromTypeArgument) {
        Visibility visibility2 = effectiveVisibility.toVisibility();
        FirClassLikeSymbol<?> $this$visibility$iv = symbol;
        boolean $i$f$getVisibility = false;
        Visibility lowestVisibility = $this$visibility$iv.getResolvedStatus().getVisibility();
        FirClassLikeSymbol<?> lowestRepresentative = symbol;
        FirClassLikeSymbol<?> currentSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)symbol);
        while (currentSymbol != null && !Intrinsics.areEqual((Object)lowestVisibility, (Object)visibility2)) {
            Visibility visibility3;
            FirClassLikeSymbol<?> $this$visibility$iv2 = currentSymbol;
            boolean $i$f$getVisibility2 = false;
            Integer compareResult = $this$visibility$iv2.getResolvedStatus().getVisibility().compareTo(lowestVisibility);
            if (compareResult != null && compareResult < 0) {
                lowestRepresentative = currentSymbol;
                $this$visibility$iv2 = currentSymbol;
                $i$f$getVisibility2 = false;
                visibility3 = $this$visibility$iv2.getResolvedStatus().getVisibility();
            } else {
                visibility3 = lowestVisibility;
            }
            lowestVisibility = visibility3;
            currentSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)currentSymbol);
        }
        RelationToType defaultRelation = fromTypeArgument ? RelationToType.ARGUMENT : RelationToType.CONSTRUCTOR;
        return new SymbolWithRelation(lowestRepresentative, effectiveVisibility, lowestRepresentative != symbol ? defaultRelation.containerRelation() : defaultRelation);
    }

    private static final KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> checkParameterBounds$getDiagnosticByFeature(CheckerContext $context, FirTypeParameterRefsOwner $declaration, LanguageFeature feature) {
        boolean reportProperError = $context.getLanguageVersionSettings().supportsFeature(feature);
        return reportProperError || $declaration instanceof FirRegularClass ? FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND() : FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND_DEPRECATION_WARNING();
    }

    private static final SymbolWithRelation checkParameterBounds$findVisibilityExposure(FirResolvedTypeRef $this$checkParameterBounds_u24findVisibilityExposure, CheckerContext $context, EffectiveVisibility $visibility, boolean ignoreInternalExposure) {
        return FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(INSTANCE, $context, $this$checkParameterBounds_u24findVisibilityExposure.getConeType(), $visibility, ignoreInternalExposure, null, 8, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u0013\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker$SymbolWithRelation;", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "visibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "relation", "Lorg/jetbrains/kotlin/descriptors/RelationToType;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/RelationToType;)V", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "getRelation", "()Lorg/jetbrains/kotlin/descriptors/RelationToType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    private static final class SymbolWithRelation {
        @NotNull
        private final FirClassLikeSymbol<?> symbol;
        @NotNull
        private final EffectiveVisibility visibility;
        @NotNull
        private final RelationToType relation;

        public SymbolWithRelation(@NotNull FirClassLikeSymbol<?> symbol, @NotNull EffectiveVisibility visibility2, @NotNull RelationToType relation) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
            Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
            this.symbol = symbol;
            this.visibility = visibility2;
            this.relation = relation;
        }

        @NotNull
        public final FirClassLikeSymbol<?> getSymbol() {
            return this.symbol;
        }

        @NotNull
        public final EffectiveVisibility getVisibility() {
            return this.visibility;
        }

        @NotNull
        public final RelationToType getRelation() {
            return this.relation;
        }

        @NotNull
        public final FirClassLikeSymbol<?> component1() {
            return this.symbol;
        }

        @NotNull
        public final EffectiveVisibility component2() {
            return this.visibility;
        }

        @NotNull
        public final RelationToType component3() {
            return this.relation;
        }

        @NotNull
        public final SymbolWithRelation copy(@NotNull FirClassLikeSymbol<?> symbol, @NotNull EffectiveVisibility visibility2, @NotNull RelationToType relation) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
            Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
            return new SymbolWithRelation(symbol, visibility2, relation);
        }

        public static /* synthetic */ SymbolWithRelation copy$default(SymbolWithRelation symbolWithRelation, FirClassLikeSymbol firClassLikeSymbol, EffectiveVisibility effectiveVisibility, RelationToType relationToType, int n, Object object) {
            if ((n & 1) != 0) {
                firClassLikeSymbol = symbolWithRelation.symbol;
            }
            if ((n & 2) != 0) {
                effectiveVisibility = symbolWithRelation.visibility;
            }
            if ((n & 4) != 0) {
                relationToType = symbolWithRelation.relation;
            }
            return symbolWithRelation.copy(firClassLikeSymbol, effectiveVisibility, relationToType);
        }

        @NotNull
        public String toString() {
            return "SymbolWithRelation(symbol=" + this.symbol + ", visibility=" + this.visibility + ", relation=" + this.relation + ')';
        }

        public int hashCode() {
            int result2 = this.symbol.hashCode();
            result2 = result2 * 31 + this.visibility.hashCode();
            result2 = result2 * 31 + this.relation.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SymbolWithRelation)) {
                return false;
            }
            SymbolWithRelation symbolWithRelation = (SymbolWithRelation)other;
            if (!Intrinsics.areEqual(this.symbol, symbolWithRelation.symbol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.visibility, (Object)symbolWithRelation.visibility)) {
                return false;
            }
            return this.relation == symbolWithRelation.relation;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            try {
                nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.SAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.MORE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

