/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/JvmClassNameExternalizer;", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "<init>", "()V", "save", "", "output", "Ljava/io/DataOutput;", "jvmClassName", "read", "input", "Ljava/io/DataInput;", "kotlin-build-common"})
public final class JvmClassNameExternalizer
implements DataExternalizer<JvmClassName> {
    @NotNull
    public static final JvmClassNameExternalizer INSTANCE = new JvmClassNameExternalizer();

    private JvmClassNameExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput output2, @NotNull JvmClassName jvmClassName) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Intrinsics.checkNotNullParameter((Object)jvmClassName, (String)"jvmClassName");
        String string = jvmClassName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        ExternalizersKt.writeString(output2, string);
    }

    @Override
    @NotNull
    public JvmClassName read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        JvmClassName jvmClassName = JvmClassName.byInternalName(ExternalizersKt.readString(input));
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
        return jvmClassName;
    }
}

