/*
 * Decompiled with CFR 0.152.
 */
package jaxp;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.TypeInfo;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class TypeInfoWriter
extends DefaultHandler {
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String DEFAULT_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    protected static final String XSD11_SCHEMA_LANGUAGE = "http://www.w3.org/XML/XMLSchema/v1.1";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected TypeInfoProvider fTypeInfoProvider;
    protected PrintWriter fOut;
    protected int fIndent;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.fIndent = 0;
        this.printIndent();
        this.fOut.print("setDocumentLocator(");
        this.fOut.print("systemId=");
        this.printQuotedString(locator.getSystemId());
        this.fOut.print(", publicId=");
        this.printQuotedString(locator.getPublicId());
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void startDocument() throws SAXException {
        this.fIndent = 0;
        this.printIndent();
        this.fOut.println("startDocument()");
        this.fOut.flush();
        ++this.fIndent;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        TypeInfo typeInfo;
        this.printIndent();
        this.fOut.print("startElement(");
        this.fOut.print("name=");
        this.printQName(string, string2);
        this.fOut.print(',');
        this.fOut.print("type=");
        if (this.fTypeInfoProvider != null && (typeInfo = this.fTypeInfoProvider.getElementTypeInfo()) != null) {
            this.printQName(typeInfo.getTypeNamespace(), typeInfo.getTypeName());
        } else {
            this.fOut.print("null");
        }
        this.fOut.print(',');
        this.fOut.print("attributes=");
        if (attributes == null) {
            this.fOut.println("null");
        } else {
            this.fOut.print('{');
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.fOut.print(',');
                }
                String string4 = attributes.getURI(i);
                String string5 = attributes.getLocalName(i);
                this.fOut.print('{');
                this.fOut.print("name=");
                this.printQName(string4, string5);
                this.fOut.print(',');
                this.fOut.print("type=");
                if (this.fTypeInfoProvider != null && (typeInfo = this.fTypeInfoProvider.getAttributeTypeInfo(i)) != null) {
                    this.printQName(typeInfo.getTypeNamespace(), typeInfo.getTypeName());
                } else {
                    this.fOut.print("null");
                }
                this.fOut.print(',');
                this.fOut.print("id=");
                this.fOut.print(this.fTypeInfoProvider != null && this.fTypeInfoProvider.isIdAttribute(i) ? "\"true\"" : "\"false\"");
                this.fOut.print(',');
                this.fOut.print("specified=");
                this.fOut.print(this.fTypeInfoProvider == null || this.fTypeInfoProvider.isSpecified(i) ? "\"true\"" : "\"false\"");
                this.fOut.print('}');
            }
            this.fOut.print('}');
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endElement(");
        this.fOut.print("name=");
        this.printQName(string, string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void endDocument() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endDocument()");
        this.fOut.flush();
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    protected void setTypeInfoProvider(TypeInfoProvider typeInfoProvider) {
        this.fTypeInfoProvider = typeInfoProvider;
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected void printIndent() {
        for (int i = 0; i < this.fIndent; ++i) {
            this.fOut.print(' ');
        }
    }

    protected void printQName(String string, String string2) {
        if (string != null && string.length() > 0) {
            this.printQuotedString('{' + string + "}" + string2);
            return;
        }
        this.printQuotedString(string2);
    }

    protected void printQuotedString(String string) {
        if (string == null) {
            this.fOut.print("null");
            return;
        }
        this.fOut.print('\"');
        this.fOut.print(string);
        this.fOut.print('\"');
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        if (stringArray.length == 0) {
            TypeInfoWriter.printUsage();
            System.exit(1);
        }
        XMLReader xMLReader = null;
        Vector<Object> vector = null;
        Vector<Object> vector2 = null;
        String string = DEFAULT_SCHEMA_LANGUAGE;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = stringArray[i];
            if (!((String)object2).startsWith("-")) continue;
            object = ((String)object2).substring(1);
            if (((String)object).equals("l")) {
                if (++i == stringArray.length) {
                    System.err.println("error: Missing argument to -l option.");
                    continue;
                }
                string = stringArray[i];
                continue;
            }
            if (((String)object).equals("xsd11")) {
                string = XSD11_SCHEMA_LANGUAGE;
                continue;
            }
            if (((String)object).equals("p")) {
                if (++i == stringArray.length) {
                    System.err.println("error: Missing argument to -p option.");
                    continue;
                }
                String string2 = stringArray[i];
                try {
                    xMLReader = XMLReaderFactory.createXMLReader(string2);
                }
                catch (Exception exception) {
                    try {
                        Parser parser = ParserFactory.makeParser(string2);
                        xMLReader = new ParserAdapter(parser);
                        System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                    }
                    catch (Exception exception2) {
                        xMLReader = null;
                        System.err.println("error: Unable to instantiate parser (" + string2 + ")");
                        exception.printStackTrace(System.err);
                        System.exit(1);
                    }
                }
                continue;
            }
            if (((String)object2).equals("-a")) {
                if (vector == null) {
                    vector = new Vector<Object>();
                }
                while (i + 1 < stringArray.length && !((String)(object2 = stringArray[i + 1])).startsWith("-")) {
                    vector.add(object2);
                    ++i;
                }
                continue;
            }
            if (((String)object2).equals("-i")) {
                if (vector2 == null) {
                    vector2 = new Vector<Object>();
                }
                while (i + 1 < stringArray.length && !((String)(object2 = stringArray[i + 1])).startsWith("-")) {
                    vector2.add(object2);
                    ++i;
                }
                continue;
            }
            if (((String)object).equalsIgnoreCase("f")) {
                bl = ((String)object).equals("f");
                continue;
            }
            if (((String)object).equalsIgnoreCase("hs")) {
                bl2 = ((String)object).equals("hs");
                continue;
            }
            if (((String)object).equalsIgnoreCase("va")) {
                bl3 = ((String)object).equals("va");
                continue;
            }
            if (((String)object).equalsIgnoreCase("ga")) {
                bl4 = ((String)object).equals("ga");
                continue;
            }
            if (((String)object).equals("h")) {
                TypeInfoWriter.printUsage();
                continue;
            }
            System.err.println("error: unknown option (" + (String)object + ").");
        }
        if (xMLReader == null) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
            }
            catch (Exception exception) {
                System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                exception.printStackTrace(System.err);
                System.exit(1);
            }
        }
        try {
            TypeInfoWriter typeInfoWriter = new TypeInfoWriter();
            typeInfoWriter.setOutput(System.out, "UTF8");
            object2 = SchemaFactory.newInstance(string);
            ((SchemaFactory)object2).setErrorHandler(typeInfoWriter);
            try {
                ((SchemaFactory)object2).setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                ((SchemaFactory)object2).setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                ((SchemaFactory)object2).setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validate-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                ((SchemaFactory)object2).setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            if (vector != null && vector.size() > 0) {
                int n = vector.size();
                Source[] sourceArray = new StreamSource[n];
                for (int i = 0; i < n; ++i) {
                    sourceArray[i] = new StreamSource((String)vector.elementAt(i));
                }
                object = ((SchemaFactory)object2).newSchema(sourceArray);
            } else {
                object = ((SchemaFactory)object2).newSchema();
            }
            ValidatorHandler validatorHandler = ((Schema)object).newValidatorHandler();
            xMLReader.setContentHandler(validatorHandler);
            if (validatorHandler instanceof DTDHandler) {
                xMLReader.setDTDHandler((DTDHandler)((Object)validatorHandler));
            }
            xMLReader.setErrorHandler(typeInfoWriter);
            validatorHandler.setContentHandler(typeInfoWriter);
            validatorHandler.setErrorHandler(typeInfoWriter);
            typeInfoWriter.setTypeInfoProvider(validatorHandler.getTypeInfoProvider());
            try {
                validatorHandler.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                validatorHandler.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                validatorHandler.setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validate-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                validatorHandler.setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            if (vector2 != null && vector2.size() > 0) {
                int n = vector2.size();
                for (int i = 0; i < n; ++i) {
                    xMLReader.parse((String)vector2.elementAt(i));
                }
            }
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            Object object3;
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            if (exception instanceof SAXException && (object2 = ((SAXException)exception).getException()) != null) {
                object3 = object2;
            }
            ((Throwable)object3).printStackTrace(System.err);
        }
    }

    private static void printUsage() {
        System.err.println("usage: java jaxp.TypeInfoWriter (options) ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -l name     Select schema language by name.");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -a uri ...  Provide a list of schema documents");
        System.err.println("  -i uri ...  Provide a list of instance documents to validate");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -ga | -GA   Turn on/off generation of synthetic schema annotations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -xsd11      Turn on XSD 1.1 support.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Schema language:                 http://www.w3.org/2001/XMLSchema");
        System.err.println("  Parser:                          org.apache.xerces.parsers.SAXParser");
        System.err.print("  Schema full checking:            ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Validate annotations:            ");
        System.err.println("off");
        System.err.print("  Generate synthetic annotations:  ");
        System.err.println("off");
    }
}

