/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnData;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;

public class FnNumber
extends Function {
    public FnNumber() {
        super(new QName("number"), 0, 1);
    }

    @Override
    public ResultSequence evaluate(Collection args) throws DynamicError {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        ResultSequence argument = null;
        argument = args.isEmpty() ? FnNumber.getResultSetForArityZero(this.dynamic_context()) : (ResultSequence)args.iterator().next();
        ResultSequence rs = ResultSequenceFactory.create_new();
        rs.add(FnNumber.fn_number(argument, this.dynamic_context()));
        return rs;
    }

    public static XSDouble fn_number(ResultSequence arg, DynamicContext dc) throws DynamicError {
        if (arg.size() > 1) {
            throw new DynamicError(TypeError.invalid_type("bad argument passed to fn:number()"));
        }
        if (arg.size() == 1) {
            AnyType at = arg.first();
            if (at instanceof AnyAtomicType) {
                if (at instanceof XSDouble) {
                    return (XSDouble)at;
                }
                if (at instanceof XSFloat) {
                    float value = ((XSFloat)at).float_value();
                    if (Float.isNaN(value)) {
                        return new XSDouble(Double.NaN);
                    }
                    if (value == Float.NEGATIVE_INFINITY) {
                        return new XSDouble(Double.NEGATIVE_INFINITY);
                    }
                    if (value == Float.POSITIVE_INFINITY) {
                        return new XSDouble(Double.POSITIVE_INFINITY);
                    }
                    return new XSDouble(value);
                }
                XSDouble d = XSDouble.parse_double(at.string_value());
                return d != null ? d : new XSDouble(Double.NaN);
            }
            if (at instanceof NodeType) {
                XSDouble d = XSDouble.parse_double(FnData.atomize(at).string_value());
                return d != null ? d : new XSDouble(Double.NaN);
            }
        } else {
            return new XSDouble(Double.NaN);
        }
        return null;
    }
}

