/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.Generating;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;

public abstract class ReducingBarrierStep<S, E>
extends AbstractStep<S, E>
implements Barrier<E>,
Generating<E, E> {
    public static final Object NON_EMITTING_SEED = NonEmittingSeed.INSTANCE;
    protected Supplier<E> seedSupplier = null;
    protected BinaryOperator<E> reducingBiOperator;
    protected boolean hasProcessedOnce = false;
    private E seed = NON_EMITTING_SEED;

    public ReducingBarrierStep(Traversal.Admin traversal) {
        super(traversal);
    }

    public void setSeedSupplier(Supplier<E> seedSupplier) {
        this.seedSupplier = seedSupplier;
    }

    public Supplier<E> getSeedSupplier() {
        return Optional.ofNullable(this.seedSupplier).orElse(this::generateSeedFromStarts);
    }

    protected E generateSeedFromStarts() {
        return this.starts.hasNext() ? (E)this.projectTraverser((Traverser.Admin<S>)this.starts.next()) : null;
    }

    public abstract E projectTraverser(Traverser.Admin<S> var1);

    public void setReducingBiOperator(BinaryOperator<E> reducingBiOperator) {
        this.reducingBiOperator = reducingBiOperator;
    }

    public BinaryOperator<E> getBiOperator() {
        return this.reducingBiOperator;
    }

    @Override
    public void reset() {
        super.reset();
        this.hasProcessedOnce = false;
        this.seed = NON_EMITTING_SEED;
    }

    @Override
    public void done() {
        this.hasProcessedOnce = true;
        this.seed = NON_EMITTING_SEED;
    }

    @Override
    public void processAllStarts() {
        if (this.hasProcessedOnce && !this.starts.hasNext()) {
            return;
        }
        this.hasProcessedOnce = true;
        if (this.seed == NON_EMITTING_SEED) {
            this.seed = this.getSeedSupplier().get();
        }
        while (this.starts.hasNext()) {
            this.seed = this.reducingBiOperator.apply(this.seed, this.projectTraverser((Traverser.Admin<S>)this.starts.next()));
        }
    }

    @Override
    public boolean hasNextBarrier() {
        this.processAllStarts();
        return NON_EMITTING_SEED != this.seed;
    }

    @Override
    public E nextBarrier() {
        if (!this.hasNextBarrier()) {
            throw FastNoSuchElementException.instance();
        }
        E temp = this.seed;
        this.seed = NON_EMITTING_SEED;
        return temp;
    }

    @Override
    public void addBarrier(E barrier) {
        this.seed = NON_EMITTING_SEED == this.seed ? barrier : this.reducingBiOperator.apply(this.seed, barrier);
    }

    @Override
    public Traverser.Admin<E> processNextStart() {
        this.processAllStarts();
        if (this.seed == NON_EMITTING_SEED) {
            throw FastNoSuchElementException.instance();
        }
        Traverser.Admin traverser = this.getTraversal().getTraverserGenerator().generate(this.generateFinalResult(this.seed), this, 1L);
        this.seed = NON_EMITTING_SEED;
        return traverser;
    }

    @Override
    public ReducingBarrierStep<S, E> clone() {
        ReducingBarrierStep clone = (ReducingBarrierStep)super.clone();
        clone.hasProcessedOnce = false;
        clone.seed = NON_EMITTING_SEED;
        return clone;
    }

    @Override
    public MemoryComputeKey<E> getMemoryComputeKey() {
        return MemoryComputeKey.of(this.getId(), this.getBiOperator(), false, true);
    }

    public static final class NonEmittingSeed
    implements Serializable {
        public static final NonEmittingSeed INSTANCE = new NonEmittingSeed();

        private NonEmittingSeed() {
        }
    }
}

