/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.io.NonSyncByteArrayOutputStream;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.ATSData;
import org.apache.tez.history.parser.datamodel.BaseParser;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.TaskInfo;
import org.apache.tez.history.parser.datamodel.VersionInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ATSFileParser
extends BaseParser
implements ATSData {
    private static final Logger LOG = LoggerFactory.getLogger(ATSFileParser.class);
    private final File atsZipFile;

    public ATSFileParser(File atsZipFile) throws TezException {
        Preconditions.checkArgument((boolean)atsZipFile.exists(), (Object)("Zipfile " + atsZipFile + " does not exist"));
        this.atsZipFile = atsZipFile;
    }

    @Override
    public DagInfo getDAGData(String dagId) throws TezException {
        try {
            this.parseATSZipFile(this.atsZipFile);
            this.linkParsedContents();
            return this.dagInfo;
        }
        catch (IOException e) {
            LOG.error("Error in reading DAG ", (Throwable)e);
            throw new TezException((Throwable)e);
        }
        catch (JSONException e) {
            LOG.error("Error in parsing DAG ", (Throwable)e);
            throw new TezException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TezException((Throwable)e);
        }
    }

    private void processVertices(JSONArray verticesJson) throws JSONException {
        Preconditions.checkState((verticesJson != null ? 1 : 0) != 0, (Object)"Vertex json can not be null");
        if (verticesJson != null) {
            LOG.debug("Started parsing vertex");
            for (int i = 0; i < verticesJson.length(); ++i) {
                VertexInfo vertexInfo = VertexInfo.create(verticesJson.getJSONObject(i));
                this.vertexList.add(vertexInfo);
            }
            LOG.debug("Finished parsing vertex");
        }
    }

    private void processTasks(JSONArray tasksJson) throws JSONException {
        Preconditions.checkState((tasksJson != null ? 1 : 0) != 0, (Object)"Task json can not be null");
        if (tasksJson != null) {
            LOG.debug("Started parsing task");
            for (int i = 0; i < tasksJson.length(); ++i) {
                TaskInfo taskInfo = TaskInfo.create(tasksJson.getJSONObject(i));
                this.taskList.add(taskInfo);
            }
            LOG.debug("Finished parsing task");
        }
    }

    private void processAttempts(JSONArray taskAttemptsJson) throws JSONException {
        Preconditions.checkState((taskAttemptsJson != null ? 1 : 0) != 0, (Object)"Attempts json can not be null");
        if (taskAttemptsJson != null) {
            LOG.debug("Started parsing task attempts");
            for (int i = 0; i < taskAttemptsJson.length(); ++i) {
                TaskAttemptInfo attemptInfo = TaskAttemptInfo.create(taskAttemptsJson.getJSONObject(i));
                this.attemptList.add(attemptInfo);
            }
            LOG.debug("Finished parsing task attempts");
        }
    }

    private void processApplication(JSONObject tezApplicationJson) throws JSONException {
        if (tezApplicationJson != null) {
            LOG.debug("Started parsing tez application");
            JSONObject otherInfoNode = tezApplicationJson.optJSONObject("otherinfo");
            if (otherInfoNode != null) {
                JSONObject tezVersion = otherInfoNode.optJSONObject("tezVersion");
                if (tezVersion != null) {
                    String version = tezVersion.optString("version");
                    String buildTime = tezVersion.optString("buildTime");
                    String revision = tezVersion.optString("revision");
                    this.versionInfo = new VersionInfo(version, revision, buildTime);
                }
                this.config = Maps.newHashMap();
                JSONObject configNode = otherInfoNode.getJSONObject("config");
                Iterator it = configNode.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = configNode.getString(key);
                    this.config.put(key, value);
                }
            }
            LOG.debug("Finished parsing tez application");
        }
    }

    private JSONObject readJson(InputStream in) throws IOException, JSONException {
        NonSyncByteArrayOutputStream bout = new NonSyncByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bout);
        return new JSONObject(new String(bout.toByteArray(), "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseATSZipFile(File atsFile) throws IOException, JSONException, TezException, InterruptedException {
        try (ZipFile atsZipFile = new ZipFile(atsFile);){
            Enumeration<? extends ZipEntry> zipEntries = atsZipFile.entries();
            while (zipEntries.hasMoreElements()) {
                JSONObject tezAppJson;
                JSONArray attemptsJson;
                JSONArray taskJson;
                JSONArray vertexJson;
                ZipEntry zipEntry = zipEntries.nextElement();
                LOG.debug("Processing " + zipEntry.getName());
                InputStream inputStream = atsZipFile.getInputStream(zipEntry);
                JSONObject jsonObject = this.readJson(inputStream);
                JSONObject dagJson = jsonObject.optJSONObject("dag");
                if (dagJson != null) {
                    this.dagInfo = DagInfo.create(dagJson);
                }
                if ((vertexJson = jsonObject.optJSONArray("vertices")) != null) {
                    this.processVertices(vertexJson);
                }
                if ((taskJson = jsonObject.optJSONArray("tasks")) != null) {
                    this.processTasks(taskJson);
                }
                if ((attemptsJson = jsonObject.optJSONArray("task_attempts")) != null) {
                    this.processAttempts(attemptsJson);
                }
                if ((tezAppJson = jsonObject.optJSONObject("application")) == null) continue;
                this.processApplication(tezAppJson);
            }
        }
    }
}

