/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser.datamodel;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.history.parser.datamodel.AdditionalInputOutputDetails;
import org.apache.tez.history.parser.datamodel.BaseInfo;
import org.apache.tez.history.parser.datamodel.Container;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.EdgeInfo;
import org.apache.tez.history.parser.datamodel.Event;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.TaskInfo;
import org.apache.tez.util.StringInterner;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class VertexInfo
extends BaseInfo {
    private static final Log LOG = LogFactory.getLog(VertexInfo.class);
    private final String vertexId;
    private final String vertexName;
    private final long finishTime;
    private final long initTime;
    private final long initRequestedTime;
    private final long startTime;
    private final long startRequestedTime;
    private final String diagnostics;
    private final String processorClass;
    private final int numTasks;
    private final int failedTasks;
    private final int completedTasks;
    private final int succeededTasks;
    private final int killedTasks;
    private final int numFailedTaskAttempts;
    private final String status;
    private Map<String, TaskInfo> taskInfoMap;
    private final List<EdgeInfo> inEdgeList;
    private final List<EdgeInfo> outEdgeList;
    private final List<AdditionalInputOutputDetails> additionalInputInfoList;
    private final List<AdditionalInputOutputDetails> additionalOutputInfoList;
    private long avgPostDataExecutionTimeInterval = -1L;
    private DagInfo dagInfo;

    VertexInfo(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        Preconditions.checkArgument((boolean)jsonObject.getString("entitytype").equalsIgnoreCase("TEZ_VERTEX_ID"));
        this.vertexId = StringInterner.intern((String)jsonObject.optString("entity"));
        this.taskInfoMap = Maps.newHashMap();
        this.inEdgeList = Lists.newLinkedList();
        this.outEdgeList = Lists.newLinkedList();
        this.additionalInputInfoList = Lists.newLinkedList();
        this.additionalOutputInfoList = Lists.newLinkedList();
        JSONObject otherInfoNode = jsonObject.getJSONObject("otherinfo");
        this.initRequestedTime = otherInfoNode.optLong("initRequestedTime");
        this.startRequestedTime = otherInfoNode.optLong("startRequestedTime");
        long sTime = otherInfoNode.optLong("startTime");
        long iTime = otherInfoNode.optLong("initTime");
        long eTime = otherInfoNode.optLong("endTime");
        if (eTime < sTime) {
            LOG.warn((Object)("Vertex has got wrong start/end values. startTime=" + sTime + ", endTime=" + eTime + ". Will check timestamps in DAG started/finished events"));
            for (Event event : this.eventList) {
                switch (HistoryEventType.valueOf((String)event.getType())) {
                    case VERTEX_INITIALIZED: {
                        iTime = event.getAbsoluteTime();
                        break;
                    }
                    case VERTEX_STARTED: {
                        sTime = event.getAbsoluteTime();
                        break;
                    }
                    case VERTEX_FINISHED: {
                        eTime = event.getAbsoluteTime();
                        break;
                    }
                }
            }
            if (eTime < sTime) {
                LOG.warn((Object)("Vertex has got wrong start/end values in events as well. startTime=" + sTime + ", endTime=" + eTime));
            }
        }
        this.startTime = sTime;
        this.finishTime = eTime;
        this.initTime = iTime;
        this.diagnostics = otherInfoNode.optString("diagnostics");
        this.numTasks = otherInfoNode.optInt("numTasks");
        this.failedTasks = otherInfoNode.optInt("numFailedTasks");
        this.succeededTasks = otherInfoNode.optInt("numSucceededTasks");
        this.completedTasks = otherInfoNode.optInt("numCompletedTasks");
        this.killedTasks = otherInfoNode.optInt("numKilledTasks");
        this.numFailedTaskAttempts = otherInfoNode.optInt("numFailedTaskAttempts");
        this.vertexName = StringInterner.intern((String)otherInfoNode.optString("vertexName"));
        this.processorClass = StringInterner.intern((String)otherInfoNode.optString("processorClassName"));
        this.status = StringInterner.intern((String)otherInfoNode.optString("status"));
    }

    public static VertexInfo create(JSONObject vertexInfoObject) throws JSONException {
        return new VertexInfo(vertexInfoObject);
    }

    private void updateEdgeInfo() {
        if (this.dagInfo.getNumVertices() == this.dagInfo.getVertices().size()) {
            Map<String, VertexInfo> vertexMapping = this.dagInfo.getVertexMapping();
            for (EdgeInfo edge : this.dagInfo.getEdges()) {
                VertexInfo sourceVertex = vertexMapping.get(edge.getInputVertexName());
                VertexInfo destinationVertex = vertexMapping.get(edge.getOutputVertexName());
                edge.setSourceVertex(sourceVertex);
                edge.setDestinationVertex(destinationVertex);
            }
        }
    }

    void addTaskInfo(TaskInfo taskInfo) {
        this.taskInfoMap.put(taskInfo.getTaskId(), taskInfo);
    }

    void setAdditionalInputInfoList(List<AdditionalInputOutputDetails> additionalInputInfoList) {
        this.additionalInputInfoList.clear();
        this.additionalInputInfoList.addAll(additionalInputInfoList);
    }

    void setAdditionalOutputInfoList(List<AdditionalInputOutputDetails> additionalOutputInfoList) {
        this.additionalOutputInfoList.clear();
        this.additionalOutputInfoList.addAll(additionalOutputInfoList);
    }

    void addInEdge(EdgeInfo edgeInfo) {
        this.inEdgeList.add(edgeInfo);
    }

    void addOutEdge(EdgeInfo edgeInfo) {
        this.outEdgeList.add(edgeInfo);
    }

    void setDagInfo(DagInfo dagInfo) {
        this.dagInfo = Objects.requireNonNull(dagInfo, "Provide valid dagInfo");
        dagInfo.addVertexInfo(this);
        this.updateEdgeInfo();
    }

    public List<AdditionalInputOutputDetails> getAdditionalInputInfoList() {
        return Collections.unmodifiableList(this.additionalInputInfoList);
    }

    public List<AdditionalInputOutputDetails> getAdditionalOutputInfoList() {
        return Collections.unmodifiableList(this.additionalOutputInfoList);
    }

    @Override
    public final long getStartTimeInterval() {
        return this.startTime - this.dagInfo.getStartTime();
    }

    public final long getFirstTaskStartTimeInterval() {
        TaskInfo firstTask = this.getFirstTaskToStart();
        if (firstTask == null) {
            return 0L;
        }
        return firstTask.getStartTimeInterval();
    }

    public final long getLastTaskFinishTimeInterval() {
        if (this.getLastTaskToFinish() == null || this.getLastTaskToFinish().getFinishTimeInterval() < 0L) {
            return this.dagInfo.getFinishTimeInterval();
        }
        return this.getLastTaskToFinish().getFinishTimeInterval();
    }

    public final long getAvgPostDataExecutionTimeInterval() {
        if (this.avgPostDataExecutionTimeInterval == -1L) {
            long totalExecutionTime = 0L;
            long totalAttempts = 0L;
            for (TaskInfo task : this.getTasks()) {
                long execTime;
                TaskAttemptInfo attempt = task.getSuccessfulTaskAttempt();
                if (attempt == null || (execTime = attempt.getPostDataExecutionTimeInterval()) < 0L) continue;
                totalExecutionTime += execTime;
                ++totalAttempts;
            }
            if (totalAttempts > 0L) {
                this.avgPostDataExecutionTimeInterval = Math.round((double)totalExecutionTime * 1.0 / (double)totalAttempts);
            }
        }
        return this.avgPostDataExecutionTimeInterval;
    }

    @Override
    public final long getStartTime() {
        return this.startTime;
    }

    @Override
    public final long getFinishTime() {
        return this.finishTime;
    }

    public final long getInitTime() {
        return this.initTime;
    }

    public final long getInitRequestedTime() {
        return this.initRequestedTime;
    }

    public final long getStartRequestedTime() {
        return this.startRequestedTime;
    }

    @Override
    public final long getFinishTimeInterval() {
        long vertexEndTime = this.finishTime - this.dagInfo.getStartTime();
        if (vertexEndTime < 0L) {
            for (TaskInfo taskInfo : this.getTasks()) {
                vertexEndTime = taskInfo.getFinishTimeInterval() > vertexEndTime ? taskInfo.getFinishTimeInterval() : vertexEndTime;
            }
        }
        return vertexEndTime;
    }

    @Override
    public final String getDiagnostics() {
        return this.diagnostics;
    }

    public final String getVertexName() {
        return this.vertexName;
    }

    public final String getVertexId() {
        return this.vertexId;
    }

    public final long getTimeTaken() {
        return this.getFinishTimeInterval() - this.getStartTimeInterval();
    }

    public final long getTimeTakenForTasks() {
        return this.getLastTaskFinishTimeInterval() - this.getFirstTaskStartTimeInterval();
    }

    public final long getInitTimeInterval() {
        return this.initTime - this.dagInfo.getStartTime();
    }

    public final int getNumTasks() {
        return this.numTasks;
    }

    public final int getFailedTasksCount() {
        return this.failedTasks;
    }

    public final int getKilledTasksCount() {
        return this.killedTasks;
    }

    public final int getCompletedTasksCount() {
        return this.completedTasks;
    }

    public final int getSucceededTasksCount() {
        return this.succeededTasks;
    }

    public final int getNumFailedTaskAttemptsCount() {
        return this.numFailedTaskAttempts;
    }

    public final String getProcessorClassName() {
        return this.processorClass;
    }

    private List<TaskInfo> getTasksInternal() {
        return Lists.newLinkedList(this.taskInfoMap.values());
    }

    public final List<TaskInfo> getTasks() {
        return Collections.unmodifiableList(this.getTasksInternal());
    }

    public final List<TaskInfo> getTasks(boolean sorted, @Nullable Ordering<TaskInfo> ordering) {
        List<TaskInfo> taskInfoList = this.getTasksInternal();
        if (sorted) {
            Collections.sort(taskInfoList, ordering == null ? this.orderingOnStartTime() : ordering);
        }
        return Collections.unmodifiableList(taskInfoList);
    }

    public final List<TaskInfo> getFailedTasks() {
        return this.getTasks(TaskState.FAILED);
    }

    public final List<TaskInfo> getKilledTasks() {
        return this.getTasks(TaskState.KILLED);
    }

    public final List<TaskInfo> getSuccessfulTasks() {
        return this.getTasks(TaskState.SUCCEEDED);
    }

    public final List<TaskInfo> getTasks(final TaskState state) {
        return Collections.unmodifiableList(Lists.newLinkedList((Iterable)Iterables.filter((Iterable)Lists.newLinkedList(this.taskInfoMap.values()), (Predicate)new Predicate<TaskInfo>(){

            public boolean apply(TaskInfo input) {
                return input.getStatus() != null && input.getStatus().equals(state.toString());
            }
        })));
    }

    public final List<VertexInfo> getInputVertices() {
        LinkedList inputVertices = Lists.newLinkedList();
        for (EdgeInfo edge : this.inEdgeList) {
            inputVertices.add(edge.getSourceVertex());
        }
        return Collections.unmodifiableList(inputVertices);
    }

    public final List<VertexInfo> getOutputVertices() {
        LinkedList outputVertices = Lists.newLinkedList();
        for (EdgeInfo edge : this.outEdgeList) {
            outputVertices.add(edge.getDestinationVertex());
        }
        return Collections.unmodifiableList(outputVertices);
    }

    private List<TaskAttemptInfo> getTaskAttemptsInternal() {
        LinkedList taskAttemptInfos = Lists.newLinkedList();
        for (TaskInfo taskInfo : this.getTasks()) {
            taskAttemptInfos.addAll(taskInfo.getTaskAttempts());
        }
        return taskAttemptInfos;
    }

    public List<TaskAttemptInfo> getTaskAttempts() {
        return Collections.unmodifiableList(this.getTaskAttemptsInternal());
    }

    public final List<TaskAttemptInfo> getTaskAttempts(boolean sorted, @Nullable Ordering<TaskAttemptInfo> ordering) {
        List<TaskAttemptInfo> taskAttemptInfos = this.getTaskAttemptsInternal();
        if (sorted) {
            Collections.sort(taskAttemptInfos, ordering == null ? this.orderingOnAttemptStartTime() : ordering);
        }
        return Collections.unmodifiableList(taskAttemptInfos);
    }

    public final TaskInfo getTask(String taskId) {
        return this.taskInfoMap.get(taskId);
    }

    public final List<EdgeInfo> getInputEdges() {
        return Collections.unmodifiableList(this.inEdgeList);
    }

    public final List<EdgeInfo> getOutputEdges() {
        return Collections.unmodifiableList(this.outEdgeList);
    }

    public final Multimap<Container, TaskAttemptInfo> getContainersMapping() {
        LinkedHashMultimap containerMapping = LinkedHashMultimap.create();
        for (TaskAttemptInfo attemptInfo : this.getTaskAttempts()) {
            containerMapping.put((Object)attemptInfo.getContainer(), (Object)attemptInfo);
        }
        return Multimaps.unmodifiableMultimap((Multimap)containerMapping);
    }

    public final TaskInfo getFirstTaskToStart() {
        LinkedList taskInfoList = Lists.newLinkedList(this.taskInfoMap.values());
        if (taskInfoList.size() == 0) {
            return null;
        }
        Collections.sort(taskInfoList, new Comparator<TaskInfo>(){

            @Override
            public int compare(TaskInfo o1, TaskInfo o2) {
                return Long.compare(o1.getStartTimeInterval(), o2.getStartTimeInterval());
            }
        });
        return (TaskInfo)taskInfoList.get(0);
    }

    public final TaskInfo getLastTaskToFinish() {
        LinkedList taskInfoList = Lists.newLinkedList(this.taskInfoMap.values());
        if (taskInfoList.size() == 0) {
            return null;
        }
        Collections.sort(taskInfoList, new Comparator<TaskInfo>(){

            @Override
            public int compare(TaskInfo o1, TaskInfo o2) {
                return -1 * Long.compare(o1.getFinishTimeInterval(), o2.getFinishTimeInterval());
            }
        });
        return (TaskInfo)taskInfoList.get(0);
    }

    public final float getAvgTaskDuration() {
        float totalTaskDuration = 0.0f;
        List<TaskInfo> tasksList = this.getTasks();
        if (tasksList.size() == 0) {
            return 0.0f;
        }
        for (TaskInfo taskInfo : tasksList) {
            totalTaskDuration += (float)taskInfo.getTimeTaken();
        }
        return totalTaskDuration * 1.0f / (float)tasksList.size();
    }

    public final long getMinTaskDuration() {
        TaskInfo taskInfo = this.getMinTaskDurationTask();
        return taskInfo != null ? taskInfo.getTimeTaken() : 0L;
    }

    public final long getMaxTaskDuration() {
        TaskInfo taskInfo = this.getMaxTaskDurationTask();
        return taskInfo != null ? taskInfo.getTimeTaken() : 0L;
    }

    private Ordering<TaskInfo> orderingOnTimeTaken() {
        return Ordering.from((Comparator)new Comparator<TaskInfo>(){

            @Override
            public int compare(TaskInfo o1, TaskInfo o2) {
                return Long.compare(o1.getTimeTaken(), o2.getTimeTaken());
            }
        });
    }

    private Ordering<TaskInfo> orderingOnStartTime() {
        return Ordering.from((Comparator)new Comparator<TaskInfo>(){

            @Override
            public int compare(TaskInfo o1, TaskInfo o2) {
                return Long.compare(o1.getStartTimeInterval(), o2.getStartTimeInterval());
            }
        });
    }

    private Ordering<TaskAttemptInfo> orderingOnAttemptStartTime() {
        return Ordering.from((Comparator)new Comparator<TaskAttemptInfo>(){

            @Override
            public int compare(TaskAttemptInfo o1, TaskAttemptInfo o2) {
                return Long.compare(o1.getStartTimeInterval(), o2.getStartTimeInterval());
            }
        });
    }

    public final TaskInfo getMinTaskDurationTask() {
        List<TaskInfo> taskInfoList = this.getTasks();
        if (taskInfoList.size() == 0) {
            return null;
        }
        return (TaskInfo)this.orderingOnTimeTaken().min(taskInfoList);
    }

    public final TaskInfo getMaxTaskDurationTask() {
        List<TaskInfo> taskInfoList = this.getTasks();
        if (taskInfoList.size() == 0) {
            return null;
        }
        return (TaskInfo)this.orderingOnTimeTaken().max(taskInfoList);
    }

    public final String getStatus() {
        return this.status;
    }

    public final DagInfo getDagInfo() {
        return this.dagInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("vertexName=").append(this.getVertexName()).append(", ");
        sb.append("events=").append(this.getEvents()).append(", ");
        sb.append("initTime=").append(this.getInitTimeInterval()).append(", ");
        sb.append("startTime=").append(this.getStartTimeInterval()).append(", ");
        sb.append("endTime=").append(this.getFinishTimeInterval()).append(", ");
        sb.append("timeTaken=").append(this.getTimeTaken()).append(", ");
        sb.append("diagnostics=").append(this.getDiagnostics()).append(", ");
        sb.append("numTasks=").append(this.getNumTasks()).append(", ");
        sb.append("processorClassName=").append(this.getProcessorClassName()).append(", ");
        sb.append("numCompletedTasks=").append(this.getCompletedTasksCount()).append(", ");
        sb.append("numFailedTaskAttempts=").append(this.getNumFailedTaskAttemptsCount()).append(", ");
        sb.append("numSucceededTasks=").append(this.getSucceededTasksCount()).append(", ");
        sb.append("numFailedTasks=").append(this.getFailedTasks()).append(", ");
        sb.append("numKilledTasks=").append(this.getKilledTasks()).append(", ");
        sb.append("tasksCount=").append(this.taskInfoMap.size()).append(", ");
        sb.append("status=").append(this.getStatus());
        sb.append("]");
        return sb.toString();
    }
}

