/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.history.logging.impl.SimpleHistoryLoggingService;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.history.parser.datamodel.BaseParser;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.TaskInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHistoryParser
extends BaseParser {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHistoryParser.class);
    protected static final String UTF8 = "UTF-8";
    private final File historyFile;

    public SimpleHistoryParser(List<File> files) {
        Preconditions.checkArgument((boolean)this.checkFiles(files), (Object)(files + " are empty or they don't exist"));
        this.historyFile = files.get(0);
    }

    public DagInfo getDAGData(String dagId) throws TezException {
        try {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dagId) ? 1 : 0) != 0, (Object)"Please provide valid dagId");
            dagId = dagId.trim();
            this.parseContents(this.historyFile, dagId);
            this.linkParsedContents();
            this.addRawDataToDagInfo();
            return this.dagInfo;
        }
        catch (IOException | JSONException e) {
            LOG.error("Error in reading DAG ", e);
            throw new TezException(e);
        }
    }

    private void populateOtherInfo(JSONObject source, JSONObject destination) throws JSONException {
        if (source == null || destination == null) {
            return;
        }
        Iterator it = source.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object val = source.get(key);
            destination.put(key, val);
        }
    }

    private void populateOtherInfo(JSONObject source, String entityName, Map<String, JSONObject> destMap) throws JSONException {
        JSONObject destinationJson = destMap.get(entityName);
        JSONObject destOtherInfo = destinationJson.getJSONObject("otherinfo");
        this.populateOtherInfo(source, destOtherInfo);
    }

    private void parseContents(File historyFile, String dagId) throws JSONException, FileNotFoundException, TezException, IOException {
        JSONObjectSource source = this.getJsonSource();
        this.parse(dagId, source);
    }

    private JSONObjectSource getJsonSource() throws FileNotFoundException {
        final Scanner scanner = new Scanner(this.historyFile, UTF8);
        scanner.useDelimiter(SimpleHistoryLoggingService.RECORD_SEPARATOR);
        JSONObjectSource source = new JSONObjectSource(){

            @Override
            public JSONObject next() throws JSONException {
                String line = scanner.next();
                return new JSONObject(line);
            }

            @Override
            public boolean hasNext() throws IOException {
                return scanner.hasNext();
            }

            @Override
            public void close() {
                scanner.close();
            }
        };
        return source;
    }

    protected void parse(String dagId, JSONObjectSource source) throws JSONException, TezException, IOException {
        HashMap vertexJsonMap = Maps.newHashMap();
        HashMap taskJsonMap = Maps.newHashMap();
        HashMap attemptJsonMap = Maps.newHashMap();
        this.readEventsFromSource(dagId, source, vertexJsonMap, taskJsonMap, attemptJsonMap);
        this.postProcessMaps(vertexJsonMap, taskJsonMap, attemptJsonMap);
    }

    protected void postProcessMaps(Map<String, JSONObject> vertexJsonMap, Map<String, JSONObject> taskJsonMap, Map<String, JSONObject> attemptJsonMap) throws JSONException {
        for (JSONObject jsonObject : vertexJsonMap.values()) {
            VertexInfo vertexInfo = VertexInfo.create(jsonObject);
            this.vertexList.add(vertexInfo);
            LOG.debug("Parsed vertex {}", (Object)vertexInfo.getVertexName());
        }
        for (JSONObject jsonObject : taskJsonMap.values()) {
            TaskInfo taskInfo = TaskInfo.create(jsonObject);
            this.taskList.add(taskInfo);
            LOG.debug("Parsed task {}", (Object)taskInfo.getTaskId());
        }
        for (JSONObject jsonObject : attemptJsonMap.values()) {
            JSONArray relatedEntities = jsonObject.optJSONArray("relatedEntities");
            if (relatedEntities == null) {
                LOG.debug("entity {} did not have related entities", (Object)jsonObject.optJSONObject("entity"));
            } else {
                String containerId;
                JSONObject otherInfo;
                String nodeId;
                JSONObject subJsonObject = relatedEntities.optJSONObject(0);
                if (subJsonObject != null && !Strings.isNullOrEmpty((String)(nodeId = subJsonObject.optString("entitytype"))) && nodeId.equalsIgnoreCase("nodeId")) {
                    otherInfo = jsonObject.optJSONObject("otherinfo");
                    String nodeIdVal = subJsonObject.optString("entity");
                    if (otherInfo != null && nodeIdVal != null) {
                        otherInfo.put("nodeId", (Object)nodeIdVal);
                    }
                }
                if ((subJsonObject = relatedEntities.optJSONObject(1)) != null && !Strings.isNullOrEmpty((String)(containerId = subJsonObject.optString("entitytype"))) && containerId.equalsIgnoreCase("containerId")) {
                    otherInfo = jsonObject.optJSONObject("otherinfo");
                    String containerIdVal = subJsonObject.optString("entity");
                    if (otherInfo != null && containerIdVal != null) {
                        otherInfo.put("containerId", (Object)containerIdVal);
                    }
                }
            }
            TaskAttemptInfo attemptInfo = TaskAttemptInfo.create(jsonObject);
            this.attemptList.add(attemptInfo);
            LOG.debug("Parsed task attempt {}", (Object)attemptInfo.getTaskAttemptId());
        }
    }

    protected void readEventsFromSource(String dagId, JSONObjectSource source, Map<String, JSONObject> vertexJsonMap, Map<String, JSONObject> taskJsonMap, Map<String, JSONObject> attemptJsonMap) throws JSONException, TezException, IOException {
        JSONObject dagJson = null;
        TezDAGID tezDAGID = TezDAGID.fromString((String)dagId);
        String userName = null;
        while (source.hasNext()) {
            String entityType;
            JSONObject jsonObject = source.next();
            String entity = jsonObject.getString("entity");
            switch (entityType = jsonObject.getString("entitytype")) {
                case "TEZ_DAG_ID": {
                    if (!dagId.equals(entity)) {
                        LOG.warn(dagId + " is not matching with " + entity);
                        break;
                    }
                    if (dagJson == null) {
                        dagJson = jsonObject;
                    } else {
                        if (dagJson.optJSONObject("otherinfo").optJSONObject("dagPlan") == null) {
                            dagJson.getJSONObject("otherinfo").put("dagPlan", (Object)jsonObject.getJSONObject("otherinfo").getJSONObject("dagPlan"));
                        }
                        this.mergeSubJSONArray(jsonObject, dagJson, "events");
                    }
                    JSONArray relatedEntities = dagJson.optJSONArray("relatedEntities");
                    if (relatedEntities != null) {
                        for (int i = 0; i < relatedEntities.length(); ++i) {
                            JSONObject subEntity = relatedEntities.getJSONObject(i);
                            String subEntityType = subEntity.optString("entitytype");
                            if (subEntityType == null || !subEntityType.equals("user")) continue;
                            userName = subEntity.getString("entity");
                            break;
                        }
                    }
                    this.populateOtherInfo(jsonObject.optJSONObject("otherinfo"), dagJson.getJSONObject("otherinfo"));
                    break;
                }
                case "TEZ_VERTEX_ID": {
                    String vertexName = entity;
                    TezVertexID tezVertexID = TezVertexID.fromString((String)vertexName);
                    if (!tezDAGID.equals((Object)tezVertexID.getDAGID())) {
                        LOG.warn("{} does not belong to {} ('{}' != '{}')}", new Object[]{vertexName, tezDAGID, tezDAGID, tezVertexID.getDAGID()});
                        break;
                    }
                    if (!vertexJsonMap.containsKey(vertexName)) {
                        vertexJsonMap.put(vertexName, jsonObject);
                    } else {
                        this.mergeSubJSONArray(jsonObject, vertexJsonMap.get(vertexName), "events");
                    }
                    this.populateOtherInfo(jsonObject.optJSONObject("otherinfo"), vertexName, vertexJsonMap);
                    break;
                }
                case "TEZ_TASK_ID": {
                    String taskName = entity;
                    TezTaskID tezTaskID = TezTaskID.fromString((String)taskName);
                    if (!tezDAGID.equals((Object)tezTaskID.getDAGID())) {
                        LOG.warn("{} does not belong to {} ('{}' != '{}')}", new Object[]{taskName, tezDAGID, tezDAGID, tezTaskID.getDAGID()});
                        break;
                    }
                    if (!taskJsonMap.containsKey(taskName)) {
                        taskJsonMap.put(taskName, jsonObject);
                    } else {
                        this.mergeSubJSONArray(jsonObject, taskJsonMap.get(taskName), "events");
                    }
                    this.populateOtherInfo(jsonObject.optJSONObject("otherinfo"), taskName, taskJsonMap);
                    break;
                }
                case "TEZ_TASK_ATTEMPT_ID": {
                    String taskAttemptName = entity;
                    TezTaskAttemptID tezAttemptId = TezTaskAttemptID.fromString((String)taskAttemptName);
                    if (!tezDAGID.equals((Object)tezAttemptId.getDAGID())) {
                        LOG.warn("{} does not belong to {} ('{}' != '{}')}", new Object[]{taskAttemptName, tezDAGID, tezDAGID, tezAttemptId.getDAGID()});
                        break;
                    }
                    if (!attemptJsonMap.containsKey(taskAttemptName)) {
                        attemptJsonMap.put(taskAttemptName, jsonObject);
                    } else {
                        this.mergeSubJSONArray(jsonObject, attemptJsonMap.get(taskAttemptName), "events");
                    }
                    this.populateOtherInfo(jsonObject.optJSONObject("otherinfo"), taskAttemptName, attemptJsonMap);
                    break;
                }
            }
        }
        source.close();
        if (dagJson == null) {
            LOG.error("Dag is not yet parsed. Looks like partial file.");
            throw new TezException("Please provide a valid/complete history log file containing " + dagId);
        }
        this.dagInfo = DagInfo.create(dagJson);
        this.setUserName(userName);
    }

    private void mergeSubJSONArray(JSONObject source, JSONObject destination, String key) throws JSONException {
        if (source.optJSONArray(key) == null) {
            source.put(key, (Object)new JSONArray());
        }
        if (destination.optJSONArray(key) == null) {
            destination.put(key, (Object)new JSONArray());
        }
        for (int i = 0; i < source.getJSONArray(key).length(); ++i) {
            destination.getJSONArray(key).put(source.getJSONArray(key).get(i));
        }
    }

    protected static interface JSONObjectSource {
        public boolean hasNext() throws IOException;

        public JSONObject next() throws JSONException;

        public void close();
    }
}

