/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.runtime.api.Event;

@InterfaceAudience.Public
public final class InputReadErrorEvent
extends Event {
    private final String diagnostics;
    private final int index;
    private final int version;
    private final int numFailures;
    private final boolean isLocalFetch;
    private final boolean isDiskErrorAtSource;
    private final String destinationLocalhostName;

    private InputReadErrorEvent(String diagnostics, int index, int version, int numFailures, boolean isLocalFetch, boolean isDiskErrorAtSource, String destinationLocalhostName) {
        this.diagnostics = diagnostics;
        this.index = index;
        this.version = version;
        this.numFailures = numFailures;
        this.isLocalFetch = isLocalFetch;
        this.isDiskErrorAtSource = isDiskErrorAtSource;
        this.destinationLocalhostName = destinationLocalhostName;
    }

    @VisibleForTesting
    public static InputReadErrorEvent create(String diagnostics, int index, int version) {
        return InputReadErrorEvent.create(diagnostics, index, version, 1, false, false, null);
    }

    public static InputReadErrorEvent create(String diagnostics, int index, int version, boolean isLocalFetch, boolean isDiskErrorAtSource, String destinationLocalhostName) {
        return InputReadErrorEvent.create(diagnostics, index, version, 1, isLocalFetch, isDiskErrorAtSource, destinationLocalhostName);
    }

    public static InputReadErrorEvent create(String diagnostics, int index, int version, int numFailures, boolean isLocalFetch, boolean isDiskErrorAtSource, String destinationLocalhostName) {
        return new InputReadErrorEvent(diagnostics, index, version, numFailures, isLocalFetch, isDiskErrorAtSource, destinationLocalhostName);
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public int getIndex() {
        return this.index;
    }

    public int getVersion() {
        return this.version;
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    public boolean isLocalFetch() {
        return this.isLocalFetch;
    }

    public boolean isDiskErrorAtSource() {
        return this.isDiskErrorAtSource;
    }

    public String getDestinationLocalhostName() {
        return this.destinationLocalhostName;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputReadErrorEvent that = (InputReadErrorEvent)o;
        return this.index == that.index && this.version == that.version;
    }
}

