/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.Result;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class HungTaskAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private final String[] headers = new String[]{"vertex", "task", " number_of_attempts", "last_attempt_id", "last_attempt_status", "last_attempt_duration_ms", "last_attempt_node"};
    private final CSVResult csvResult = new CSVResult(this.headers);
    private static final String HEADER_NUM_ATTEMPTS = "num_attempts";
    private static final String HEADER_LAST_ATTEMPT_ID_AND_STATUS = "last_attempt_id_and_status";
    private static final String HEADER_LAST_ATTEMPT_STATUS = "last_attempt_status";
    private static final String HEADER_LAST_ATTEMPT_NODE = "last_attempt_node";
    private static final String HEADER_LAST_ATTEMPT_DURATION_MS = "last_attempt_duration_ms";

    public HungTaskAnalyzer(Configuration config) {
        super(config);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        HashMap taskData = new HashMap();
        for (VertexInfo vertex : dagInfo.getVertices()) {
            taskData.clear();
            for (TaskAttemptInfo taskAttemptInfo : vertex.getTaskAttempts()) {
                int attemptNumber;
                String taskId = taskAttemptInfo.getTaskInfo().getTaskId();
                int numAttemptsForTask = taskAttemptInfo.getTaskInfo().getNumberOfTaskAttempts();
                HashMap<String, String> thisTaskData = (HashMap<String, String>)taskData.get(taskId);
                if (thisTaskData == null) {
                    thisTaskData = new HashMap<String, String>();
                    thisTaskData.put(HEADER_NUM_ATTEMPTS, Integer.toString(numAttemptsForTask));
                    taskData.put(taskId, thisTaskData);
                }
                if ((attemptNumber = TezTaskAttemptID.fromString((String)taskAttemptInfo.getTaskAttemptId()).getId()) != numAttemptsForTask - 1) continue;
                thisTaskData.put(HEADER_LAST_ATTEMPT_ID_AND_STATUS, String.format("%s/%s", taskAttemptInfo.getTaskAttemptId(), taskAttemptInfo.getStatus()));
                thisTaskData.put(HEADER_LAST_ATTEMPT_STATUS, taskAttemptInfo.getDetailedStatus());
                thisTaskData.put(HEADER_LAST_ATTEMPT_NODE, taskAttemptInfo.getNodeId());
                thisTaskData.put(HEADER_LAST_ATTEMPT_DURATION_MS, taskAttemptInfo.getFinishTime() == 0L || taskAttemptInfo.getStartTime() == 0L ? "-1" : Long.toString(taskAttemptInfo.getFinishTime() - taskAttemptInfo.getStartTime()));
            }
            for (Map.Entry entry : taskData.entrySet()) {
                this.addARecord(vertex.getVertexName(), (String)entry.getKey(), (String)((Map)entry.getValue()).get(HEADER_NUM_ATTEMPTS), (String)((Map)entry.getValue()).get(HEADER_LAST_ATTEMPT_ID_AND_STATUS), (String)((Map)entry.getValue()).get(HEADER_LAST_ATTEMPT_STATUS), (String)((Map)entry.getValue()).get(HEADER_LAST_ATTEMPT_DURATION_MS), (String)((Map)entry.getValue()).get(HEADER_LAST_ATTEMPT_NODE));
            }
        }
        this.csvResult.sort(new Comparator<String[]>(){

            @Override
            public int compare(String[] first, String[] second) {
                int vertexOrder = first[0].compareTo(second[0]);
                int lastAttemptStatusOrder = first[4] == null || second[4] == null ? 0 : first[4].compareTo(second[4]);
                int attemptNumberOrder = Integer.valueOf(second[2]).compareTo(Integer.valueOf(first[2]));
                return vertexOrder == 0 ? (lastAttemptStatusOrder == 0 ? attemptNumberOrder : lastAttemptStatusOrder) : vertexOrder;
            }
        });
    }

    private void addARecord(String vertexName, String taskId, String numAttempts, String lastAttemptId, String lastAttemptStatus, String lastAttemptDuration, String lastAttemptNode) {
        String[] record = new String[]{vertexName, taskId, numAttempts, lastAttemptId, lastAttemptStatus, lastAttemptDuration, lastAttemptNode};
        this.csvResult.addRecord(record);
    }

    @Override
    public Result getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "Hung Task Analyzer";
    }

    @Override
    public String getDescription() {
        return "TaskHandAnalyzer can give quick insights about hanging task attempts by giving an overview of all tasks and their last attempts' status, duration, etc.";
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        HungTaskAnalyzer analyzer = new HungTaskAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

