/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.EvalNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MatrixBuiltinNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarBuiltinNaryCPInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.SimpleOperator;

public abstract class BuiltinNaryCPInstruction
extends CPInstruction {
    protected final CPOperand output;
    protected final CPOperand[] inputs;

    public BuiltinNaryCPInstruction(Operator op, String opcode, String istr, CPOperand output, CPOperand ... inputs) {
        super(CPInstruction.CPType.BuiltinNary, op, opcode, istr);
        this.output = output;
        this.inputs = inputs;
    }

    public CPOperand[] getInputs() {
        return this.inputs;
    }

    public CPOperand getOutput() {
        return this.output;
    }

    public static BuiltinNaryCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand outputOperand = new CPOperand(parts[parts.length - 1]);
        CPOperand[] inputOperands = null;
        if (parts.length > 2) {
            inputOperands = new CPOperand[parts.length - 2];
            for (int i = 1; i < parts.length - 1; ++i) {
                inputOperands[i - 1] = new CPOperand(parts[i]);
            }
        }
        if ("printf".equals(opcode) || "list".equals(opcode)) {
            Builtin func = Builtin.getBuiltinFnObject(opcode);
            return new ScalarBuiltinNaryCPInstruction(new SimpleOperator(func), opcode, str, outputOperand, inputOperands);
        }
        if (opcode.equals("cbind") || opcode.equals("rbind")) {
            return new MatrixBuiltinNaryCPInstruction(null, opcode, str, outputOperand, inputOperands);
        }
        if (opcode.equals("nmin") || opcode.equals("nmax")) {
            Builtin func = Builtin.getBuiltinFnObject(opcode.substring(1));
            return new MatrixBuiltinNaryCPInstruction(new SimpleOperator(func), opcode, str, outputOperand, inputOperands);
        }
        if (opcode.equals("n+")) {
            return new MatrixBuiltinNaryCPInstruction(new SimpleOperator(Plus.getPlusFnObject()), opcode, str, outputOperand, inputOperands);
        }
        if (Types.OpOpN.EVAL.name().equalsIgnoreCase(opcode)) {
            return new EvalNaryCPInstruction(null, opcode, str, outputOperand, inputOperands);
        }
        throw new DMLRuntimeException("Opcode (" + opcode + ") not recognized in BuiltinMultipleCPInstruction");
    }
}

