/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.data.SparseRowScalar;
import org.apache.sysds.runtime.data.SparseRowVector;
import org.apache.sysds.runtime.util.SortUtils;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class SparseBlockCSR
extends SparseBlock {
    private static final long serialVersionUID = 1922673868466164244L;
    private int[] _ptr = null;
    private int[] _indexes = null;
    private double[] _values = null;
    private int _size = 0;

    public SparseBlockCSR(int rlen) {
        this(rlen, 4);
    }

    public SparseBlockCSR(int rlen, int capacity) {
        this._ptr = new int[rlen + 1];
        this._indexes = new int[capacity];
        this._values = new double[capacity];
        this._size = 0;
    }

    public SparseBlockCSR(int rlen, int capacity, int size) {
        this._ptr = new int[rlen + 1];
        this._indexes = new int[capacity];
        this._values = new double[capacity];
        this._size = size;
    }

    public SparseBlockCSR(int[] rowPtr, int[] colInd, double[] values, int nnz) {
        this._ptr = rowPtr;
        this._indexes = colInd;
        this._values = values;
        this._size = nnz;
    }

    public SparseBlockCSR(SparseBlock sblock) {
        long size = sblock.size();
        if (size > Integer.MAX_VALUE) {
            throw new RuntimeException("SparseBlockCSR supports nnz<=Integer.MAX_VALUE but got " + size);
        }
        if (sblock instanceof SparseBlockCSR) {
            SparseBlockCSR ocsr = (SparseBlockCSR)sblock;
            this._ptr = Arrays.copyOf(ocsr._ptr, ocsr.numRows() + 1);
            this._indexes = Arrays.copyOf(ocsr._indexes, ocsr._size);
            this._values = Arrays.copyOf(ocsr._values, ocsr._size);
            this._size = ocsr._size;
        } else {
            int rlen = sblock.numRows();
            this._ptr = new int[rlen + 1];
            this._indexes = new int[(int)size];
            this._values = new double[(int)size];
            this._size = (int)size;
            int pos = 0;
            for (int i = 0; i < rlen; ++i) {
                if (!sblock.isEmpty(i)) {
                    int apos = sblock.pos(i);
                    int alen = sblock.size(i);
                    int[] aix = sblock.indexes(i);
                    double[] avals = sblock.values(i);
                    System.arraycopy(aix, apos, this._indexes, pos, alen);
                    System.arraycopy(avals, apos, this._values, pos, alen);
                    pos += alen;
                }
                this._ptr[i + 1] = pos;
            }
        }
    }

    public SparseBlockCSR(SparseRow[] rows, int nnz) {
        int rlen = rows.length;
        this._ptr = new int[rlen + 1];
        this._indexes = new int[nnz];
        this._values = new double[nnz];
        this._size = nnz;
        int pos = 0;
        for (int i = 0; i < rlen; ++i) {
            if (rows[i] != null && !rows[i].isEmpty()) {
                int alen = rows[i].size();
                int[] aix = rows[i].indexes();
                double[] avals = rows[i].values();
                System.arraycopy(aix, 0, this._indexes, pos, alen);
                System.arraycopy(avals, 0, this._values, pos, alen);
                pos += alen;
            }
            this._ptr[i + 1] = pos;
        }
    }

    public SparseBlockCSR(int rows, int[] rowInd, int[] colInd, double[] values) {
        int nnz = values.length;
        this._ptr = new int[rows + 1];
        this._indexes = Arrays.copyOf(colInd, colInd.length);
        this._values = Arrays.copyOf(values, values.length);
        this._size = nnz;
        int rlast = 0;
        for (int i = 0; i < nnz; ++i) {
            int r = rowInd[i];
            if (rlast < r) {
                Arrays.fill(this._ptr, rlast + 1, r + 1, i);
            }
            rlast = r;
        }
        Arrays.fill(this._ptr, rlast + 1, this.numRows() + 1, nnz);
    }

    public SparseBlockCSR(int rows, int nnz, int[] colInd) {
        this._ptr = new int[rows + 1];
        this._indexes = rows == nnz ? colInd : new int[nnz];
        this._values = new double[nnz];
        Arrays.fill(this._values, 1.0);
        this._size = nnz;
        int pos = 0;
        for (int i = 0; i < rows; ++i) {
            if (colInd[i] >= 0 && rows > nnz) {
                this._indexes[pos] = colInd[i];
            }
            this._ptr[i + 1] = ++pos;
        }
    }

    public void initUltraSparse(int nnz, DataInput in) throws IOException {
        if (this._values.length < nnz) {
            this.resize(this.newCapacity(nnz));
        }
        int rlast = 0;
        for (int i = 0; i < nnz; ++i) {
            int r = in.readInt();
            if (rlast < r) {
                Arrays.fill(this._ptr, rlast + 1, r + 1, i);
            }
            rlast = r;
            this._indexes[i] = in.readInt();
            this._values[i] = in.readDouble();
        }
        Arrays.fill(this._ptr, rlast + 1, this.numRows() + 1, nnz);
        this._size = nnz;
    }

    public void initSparse(int rlen, int nnz, DataInput in) throws IOException {
        if (this._values.length < nnz) {
            this.resize(this.newCapacity(nnz));
        }
        this._ptr[0] = 0;
        int pos = 0;
        for (int r = 0; r < rlen; ++r) {
            int lnnz = in.readInt();
            int j = 0;
            while (j < lnnz) {
                this._indexes[pos] = in.readInt();
                this._values[pos] = in.readDouble();
                ++j;
                ++pos;
            }
            this._ptr[r + 1] = pos;
        }
        this._size = nnz;
    }

    public static long estimateSizeInMemory(long nrows, long ncols, double sparsity) {
        double lnnz = Math.max(4.0, Math.ceil(sparsity * (double)nrows * (double)ncols));
        double size = 24.0;
        size += MemoryEstimates.intArrayCost(nrows + 1L);
        size += MemoryEstimates.intArrayCost((long)lnnz);
        return (long)Math.min(size += MemoryEstimates.doubleArrayCost((long)lnnz), 9.223372036854776E18);
    }

    public int[] rowPointers() {
        return this._ptr;
    }

    public int[] indexes() {
        return this.indexes(0);
    }

    public double[] values() {
        return this.values(0);
    }

    @Override
    public void allocate(int r) {
    }

    @Override
    public void allocate(int r, int nnz) {
    }

    @Override
    public void allocate(int r, int ennz, int maxnnz) {
    }

    @Override
    public void compact(int r) {
    }

    @Override
    public int numRows() {
        return this._ptr.length - 1;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public boolean isAllocated(int r) {
        return true;
    }

    @Override
    public void reset() {
        if (this._size > 0) {
            Arrays.fill(this._ptr, 0);
            this._size = 0;
        }
    }

    @Override
    public void reset(int ennz, int maxnnz) {
        if (this._size > 0) {
            Arrays.fill(this._ptr, 0);
            this._size = 0;
        }
    }

    @Override
    public void reset(int r, int ennz, int maxnnz) {
        int pos = this.pos(r);
        int len = this.size(r);
        if (len > 0) {
            System.arraycopy(this._indexes, pos + len, this._indexes, pos, this._size - (pos + len));
            System.arraycopy(this._values, pos + len, this._values, pos, this._size - (pos + len));
            this._size -= len;
            this.decrPtr(r + 1, len);
        }
    }

    @Override
    public long size() {
        return this._size;
    }

    @Override
    public int size(int r) {
        return this._ptr[r + 1] - this._ptr[r];
    }

    @Override
    public long size(int rl, int ru) {
        return this._ptr[ru] - this._ptr[rl];
    }

    @Override
    public long size(int rl, int ru, int cl, int cu) {
        long nnz = 0L;
        for (int i = rl; i < ru; ++i) {
            if (this.isEmpty(i)) continue;
            int start = this.internPosFIndexGTE(i, cl);
            int end = this.internPosFIndexGTE(i, cu);
            nnz += start != -1 ? (long)(end - start) : 0L;
        }
        return nnz;
    }

    @Override
    public boolean isEmpty(int r) {
        return this._ptr[r + 1] - this._ptr[r] == 0;
    }

    @Override
    public int[] indexes(int r) {
        return this._indexes;
    }

    @Override
    public double[] values(int r) {
        return this._values;
    }

    @Override
    public int pos(int r) {
        return this._ptr[r];
    }

    @Override
    public boolean set(int r, int c, double v) {
        int len;
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.size(r)), c);
        if (index >= 0) {
            if (v == 0.0) {
                this.shiftLeftAndDelete(index);
                this.decrPtr(r + 1);
                return true;
            }
            this._values[index] = v;
            return false;
        }
        if (v == 0.0) {
            return false;
        }
        index = Math.abs(index + 1);
        if (this._size == this._values.length) {
            this.resizeAndInsert(index, c, v);
        } else {
            this.shiftRightAndInsert(index, c, v);
        }
        this.incrPtr(r + 1);
        return true;
    }

    @Override
    public boolean add(int r, int c, double v) {
        int len;
        if (v == 0.0) {
            return false;
        }
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.size(r)), c);
        if (index >= 0) {
            int n = index;
            this._values[n] = this._values[n] + v;
            return false;
        }
        index = Math.abs(index + 1);
        if (this._size == this._values.length) {
            this.resizeAndInsert(index, c, v);
        } else {
            this.shiftRightAndInsert(index, c, v);
        }
        this.incrPtr(r + 1);
        return true;
    }

    @Override
    public void set(int r, SparseRow row, boolean deep) {
        int lsize;
        int pos = this.pos(r);
        int len = this.size(r);
        int alen = row.size();
        int[] aix = row.indexes();
        double[] avals = row.values();
        if (len > 0) {
            this.deleteIndexRange(r, aix[pos], aix[pos + len - 1] + 1);
        }
        if (this._values.length < (lsize = this._size + alen)) {
            this.resize(lsize);
        }
        this.shiftRightByN(pos, alen);
        this.incrPtr(r + 1, alen);
        System.arraycopy(aix, 0, this._indexes, pos, alen);
        System.arraycopy(avals, 0, this._values, pos, alen);
    }

    @Override
    public void append(int r, int c, double v) {
        int len;
        if (v == 0.0) {
            return;
        }
        int pos = this.pos(r);
        if (pos + (len = this.size(r)) == this._size) {
            if (this._size == this._values.length) {
                this.resize();
            }
            this.insert(this._size, c, v);
        } else if (this._size == this._values.length) {
            this.resizeAndInsert(pos + len, c, v);
        } else {
            this.shiftRightAndInsert(pos + len, c, v);
        }
        this.incrPtr(r + 1);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int vix, int vlen) {
        int index;
        int lnnz;
        int lsize;
        if (!this.isEmpty(r)) {
            this.deleteIndexRange(r, cl, cu);
        }
        if (this._values.length < (lsize = this._size + (lnnz = UtilFunctions.computeNnz(v, vix, vlen)))) {
            this.resize(lsize);
        }
        int index2 = (index = this.internPosFIndexGT(r, cl)) > 0 ? index : this.pos(r + 1);
        this.shiftRightByN(index2, lnnz);
        for (int i = vix; i < vix + vlen; ++i) {
            if (v[i] == 0.0) continue;
            this._indexes[index2] = cl + i - vix;
            this._values[index2] = v[i];
            ++index2;
        }
        this.incrPtr(r + 1, lnnz);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int[] vix, int vpos, int vlen) {
        int index;
        int lsize;
        if (!this.isEmpty(r)) {
            this.deleteIndexRange(r, cl, cu);
        }
        if (this._values.length < (lsize = this._size + vlen)) {
            this.resize(lsize);
        }
        int index2 = (index = this.internPosFIndexGT(r, cl)) > 0 ? index : this.pos(r + 1);
        this.shiftRightByN(index2, vlen);
        for (int i = vpos; i < vpos + vlen; ++i) {
            this._indexes[index2] = cl + vix[i];
            this._values[index2] = v[i];
            ++index2;
        }
        this.incrPtr(r + 1, vlen);
    }

    public void setIndexRange(int rl, int ru, int cl, int cu, double[] v, int vix, int vlen) {
        int nnz = this._size - (int)this.size(rl, ru, cl, cu);
        if (v != null) {
            nnz += UtilFunctions.computeNnz(v, vix, vlen);
        }
        if (this._values.length < nnz) {
            this.resize(nnz);
        }
        int pos = this.pos(rl);
        for (int r = rl; r < ru; ++r) {
            int rpos = this.pos(r);
            int rlen = this.size(r);
            this._ptr[r] = pos;
            for (int k = rpos; k < rpos + rlen; ++k) {
                if (this._indexes[k] >= cl && cu > this._indexes[k]) continue;
                this._indexes[pos] = this._indexes[k];
                this._values[pos++] = this._values[k];
            }
        }
        this.shiftLeftByN(this.pos(ru), this.pos(ru) - pos);
        this.decrPtr(ru, this.pos(ru) - pos);
        int tshift1 = nnz - this._size;
        if (v == null || tshift1 == 0) {
            return;
        }
        this.shiftRightByN(this.pos(ru), tshift1);
        this.incrPtr(ru, tshift1);
        pos = this.pos(ru) - 1;
        int clen2 = cu - cl;
        for (int r = ru - 1; r >= rl; --r) {
            int rpos = this.pos(r);
            int rlen = this.size(r) - tshift1;
            int k = -1;
            for (k = rpos + rlen - 1; k >= rpos && this._indexes[k] >= cu; --k) {
                this._indexes[pos] = this._indexes[k];
                this._values[pos--] = this._values[k];
            }
            int voff = vix + (r - rl) * clen2;
            int k2 = clen2 - 1;
            while (k2 >= 0 & vlen > voff) {
                if (v[voff + k2] != 0.0) {
                    this._indexes[pos] = cl + k2;
                    this._values[pos--] = v[voff + k2];
                    --tshift1;
                }
                --k2;
            }
            while (k >= rpos) {
                this._indexes[pos] = this._indexes[k];
                this._values[pos--] = this._values[k];
                --k;
            }
            this._ptr[r] = pos + 1;
        }
    }

    public void setIndexRange(int rl, int ru, int cl, int cu, SparseBlock sb) {
        int nnz = (int)((long)this._size - this.size(rl, ru, cl, cu) + (sb != null ? sb.size() : 0L));
        if (this._values.length < nnz) {
            this.resize(nnz);
        }
        int pos = this.pos(rl);
        for (int r = rl; r < ru; ++r) {
            int rpos = this.pos(r);
            int rlen = this.size(r);
            this._ptr[r] = pos;
            for (int k = rpos; k < rpos + rlen; ++k) {
                if (this._indexes[k] >= cl && cu > this._indexes[k]) continue;
                this._indexes[pos] = this._indexes[k];
                this._values[pos++] = this._values[k];
            }
        }
        this.shiftLeftByN(this.pos(ru), this.pos(ru) - pos);
        this.decrPtr(ru, this.pos(ru) - pos);
        int tshift1 = nnz - this._size;
        if (sb == null || tshift1 == 0) {
            return;
        }
        this.shiftRightByN(this.pos(ru), tshift1);
        this.incrPtr(ru, tshift1);
        pos = this.pos(ru) - 1;
        for (int r = ru - 1; r >= rl; --r) {
            int rpos = this.pos(r);
            int rlen = this.size(r) - tshift1;
            int k = -1;
            for (k = rpos + rlen - 1; k >= rpos && this._indexes[k] >= cu; --k) {
                this._indexes[pos] = this._indexes[k];
                this._values[pos--] = this._values[k];
            }
            int r2 = r - rl;
            int r2pos = sb.pos(r2);
            for (int k2 = r2pos + sb.size(r2) - 1; k2 >= r2pos; --k2) {
                this._indexes[pos] = cl + sb.indexes(r2)[k2];
                this._values[pos--] = sb.values(r2)[k2];
                --tshift1;
            }
            while (k >= rpos) {
                this._indexes[pos] = this._indexes[k];
                this._values[pos--] = this._values[k];
                --k;
            }
            this._ptr[r] = pos + 1;
        }
    }

    @Override
    public void deleteIndexRange(int r, int cl, int cu) {
        int start = this.internPosFIndexGTE(r, cl);
        if (start < 0) {
            return;
        }
        int len = this.size(r);
        int end = this.internPosFIndexGTE(r, cu);
        if (end < 0) {
            end = start + len;
        }
        System.arraycopy(this._indexes, end, this._indexes, start, this._size - end);
        System.arraycopy(this._values, end, this._values, start, this._size - end);
        this._size -= end - start;
        this.decrPtr(r + 1, end - start);
    }

    @Override
    public void sort() {
        int rlen = this.numRows();
        for (int i = 0; i < rlen && this.pos(i) < this._size; ++i) {
            this.sort(i);
        }
    }

    @Override
    public void sort(int r) {
        int pos = this.pos(r);
        int len = this.size(r);
        if (len <= 100 || !SortUtils.isSorted(pos, pos + len, this._indexes)) {
            SortUtils.sortByIndex(pos, pos + len, this._indexes, this._values);
        }
    }

    @Override
    public double get(int r, int c) {
        int len;
        if (this.isEmpty(r)) {
            return 0.0;
        }
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.size(r)), c);
        return index >= 0 ? this._values[index] : 0.0;
    }

    @Override
    public SparseRow get(int r) {
        if (this.isEmpty(r)) {
            return new SparseRowScalar();
        }
        int pos = this.pos(r);
        int len = this.size(r);
        SparseRowVector row = new SparseRowVector(len);
        System.arraycopy(this._indexes, pos, row.indexes(), 0, len);
        System.arraycopy(this._values, pos, row.values(), 0, len);
        row.setSize(len);
        return row;
    }

    @Override
    public int posFIndexLTE(int r, int c) {
        int index = this.internPosFIndexLTE(r, c);
        return index >= 0 ? index - this.pos(r) : index;
    }

    private int internPosFIndexLTE(int r, int c) {
        int len;
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.size(r)), c);
        if (index >= 0) {
            return index < pos + len ? index : -1;
        }
        return (index = Math.abs(index + 1)) - 1 >= pos ? index - 1 : -1;
    }

    @Override
    public int posFIndexGTE(int r, int c) {
        int index = this.internPosFIndexGTE(r, c);
        return index >= 0 ? index - this.pos(r) : index;
    }

    private int internPosFIndexGTE(int r, int c) {
        int len;
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.size(r)), c);
        if (index >= 0) {
            return index < pos + len ? index : -1;
        }
        return (index = Math.abs(index + 1)) < pos + len ? index : -1;
    }

    @Override
    public int posFIndexGT(int r, int c) {
        int index = this.internPosFIndexGT(r, c);
        return index >= 0 ? index - this.pos(r) : index;
    }

    private int internPosFIndexGT(int r, int c) {
        int len;
        int pos = this.pos(r);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.size(r)), c);
        if (index >= 0) {
            return index + 1 < pos + len ? index + 1 : -1;
        }
        return (index = Math.abs(index + 1)) < pos + len ? index : -1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SparseBlockCSR: rlen=");
        sb.append(this.numRows());
        sb.append(", nnz=");
        sb.append(this.size());
        sb.append("\n");
        for (int i = 0; i < this.numRows(); ++i) {
            sb.append("row +");
            sb.append(i);
            sb.append(": ");
            int pos = this.pos(i);
            int len = this.size(i);
            for (int j = pos; j < pos + len; ++j) {
                sb.append(this._indexes[j]);
                sb.append(": ");
                sb.append(this._values[j]);
                sb.append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean checkValidity(int rlen, int clen, long nnz, boolean strict) {
        int i;
        if (rlen < 0 || clen < 0) {
            throw new RuntimeException("Invalid block dimensions: " + rlen + " " + clen);
        }
        if ((long)this._size != nnz && this._ptr.length < rlen + 1 && (long)this._values.length < nnz && (long)this._indexes.length < nnz) {
            throw new RuntimeException("Incorrect array lengths.");
        }
        for (i = 1; i < rlen; ++i) {
            if (this._ptr[i - 1] <= this._ptr[i] || !strict) continue;
            throw new RuntimeException("Row pointers are decreasing at row: " + i + ", with pointers " + this._ptr[i - 1] + " > " + this._ptr[i]);
        }
        for (i = 0; i < rlen; ++i) {
            int k;
            int apos = this.pos(i);
            int alen = this.size(i);
            for (k = apos + 1; k < apos + alen; ++k) {
                if (this._indexes[k - 1] < this._indexes[k]) continue;
                throw new RuntimeException("Wrong sparse row ordering: " + k + " " + this._indexes[k - 1] + " " + this._indexes[k]);
            }
            for (k = apos; k < apos + alen; ++k) {
                if (this._values[k] != 0.0) continue;
                throw new RuntimeException("Wrong sparse row: zero at " + k + " at col index " + this._indexes[k]);
            }
        }
        for (i = 0; i < this._size; ++i) {
            if (this._values[i] != 0.0) continue;
            throw new RuntimeException("The values array should not contain zeros. The " + i + "th value is " + this._values[i]);
        }
        int capacity = this._values.length;
        if ((double)capacity > (double)nnz * 2.0) {
            throw new RuntimeException("Capacity is larger than the nnz times a resize factor. Current size: " + capacity + ", while Expected size:" + (double)nnz * 2.0);
        }
        return true;
    }

    private int newCapacity(int minsize) {
        double tmpCap;
        for (tmpCap = (double)Math.max(this._values.length, 1); tmpCap < (double)minsize; tmpCap *= tmpCap <= 1024.0 ? 2.0 : 1.1) {
        }
        return (int)Math.min(tmpCap, 2.147483647E9);
    }

    private void resize() {
        int newCap = this.newCapacity(this._values.length + 1);
        this.resizeCopy(newCap);
    }

    private void resize(int minsize) {
        int newCap = this.newCapacity(minsize);
        this.resizeCopy(newCap);
    }

    private void resizeCopy(int capacity) {
        this._indexes = Arrays.copyOf(this._indexes, capacity);
        this._values = Arrays.copyOf(this._values, capacity);
    }

    private void resizeAndInsert(int ix, int c, double v) {
        int newCap = this.newCapacity(this._values.length + 1);
        int[] oldindexes = this._indexes;
        double[] oldvalues = this._values;
        this._indexes = new int[newCap];
        this._values = new double[newCap];
        System.arraycopy(oldindexes, 0, this._indexes, 0, ix);
        System.arraycopy(oldvalues, 0, this._values, 0, ix);
        System.arraycopy(oldindexes, ix, this._indexes, ix + 1, this._size - ix);
        System.arraycopy(oldvalues, ix, this._values, ix + 1, this._size - ix);
        this.insert(ix, c, v);
    }

    private void shiftRightAndInsert(int ix, int c, double v) {
        System.arraycopy(this._indexes, ix, this._indexes, ix + 1, this._size - ix);
        System.arraycopy(this._values, ix, this._values, ix + 1, this._size - ix);
        this.insert(ix, c, v);
    }

    private void shiftLeftAndDelete(int ix) {
        System.arraycopy(this._indexes, ix + 1, this._indexes, ix, this._size - ix - 1);
        System.arraycopy(this._values, ix + 1, this._values, ix, this._size - ix - 1);
        --this._size;
    }

    private void shiftRightByN(int ix, int n) {
        System.arraycopy(this._indexes, ix, this._indexes, ix + n, this._size - ix);
        System.arraycopy(this._values, ix, this._values, ix + n, this._size - ix);
        this._size += n;
    }

    private void shiftLeftByN(int ix, int n) {
        System.arraycopy(this._indexes, ix, this._indexes, ix - n, this._size - ix);
        System.arraycopy(this._values, ix, this._values, ix - n, this._size - ix);
        this._size -= n;
    }

    private void insert(int ix, int c, double v) {
        this._indexes[ix] = c;
        this._values[ix] = v;
        ++this._size;
    }

    private void incrPtr(int rl) {
        this.incrPtr(rl, 1);
    }

    private void incrPtr(int rl, int cnt) {
        int rlen = this.numRows();
        int i = rl;
        while (i < rlen + 1) {
            int n = i++;
            this._ptr[n] = this._ptr[n] + cnt;
        }
    }

    private void decrPtr(int rl) {
        this.decrPtr(rl, 1);
    }

    private void decrPtr(int rl, int cnt) {
        int rlen = this.numRows();
        int i = rl;
        while (i < rlen + 1) {
            int n = i++;
            this._ptr[n] = this._ptr[n] - cnt;
        }
    }
}

