/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDenseSingleBlockTransposed
extends ReaderColumnSelection {
    private final double[] _data;

    protected ReaderColumnSelectionDenseSingleBlockTransposed(MatrixBlock data, int[] colIndexes, int rl, int ru) {
        super((int[])colIndexes.clone(), rl, Math.min(ru, data.getNumColumns()));
        this._data = data.getDenseBlockValues();
        if (data.getDenseBlock().numBlocks() > 1) {
            throw new DMLCompressionException("Not handling multi block data reading in dense transposed reader");
        }
        for (int i = 0; i < this._colIndexes.length; ++i) {
            this._colIndexes[i] = this._colIndexes[i] * data.getNumColumns();
        }
    }

    @Override
    protected DblArray getNextRow() {
        if (this._rl == this._ru - 1) {
            return null;
        }
        ++this._rl;
        boolean empty = true;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            double v = this._data[this._colIndexes[i] + this._rl];
            if (v != 0.0) {
                empty = false;
            }
            this.reusableArr[i] = v;
        }
        return empty ? emptyReturn : this.reusableReturn;
    }
}

