/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;

public class ColGroupIO {
    protected static final Log LOG = LogFactory.getLog((String)ColGroupIO.class.getName());

    public static List<AColGroup> readGroups(DataInput in, int nRows) throws IOException {
        int nColGroups = in.readInt();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading " + nColGroups + " ColGroups"));
        }
        ArrayList<AColGroup> _colGroups = new ArrayList<AColGroup>(nColGroups);
        for (int i = 0; i < nColGroups; ++i) {
            AColGroup.ColGroupType ctype = AColGroup.ColGroupType.values()[in.readByte()];
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Reading in : " + (Object)((Object)ctype)));
            }
            AColGroup grp = ColGroupIO.constructColGroup(ctype, nRows);
            grp.readFields(in);
            _colGroups.add(grp);
        }
        return _colGroups;
    }

    public static void writeGroups(DataOutput out, List<AColGroup> colGroups) throws IOException {
        out.writeInt(colGroups.size());
        for (AColGroup grp : colGroups) {
            grp.write(out);
        }
    }

    public static long getExactSizeOnDisk(List<AColGroup> colGroups) {
        long ret = 4L;
        for (AColGroup grp : colGroups) {
            ret += grp.getExactSizeOnDisk();
        }
        return ret;
    }

    private static AColGroup constructColGroup(AColGroup.ColGroupType ctype, int nRows) {
        switch (ctype) {
            case UNCOMPRESSED: {
                return new ColGroupUncompressed();
            }
            case OLE: {
                return new ColGroupOLE(nRows);
            }
            case RLE: {
                return new ColGroupRLE(nRows);
            }
            case DDC: {
                return new ColGroupDDC(nRows);
            }
            case CONST: {
                return new ColGroupConst();
            }
            case EMPTY: {
                return new ColGroupEmpty();
            }
            case SDC: {
                return new ColGroupSDC(nRows);
            }
            case SDCSingle: {
                return new ColGroupSDCSingle(nRows);
            }
            case SDCSingleZeros: {
                return new ColGroupSDCSingleZeros(nRows);
            }
            case SDCZeros: {
                return new ColGroupSDCZeros(nRows);
            }
        }
        throw new DMLRuntimeException("Unsupported ColGroup Type used:  " + (Object)((Object)ctype));
    }
}

