/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.ArrayList;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.rewrite.HopRewriteRule;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;

public class RewriteInjectSparkPReadCheckpointing
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (!OptimizerUtils.isSparkExecutionMode()) {
            return roots;
        }
        if (roots == null) {
            return null;
        }
        for (Hop h : roots) {
            this.rInjectCheckpointAfterPRead(h);
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        return root;
    }

    private void rInjectCheckpointAfterPRead(Hop hop) {
        boolean isFrameException;
        if (hop.isVisited()) {
            return;
        }
        boolean isMatrix = hop.getDataType().isMatrix();
        boolean isPRead = hop instanceof DataOp && ((DataOp)hop).getOp() == Types.OpOpData.PERSISTENTREAD;
        boolean bl = isFrameException = hop.getDataType().isFrame() && isPRead && !((DataOp)hop).getFileFormat().isIJV();
        if (isMatrix && isPRead || hop.requiresReblock() && !isFrameException) {
            hop.setRequiresCheckpoint(true);
        } else if (hop.getInput() != null) {
            for (int i = 0; i < hop.getInput().size(); ++i) {
                this.rInjectCheckpointAfterPRead(hop.getInput().get(i));
            }
        }
        hop.setVisited();
    }
}

