/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.H5Superblock;

public class H5RootObject {
    protected BufferedInputStream bufferedInputStream;
    protected BufferedOutputStream bufferedOutputStream;
    protected H5Superblock superblock;
    protected int rank;
    protected long row;
    protected long col;
    protected int[] dimensions;
    protected long maxRow;
    protected long maxCol;
    protected int[] maxSizes;
    protected String datasetName;
    public H5BufferBuilder bufferBuilder;
    protected byte dataSpaceVersion = 1;
    protected byte objectHeaderVersion = 1;
    protected byte localHeapVersion = 0;
    protected byte fillValueVersion = (byte)2;
    protected byte dataLayoutVersion = (byte)3;
    protected byte objectModificationTimeVersion = 1;
    protected byte groupSymbolTableNodeVersion = 1;
    protected byte dataLayoutClass = 1;

    public ByteBuffer readBufferFromAddress(long address, int length) {
        ByteBuffer bb = ByteBuffer.allocate(length);
        try {
            byte[] b = new byte[length];
            this.bufferedInputStream.reset();
            this.bufferedInputStream.skip(address);
            this.bufferedInputStream.read(b);
            bb.put(b);
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.rewind();
        return bb;
    }

    public ByteBuffer readBufferFromAddressNoOrder(long address, int length) {
        ByteBuffer bb = ByteBuffer.allocate(length);
        try {
            byte[] b = new byte[length];
            this.bufferedInputStream.reset();
            this.bufferedInputStream.skip(address);
            this.bufferedInputStream.read(b);
            bb.put(b);
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
        bb.rewind();
        return bb;
    }

    public BufferedInputStream getBufferedInputStream() {
        return this.bufferedInputStream;
    }

    public void setBufferedInputStream(BufferedInputStream bufferedInputStream) {
        this.bufferedInputStream = bufferedInputStream;
    }

    public BufferedOutputStream getBufferedOutputStream() {
        return this.bufferedOutputStream;
    }

    public void setBufferedOutputStream(BufferedOutputStream bufferedOutputStream) {
        this.bufferedOutputStream = bufferedOutputStream;
    }

    public H5Superblock getSuperblock() {
        return this.superblock;
    }

    public void setSuperblock(H5Superblock superblock) {
        this.superblock = superblock;
    }

    public long getRow() {
        return this.row;
    }

    public void setRow(long row) {
        this.row = row;
        this.dimensions[0] = (int)row;
    }

    public long getCol() {
        return this.col;
    }

    public void setCol(long col) {
        this.col = col;
        this.dimensions[1] = (int)col;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
        this.dimensions = new int[rank];
        this.maxSizes = new int[rank];
    }

    public long getMaxRow() {
        return this.maxRow;
    }

    public void setMaxRow(long maxRow) {
        this.maxRow = maxRow;
        this.maxSizes[0] = (int)maxRow;
    }

    public long getMaxCol() {
        return this.maxCol;
    }

    public void setMaxCol(long maxCol) {
        this.maxCol = maxCol;
        this.maxSizes[1] = (int)maxCol;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public int[] getMaxSizes() {
        return this.maxSizes;
    }

    public byte getDataSpaceVersion() {
        return this.dataSpaceVersion;
    }

    public void setDataSpaceVersion(byte dataSpaceVersion) {
        this.dataSpaceVersion = dataSpaceVersion;
    }

    public void setDimensions(int[] dimensions) {
        this.dimensions = dimensions;
        this.row = dimensions[0];
        this.col = dimensions[1];
    }

    public void setMaxSizes(int[] maxSizes) {
        this.maxSizes = maxSizes;
        this.maxRow = maxSizes[0];
        this.maxCol = maxSizes[1];
    }

    public byte getObjectHeaderVersion() {
        return this.objectHeaderVersion;
    }

    public void setObjectHeaderVersion(byte objectHeaderVersion) {
        this.objectHeaderVersion = objectHeaderVersion;
    }

    public byte getLocalHeapVersion() {
        return this.localHeapVersion;
    }

    public void setLocalHeapVersion(byte localHeapVersion) {
        this.localHeapVersion = localHeapVersion;
    }

    public byte getFillValueVersion() {
        return this.fillValueVersion;
    }

    public void setFillValueVersion(byte fillValueVersion) {
        this.fillValueVersion = fillValueVersion;
    }

    public byte getDataLayoutVersion() {
        return this.dataLayoutVersion;
    }

    public void setDataLayoutVersion(byte dataLayoutVersion) {
        this.dataLayoutVersion = dataLayoutVersion;
    }

    public byte getDataLayoutClass() {
        return this.dataLayoutClass;
    }

    public void setDataLayoutClass(byte dataLayoutClass) {
        this.dataLayoutClass = dataLayoutClass;
    }

    public byte getObjectModificationTimeVersion() {
        return this.objectModificationTimeVersion;
    }

    public void setObjectModificationTimeVersion(byte objectModificationTimeVersion) {
        this.objectModificationTimeVersion = objectModificationTimeVersion;
    }

    public byte getGroupSymbolTableNodeVersion() {
        return this.groupSymbolTableNodeVersion;
    }

    public void setGroupSymbolTableNodeVersion(byte groupSymbolTableNodeVersion) {
        this.groupSymbolTableNodeVersion = groupSymbolTableNodeVersion;
    }
}

