/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.server;

import org.spark_project.jetty.io.AbstractConnection;
import org.spark_project.jetty.io.Connection;
import org.spark_project.jetty.io.EndPoint;
import org.spark_project.jetty.server.ConnectionFactory;
import org.spark_project.jetty.server.Connector;
import org.spark_project.jetty.server.HttpConfiguration;
import org.spark_project.jetty.server.SecureRequestCustomizer;
import org.spark_project.jetty.server.SslConnectionFactory;
import org.spark_project.jetty.util.ArrayUtil;
import org.spark_project.jetty.util.component.ContainerLifeCycle;
import org.spark_project.jetty.util.ssl.SslContextFactory;

public abstract class AbstractConnectionFactory
extends ContainerLifeCycle
implements ConnectionFactory {
    private final String _protocol;
    private int _inputbufferSize = 8192;

    protected AbstractConnectionFactory(String protocol) {
        this._protocol = protocol;
    }

    @Override
    public String getProtocol() {
        return this._protocol;
    }

    public int getInputBufferSize() {
        return this._inputbufferSize;
    }

    public void setInputBufferSize(int size) {
        this._inputbufferSize = size;
    }

    protected AbstractConnection configure(AbstractConnection connection, Connector connector, EndPoint endPoint) {
        connection.setInputBufferSize(this.getInputBufferSize());
        if (connector instanceof ContainerLifeCycle) {
            ContainerLifeCycle aggregate2 = (ContainerLifeCycle)((Object)connector);
            for (Connection.Listener listener : aggregate2.getBeans(Connection.Listener.class)) {
                connection.addListener(listener);
            }
        }
        return connection;
    }

    public String toString() {
        return String.format("%s@%x{%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocol());
    }

    public static ConnectionFactory[] getFactories(SslContextFactory sslContextFactory, ConnectionFactory ... factories) {
        factories = ArrayUtil.removeNulls(factories);
        if (sslContextFactory == null) {
            return factories;
        }
        for (ConnectionFactory factory : factories) {
            HttpConfiguration config;
            if (!(factory instanceof HttpConfiguration.ConnectionFactory) || (config = ((HttpConfiguration.ConnectionFactory)((Object)factory)).getHttpConfiguration()).getCustomizer(SecureRequestCustomizer.class) != null) continue;
            config.addCustomizer(new SecureRequestCustomizer());
        }
        return ArrayUtil.prependToArray(new SslConnectionFactory(sslContextFactory, factories[0].getProtocol()), factories, ConnectionFactory.class);
    }
}

