/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.zip;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.zip.AbstractZip;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.util.JRLoader;

public class FileBufferedZip
extends AbstractZip {
    private final Integer memoryThreshold;

    public FileBufferedZip() {
        this(null);
    }

    public FileBufferedZip(Integer memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    @Override
    public ExportZipEntry createEntry(String name) {
        FileBufferedZipEntry entry = this.memoryThreshold == null ? new FileBufferedZipEntry(name) : new FileBufferedZipEntry(name, this.memoryThreshold);
        this.addEntry(entry);
        return entry;
    }

    public void addEntry(String name, String resource) {
        byte[] bytes = null;
        try {
            bytes = JRLoader.loadBytesFromResource(resource);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        this.addEntry(new FileBufferedZipEntry(name, bytes));
    }

    public void addEntry(String name, byte[] bytes) {
        this.addEntry(new FileBufferedZipEntry(name, bytes));
    }
}

