/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.reparent;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.AbstractNode;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.parser.Namespace;
import com.google.gxp.compiler.parser.NullNamespace;
import com.google.gxp.compiler.schema.Schema;

public class Attribute
extends AbstractNode {
    private final Namespace namespace;
    private final String name;
    private final Expression value;
    private final Expression condition;
    private final Schema innerSchema;

    public Attribute(SourcePosition sourcePosition, String displayName, Namespace namespace, String name, Expression value, Expression condition, Schema innerSchema) {
        super(sourcePosition, displayName);
        this.namespace = Preconditions.checkNotNull(namespace);
        if (name.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.value = Preconditions.checkNotNull(value);
        this.condition = condition;
        this.innerSchema = innerSchema;
    }

    public Attribute(Node fromNode, Namespace namespace, String name, Expression value, Expression condition, Schema innerSchema) {
        this(fromNode.getSourcePosition(), fromNode.getDisplayName(), namespace, name, value, condition, innerSchema);
    }

    public Attribute(Node fromNode, Namespace namespace, String name, Expression value) {
        this(fromNode, namespace, name, value, null, null);
    }

    public Attribute(Node fromNode, String name, Expression value, Expression condition) {
        this(fromNode.getSourcePosition(), "'" + name + "' attribute", NullNamespace.INSTANCE, name, value, condition, null);
    }

    public String getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Schema getInnerSchema() {
        return this.innerSchema;
    }

    public Attribute withValue(Expression newValue) {
        return newValue.equals(this.value) ? this : new Attribute(this, this.getNamespace(), this.getName(), newValue, this.condition, this.getInnerSchema());
    }

    public Attribute withCondition(Expression newCondition) {
        return Objects.equal(newCondition, this.condition) ? this : new Attribute(this, this.getNamespace(), this.getName(), this.value, newCondition, this.getInnerSchema());
    }

    public Attribute withInnerSchema(Schema innerSchema) {
        return new Attribute(this, this.getNamespace(), this.getName(), this.getValue(), this.getCondition(), Preconditions.checkNotNull(innerSchema));
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Attribute && this.equals((Attribute)that);
    }

    public boolean equals(Attribute that) {
        return this.equalsAbstractNode(that) && Objects.equal(this.getNamespace(), that.getNamespace()) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getValue(), that.getValue()) && Objects.equal(this.getCondition(), that.getCondition());
    }

    public int hashCode() {
        return Objects.hashCode(this.abstractNodeHashCode(), this.getNamespace(), this.getName(), this.getValue(), this.getCondition());
    }
}

