/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.util.Pair;

public interface SqlValidatorScope {
    public SqlValidator getValidator();

    public SqlNode getNode();

    public void resolve(List<String> var1, boolean var2, Resolved var3);

    public Pair<String, SqlValidatorNamespace> findQualifyingTableName(String var1, SqlNode var2);

    public void findAllColumnNames(List<SqlMoniker> var1);

    public void findAliases(Collection<SqlMoniker> var1);

    public SqlQualified fullyQualify(SqlIdentifier var1);

    public void addChild(SqlValidatorNamespace var1, String var2, boolean var3);

    public SqlWindow lookupWindow(String var1);

    public SqlMonotonicity getMonotonicity(SqlNode var1);

    public SqlNodeList getOrderList();

    public RelDataType resolveColumn(String var1, SqlNode var2);

    public SqlValidatorScope getOperandScope(SqlCall var1);

    public void validateExpr(SqlNode var1);

    public SqlValidatorNamespace getTableNamespace(List<String> var1);

    public RelDataType nullifyType(SqlNode var1, RelDataType var2);

    public static class Resolve {
        public final SqlValidatorNamespace namespace;
        private final boolean nullable;
        public final SqlValidatorScope scope;
        public final Path path;

        Resolve(SqlValidatorNamespace namespace, boolean nullable, SqlValidatorScope scope, Path path) {
            this.namespace = (SqlValidatorNamespace)Preconditions.checkNotNull((Object)namespace);
            this.nullable = nullable;
            this.scope = scope;
            this.path = (Path)Preconditions.checkNotNull((Object)path);
        }

        public RelDataType rowType() {
            return this.namespace.getValidator().getTypeFactory().createTypeWithNullability(this.namespace.getRowType(), this.nullable);
        }
    }

    public static class ResolvedImpl
    implements Resolved {
        final List<Resolve> resolves = new ArrayList<Resolve>();
        private final EmptyPath emptyPath = new EmptyPath();

        @Override
        public void found(SqlValidatorNamespace namespace, boolean nullable, SqlValidatorScope scope, Path path) {
            this.resolves.add(new Resolve(namespace, nullable, scope, path));
        }

        @Override
        public int count() {
            return this.resolves.size();
        }

        @Override
        public Path emptyPath() {
            return this.emptyPath;
        }

        public Resolve only() {
            return (Resolve)Iterables.getOnlyElement(this.resolves);
        }

        public void clear() {
            this.resolves.clear();
        }
    }

    public static class Step
    extends Path {
        final Path parent;
        final RelDataType rowType;
        public final int i;
        final StructKind kind;

        Step(Path parent, RelDataType rowType, int i, StructKind kind) {
            this.parent = (Path)Preconditions.checkNotNull((Object)parent);
            this.rowType = rowType;
            this.i = i;
            this.kind = (StructKind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        }

        @Override
        public int stepCount() {
            return 1 + this.parent.stepCount();
        }

        @Override
        protected void build(ImmutableList.Builder<Step> paths) {
            this.parent.build(paths);
            paths.add((Object)this);
        }
    }

    public static class EmptyPath
    extends Path {
    }

    public static abstract class Path {
        Step add(RelDataType rowType, int i, StructKind kind) {
            return new Step(this, rowType, i, kind);
        }

        public int stepCount() {
            return 0;
        }

        public List<Step> steps() {
            ImmutableList.Builder paths = new ImmutableList.Builder();
            this.build((ImmutableList.Builder<Step>)paths);
            return paths.build();
        }

        protected void build(ImmutableList.Builder<Step> paths) {
        }
    }

    public static interface Resolved {
        public void found(SqlValidatorNamespace var1, boolean var2, SqlValidatorScope var3, Path var4);

        public int count();

        public Path emptyPath();
    }
}

