/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.util.Util;

public interface SaffronProperties {
    public static final SaffronProperties INSTANCE = Helper.instance();

    @Resources.Resource(value="saffron.opt.allowInfiniteCostConverters")
    @Resources.Default(value="true")
    public Resources.BooleanProp allowInfiniteCostConverters();

    @Resources.Resource(value="saffron.default.charset")
    @Resources.Default(value="ISO-8859-1")
    public Resources.StringProp defaultCharset();

    @Resources.Resource(value="saffron.default.nationalcharset")
    @Resources.Default(value="ISO-8859-1")
    public Resources.StringProp defaultNationalCharset();

    @Resources.Resource(value="saffron.default.collation.name")
    @Resources.Default(value="ISO-8859-1$en_US")
    public Resources.StringProp defaultCollation();

    @Resources.Resource(value="saffron.default.collation.strength")
    @Resources.Default(value="primary")
    public Resources.StringProp defaultCollationStrength();

    public static class Helper {
        private Helper() {
        }

        static SaffronProperties instance() {
            Properties properties;
            block5: {
                properties = new Properties();
                File file = new File("saffron.properties");
                try {
                    if (!file.exists()) break block5;
                    try {
                        properties.load(new FileInputStream(file));
                    }
                    catch (IOException e) {
                        throw Util.newInternal(e, "while reading from " + file);
                    }
                }
                catch (AccessControlException e) {
                    // empty catch block
                }
            }
            Properties source = System.getProperties();
            Enumeration<Object> keys = source.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = source.getProperty(key);
                if (!key.startsWith("saffron.") && !key.startsWith("net.sf.saffron.")) continue;
                properties.setProperty(key, value);
            }
            return Resources.create(properties, SaffronProperties.class);
        }
    }
}

