/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.shaded.admin.AdminUtils$;
import kafka.shaded.controller.ControllerStats$;
import kafka.shaded.controller.KafkaController;
import kafka.shaded.log.CleanerConfig;
import kafka.shaded.log.CleanerConfig$;
import kafka.shaded.log.LogConfig;
import kafka.shaded.log.LogConfig$;
import kafka.shaded.log.LogManager;
import kafka.shaded.message.CompressionCodec;
import kafka.shaded.metrics.KafkaMetricsGroup;
import kafka.shaded.metrics.KafkaMetricsGroup$class;
import kafka.shaded.network.SocketServer;
import kafka.shaded.server.BrokerShuttingDown$;
import kafka.shaded.server.BrokerState;
import kafka.shaded.server.BrokerTopicStats$;
import kafka.shaded.server.KafkaApis;
import kafka.shaded.server.KafkaConfig;
import kafka.shaded.server.KafkaHealthcheck;
import kafka.shaded.server.KafkaRequestHandlerPool;
import kafka.shaded.server.KafkaServer$;
import kafka.shaded.server.NotRunning$;
import kafka.shaded.server.OffsetManager;
import kafka.shaded.server.OffsetManagerConfig;
import kafka.shaded.server.OffsetManagerConfig$;
import kafka.shaded.server.ReplicaManager;
import kafka.shaded.server.RunningAsBroker$;
import kafka.shaded.server.Starting$;
import kafka.shaded.server.TopicConfigManager;
import kafka.shaded.server.TopicConfigManager$;
import kafka.shaded.utils.KafkaScheduler;
import kafka.shaded.utils.KafkaScheduler$;
import kafka.shaded.utils.Log4jController$;
import kafka.shaded.utils.Logging$class;
import kafka.shaded.utils.Mx4jLoader$;
import kafka.shaded.utils.Time;
import kafka.shaded.utils.Utils$;
import kafka.shaded.utils.ZKStringSerializer$;
import kafka.shaded.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u0001\u001d\u00111bS1gW\u0006\u001cVM\u001d<fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u00119!\u0002CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h!\t)\u0002$D\u0001\u0017\u0015\t9B!A\u0004nKR\u0014\u0018nY:\n\u0005e1\"!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\"A1\u0004\u0001BC\u0002\u0013\u0005A$\u0001\u0004d_:4\u0017nZ\u000b\u0002;A\u0011adH\u0007\u0002\u0005%\u0011\u0001E\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0005i&lW\r\u0005\u0002\u0010M%\u0011q\u0005\u0005\u0002\u0005)&lW\rC\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0004W1j\u0003C\u0001\u0010\u0001\u0011\u0015Y\u0002\u00061\u0001\u001e\u0011\u001d!\u0003\u0006%AA\u0002\u0015Bqa\f\u0001A\u0002\u0013%\u0001'\u0001\bjgNCW\u000f\u001e;j]\u001e$un\u001e8\u0016\u0003E\u0002\"AM\u001e\u000e\u0003MR!\u0001N\u001b\u0002\r\u0005$x.\\5d\u0015\t1t'\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001O\u001d\u0002\tU$\u0018\u000e\u001c\u0006\u0002u\u0005!!.\u0019<b\u0013\ta4GA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\b}\u0001\u0001\r\u0011\"\u0003@\u0003II7o\u00155viRLgn\u001a#po:|F%Z9\u0015\u0005\u0001\u001b\u0005CA\u0005B\u0013\t\u0011%B\u0001\u0003V]&$\bb\u0002#>\u0003\u0003\u0005\r!M\u0001\u0004q\u0012\n\u0004B\u0002$\u0001A\u0003&\u0011'A\bjgNCW\u000f\u001e;j]\u001e$un\u001e8!\u0011\u001dA\u0005\u00011A\u0005\n%\u000bQb\u001d5vi\u0012|wO\u001c'bi\u000eDW#\u0001&\u0011\u0005-cU\"A\u001b\n\u00055+$AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\b\u001f\u0002\u0001\r\u0011\"\u0003Q\u0003E\u0019\b.\u001e;e_^tG*\u0019;dQ~#S-\u001d\u000b\u0003\u0001FCq\u0001\u0012(\u0002\u0002\u0003\u0007!\n\u0003\u0004T\u0001\u0001\u0006KAS\u0001\u000fg\",H\u000fZ8x]2\u000bGo\u00195!\u0011\u001d)\u0006\u00011A\u0005\nA\nqb\u001d;beR,\boQ8na2,G/\u001a\u0005\b/\u0002\u0001\r\u0011\"\u0003Y\u0003M\u0019H/\u0019:ukB\u001cu.\u001c9mKR,w\fJ3r)\t\u0001\u0015\fC\u0004E-\u0006\u0005\t\u0019A\u0019\t\rm\u0003\u0001\u0015)\u00032\u0003A\u0019H/\u0019:ukB\u001cu.\u001c9mKR,\u0007\u0005C\u0004^\u0001\t\u0007I\u0011\u00010\u0002\u0017\t\u0014xn[3s'R\fG/Z\u000b\u0002?B\u0011a\u0004Y\u0005\u0003C\n\u00111B\u0011:pW\u0016\u00148\u000b^1uK\"11\r\u0001Q\u0001\n}\u000bAB\u0019:pW\u0016\u00148\u000b^1uK\u0002Bq!\u001a\u0001C\u0002\u0013\u0005a-A\u0007d_J\u0014X\r\\1uS>t\u0017\nZ\u000b\u0002OB\u0011!\u0007[\u0005\u0003SN\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bBB6\u0001A\u0003%q-\u0001\bd_J\u0014X\r\\1uS>t\u0017\n\u001a\u0011\t\u000f5\u0004\u0001\u0019!C\u0001]\u0006a1o\\2lKR\u001cVM\u001d<feV\tq\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002s\t\u00059a.\u001a;x_J\\\u0017B\u0001;r\u00051\u0019vnY6fiN+'O^3s\u0011\u001d1\b\u00011A\u0005\u0002]\f\u0001c]8dW\u0016$8+\u001a:wKJ|F%Z9\u0015\u0005\u0001C\bb\u0002#v\u0003\u0003\u0005\ra\u001c\u0005\u0007u\u0002\u0001\u000b\u0015B8\u0002\u001bM|7m[3u'\u0016\u0014h/\u001a:!\u0011\u001da\b\u00011A\u0005\u0002u\f!C]3rk\u0016\u001cH\u000fS1oI2,'\u000fU8pYV\ta\u0010\u0005\u0002\u001f\u007f&\u0019\u0011\u0011\u0001\u0002\u0003/-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:Q_>d\u0007\"CA\u0003\u0001\u0001\u0007I\u0011AA\u0004\u0003Y\u0011X-];fgRD\u0015M\u001c3mKJ\u0004vn\u001c7`I\u0015\fHc\u0001!\u0002\n!AA)a\u0001\u0002\u0002\u0003\u0007a\u0010C\u0004\u0002\u000e\u0001\u0001\u000b\u0015\u0002@\u0002'I,\u0017/^3ti\"\u000bg\u000e\u001a7feB{w\u000e\u001c\u0011\t\u0013\u0005E\u0001\u00011A\u0005\u0002\u0005M\u0011A\u00037pO6\u000bg.Y4feV\u0011\u0011Q\u0003\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u0004\u0003\u0002\u00071|w-\u0003\u0003\u0002 \u0005e!A\u0003'pO6\u000bg.Y4fe\"I\u00111\u0005\u0001A\u0002\u0013\u0005\u0011QE\u0001\u000fY><W*\u00198bO\u0016\u0014x\fJ3r)\r\u0001\u0015q\u0005\u0005\n\t\u0006\u0005\u0012\u0011!a\u0001\u0003+A\u0001\"a\u000b\u0001A\u0003&\u0011QC\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005C\u0005\u00020\u0001\u0001\r\u0011\"\u0001\u00022\u0005iqN\u001a4tKRl\u0015M\\1hKJ,\"!a\r\u0011\u0007y\t)$C\u0002\u00028\t\u0011Qb\u00144gg\u0016$X*\u00198bO\u0016\u0014\b\"CA\u001e\u0001\u0001\u0007I\u0011AA\u001f\u0003EygMZ:fi6\u000bg.Y4fe~#S-\u001d\u000b\u0004\u0001\u0006}\u0002\"\u0003#\u0002:\u0005\u0005\t\u0019AA\u001a\u0011!\t\u0019\u0005\u0001Q!\n\u0005M\u0012AD8gMN,G/T1oC\u001e,'\u000f\t\u0005\n\u0003\u000f\u0002\u0001\u0019!C\u0001\u0003\u0013\n\u0001c[1gW\u0006DU-\u00197uQ\u000eDWmY6\u0016\u0005\u0005-\u0003c\u0001\u0010\u0002N%\u0019\u0011q\n\u0002\u0003!-\u000bgm[1IK\u0006dG\u000f[2iK\u000e\\\u0007\"CA*\u0001\u0001\u0007I\u0011AA+\u0003QY\u0017MZ6b\u0011\u0016\fG\u000e\u001e5dQ\u0016\u001c7n\u0018\u0013fcR\u0019\u0001)a\u0016\t\u0013\u0011\u000b\t&!AA\u0002\u0005-\u0003\u0002CA.\u0001\u0001\u0006K!a\u0013\u0002#-\fgm[1IK\u0006dG\u000f[2iK\u000e\\\u0007\u0005C\u0005\u0002`\u0001\u0001\r\u0011\"\u0001\u0002b\u0005\u0011Bo\u001c9jG\u000e{gNZ5h\u001b\u0006t\u0017mZ3s+\t\t\u0019\u0007E\u0002\u001f\u0003KJ1!a\u001a\u0003\u0005I!v\u000e]5d\u0007>tg-[4NC:\fw-\u001a:\t\u0013\u0005-\u0004\u00011A\u0005\u0002\u00055\u0014A\u0006;pa&\u001c7i\u001c8gS\u001el\u0015M\\1hKJ|F%Z9\u0015\u0007\u0001\u000by\u0007C\u0005E\u0003S\n\t\u00111\u0001\u0002d!A\u00111\u000f\u0001!B\u0013\t\u0019'A\nu_BL7mQ8oM&<W*\u00198bO\u0016\u0014\b\u0005C\u0005\u0002x\u0001\u0001\r\u0011\"\u0001\u0002z\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA>!\rq\u0012QP\u0005\u0004\u0003\u007f\u0012!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\n\u0003\u0007\u0003\u0001\u0019!C\u0001\u0003\u000b\u000b!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR\u0019\u0001)a\"\t\u0013\u0011\u000b\t)!AA\u0002\u0005m\u0004\u0002CAF\u0001\u0001\u0006K!a\u001f\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002B\u0011\"a$\u0001\u0001\u0004%\t!!%\u0002\t\u0005\u0004\u0018n]\u000b\u0003\u0003'\u00032AHAK\u0013\r\t9J\u0001\u0002\n\u0017\u000647.Y!qSND\u0011\"a'\u0001\u0001\u0004%\t!!(\u0002\u0011\u0005\u0004\u0018n]0%KF$2\u0001QAP\u0011%!\u0015\u0011TA\u0001\u0002\u0004\t\u0019\n\u0003\u0005\u0002$\u0002\u0001\u000b\u0015BAJ\u0003\u0015\t\u0007/[:!\u0011%\t9\u000b\u0001a\u0001\n\u0003\tI+A\blC\u001a\\\u0017mQ8oiJ|G\u000e\\3s+\t\tY\u000b\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\t\fB\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002BA[\u0003_\u0013qbS1gW\u0006\u001cuN\u001c;s_2dWM\u001d\u0005\n\u0003s\u0003\u0001\u0019!C\u0001\u0003w\u000b1c[1gW\u0006\u001cuN\u001c;s_2dWM]0%KF$2\u0001QA_\u0011%!\u0015qWA\u0001\u0002\u0004\tY\u000b\u0003\u0005\u0002B\u0002\u0001\u000b\u0015BAV\u0003AY\u0017MZ6b\u0007>tGO]8mY\u0016\u0014\b\u0005C\u0005\u0002F\u0002\u0011\r\u0011\"\u0001\u0002H\u0006q1.\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014XCAAe!\ry\u00111Z\u0005\u0004\u0003\u001b\u0004\"AD&bM.\f7k\u00195fIVdWM\u001d\u0005\t\u0003#\u0004\u0001\u0015!\u0003\u0002J\u0006y1.\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0005C\u0005\u0002V\u0002\u0001\r\u0011\"\u0001\u0002X\u0006A!p[\"mS\u0016tG/\u0006\u0002\u0002ZB!\u00111\\Au\u001b\t\tiN\u0003\u0003\u0002`\u0006\u0005\u0018\u0001\u0003>lG2LWM\u001c;\u000b\t\u0005\r\u0018Q]\u0001\u0007\u0013BJE/Z2\u000b\u0005\u0005\u001d\u0018aA8sO&!\u00111^Ao\u0005!Q6n\u00117jK:$\b\"CAx\u0001\u0001\u0007I\u0011AAy\u00031Q8n\u00117jK:$x\fJ3r)\r\u0001\u00151\u001f\u0005\n\t\u00065\u0018\u0011!a\u0001\u00033D\u0001\"a>\u0001A\u0003&\u0011\u0011\\\u0001\nu.\u001cE.[3oi\u0002Bq!a?\u0001\t\u0003\ti0A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003\u0001CqA!\u0001\u0001\t\u0013\u0011\u0019!\u0001\u0004j]&$(l\u001b\u000b\u0003\u00033DqAa\u0002\u0001\t\u0013\ti0A\u0007sK\u001eL7\u000f^3s'R\fGo\u001d\u0005\b\u0005\u0017\u0001A\u0011BA\u007f\u0003I\u0019wN\u001c;s_2dW\rZ*ikR$wn\u001e8\t\u000f\t=\u0001\u0001\"\u0001\u0002~\u0006A1\u000f[;uI><h\u000eC\u0004\u0003\u0014\u0001!\t!!@\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0011\u001d\u00119\u0002\u0001C\u0001\u00053\tQbZ3u\u0019><W*\u00198bO\u0016\u0014HCAA\u000b\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?\t\u0001c\u0019:fCR,Gj\\4NC:\fw-\u001a:\u0015\r\u0005U!\u0011\u0005B\u0012\u0011!\t)Na\u0007A\u0002\u0005e\u0007BB/\u0003\u001c\u0001\u0007q\fC\u0004\u0003(\u0001!IA!\u000b\u0002'\r\u0014X-\u0019;f\u001f\u001a47/\u001a;NC:\fw-\u001a:\u0015\u0005\u0005Mr!\u0003B\u0017\u0005\u0005\u0005\t\u0012\u0001B\u0018\u0003-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0011\u0007y\u0011\tD\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B\u001a'\r\u0011\t\u0004\u0003\u0005\bS\tEB\u0011\u0001B\u001c)\t\u0011y\u0003\u0003\u0006\u0003<\tE\u0012\u0013!C\u0001\u0005{\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TC\u0001B U\r)#\u0011I\u0016\u0003\u0005\u0007\u0002BA!\u0012\u0003P5\u0011!q\t\u0006\u0005\u0005\u0013\u0012Y%A\u0005v]\u000eDWmY6fI*\u0019!Q\n\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003R\t\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class KafkaServer
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Time time;
    private AtomicBoolean isShuttingDown;
    private CountDownLatch shutdownLatch;
    private AtomicBoolean startupComplete;
    private final BrokerState brokerState;
    private final AtomicInteger correlationId;
    private SocketServer socketServer;
    private KafkaRequestHandlerPool requestHandlerPool;
    private LogManager logManager;
    private OffsetManager offsetManager;
    private KafkaHealthcheck kafkaHealthcheck;
    private TopicConfigManager topicConfigManager;
    private ReplicaManager replicaManager;
    private KafkaApis apis;
    private KafkaController kafkaController;
    private final KafkaScheduler kafkaScheduler;
    private ZkClient zkClient;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$2() {
        return KafkaServer$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaServer kafkaServer = this;
        synchronized (kafkaServer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    private AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    private void isShuttingDown_$eq(AtomicBoolean x$1) {
        this.isShuttingDown = x$1;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    private void shutdownLatch_$eq(CountDownLatch x$1) {
        this.shutdownLatch = x$1;
    }

    private AtomicBoolean startupComplete() {
        return this.startupComplete;
    }

    private void startupComplete_$eq(AtomicBoolean x$1) {
        this.startupComplete = x$1;
    }

    public BrokerState brokerState() {
        return this.brokerState;
    }

    public AtomicInteger correlationId() {
        return this.correlationId;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public KafkaRequestHandlerPool requestHandlerPool() {
        return this.requestHandlerPool;
    }

    public void requestHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.requestHandlerPool = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public OffsetManager offsetManager() {
        return this.offsetManager;
    }

    public void offsetManager_$eq(OffsetManager x$1) {
        this.offsetManager = x$1;
    }

    public KafkaHealthcheck kafkaHealthcheck() {
        return this.kafkaHealthcheck;
    }

    public void kafkaHealthcheck_$eq(KafkaHealthcheck x$1) {
        this.kafkaHealthcheck = x$1;
    }

    public TopicConfigManager topicConfigManager() {
        return this.topicConfigManager;
    }

    public void topicConfigManager_$eq(TopicConfigManager x$1) {
        this.topicConfigManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public KafkaApis apis() {
        return this.apis;
    }

    public void apis_$eq(KafkaApis x$1) {
        this.apis = x$1;
    }

    public KafkaController kafkaController() {
        return this.kafkaController;
    }

    public void kafkaController_$eq(KafkaController x$1) {
        this.kafkaController = x$1;
    }

    public KafkaScheduler kafkaScheduler() {
        return this.kafkaScheduler;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    public void startup() {
        try {
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "starting";
                }
            }));
            this.brokerState().newState(Starting$.MODULE$);
            this.isShuttingDown_$eq(new AtomicBoolean(false));
            this.shutdownLatch_$eq(new CountDownLatch(1));
            this.kafkaScheduler().startup();
            this.zkClient_$eq(this.initZk());
            this.logManager_$eq(this.createLogManager(this.zkClient(), this.brokerState()));
            this.logManager().startup();
            this.socketServer_$eq(new SocketServer(this.config().brokerId(), this.config().hostName(), this.config().port(), this.config().numNetworkThreads(), this.config().queuedMaxRequests(), this.config().socketSendBufferBytes(), this.config().socketReceiveBufferBytes(), this.config().socketRequestMaxBytes(), this.config().maxConnectionsPerIp(), this.config().connectionsMaxIdleMs(), this.config().maxConnectionsPerIpOverrides()));
            this.socketServer().startup();
            this.replicaManager_$eq(new ReplicaManager(this.config(), this.time, this.zkClient(), this.kafkaScheduler(), this.logManager(), this.isShuttingDown()));
            this.offsetManager_$eq(this.createOffsetManager());
            this.kafkaController_$eq(new KafkaController(this.config(), this.zkClient(), this.brokerState()));
            this.apis_$eq(new KafkaApis(this.socketServer().requestChannel(), this.replicaManager(), this.offsetManager(), this.zkClient(), this.config().brokerId(), this.config(), this.kafkaController()));
            this.requestHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().brokerId(), this.socketServer().requestChannel(), this.apis(), this.config().numIoThreads()));
            this.brokerState().newState(RunningAsBroker$.MODULE$);
            Mx4jLoader$.MODULE$.maybeLoad();
            this.replicaManager().startup();
            this.kafkaController().startup();
            this.topicConfigManager_$eq(new TopicConfigManager(this.zkClient(), this.logManager(), TopicConfigManager$.MODULE$.$lessinit$greater$default$3(), TopicConfigManager$.MODULE$.$lessinit$greater$default$4()));
            this.topicConfigManager().startup();
            this.kafkaHealthcheck_$eq(new KafkaHealthcheck(this.config().brokerId(), this.config().advertisedHostName(), this.config().advertisedPort(), this.config().zkSessionTimeoutMs(), this.zkClient()));
            this.kafkaHealthcheck().startup();
            this.registerStats();
            this.startupComplete().set(true);
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "started";
                }
            }));
            return;
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Fatal error during KafkaServer startup. Prepare to shutdown";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            }));
            this.shutdown();
            throw throwable;
        }
    }

    private ZkClient initZk() {
        String chroot;
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaServer $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Connecting to zookeeper on ").append((Object)this.$outer.config().zkConnect()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String string2 = chroot = this.config().zkConnect().indexOf("/") > 0 ? this.config().zkConnect().substring(this.config().zkConnect().indexOf("/")) : "";
        if (chroot.length() > 1) {
            String zkConnForChrootCreation = this.config().zkConnect().substring(0, this.config().zkConnect().indexOf("/"));
            ZkClient zkClientForChrootCreation = new ZkClient(zkConnForChrootCreation, this.config().zkSessionTimeoutMs(), this.config().zkConnectionTimeoutMs(), ZKStringSerializer$.MODULE$);
            ZkUtils$.MODULE$.makeSurePersistentPathExists(zkClientForChrootCreation, chroot);
            this.info((Function0<String>)((Object)new Serializable(this, chroot){
                public static final long serialVersionUID = 0L;
                private final String chroot$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Created zookeeper path ").append((Object)this.chroot$1).toString();
                }
                {
                    this.chroot$1 = chroot$1;
                }
            }));
            zkClientForChrootCreation.close();
        }
        ZkClient zkClient = new ZkClient(this.config().zkConnect(), this.config().zkSessionTimeoutMs(), this.config().zkConnectionTimeoutMs(), ZKStringSerializer$.MODULE$);
        ZkUtils$.MODULE$.setupCommonPaths(zkClient);
        return zkClient;
    }

    private void registerStats() {
        BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats();
        ControllerStats$.MODULE$.uncleanLeaderElectionRate();
        ControllerStats$.MODULE$.leaderElectionTimer();
    }

    /*
     * Exception decompiling
     */
    public void kafka$server$KafkaServer$$controlledShutdown() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [0 : 306->442)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void shutdown() {
        try {
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "shutting down";
                }
            }));
            boolean canShutdown = this.isShuttingDown().compareAndSet(false, true);
            if (canShutdown) {
                Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaServer $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$server$KafkaServer$$controlledShutdown();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                this.brokerState().newState(BrokerShuttingDown$.MODULE$);
                if (this.socketServer() != null) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.socketServer().shutdown();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                if (this.requestHandlerPool() != null) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.requestHandlerPool().shutdown();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                if (this.offsetManager() != null) {
                    this.offsetManager().shutdown();
                }
                Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaServer $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafkaScheduler().shutdown();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                if (this.apis() != null) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.apis().close();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                if (this.replicaManager() != null) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.replicaManager().shutdown();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                if (this.logManager() != null) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.logManager().shutdown();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                if (this.kafkaController() != null) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.kafkaController().shutdown();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                if (this.zkClient() != null) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaServer $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.zkClient().close();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                this.brokerState().newState(NotRunning$.MODULE$);
                this.shutdownLatch().countDown();
                this.startupComplete().set(false);
                this.info((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "shut down completed";
                    }
                }));
            }
            return;
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Fatal error during KafkaServer shutdown.";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            }));
            throw throwable;
        }
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    public LogManager getLogManager() {
        return this.logManager();
    }

    private LogManager createLogManager(ZkClient zkClient, BrokerState brokerState) {
        int x$3 = this.config().logSegmentBytes();
        long x$4 = this.config().logRollTimeMillis();
        long x$5 = this.config().logRollTimeJitterMillis();
        long x$6 = this.config().logFlushIntervalMessages();
        long x$7 = this.config().logFlushIntervalMs();
        long x$8 = this.config().logRetentionBytes();
        long x$9 = this.config().logRetentionTimeMillis();
        int x$10 = this.config().messageMaxBytes();
        int x$11 = this.config().logIndexSizeMaxBytes();
        int x$12 = this.config().logIndexIntervalBytes();
        long x$13 = this.config().logCleanerDeleteRetentionMs();
        long x$14 = this.config().logDeleteDelayMs();
        double x$15 = this.config().logCleanerMinCleanRatio();
        String string2 = this.config().logCleanupPolicy().trim().toLowerCase();
        String string3 = "compact";
        boolean x$16 = !(string2 != null ? !string2.equals(string3) : string3 != null);
        boolean x$17 = LogConfig$.MODULE$.apply$default$15();
        int x$18 = LogConfig$.MODULE$.apply$default$16();
        LogConfig defaultLogConfig = new LogConfig(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$14, x$13, x$15, x$16, x$17, x$18);
        Properties defaultProps = defaultLogConfig.toProps();
        Map<String, LogConfig> configs = AdminUtils$.MODULE$.fetchAllTopicConfigs(zkClient).mapValues(new Serializable(this, defaultProps){
            public static final long serialVersionUID = 0L;
            private final Properties defaultProps$1;

            public final LogConfig apply(Properties x$1) {
                return LogConfig$.MODULE$.fromProps(this.defaultProps$1, x$1);
            }
            {
                this.defaultProps$1 = defaultProps$1;
            }
        });
        CleanerConfig cleanerConfig = new CleanerConfig(this.config().logCleanerThreads(), this.config().logCleanerDedupeBufferSize(), this.config().logCleanerDedupeBufferLoadFactor(), this.config().logCleanerIoBufferSize(), this.config().messageMaxBytes(), this.config().logCleanerIoMaxBytesPerSecond(), this.config().logCleanerBackoffMs(), this.config().logCleanerEnable(), CleanerConfig$.MODULE$.apply$default$9());
        return new LogManager((File[])((TraversableOnce)this.config().logDirs().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), configs, defaultLogConfig, cleanerConfig, this.config().numRecoveryThreadsPerDataDir(), this.config().logFlushSchedulerIntervalMs(), this.config().logFlushOffsetCheckpointIntervalMs(), this.config().logCleanupIntervalMs(), this.kafkaScheduler(), brokerState, this.time);
    }

    private OffsetManager createOffsetManager() {
        int x$19 = this.config().offsetMetadataMaxSize();
        int x$20 = this.config().offsetsLoadBufferSize();
        long x$21 = (long)(this.config().offsetsRetentionMinutes() * 60) * 1000L;
        int x$22 = this.config().offsetsTopicPartitions();
        short x$23 = this.config().offsetsTopicReplicationFactor();
        int x$24 = this.config().offsetCommitTimeoutMs();
        short x$25 = this.config().offsetCommitRequiredAcks();
        long x$26 = OffsetManagerConfig$.MODULE$.apply$default$4();
        int x$27 = OffsetManagerConfig$.MODULE$.apply$default$6();
        CompressionCodec x$28 = OffsetManagerConfig$.MODULE$.apply$default$8();
        OffsetManagerConfig offsetManagerConfig = new OffsetManagerConfig(x$19, x$20, x$21, x$26, x$22, x$27, x$23, x$28, x$24, x$25);
        return new OffsetManager(offsetManagerConfig, this.replicaManager(), this.zkClient(), this.kafkaScheduler());
    }

    public KafkaServer(KafkaConfig config, Time time) {
        this.config = config;
        this.time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Kafka Server ").append(BoxesRunTime.boxToInteger(config.brokerId())).append((Object)"], ").toString());
        this.isShuttingDown = new AtomicBoolean(false);
        this.shutdownLatch = new CountDownLatch(1);
        this.startupComplete = new AtomicBoolean(false);
        this.brokerState = new BrokerState();
        this.correlationId = new AtomicInteger(0);
        this.socketServer = null;
        this.requestHandlerPool = null;
        this.logManager = null;
        this.offsetManager = null;
        this.kafkaHealthcheck = null;
        this.topicConfigManager = null;
        this.replicaManager = null;
        this.apis = null;
        this.kafkaController = null;
        this.kafkaScheduler = new KafkaScheduler(config.backgroundThreads(), KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        this.zkClient = null;
        this.newGauge("BrokerState", new Gauge<Object>(this){
            private final /* synthetic */ KafkaServer $outer;

            public int value() {
                return this.$outer.brokerState().currentState();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

