/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.oap.server.exporter.provider;

import lombok.Getter;
import lombok.Setter;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;

@Setter
@Getter
public class ExporterSetting extends ModuleConfig {
    private boolean enableGRPCMetrics = false;
    private String gRPCTargetHost;
    private int gRPCTargetPort;
    private int bufferChannelSize = 20000;
    private int bufferChannelNum = 2;

    //kafka
    private boolean enableKafkaTrace = false;
    private boolean enableKafkaLog = false;
    private String kafkaBootstrapServers;
    private String kafkaProducerConfig;
    private String kafkaTopicTrace = "skywalking-export-trace";
    private String kafkaTopicLog = "skywalking-export-log";
    private boolean exportErrorStatusTraceOnly = false;
}
