/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SWSpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBSpanAttachedEventQueryDAO
extends AbstractBanyanDBDAO
implements ISpanAttachedEventQueryDAO {
    private static final Set<String> ZK_TAGS = ImmutableSet.of((Object)"start_time_second", (Object)"start_time_nanos", (Object)"event", (Object)"end_time_second", (Object)"end_time_nanos", (Object)"trace_ref_type", (Object[])new String[]{"related_trace_id", "trace_segment_id", "trace_span_id", "data_binary", "timestamp"});
    private static final Set<String> SW_TAGS = ImmutableSet.of((Object)"start_time_second", (Object)"start_time_nanos", (Object)"event", (Object)"end_time_second", (Object)"end_time_nanos", (Object)"trace_ref_type", (Object[])new String[]{"related_trace_id", "trace_segment_id", "trace_span_id", "data_binary", "timestamp"});
    private final int batchSize;

    public BanyanDBSpanAttachedEventQueryDAO(BanyanDBStorageClient client, int profileDataQueryBatchSize) {
        super(client);
        this.batchSize = profileDataQueryBatchSize;
    }

    public List<SWSpanAttachedEventRecord> querySWSpanAttachedEvents(final List<String> traceIds, @Nullable Duration duration) throws IOException {
        boolean isColdStage = duration != null && duration.isColdStage();
        StreamQueryResponse resp = this.queryDebuggable(isColdStage, "sw_span_attached_event_record", ZK_TAGS, this.getTimestampRange(duration), new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                query.and(this.in("related_trace_id", traceIds));
                query.setOrderBy(new AbstractQuery.OrderBy(AbstractQuery.Sort.ASC));
                query.setLimit(BanyanDBSpanAttachedEventQueryDAO.this.batchSize);
            }
        });
        return resp.getElements().stream().map(this::buildSWRecord).collect(Collectors.toList());
    }

    public List<SpanAttachedEventRecord> queryZKSpanAttachedEvents(final List<String> traceIds, @Nullable Duration duration) throws IOException {
        boolean isColdStage = duration != null && duration.isColdStage();
        StreamQueryResponse resp = this.queryDebuggable(isColdStage, "span_attached_event_record", ZK_TAGS, this.getTimestampRange(duration), new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                query.and(this.in("related_trace_id", traceIds));
                query.setOrderBy(new AbstractQuery.OrderBy(AbstractQuery.Sort.ASC));
                query.setLimit(BanyanDBSpanAttachedEventQueryDAO.this.batchSize);
            }
        });
        return resp.getElements().stream().map(this::buildZKRecord).collect(Collectors.toList());
    }

    private SpanAttachedEventRecord buildZKRecord(RowEntity row) {
        SpanAttachedEventRecord.Builder builder = new SpanAttachedEventRecord.Builder();
        return builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("span_attached_event_record", row));
    }

    private SWSpanAttachedEventRecord buildSWRecord(RowEntity row) {
        SWSpanAttachedEventRecord.Builder builder = new SWSpanAttachedEventRecord.Builder();
        return builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("sw_span_attached_event_record", row));
    }
}

