/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.logql.rt;

import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.logql.rt.grammar.LogQLParser;
import org.apache.skywalking.logql.rt.grammar.LogQLParserBaseVisitor;
import org.apache.skywalking.oap.query.logql.rt.result.LogQLParseResult;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class LogQLExprVisitor
extends LogQLParserBaseVisitor<LogQLParseResult> {
    private static final String ALL_VALUE = "*";

    @Override
    public LogQLParseResult visitRoot(LogQLParser.RootContext ctx) {
        LogQLParseResult result = (LogQLParseResult)this.visit((ParseTree)ctx.streamSelector());
        if (ctx.lineFilterList() != null) {
            LogQLParseResult filterResult = (LogQLParseResult)this.visit((ParseTree)ctx.lineFilterList());
            result.setKeywordsOfContent(filterResult.getKeywordsOfContent());
            result.setExcludingKeywordsOfContent(filterResult.getExcludingKeywordsOfContent());
        }
        return result;
    }

    @Override
    public LogQLParseResult visitStreamSelector(LogQLParser.StreamSelectorContext ctx) {
        LogQLParseResult result = new LogQLParseResult();
        Map<String, String> labelMap = result.getLabelMap();
        if (ctx.labelList() != null) {
            for (LogQLParser.LabelContext labelCtx : ctx.labelList().label()) {
                String labelName = labelCtx.labelName().getText();
                String labelValue = labelCtx.labelValue().getText();
                String labelValueTrim = labelValue.substring(1, labelValue.length() - 1);
                if (StringUtil.isBlank((String)labelValueTrim) || Objects.equals(ALL_VALUE, labelValueTrim)) continue;
                labelMap.put(labelName, labelValueTrim);
            }
        }
        return result;
    }

    @Override
    public LogQLParseResult visitLineFilterList(LogQLParser.LineFilterListContext ctx) {
        LogQLParseResult filterResult = new LogQLParseResult();
        for (LogQLParser.LineFilterContext lineFilterContext : ctx.lineFilter()) {
            String filterValue = lineFilterContext.filterValue().getText();
            String filterValueTrim = filterValue.substring(1, filterValue.length() - 1);
            if (StringUtil.isEmpty((String)filterValueTrim)) continue;
            if (lineFilterContext.operator().getStart().getType() == 1) {
                filterResult.getKeywordsOfContent().add(filterValueTrim);
            }
            if (lineFilterContext.operator().getStart().getType() != 2) continue;
            filterResult.getExcludingKeywordsOfContent().add(filterValueTrim);
        }
        return filterResult;
    }
}

