/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.prometheus;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import io.vavr.API;
import io.vavr.Predicates;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.oap.meter.analyzer.Analyzer;
import org.apache.skywalking.oap.meter.analyzer.dsl.Sample;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamily;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamilyBuilder;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Counter;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Gauge;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Histogram;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Metric;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricConverter.class);
    private static final Pattern METRICS_NAME_ESCAPE_PATTERN = Pattern.compile("[/.]");
    private static final LoadingCache<String, String> ESCAPED_METRICS_NAME_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String name) {
            return METRICS_NAME_ESCAPE_PATTERN.matcher(name).replaceAll("_");
        }
    });

    public static ImmutableMap<String, SampleFamily> convertPromMetricToSampleFamily(Stream<Metric> metricStream) {
        return (ImmutableMap)metricStream.peek(metric -> log.debug("Prom metric to be convert to SampleFamily: {}", metric)).flatMap(PrometheusMetricConverter::convertMetric).filter(t -> t != Analyzer.NIL && ((SampleFamily)t._2).samples.length > 0).peek(t -> log.debug("SampleFamily: {}", t)).collect(ImmutableMap.toImmutableMap(Tuple2::_1, Tuple2::_2, (a, b) -> {
            log.debug("merge {} {}", a, b);
            Sample[] m = new Sample[a.samples.length + b.samples.length];
            System.arraycopy(a.samples, 0, m, 0, a.samples.length);
            System.arraycopy(b.samples, 0, m, a.samples.length, b.samples.length);
            return SampleFamilyBuilder.newBuilder(m).build();
        }));
    }

    private static Stream<Tuple2<String, SampleFamily>> convertMetric(Metric metric) {
        return (Stream)API.Match((Object)metric).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Histogram.class)), t -> Stream.of(Tuple.of((Object)PrometheusMetricConverter.escapedName(metric.getName() + "_count"), (Object)SampleFamilyBuilder.newBuilder(Sample.builder().name(PrometheusMetricConverter.escapedName(metric.getName() + "_count")).timestamp(metric.getTimestamp()).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)metric.getLabels())).value(((Histogram)metric).getSampleCount()).build()).build()), Tuple.of((Object)PrometheusMetricConverter.escapedName(metric.getName() + "_sum"), (Object)SampleFamilyBuilder.newBuilder(Sample.builder().name(PrometheusMetricConverter.escapedName(metric.getName() + "_sum")).timestamp(metric.getTimestamp()).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)metric.getLabels())).value(((Histogram)metric).getSampleSum()).build()).build()), PrometheusMetricConverter.convertToSample(metric).orElse(Analyzer.NIL))), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Summary.class)), t -> Stream.of(Tuple.of((Object)PrometheusMetricConverter.escapedName(metric.getName() + "_count"), (Object)SampleFamilyBuilder.newBuilder(Sample.builder().name(PrometheusMetricConverter.escapedName(metric.getName() + "_count")).timestamp(metric.getTimestamp()).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)metric.getLabels())).value(((Summary)metric).getSampleCount()).build()).build()), Tuple.of((Object)PrometheusMetricConverter.escapedName(metric.getName() + "_sum"), (Object)SampleFamilyBuilder.newBuilder(Sample.builder().name(PrometheusMetricConverter.escapedName(metric.getName() + "_sum")).timestamp(metric.getTimestamp()).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)metric.getLabels())).value(((Summary)metric).getSampleSum()).build()).build()), PrometheusMetricConverter.convertToSample(metric).orElse(Analyzer.NIL))), API.Case((API.Match.Pattern0)API.$(), t -> Stream.of(PrometheusMetricConverter.convertToSample(metric).orElse(Analyzer.NIL)))});
    }

    private static Optional<Tuple2<String, SampleFamily>> convertToSample(Metric metric) {
        Sample[] ss = ((List)API.Match((Object)metric).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Counter.class)), t -> Collections.singletonList(Sample.builder().name(PrometheusMetricConverter.escapedName(t.getName())).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)t.getLabels())).timestamp(t.getTimestamp()).value(t.getValue()).build())), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Gauge.class)), t -> Collections.singletonList(Sample.builder().name(PrometheusMetricConverter.escapedName(t.getName())).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)t.getLabels())).timestamp(t.getTimestamp()).value(t.getValue()).build())), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Histogram.class)), t -> t.getBuckets().entrySet().stream().map(b -> Sample.builder().name(PrometheusMetricConverter.escapedName(t.getName())).labels((ImmutableMap<String, String>)ImmutableMap.builder().putAll(t.getLabels()).put((Object)"le", (Object)((Double)b.getKey()).toString()).build()).timestamp(t.getTimestamp()).value(((Long)b.getValue()).longValue()).build()).collect(Collectors.toList())), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Summary.class)), t -> t.getQuantiles().entrySet().stream().map(b -> Sample.builder().name(PrometheusMetricConverter.escapedName(t.getName())).labels((ImmutableMap<String, String>)ImmutableMap.builder().putAll(t.getLabels()).put((Object)"quantile", (Object)((Double)b.getKey()).toString()).build()).timestamp(t.getTimestamp()).value((Double)b.getValue()).build()).collect(Collectors.toList()))})).toArray(new Sample[0]);
        if (ss.length < 1) {
            return Optional.empty();
        }
        return Optional.of(Tuple.of((Object)PrometheusMetricConverter.escapedName(metric.getName()), (Object)SampleFamilyBuilder.newBuilder(ss).build()));
    }

    protected static String escapedName(String name) {
        try {
            return (String)ESCAPED_METRICS_NAME_CACHE.get((Object)name);
        }
        catch (ExecutionException e) {
            log.error("Failed to get escaped metrics name from cache", (Throwable)e);
            return METRICS_NAME_ESCAPE_PATTERN.matcher(name).replaceAll("_");
        }
    }
}

